# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
from msrest import Serializer, Deserializer


class NetworkManagementClientOperationsMixin(object):


    def check_dns_name_availability(self, location, domain_name_label, custom_headers=None, raw=False, **operation_config):
        """Checks whether a domain name in the cloudapp.azure.com zone is
        available for use.

        :param location: The location of the domain name.
        :type location: str
        :param domain_name_label: The domain name to be verified. It must
         conform to the following regular expression:
         ^[a-z][a-z0-9-]{1,61}[a-z0-9]$.
        :type domain_name_label: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: DnsNameAvailabilityResult or ClientRawResponse if raw=true
        :rtype:
         ~azure.mgmt.network.v2020_06_01.models.DnsNameAvailabilityResult or
         ~msrest.pipeline.ClientRawResponse
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        
        """
        api_version = self._get_api_version('check_dns_name_availability')
        if api_version == '2015-06-15':
            from .v2015_06_15.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2016-09-01':
            from .v2016_09_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2016-12-01':
            from .v2016_12_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2017-03-01':
            from .v2017_03_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2017-06-01':
            from .v2017_06_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2017-08-01':
            from .v2017_08_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2017-09-01':
            from .v2017_09_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2017-10-01':
            from .v2017_10_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2017-11-01':
            from .v2017_11_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-01-01':
            from .v2018_01_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-02-01':
            from .v2018_02_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-04-01':
            from .v2018_04_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-07-01':
            from .v2018_07_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-08-01':
            from .v2018_08_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        mixin_instance.api_version = api_version
        return mixin_instance.check_dns_name_availability(location, domain_name_label, custom_headers, raw, **operation_config)

    def delete_bastion_shareable_link(self, resource_group_name, bastion_host_name, vms=None, custom_headers=None, raw=False, polling=True, **operation_config):
        """Deletes the Bastion Shareable Links for all the VMs specified in the
        request.

        :param resource_group_name: The name of the resource group.
        :type resource_group_name: str
        :param bastion_host_name: The name of the Bastion Host.
        :type bastion_host_name: str
        :param vms: List of VM references.
        :type vms:
         list[~azure.mgmt.network.v2020_06_01.models.BastionShareableLink]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: The poller return type is ClientRawResponse, the
         direct response alongside the deserialized response
        :param polling: True for ARMPolling, False for no polling, or a
         polling object for personal polling strategy
        :return: An instance of LROPoller that returns None or
         ClientRawResponse<None> if raw==True
        :rtype: ~msrestazure.azure_operation.AzureOperationPoller[None] or
         ~msrestazure.azure_operation.AzureOperationPoller[~msrest.pipeline.ClientRawResponse[None]]
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        
        """
        api_version = self._get_api_version('delete_bastion_shareable_link')
        if api_version == '2019-09-01':
            from .v2019_09_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        mixin_instance.api_version = api_version
        return mixin_instance.delete_bastion_shareable_link(resource_group_name, bastion_host_name, vms, custom_headers, raw, polling, **operation_config)

    def disconnect_active_sessions(self, resource_group_name, bastion_host_name, session_ids=None, custom_headers=None, raw=False, **operation_config):
        """Returns the list of currently active sessions on the Bastion.

        :param resource_group_name: The name of the resource group.
        :type resource_group_name: str
        :param bastion_host_name: The name of the Bastion Host.
        :type bastion_host_name: str
        :param session_ids: List of session IDs.
        :type session_ids: list[str]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of BastionSessionState
        :rtype:
         ~azure.mgmt.network.v2020_06_01.models.BastionSessionStatePaged[~azure.mgmt.network.v2020_06_01.models.BastionSessionState]
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        
        """
        api_version = self._get_api_version('disconnect_active_sessions')
        if api_version == '2019-09-01':
            from .v2019_09_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        mixin_instance.api_version = api_version
        return mixin_instance.disconnect_active_sessions(resource_group_name, bastion_host_name, session_ids, custom_headers, raw, **operation_config)

    def generatevirtualwanvpnserverconfigurationvpnprofile(self, resource_group_name, virtual_wan_name, vpn_server_configuration_resource_id=None, authentication_method=None, custom_headers=None, raw=False, polling=True, **operation_config):
        """Generates a unique VPN profile for P2S clients for VirtualWan and
        associated VpnServerConfiguration combination in the specified resource
        group.

        :param resource_group_name: The resource group name.
        :type resource_group_name: str
        :param virtual_wan_name: The name of the VirtualWAN whose associated
         VpnServerConfigurations is needed.
        :type virtual_wan_name: str
        :param vpn_server_configuration_resource_id: VpnServerConfiguration
         partial resource uri with which VirtualWan is associated to.
        :type vpn_server_configuration_resource_id: str
        :param authentication_method: VPN client authentication method.
         Possible values include: 'EAPTLS', 'EAPMSCHAPv2'
        :type authentication_method: str or
         ~azure.mgmt.network.v2020_06_01.models.AuthenticationMethod
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: The poller return type is ClientRawResponse, the
         direct response alongside the deserialized response
        :param polling: True for ARMPolling, False for no polling, or a
         polling object for personal polling strategy
        :return: An instance of LROPoller that returns VpnProfileResponse or
         ClientRawResponse<VpnProfileResponse> if raw==True
        :rtype:
         ~msrestazure.azure_operation.AzureOperationPoller[~azure.mgmt.network.v2020_06_01.models.VpnProfileResponse]
         or
         ~msrestazure.azure_operation.AzureOperationPoller[~msrest.pipeline.ClientRawResponse[~azure.mgmt.network.v2020_06_01.models.VpnProfileResponse]]
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        
        """
        api_version = self._get_api_version('generatevirtualwanvpnserverconfigurationvpnprofile')
        if api_version == '2019-08-01':
            from .v2019_08_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        mixin_instance.api_version = api_version
        return mixin_instance.generatevirtualwanvpnserverconfigurationvpnprofile(resource_group_name, virtual_wan_name, vpn_server_configuration_resource_id, authentication_method, custom_headers, raw, polling, **operation_config)

    def get_active_sessions(self, resource_group_name, bastion_host_name, custom_headers=None, raw=False, polling=True, **operation_config):
        """Returns the list of currently active sessions on the Bastion.

        :param resource_group_name: The name of the resource group.
        :type resource_group_name: str
        :param bastion_host_name: The name of the Bastion Host.
        :type bastion_host_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: The poller return type is ClientRawResponse, the
         direct response alongside the deserialized response
        :param polling: True for ARMPolling, False for no polling, or a
         polling object for personal polling strategy
        :return: An instance of LROPoller that returns
         BastionActiveSessionListResult or
         ClientRawResponse<BastionActiveSessionListResult> if raw==True
        :rtype:
         ~msrestazure.azure_operation.AzureOperationPoller[~azure.mgmt.network.v2020_06_01.models.BastionActiveSessionListResult]
         or
         ~msrestazure.azure_operation.AzureOperationPoller[~msrest.pipeline.ClientRawResponse[~azure.mgmt.network.v2020_06_01.models.BastionActiveSessionListResult]]
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        
        """
        api_version = self._get_api_version('get_active_sessions')
        if api_version == '2019-09-01':
            from .v2019_09_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        mixin_instance.api_version = api_version
        return mixin_instance.get_active_sessions(resource_group_name, bastion_host_name, custom_headers, raw, polling, **operation_config)

    def get_bastion_shareable_link(self, resource_group_name, bastion_host_name, vms=None, custom_headers=None, raw=False, **operation_config):
        """Return the Bastion Shareable Links for all the VMs specified in the
        request.

        :param resource_group_name: The name of the resource group.
        :type resource_group_name: str
        :param bastion_host_name: The name of the Bastion Host.
        :type bastion_host_name: str
        :param vms: List of VM references.
        :type vms:
         list[~azure.mgmt.network.v2020_06_01.models.BastionShareableLink]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: An iterator like instance of BastionShareableLink
        :rtype:
         ~azure.mgmt.network.v2020_06_01.models.BastionShareableLinkPaged[~azure.mgmt.network.v2020_06_01.models.BastionShareableLink]
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        
        """
        api_version = self._get_api_version('get_bastion_shareable_link')
        if api_version == '2019-09-01':
            from .v2019_09_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        mixin_instance.api_version = api_version
        return mixin_instance.get_bastion_shareable_link(resource_group_name, bastion_host_name, vms, custom_headers, raw, **operation_config)

    def put_bastion_shareable_link(self, resource_group_name, bastion_host_name, vms=None, custom_headers=None, raw=False, polling=True, **operation_config):
        """Creates a Bastion Shareable Links for all the VMs specified in the
        request.

        :param resource_group_name: The name of the resource group.
        :type resource_group_name: str
        :param bastion_host_name: The name of the Bastion Host.
        :type bastion_host_name: str
        :param vms: List of VM references.
        :type vms:
         list[~azure.mgmt.network.v2020_06_01.models.BastionShareableLink]
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: The poller return type is ClientRawResponse, the
         direct response alongside the deserialized response
        :param polling: True for ARMPolling, False for no polling, or a
         polling object for personal polling strategy
        :return: An instance of LROPoller that returns
         BastionShareableLinkListResult or
         ClientRawResponse<BastionShareableLinkListResult> if raw==True
        :rtype:
         ~msrestazure.azure_operation.AzureOperationPoller[~azure.mgmt.network.v2020_06_01.models.BastionShareableLinkListResult]
         or
         ~msrestazure.azure_operation.AzureOperationPoller[~msrest.pipeline.ClientRawResponse[~azure.mgmt.network.v2020_06_01.models.BastionShareableLinkListResult]]
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        
        """
        api_version = self._get_api_version('put_bastion_shareable_link')
        if api_version == '2019-09-01':
            from .v2019_09_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        mixin_instance.api_version = api_version
        return mixin_instance.put_bastion_shareable_link(resource_group_name, bastion_host_name, vms, custom_headers, raw, polling, **operation_config)

    def supported_security_providers(self, resource_group_name, virtual_wan_name, custom_headers=None, raw=False, **operation_config):
        """Gives the supported security providers for the virtual wan.

        :param resource_group_name: The resource group name.
        :type resource_group_name: str
        :param virtual_wan_name: The name of the VirtualWAN for which
         supported security providers are needed.
        :type virtual_wan_name: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: VirtualWanSecurityProviders or ClientRawResponse if raw=true
        :rtype:
         ~azure.mgmt.network.v2020_06_01.models.VirtualWanSecurityProviders or
         ~msrest.pipeline.ClientRawResponse
        :raises: :class:`CloudError<msrestazure.azure_exceptions.CloudError>`
        
        """
        api_version = self._get_api_version('supported_security_providers')
        if api_version == '2018-08-01':
            from .v2018_08_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-10-01':
            from .v2018_10_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-11-01':
            from .v2018_11_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2018-12-01':
            from .v2018_12_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-02-01':
            from .v2019_02_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-04-01':
            from .v2019_04_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-07-01':
            from .v2019_07_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-08-01':
            from .v2019_08_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-09-01':
            from .v2019_09_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2019-12-01':
            from .v2019_12_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-03-01':
            from .v2020_03_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-04-01':
            from .v2020_04_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-05-01':
            from .v2020_05_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        elif api_version == '2020-06-01':
            from .v2020_06_01.operations import NetworkManagementClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        mixin_instance.api_version = api_version
        return mixin_instance.supported_security_providers(resource_group_name, virtual_wan_name, custom_headers, raw, **operation_config)
