# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.9.0, generator: @autorest/python@6.0.1)
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import sys
from typing import (
    Any,
    Callable,
    Dict,
    IO,
    Iterator,
    Optional,
    TypeVar,
    Union,
    cast,
    overload,
)

from azure.core.exceptions import (
    ClientAuthenticationError,
    HttpResponseError,
    ResourceExistsError,
    ResourceNotFoundError,
    map_error,
)
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace
from azure.core.utils import case_insensitive_dict

from .._serialization import Serializer
from .._vendor import _format_url_section

if sys.version_info >= (3, 9):
    from collections.abc import MutableMapping
else:
    from typing import MutableMapping  # type: ignore  # pylint: disable=ungrouped-imports
JSON = MutableMapping[str, Any]  # pylint: disable=unsubscriptable-object
T = TypeVar("T")
ClsType = Optional[
    Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]
]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False


def build_one_clicks_list_request(
    *, type: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/1-clicks"

    # Construct parameters
    if type is not None:
        _params["type"] = _SERIALIZER.query("type", type, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_one_clicks_install_kubernetes_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/1-clicks/kubernetes"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_account_get_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/account"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_ssh_keys_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/account/keys"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_ssh_keys_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/account/keys"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_ssh_keys_get_request(ssh_key_identifier: JSON, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/account/keys/{ssh_key_identifier}"
    path_format_arguments = {
        "ssh_key_identifier": _SERIALIZER.url(
            "ssh_key_identifier", ssh_key_identifier, "object"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_ssh_keys_update_request(
    ssh_key_identifier: JSON, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/account/keys/{ssh_key_identifier}"
    path_format_arguments = {
        "ssh_key_identifier": _SERIALIZER.url(
            "ssh_key_identifier", ssh_key_identifier, "object"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_ssh_keys_delete_request(
    ssh_key_identifier: JSON, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/account/keys/{ssh_key_identifier}"
    path_format_arguments = {
        "ssh_key_identifier": _SERIALIZER.url(
            "ssh_key_identifier", ssh_key_identifier, "object"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_actions_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/actions"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_actions_get_request(action_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/actions/{action_id}"
    path_format_arguments = {
        "action_id": _SERIALIZER.url("action_id", action_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_list_request(
    *, page: int = 1, per_page: int = 20, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps"

    # Construct parameters
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_apps_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_delete_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_apps_get_request(
    id: str, *, name: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_apps_update_request(id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{id}"
    path_format_arguments = {
        "id": _SERIALIZER.url("id", id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_apps_list_deployments_request(
    app_id: str, *, page: int = 1, per_page: int = 20, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/deployments"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_apps_create_deployment_request(app_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/deployments"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_get_deployment_request(
    app_id: str, deployment_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/deployments/{deployment_id}"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
        "deployment_id": _SERIALIZER.url("deployment_id", deployment_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_cancel_deployment_request(
    app_id: str, deployment_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/deployments/{deployment_id}/cancel"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
        "deployment_id": _SERIALIZER.url("deployment_id", deployment_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_get_logs_request(
    app_id: str,
    deployment_id: str,
    component_name: str,
    *,
    follow: Optional[bool] = None,
    type: str = "UNSPECIFIED",
    pod_connection_timeout: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = (
        "/v2/apps/{app_id}/deployments/{deployment_id}/components/{component_name}/logs"
    )
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
        "deployment_id": _SERIALIZER.url("deployment_id", deployment_id, "str"),
        "component_name": _SERIALIZER.url("component_name", component_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if follow is not None:
        _params["follow"] = _SERIALIZER.query("follow", follow, "bool")
    _params["type"] = _SERIALIZER.query("type", type, "str")
    if pod_connection_timeout is not None:
        _params["pod_connection_timeout"] = _SERIALIZER.query(
            "pod_connection_timeout", pod_connection_timeout, "str"
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_apps_get_logs_aggregate_request(
    app_id: str,
    deployment_id: str,
    *,
    follow: Optional[bool] = None,
    type: str = "UNSPECIFIED",
    pod_connection_timeout: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/deployments/{deployment_id}/logs"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
        "deployment_id": _SERIALIZER.url("deployment_id", deployment_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if follow is not None:
        _params["follow"] = _SERIALIZER.query("follow", follow, "bool")
    _params["type"] = _SERIALIZER.query("type", type, "str")
    if pod_connection_timeout is not None:
        _params["pod_connection_timeout"] = _SERIALIZER.query(
            "pod_connection_timeout", pod_connection_timeout, "str"
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_apps_list_tiers_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/tiers"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_get_tier_request(slug: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/tiers/{slug}"
    path_format_arguments = {
        "slug": _SERIALIZER.url("slug", slug, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_list_instance_sizes_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/tiers/instance_sizes"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_get_instance_size_request(slug: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/tiers/instance_sizes/{slug}"
    path_format_arguments = {
        "slug": _SERIALIZER.url("slug", slug, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_list_regions_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/regions"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_validate_app_spec_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/propose"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_list_alerts_request(app_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/alerts"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_apps_assign_alert_destinations_request(
    app_id: str, alert_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/alerts/{alert_id}/destinations"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
        "alert_id": _SERIALIZER.url("alert_id", alert_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_create_rollback_request(app_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/rollback"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_validate_rollback_request(app_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/rollback/validate"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_commit_rollback_request(app_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/rollback/commit"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_apps_revert_rollback_request(app_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/apps/{app_id}/rollback/revert"
    path_format_arguments = {
        "app_id": _SERIALIZER.url("app_id", app_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_cdn_list_endpoints_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/cdn/endpoints"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_cdn_create_endpoint_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/cdn/endpoints"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_cdn_get_endpoint_request(cdn_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/cdn/endpoints/{cdn_id}"
    path_format_arguments = {
        "cdn_id": _SERIALIZER.url("cdn_id", cdn_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_cdn_update_endpoints_request(cdn_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/cdn/endpoints/{cdn_id}"
    path_format_arguments = {
        "cdn_id": _SERIALIZER.url("cdn_id", cdn_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_cdn_delete_endpoint_request(cdn_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/cdn/endpoints/{cdn_id}"
    path_format_arguments = {
        "cdn_id": _SERIALIZER.url("cdn_id", cdn_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_cdn_purge_cache_request(cdn_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/cdn/endpoints/{cdn_id}/cache"
    path_format_arguments = {
        "cdn_id": _SERIALIZER.url("cdn_id", cdn_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_certificates_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/certificates"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_certificates_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/certificates"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_certificates_get_request(certificate_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/certificates/{certificate_id}"
    path_format_arguments = {
        "certificate_id": _SERIALIZER.url("certificate_id", certificate_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_certificates_delete_request(
    certificate_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/certificates/{certificate_id}"
    path_format_arguments = {
        "certificate_id": _SERIALIZER.url("certificate_id", certificate_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_balance_get_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/customers/my/balance"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_billing_history_list_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/customers/my/billing_history"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_invoices_list_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/customers/my/invoices"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_invoices_get_by_uuid_request(invoice_uuid: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/customers/my/invoices/{invoice_uuid}"
    path_format_arguments = {
        "invoice_uuid": _SERIALIZER.url("invoice_uuid", invoice_uuid, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_invoices_get_csv_by_uuid_request(
    invoice_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "text/csv, application/json")

    # Construct URL
    _url = "/v2/customers/my/invoices/{invoice_uuid}/csv"
    path_format_arguments = {
        "invoice_uuid": _SERIALIZER.url("invoice_uuid", invoice_uuid, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_invoices_get_pdf_by_uuid_request(
    invoice_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/pdf, application/json")

    # Construct URL
    _url = "/v2/customers/my/invoices/{invoice_uuid}/pdf"
    path_format_arguments = {
        "invoice_uuid": _SERIALIZER.url("invoice_uuid", invoice_uuid, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_invoices_get_summary_by_uuid_request(
    invoice_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/customers/my/invoices/{invoice_uuid}/summary"
    path_format_arguments = {
        "invoice_uuid": _SERIALIZER.url("invoice_uuid", invoice_uuid, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_list_options_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/options"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_list_clusters_request(
    *, tag_name: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases"

    # Construct parameters
    if tag_name is not None:
        _params["tag_name"] = _SERIALIZER.query("tag_name", tag_name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_databases_create_cluster_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_databases_get_cluster_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_destroy_cluster_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_databases_get_config_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/config"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_patch_config_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/config"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_databases_get_ca_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/ca"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_get_migration_status_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/online-migration"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_update_online_migration_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/online-migration"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_delete_online_migration_request(
    database_cluster_uuid: str, migration_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/online-migration/{migration_id}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "migration_id": _SERIALIZER.url("migration_id", migration_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_databases_update_region_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/migrate"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_update_cluster_size_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/resize"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_list_firewall_rules_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/firewall"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_update_firewall_rules_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/firewall"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_update_maintenance_window_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/maintenance"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_list_backups_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/backups"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_list_replicas_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/replicas"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_create_replica_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/replicas"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_databases_get_replica_request(
    database_cluster_uuid: str, replica_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/replicas/{replica_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "replica_name": _SERIALIZER.url("replica_name", replica_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_destroy_replica_request(
    database_cluster_uuid: str, replica_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/replicas/{replica_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "replica_name": _SERIALIZER.url("replica_name", replica_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_databases_list_users_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/users"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_add_user_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/users"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_databases_get_user_request(
    database_cluster_uuid: str, username: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/users/{username}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "username": _SERIALIZER.url("username", username, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_delete_user_request(
    database_cluster_uuid: str, username: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/users/{username}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "username": _SERIALIZER.url("username", username, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_databases_reset_auth_request(
    database_cluster_uuid: str, username: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/users/{username}/reset_auth"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "username": _SERIALIZER.url("username", username, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_databases_list_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/dbs"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_add_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/dbs"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_databases_get_request(
    database_cluster_uuid: str, database_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/dbs/{database_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "database_name": _SERIALIZER.url("database_name", database_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_delete_request(
    database_cluster_uuid: str, database_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/dbs/{database_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "database_name": _SERIALIZER.url("database_name", database_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_databases_list_connection_pools_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/pools"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_add_connection_pool_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/pools"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_databases_get_connection_pool_request(
    database_cluster_uuid: str, pool_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/pools/{pool_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "pool_name": _SERIALIZER.url("pool_name", pool_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_delete_connection_pool_request(
    database_cluster_uuid: str, pool_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/pools/{pool_name}"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
        "pool_name": _SERIALIZER.url("pool_name", pool_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_databases_get_eviction_policy_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/eviction_policy"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_update_eviction_policy_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/eviction_policy"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_databases_get_sql_mode_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/sql_mode"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_databases_update_sql_mode_request(
    database_cluster_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/databases/{database_cluster_uuid}/sql_mode"
    path_format_arguments = {
        "database_cluster_uuid": _SERIALIZER.url(
            "database_cluster_uuid", database_cluster_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_domains_list_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_domains_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_domains_get_request(domain_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains/{domain_name}"
    path_format_arguments = {
        "domain_name": _SERIALIZER.url("domain_name", domain_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_domains_delete_request(domain_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains/{domain_name}"
    path_format_arguments = {
        "domain_name": _SERIALIZER.url("domain_name", domain_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_domains_list_records_request(
    domain_name: str,
    *,
    name: Optional[str] = None,
    type: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains/{domain_name}/records"
    path_format_arguments = {
        "domain_name": _SERIALIZER.url("domain_name", domain_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")
    if type is not None:
        _params["type"] = _SERIALIZER.query("type", type, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_domains_create_record_request(domain_name: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains/{domain_name}/records"
    path_format_arguments = {
        "domain_name": _SERIALIZER.url("domain_name", domain_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_domains_get_record_request(
    domain_name: str, domain_record_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains/{domain_name}/records/{domain_record_id}"
    path_format_arguments = {
        "domain_name": _SERIALIZER.url("domain_name", domain_name, "str"),
        "domain_record_id": _SERIALIZER.url(
            "domain_record_id", domain_record_id, "int"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_domains_patch_record_request(
    domain_name: str, domain_record_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains/{domain_name}/records/{domain_record_id}"
    path_format_arguments = {
        "domain_name": _SERIALIZER.url("domain_name", domain_name, "str"),
        "domain_record_id": _SERIALIZER.url(
            "domain_record_id", domain_record_id, "int"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_domains_update_record_request(
    domain_name: str, domain_record_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains/{domain_name}/records/{domain_record_id}"
    path_format_arguments = {
        "domain_name": _SERIALIZER.url("domain_name", domain_name, "str"),
        "domain_record_id": _SERIALIZER.url(
            "domain_record_id", domain_record_id, "int"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_domains_delete_record_request(
    domain_name: str, domain_record_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/domains/{domain_name}/records/{domain_record_id}"
    path_format_arguments = {
        "domain_name": _SERIALIZER.url("domain_name", domain_name, "str"),
        "domain_record_id": _SERIALIZER.url(
            "domain_record_id", domain_record_id, "int"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_droplets_list_request(
    *,
    per_page: int = 20,
    page: int = 1,
    tag_name: Optional[str] = None,
    name: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)
    if tag_name is not None:
        _params["tag_name"] = _SERIALIZER.query("tag_name", tag_name, "str")
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplets_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_droplets_destroy_by_tag_request(
    *, tag_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets"

    # Construct parameters
    _params["tag_name"] = _SERIALIZER.query("tag_name", tag_name, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="DELETE", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplets_get_request(droplet_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_droplets_destroy_request(droplet_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_droplets_list_backups_request(
    droplet_id: int, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/backups"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplets_list_snapshots_request(
    droplet_id: int, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/snapshots"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplets_list_kernels_request(
    droplet_id: int, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/kernels"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplets_list_firewalls_request(
    droplet_id: int, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/firewalls"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplets_list_neighbors_request(
    droplet_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/neighbors"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_droplets_list_associated_resources_request(
    droplet_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/destroy_with_associated_resources"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_droplets_destroy_with_associated_resources_selective_request(
    droplet_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/destroy_with_associated_resources/selective"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_droplets_destroy_with_associated_resources_dangerous_request(
    droplet_id: int, *, x_dangerous: bool, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/destroy_with_associated_resources/dangerous"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["X-Dangerous"] = _SERIALIZER.header("x_dangerous", x_dangerous, "bool")
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_droplets_get_destroy_associated_resources_status_request(
    droplet_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/destroy_with_associated_resources/status"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_droplets_destroy_retry_with_associated_resources_request(
    droplet_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/destroy_with_associated_resources/retry"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_droplets_list_neighbors_ids_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reports/droplet_neighbors_ids"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_droplet_actions_list_request(
    droplet_id: int, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/actions"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplet_actions_post_request(droplet_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/actions"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_droplet_actions_post_by_tag_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    tag_name = kwargs.pop(
        "tag_name", _params.pop("tag_name", None)
    )  # type: Optional[str]
    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/actions"

    # Construct parameters
    if tag_name is not None:
        _params["tag_name"] = _SERIALIZER.query("tag_name", tag_name, "str")

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="POST", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_droplet_actions_get_request(
    droplet_id: int, action_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/droplets/{droplet_id}/actions/{action_id}"
    path_format_arguments = {
        "droplet_id": _SERIALIZER.url("droplet_id", droplet_id, "int", minimum=1),
        "action_id": _SERIALIZER.url("action_id", action_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_firewalls_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_firewalls_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_firewalls_get_request(firewall_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_firewalls_update_request(firewall_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_firewalls_delete_request(firewall_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_firewalls_assign_droplets_request(
    firewall_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}/droplets"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_firewalls_delete_droplets_request(
    firewall_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}/droplets"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_firewalls_add_tags_request(firewall_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}/tags"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_firewalls_delete_tags_request(firewall_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}/tags"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_firewalls_add_rules_request(firewall_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}/rules"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_firewalls_delete_rules_request(
    firewall_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/firewalls/{firewall_id}/rules"
    path_format_arguments = {
        "firewall_id": _SERIALIZER.url("firewall_id", firewall_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_functions_list_namespaces_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/functions/namespaces"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_functions_create_namespace_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/functions/namespaces"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_functions_get_namespace_request(
    namespace_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/functions/namespaces/{namespace_id}"
    path_format_arguments = {
        "namespace_id": _SERIALIZER.url("namespace_id", namespace_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_functions_delete_namespace_request(
    namespace_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/functions/namespaces/{namespace_id}"
    path_format_arguments = {
        "namespace_id": _SERIALIZER.url("namespace_id", namespace_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_images_list_request(
    *,
    type: Optional[str] = None,
    private: Optional[bool] = None,
    tag_name: Optional[str] = None,
    per_page: int = 20,
    page: int = 1,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/images"

    # Construct parameters
    if type is not None:
        _params["type"] = _SERIALIZER.query("type", type, "str")
    if private is not None:
        _params["private"] = _SERIALIZER.query("private", private, "bool")
    if tag_name is not None:
        _params["tag_name"] = _SERIALIZER.query("tag_name", tag_name, "str")
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_images_create_custom_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/images"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_images_get_request(image_id: JSON, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/images/{image_id}"
    path_format_arguments = {
        "image_id": _SERIALIZER.url("image_id", image_id, "object"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_images_update_request(image_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/images/{image_id}"
    path_format_arguments = {
        "image_id": _SERIALIZER.url("image_id", image_id, "int"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_images_delete_request(image_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/images/{image_id}"
    path_format_arguments = {
        "image_id": _SERIALIZER.url("image_id", image_id, "int"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_image_actions_list_request(image_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/images/{image_id}/actions"
    path_format_arguments = {
        "image_id": _SERIALIZER.url("image_id", image_id, "int"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_image_actions_post_request(image_id: int, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/images/{image_id}/actions"
    path_format_arguments = {
        "image_id": _SERIALIZER.url("image_id", image_id, "int"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_image_actions_get_request(
    image_id: int, action_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/images/{image_id}/actions/{action_id}"
    path_format_arguments = {
        "image_id": _SERIALIZER.url("image_id", image_id, "int"),
        "action_id": _SERIALIZER.url("action_id", action_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_kubernetes_list_clusters_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_kubernetes_create_cluster_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_kubernetes_get_cluster_request(cluster_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_kubernetes_update_cluster_request(
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_kubernetes_delete_cluster_request(
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_kubernetes_list_associated_resources_request(
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/destroy_with_associated_resources"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_kubernetes_destroy_associated_resources_selective_request(
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/destroy_with_associated_resources/selective"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_kubernetes_destroy_associated_resources_dangerous_request(
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/destroy_with_associated_resources/dangerous"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_kubernetes_get_kubeconfig_request(
    cluster_id: str, *, expiry_seconds: int = 0, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/kubeconfig"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if expiry_seconds is not None:
        _params["expiry_seconds"] = _SERIALIZER.query(
            "expiry_seconds", expiry_seconds, "int", minimum=0
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_kubernetes_get_credentials_request(
    cluster_id: str, *, expiry_seconds: int = 0, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/credentials"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if expiry_seconds is not None:
        _params["expiry_seconds"] = _SERIALIZER.query(
            "expiry_seconds", expiry_seconds, "int", minimum=0
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_kubernetes_get_available_upgrades_request(
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/upgrades"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_kubernetes_upgrade_cluster_request(
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/upgrade"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_kubernetes_list_node_pools_request(
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/node_pools"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_kubernetes_add_node_pool_request(
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/node_pools"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_kubernetes_get_node_pool_request(
    cluster_id: str, node_pool_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/node_pools/{node_pool_id}"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
        "node_pool_id": _SERIALIZER.url("node_pool_id", node_pool_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_kubernetes_update_node_pool_request(
    cluster_id: str, node_pool_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/node_pools/{node_pool_id}"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
        "node_pool_id": _SERIALIZER.url("node_pool_id", node_pool_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_kubernetes_delete_node_pool_request(
    cluster_id: str, node_pool_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/node_pools/{node_pool_id}"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
        "node_pool_id": _SERIALIZER.url("node_pool_id", node_pool_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_kubernetes_delete_node_request(
    cluster_id: str,
    node_pool_id: str,
    node_id: str,
    *,
    skip_drain: int = 0,
    replace: int = 0,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = (
        "/v2/kubernetes/clusters/{cluster_id}/node_pools/{node_pool_id}/nodes/{node_id}"
    )
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
        "node_pool_id": _SERIALIZER.url("node_pool_id", node_pool_id, "str"),
        "node_id": _SERIALIZER.url("node_id", node_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if skip_drain is not None:
        _params["skip_drain"] = _SERIALIZER.query(
            "skip_drain", skip_drain, "int", maximum=1, minimum=0
        )
    if replace is not None:
        _params["replace"] = _SERIALIZER.query(
            "replace", replace, "int", maximum=1, minimum=0
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="DELETE", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_kubernetes_recycle_node_pool_request(
    cluster_id: str, node_pool_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/node_pools/{node_pool_id}/recycle"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
        "node_pool_id": _SERIALIZER.url("node_pool_id", node_pool_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_kubernetes_get_cluster_user_request(
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/user"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_kubernetes_list_options_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/options"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_kubernetes_run_cluster_lint_request(
    cluster_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/clusterlint"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_kubernetes_get_cluster_lint_results_request(
    cluster_id: str, *, run_id: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/clusters/{cluster_id}/clusterlint"
    path_format_arguments = {
        "cluster_id": _SERIALIZER.url("cluster_id", cluster_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if run_id is not None:
        _params["run_id"] = _SERIALIZER.query("run_id", run_id, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_kubernetes_add_registry_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/registry"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_kubernetes_remove_registry_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/kubernetes/registry"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_load_balancers_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_load_balancers_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_load_balancers_get_request(lb_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers/{lb_id}"
    path_format_arguments = {
        "lb_id": _SERIALIZER.url("lb_id", lb_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_load_balancers_update_request(lb_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers/{lb_id}"
    path_format_arguments = {
        "lb_id": _SERIALIZER.url("lb_id", lb_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_load_balancers_delete_request(lb_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers/{lb_id}"
    path_format_arguments = {
        "lb_id": _SERIALIZER.url("lb_id", lb_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_load_balancers_add_droplets_request(lb_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers/{lb_id}/droplets"
    path_format_arguments = {
        "lb_id": _SERIALIZER.url("lb_id", lb_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_load_balancers_remove_droplets_request(
    lb_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers/{lb_id}/droplets"
    path_format_arguments = {
        "lb_id": _SERIALIZER.url("lb_id", lb_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_load_balancers_add_forwarding_rules_request(
    lb_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers/{lb_id}/forwarding_rules"
    path_format_arguments = {
        "lb_id": _SERIALIZER.url("lb_id", lb_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_load_balancers_remove_forwarding_rules_request(
    lb_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/load_balancers/{lb_id}/forwarding_rules"
    path_format_arguments = {
        "lb_id": _SERIALIZER.url("lb_id", lb_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_monitoring_list_alert_policy_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/alerts"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_create_alert_policy_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/alerts"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_monitoring_get_alert_policy_request(
    alert_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/alerts/{alert_uuid}"
    path_format_arguments = {
        "alert_uuid": _SERIALIZER.url("alert_uuid", alert_uuid, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_monitoring_update_alert_policy_request(
    alert_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/alerts/{alert_uuid}"
    path_format_arguments = {
        "alert_uuid": _SERIALIZER.url("alert_uuid", alert_uuid, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_monitoring_delete_alert_policy_request(
    alert_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/alerts/{alert_uuid}"
    path_format_arguments = {
        "alert_uuid": _SERIALIZER.url("alert_uuid", alert_uuid, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_monitoring_get_droplet_bandwidth_metrics_request(
    *, host_id: str, interface: str, direction: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/bandwidth"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["interface"] = _SERIALIZER.query("interface", interface, "str")
    _params["direction"] = _SERIALIZER.query("direction", direction, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_cpu_metrics_request(
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/cpu"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_filesystem_free_metrics_request(
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/filesystem_free"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_filesystem_size_metrics_request(
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/filesystem_size"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_load1_metrics_request(
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/load_1"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_load5_metrics_request(
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/load_5"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_load15_metrics_request(
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/load_15"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_memory_cached_metrics_request(
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/memory_cached"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_memory_free_metrics_request(
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/memory_free"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_memory_total_metrics_request(
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/memory_total"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_monitoring_get_droplet_memory_available_metrics_request(
    *, host_id: str, start: str, end: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/monitoring/metrics/droplet/memory_available"

    # Construct parameters
    _params["host_id"] = _SERIALIZER.query("host_id", host_id, "str")
    _params["start"] = _SERIALIZER.query("start", start, "str")
    _params["end"] = _SERIALIZER.query("end", end, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_projects_list_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_projects_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_projects_get_default_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/default"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_projects_update_default_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/default"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_projects_patch_default_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/default"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_projects_get_request(project_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/{project_id}"
    path_format_arguments = {
        "project_id": _SERIALIZER.url("project_id", project_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_projects_update_request(project_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/{project_id}"
    path_format_arguments = {
        "project_id": _SERIALIZER.url("project_id", project_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_projects_patch_request(project_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/{project_id}"
    path_format_arguments = {
        "project_id": _SERIALIZER.url("project_id", project_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_projects_delete_request(project_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/{project_id}"
    path_format_arguments = {
        "project_id": _SERIALIZER.url("project_id", project_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_projects_list_resources_request(
    project_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/{project_id}/resources"
    path_format_arguments = {
        "project_id": _SERIALIZER.url("project_id", project_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_projects_assign_resources_request(
    project_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/{project_id}/resources"
    path_format_arguments = {
        "project_id": _SERIALIZER.url("project_id", project_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_projects_list_resources_default_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/default/resources"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_projects_assign_resources_default_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/projects/default/resources"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_regions_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/regions"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_registry_get_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_registry_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_registry_delete_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_registry_get_subscription_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/subscription"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_registry_update_subscription_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/subscription"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_registry_get_docker_credentials_request(
    *, expiry_seconds: int = 0, read_write: bool = False, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/docker-credentials"

    # Construct parameters
    if expiry_seconds is not None:
        _params["expiry_seconds"] = _SERIALIZER.query(
            "expiry_seconds", expiry_seconds, "int", minimum=0
        )
    if read_write is not None:
        _params["read_write"] = _SERIALIZER.query("read_write", read_write, "bool")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_registry_validate_name_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/validate-name"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_registry_list_repositories_request(
    registry_name: str, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/repositories"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_registry_list_repositories_v2_request(
    registry_name: str,
    *,
    per_page: int = 20,
    page: int = 1,
    page_token: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/repositoriesV2"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)
    if page_token is not None:
        _params["page_token"] = _SERIALIZER.query("page_token", page_token, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_registry_list_repository_tags_request(
    registry_name: str,
    repository_name: str,
    *,
    per_page: int = 20,
    page: int = 1,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/{repository_name}/tags"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
        "repository_name": _SERIALIZER.url("repository_name", repository_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_registry_delete_repository_tag_request(
    registry_name: str, repository_name: str, repository_tag: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/{repository_name}/tags/{repository_tag}"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
        "repository_name": _SERIALIZER.url("repository_name", repository_name, "str"),
        "repository_tag": _SERIALIZER.url("repository_tag", repository_tag, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_registry_list_repository_manifests_request(
    registry_name: str,
    repository_name: str,
    *,
    per_page: int = 20,
    page: int = 1,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/{repository_name}/digests"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
        "repository_name": _SERIALIZER.url("repository_name", repository_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_registry_delete_repository_manifest_request(
    registry_name: str, repository_name: str, manifest_digest: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/{repository_name}/digests/{manifest_digest}"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
        "repository_name": _SERIALIZER.url("repository_name", repository_name, "str"),
        "manifest_digest": _SERIALIZER.url("manifest_digest", manifest_digest, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_registry_run_garbage_collection_request(
    registry_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/garbage-collection"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_registry_get_garbage_collection_request(
    registry_name: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/garbage-collection"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_registry_list_garbage_collections_request(
    registry_name: str, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/garbage-collections"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_registry_update_garbage_collection_request(
    registry_name: str, garbage_collection_uuid: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/{registry_name}/garbage-collection/{garbage_collection_uuid}"
    path_format_arguments = {
        "registry_name": _SERIALIZER.url("registry_name", registry_name, "str"),
        "garbage_collection_uuid": _SERIALIZER.url(
            "garbage_collection_uuid", garbage_collection_uuid, "str"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_registry_get_options_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/registry/options"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_reserved_ips_list_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ips"

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_reserved_ips_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ips"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_reserved_ips_get_request(reserved_ip: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ips/{reserved_ip}"
    path_format_arguments = {
        "reserved_ip": _SERIALIZER.url("reserved_ip", reserved_ip, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_reserved_ips_delete_request(reserved_ip: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ips/{reserved_ip}"
    path_format_arguments = {
        "reserved_ip": _SERIALIZER.url("reserved_ip", reserved_ip, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_reserved_ips_actions_list_request(
    reserved_ip: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ips/{reserved_ip}/actions"
    path_format_arguments = {
        "reserved_ip": _SERIALIZER.url("reserved_ip", reserved_ip, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_reserved_ips_actions_post_request(
    reserved_ip: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ips/{reserved_ip}/actions"
    path_format_arguments = {
        "reserved_ip": _SERIALIZER.url("reserved_ip", reserved_ip, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_reserved_ips_actions_get_request(
    reserved_ip: str, action_id: int, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/reserved_ips/{reserved_ip}/actions/{action_id}"
    path_format_arguments = {
        "reserved_ip": _SERIALIZER.url("reserved_ip", reserved_ip, "str"),
        "action_id": _SERIALIZER.url("action_id", action_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_sizes_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/sizes"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_snapshots_list_request(
    *,
    per_page: int = 20,
    page: int = 1,
    resource_type: Optional[str] = None,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/snapshots"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)
    if resource_type is not None:
        _params["resource_type"] = _SERIALIZER.query(
            "resource_type", resource_type, "str"
        )

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_snapshots_get_request(snapshot_id: JSON, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/snapshots/{snapshot_id}"
    path_format_arguments = {
        "snapshot_id": _SERIALIZER.url("snapshot_id", snapshot_id, "object"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_snapshots_delete_request(snapshot_id: JSON, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/snapshots/{snapshot_id}"
    path_format_arguments = {
        "snapshot_id": _SERIALIZER.url("snapshot_id", snapshot_id, "object"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_tags_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/tags"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_tags_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/tags"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_tags_get_request(tag_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/tags/{tag_id}"
    path_format_arguments = {
        "tag_id": _SERIALIZER.url(
            "tag_id", tag_id, "str", max_length=255, pattern=r"^[a-zA-Z0-9_\-\:]+$"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_tags_delete_request(tag_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/tags/{tag_id}"
    path_format_arguments = {
        "tag_id": _SERIALIZER.url(
            "tag_id", tag_id, "str", max_length=255, pattern=r"^[a-zA-Z0-9_\-\:]+$"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_tags_assign_resources_request(tag_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/tags/{tag_id}/resources"
    path_format_arguments = {
        "tag_id": _SERIALIZER.url(
            "tag_id", tag_id, "str", max_length=255, pattern=r"^[a-zA-Z0-9_\-\:]+$"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_tags_unassign_resources_request(tag_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/tags/{tag_id}/resources"
    path_format_arguments = {
        "tag_id": _SERIALIZER.url(
            "tag_id", tag_id, "str", max_length=255, pattern=r"^[a-zA-Z0-9_\-\:]+$"
        ),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_volumes_list_request(
    *,
    name: Optional[str] = None,
    region: Optional[str] = None,
    per_page: int = 20,
    page: int = 1,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes"

    # Construct parameters
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")
    if region is not None:
        _params["region"] = _SERIALIZER.query("region", region, "str")
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_volumes_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_volumes_delete_by_name_request(
    *, name: Optional[str] = None, region: Optional[str] = None, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes"

    # Construct parameters
    if name is not None:
        _params["name"] = _SERIALIZER.query("name", name, "str")
    if region is not None:
        _params["region"] = _SERIALIZER.query("region", region, "str")

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="DELETE", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_volumes_get_request(volume_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/{volume_id}"
    path_format_arguments = {
        "volume_id": _SERIALIZER.url("volume_id", volume_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_volumes_delete_request(volume_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/{volume_id}"
    path_format_arguments = {
        "volume_id": _SERIALIZER.url("volume_id", volume_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_volume_actions_post_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    per_page = kwargs.pop("per_page", _params.pop("per_page", 20))  # type: int
    page = kwargs.pop("page", _params.pop("page", 1))  # type: int
    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/actions"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="POST", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_volume_actions_list_request(
    volume_id: str, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/{volume_id}/actions"
    path_format_arguments = {
        "volume_id": _SERIALIZER.url("volume_id", volume_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_volume_actions_post_by_id_request(
    volume_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    per_page = kwargs.pop("per_page", _params.pop("per_page", 20))  # type: int
    page = kwargs.pop("page", _params.pop("page", 1))  # type: int
    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/{volume_id}/actions"
    path_format_arguments = {
        "volume_id": _SERIALIZER.url("volume_id", volume_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="POST", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_volume_actions_get_request(
    volume_id: str, action_id: int, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/{volume_id}/actions/{action_id}"
    path_format_arguments = {
        "volume_id": _SERIALIZER.url("volume_id", volume_id, "str"),
        "action_id": _SERIALIZER.url("action_id", action_id, "int", minimum=1),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_volume_snapshots_get_by_id_request(
    snapshot_id: JSON, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/snapshots/{snapshot_id}"
    path_format_arguments = {
        "snapshot_id": _SERIALIZER.url("snapshot_id", snapshot_id, "object"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_volume_snapshots_delete_by_id_request(
    snapshot_id: JSON, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/snapshots/{snapshot_id}"
    path_format_arguments = {
        "snapshot_id": _SERIALIZER.url("snapshot_id", snapshot_id, "object"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_volume_snapshots_list_request(
    volume_id: str, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/{volume_id}/snapshots"
    path_format_arguments = {
        "volume_id": _SERIALIZER.url("volume_id", volume_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_volume_snapshots_create_request(volume_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/volumes/{volume_id}/snapshots"
    path_format_arguments = {
        "volume_id": _SERIALIZER.url("volume_id", volume_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_vpcs_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_vpcs_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_vpcs_get_request(vpc_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs/{vpc_id}"
    path_format_arguments = {
        "vpc_id": _SERIALIZER.url("vpc_id", vpc_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_vpcs_update_request(vpc_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs/{vpc_id}"
    path_format_arguments = {
        "vpc_id": _SERIALIZER.url("vpc_id", vpc_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_vpcs_patch_request(vpc_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs/{vpc_id}"
    path_format_arguments = {
        "vpc_id": _SERIALIZER.url("vpc_id", vpc_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PATCH", url=_url, headers=_headers, **kwargs)


def build_vpcs_delete_request(vpc_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs/{vpc_id}"
    path_format_arguments = {
        "vpc_id": _SERIALIZER.url("vpc_id", vpc_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_vpcs_list_members_request(
    vpc_id: str,
    *,
    resource_type: Optional[str] = None,
    per_page: int = 20,
    page: int = 1,
    **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/vpcs/{vpc_id}/members"
    path_format_arguments = {
        "vpc_id": _SERIALIZER.url("vpc_id", vpc_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if resource_type is not None:
        _params["resource_type"] = _SERIALIZER.query(
            "resource_type", resource_type, "str"
        )
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_uptime_checks_list_request(
    *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks"

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_uptime_check_create_request(**kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks"

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_uptime_check_get_request(check_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_uptime_check_update_request(check_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_uptime_check_delete_request(check_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


def build_uptime_check_state_get_request(check_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}/state"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_uptime_check_alerts_list_request(
    check_id: str, *, per_page: int = 20, page: int = 1, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
    _params = case_insensitive_dict(kwargs.pop("params", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}/alerts"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct parameters
    if per_page is not None:
        _params["per_page"] = _SERIALIZER.query(
            "per_page", per_page, "int", maximum=200, minimum=1
        )
    if page is not None:
        _params["page"] = _SERIALIZER.query("page", page, "int", minimum=1)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(
        method="GET", url=_url, params=_params, headers=_headers, **kwargs
    )


def build_uptime_alert_create_request(check_id: str, **kwargs: Any) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}/alerts"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="POST", url=_url, headers=_headers, **kwargs)


def build_uptime_alert_get_request(
    check_id: str, alert_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}/alerts/{alert_id}"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
        "alert_id": _SERIALIZER.url("alert_id", alert_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="GET", url=_url, headers=_headers, **kwargs)


def build_uptime_alert_update_request(
    check_id: str, alert_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    content_type = kwargs.pop(
        "content_type", _headers.pop("Content-Type", None)
    )  # type: Optional[str]
    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}/alerts/{alert_id}"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
        "alert_id": _SERIALIZER.url("alert_id", alert_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    if content_type is not None:
        _headers["Content-Type"] = _SERIALIZER.header(
            "content_type", content_type, "str"
        )
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="PUT", url=_url, headers=_headers, **kwargs)


def build_uptime_alert_delete_request(
    check_id: str, alert_id: str, **kwargs: Any
) -> HttpRequest:
    _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})

    accept = _headers.pop("Accept", "application/json")

    # Construct URL
    _url = "/v2/uptime/checks/{check_id}/alerts/{alert_id}"
    path_format_arguments = {
        "check_id": _SERIALIZER.url("check_id", check_id, "str"),
        "alert_id": _SERIALIZER.url("alert_id", alert_id, "str"),
    }

    _url = _format_url_section(_url, **path_format_arguments)

    # Construct headers
    _headers["Accept"] = _SERIALIZER.header("accept", accept, "str")

    return HttpRequest(method="DELETE", url=_url, headers=_headers, **kwargs)


class OneClicksOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~pydo.GeneratedClient`'s
        :attr:`one_clicks` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @distributed_trace
    def list(self, *, type: Optional[str] = None, **kwargs: Any) -> JSON:
        """List 1-Click Applications.

        To list all available 1-Click applications, send a GET request to ``/v2/1-clicks``. The
        ``type`` may
        be provided as query paramater in order to restrict results to a certain type of 1-Click, for
        example: ``/v2/1-clicks?type=droplet``. Current supported types are ``kubernetes`` and
        ``droplet``.

        The response will be a JSON object with a key called ``1_clicks``. This will be set to an array
        of
        1-Click application data, each of which will contain the the slug and type for the 1-Click.

        :keyword type: Restrict results to a certain type of 1-Click. Known values are: "droplet" and
         "kubernetes". Default value is None.
        :paramtype type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "1_clicks": [
                        {
                            "slug": "str",  # The slug identifier for the 1-Click
                              application. Required.
                            "type": "str"  # The type of the 1-Click application.
                              Required.
                        }
                    ]
                }
                # response body for status code(s): 401, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_one_clicks_list_request(
            type=type,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 429, 500]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 401:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 429:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 500:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)

        return cast(JSON, deserialized)

    @overload
    def install_kubernetes(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Install Kubernetes 1-Click Applications.

        To install a Kubernetes 1-Click application on a cluster, send a POST request to
        ``/v2/1-clicks/kubernetes``. The ``addon_slugs`` and ``cluster_uuid`` must be provided as body
        parameter in order to specify which 1-Click application(s) to install. To list all available
        1-Click Kubernetes applications, send a request to ``/v2/1-clicks?type=kubernetes``.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "addon_slugs": [
                        "str"  # An array of 1-Click Application slugs to be installed to the
                          Kubernetes cluster. Required.
                    ],
                    "cluster_uuid": "str"  # A unique ID for the Kubernetes cluster to which the
                      1-Click Applications will be installed. Required.
                }

                # response body for status code(s): 200
                response == {
                    "message": "str"  # Optional. A message about the result of the request.
                }
                # response body for status code(s): 401, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """

    @overload
    def install_kubernetes(
        self, body: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Install Kubernetes 1-Click Applications.

        To install a Kubernetes 1-Click application on a cluster, send a POST request to
        ``/v2/1-clicks/kubernetes``. The ``addon_slugs`` and ``cluster_uuid`` must be provided as body
        parameter in order to specify which 1-Click application(s) to install. To list all available
        1-Click Kubernetes applications, send a request to ``/v2/1-clicks?type=kubernetes``.

        :param body: Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "message": "str"  # Optional. A message about the result of the request.
                }
                # response body for status code(s): 401, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """

    @distributed_trace
    def install_kubernetes(self, body: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Install Kubernetes 1-Click Applications.

        To install a Kubernetes 1-Click application on a cluster, send a POST request to
        ``/v2/1-clicks/kubernetes``. The ``addon_slugs`` and ``cluster_uuid`` must be provided as body
        parameter in order to specify which 1-Click application(s) to install. To list all available
        1-Click Kubernetes applications, send a request to ``/v2/1-clicks?type=kubernetes``.

        :param body: Is either a model type or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "message": "str"  # Optional. A message about the result of the request.
                }
                # response body for status code(s): 401, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_one_clicks_install_kubernetes_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 429, 500]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 401:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 429:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 500:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)

        return cast(JSON, deserialized)


class AccountOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~pydo.GeneratedClient`'s
        :attr:`account` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @distributed_trace
    def get(self, **kwargs: Any) -> JSON:
        """Get User Information.

        To show information about the current user account, send a GET request to ``/v2/account``.

        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "account": {
                        "droplet_limit": 0,  # The total number of Droplets current user or
                          team may have active at one time. Required.
                        "email": "str",  # The email address used by the current user to
                          register for DigitalOcean. Required.
                        "email_verified": False,  # Default value is False. If true, the user
                          has verified their account via email. False otherwise. Required.
                        "floating_ip_limit": 0,  # The total number of Floating IPs the
                          current user or team may have. Required.
                        "status": "active",  # Default value is "active". This value is one
                          of "active", "warning" or "locked". Known values are: "active", "warning",
                          and "locked".
                        "status_message": "str",  # A human-readable message giving more
                          details about the status of the account. Required.
                        "team": {
                            "name": "str",  # Optional. The name for the current team.
                            "uuid": "str"  # Optional. The unique universal identifier
                              for the current team.
                        },
                        "uuid": "str"  # The unique universal identifier for the current
                          user. Required.
                    }
                }
                # response body for status code(s): 401, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_account_get_request(
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 429, 500]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 401:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 429:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 500:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)

        return cast(JSON, deserialized)


class SshKeysOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~pydo.GeneratedClient`'s
        :attr:`ssh_keys` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @distributed_trace
    def list(self, *, per_page: int = 20, page: int = 1, **kwargs: Any) -> JSON:
        """List All SSH Keys.

        To list all of the keys in your account, send a GET request to ``/v2/account/keys``. The
        response will be a JSON object with a key set to ``ssh_keys``. The value of this will be an
        array of ssh_key objects, each of which contains the standard ssh_key attributes.

        :keyword per_page: Number of items returned per page. Default value is 20.
        :paramtype per_page: int
        :keyword page: Which 'page' of paginated results to return. Default value is 1.
        :paramtype page: int
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "links": {
                        "pages": {}
                    },
                    "meta": {
                        "total": 0  # Optional. Number of objects returned by the request.
                    },
                    "ssh_keys": [
                        {
                            "fingerprint": "str",  # Optional. A unique identifier that
                              differentiates this key from other keys using  a format that SSH
                              recognizes. The fingerprint is created when the key is added to your
                              account.
                            "id": 0,  # Optional. A unique identification number for this
                              key. Can be used to embed a  specific SSH key into a Droplet.
                            "name": "str",  # A human-readable display name for this key,
                              used to easily identify the SSH keys when they are displayed. Required.
                            "public_key": "str"  # The entire public key string that was
                              uploaded. Embedded into the root user's ``authorized_keys`` file if you
                              include this key during Droplet creation. Required.
                        }
                    ]
                }
                # response body for status code(s): 401, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_ssh_keys_list_request(
            per_page=per_page,
            page=page,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 429, 500]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 401:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 429:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 500:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)

        return cast(JSON, deserialized)

    @overload
    def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a New SSH Key.

        To add a new SSH public key to your DigitalOcean account, send a POST request to
        ``/v2/account/keys``. Set the ``name`` attribute to the name you wish to use and the
        ``public_key`` attribute to the full public key you are adding.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "fingerprint": "str",  # Optional. A unique identifier that differentiates
                      this key from other keys using  a format that SSH recognizes. The fingerprint is
                      created when the key is added to your account.
                    "id": 0,  # Optional. A unique identification number for this key. Can be
                      used to embed a  specific SSH key into a Droplet.
                    "name": "str",  # A human-readable display name for this key, used to easily
                      identify the SSH keys when they are displayed. Required.
                    "public_key": "str"  # The entire public key string that was uploaded.
                      Embedded into the root user's ``authorized_keys`` file if you include this key
                      during Droplet creation. Required.
                }

                # response body for status code(s): 201
                response == {
                    "ssh_key": {
                        "fingerprint": "str",  # Optional. A unique identifier that
                          differentiates this key from other keys using  a format that SSH recognizes.
                          The fingerprint is created when the key is added to your account.
                        "id": 0,  # Optional. A unique identification number for this key.
                          Can be used to embed a  specific SSH key into a Droplet.
                        "name": "str",  # A human-readable display name for this key, used to
                          easily identify the SSH keys when they are displayed. Required.
                        "public_key": "str"  # The entire public key string that was
                          uploaded. Embedded into the root user's ``authorized_keys`` file if you
                          include this key during Droplet creation. Required.
                    }
                }
                # response body for status code(s): 401, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """

    @overload
    def create(
        self, body: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a New SSH Key.

        To add a new SSH public key to your DigitalOcean account, send a POST request to
        ``/v2/account/keys``. Set the ``name`` attribute to the name you wish to use and the
        ``public_key`` attribute to the full public key you are adding.

        :param body: Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 201
                response == {
                    "ssh_key": {
                        "fingerprint": "str",  # Optional. A unique identifier that
                          differentiates this key from other keys using  a format that SSH recognizes.
                          The fingerprint is created when the key is added to your account.
                        "id": 0,  # Optional. A unique identification number for this key.
                          Can be used to embed a  specific SSH key into a Droplet.
                        "name": "str",  # A human-readable display name for this key, used to
                          easily identify the SSH keys when they are displayed. Required.
                        "public_key": "str"  # The entire public key string that was
                          uploaded. Embedded into the root user's ``authorized_keys`` file if you
                          include this key during Droplet creation. Required.
                    }
                }
                # response body for status code(s): 401, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """

    @distributed_trace
    def create(self, body: Union[JSON, IO], **kwargs: Any) -> JSON:
        """Create a New SSH Key.

        To add a new SSH public key to your DigitalOcean account, send a POST request to
        ``/v2/account/keys``. Set the ``name`` attribute to the name you wish to use and the
        ``public_key`` attribute to the full public key you are adding.

        :param body: Is either a model type or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 201
                response == {
                    "ssh_key": {
                        "fingerprint": "str",  # Optional. A unique identifier that
                          differentiates this key from other keys using  a format that SSH recognizes.
                          The fingerprint is created when the key is added to your account.
                        "id": 0,  # Optional. A unique identification number for this key.
                          Can be used to embed a  specific SSH key into a Droplet.
                        "name": "str",  # A human-readable display name for this key, used to
                          easily identify the SSH keys when they are displayed. Required.
                        "public_key": "str"  # The entire public key string that was
                          uploaded. Embedded into the root user's ``authorized_keys`` file if you
                          include this key during Droplet creation. Required.
                    }
                }
                # response body for status code(s): 401, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_ssh_keys_create_request(
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [201, 401, 429, 500]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 201:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 401:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 429:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 500:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)

        return cast(JSON, deserialized)

    @distributed_trace
    def get(self, ssh_key_identifier: JSON, **kwargs: Any) -> JSON:
        """Retrieve an Existing SSH Key.

        To get information about a key, send a GET request to ``/v2/account/keys/$KEY_ID`` or
        ``/v2/account/keys/$KEY_FINGERPRINT``.
        The response will be a JSON object with the key ``ssh_key`` and value an ssh_key object which
        contains the standard ssh_key attributes.

        :param ssh_key_identifier: Either the ID or the fingerprint of an existing SSH key. Required.
        :type ssh_key_identifier: JSON
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "ssh_key": {
                        "fingerprint": "str",  # Optional. A unique identifier that
                          differentiates this key from other keys using  a format that SSH recognizes.
                          The fingerprint is created when the key is added to your account.
                        "id": 0,  # Optional. A unique identification number for this key.
                          Can be used to embed a  specific SSH key into a Droplet.
                        "name": "str",  # A human-readable display name for this key, used to
                          easily identify the SSH keys when they are displayed. Required.
                        "public_key": "str"  # The entire public key string that was
                          uploaded. Embedded into the root user's ``authorized_keys`` file if you
                          include this key during Droplet creation. Required.
                    }
                }
                # response body for status code(s): 401, 404, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_ssh_keys_get_request(
            ssh_key_identifier=ssh_key_identifier,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404, 429, 500]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 401:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 404:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 429:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 500:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)

        return cast(JSON, deserialized)

    @overload
    def update(
        self,
        ssh_key_identifier: JSON,
        body: JSON,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Update an SSH Key's Name.

        To update the name of an SSH key, send a PUT request to either ``/v2/account/keys/$SSH_KEY_ID``
        or ``/v2/account/keys/$SSH_KEY_FINGERPRINT``. Set the ``name`` attribute to the new name you
        want to use.

        :param ssh_key_identifier: Either the ID or the fingerprint of an existing SSH key. Required.
        :type ssh_key_identifier: JSON
        :param body: Set the ``name`` attribute to the new name you want to use. Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "name": "str"  # Optional. A human-readable display name for this key, used
                      to easily identify the SSH keys when they are displayed.
                }

                # response body for status code(s): 200
                response == {
                    "ssh_key": {
                        "fingerprint": "str",  # Optional. A unique identifier that
                          differentiates this key from other keys using  a format that SSH recognizes.
                          The fingerprint is created when the key is added to your account.
                        "id": 0,  # Optional. A unique identification number for this key.
                          Can be used to embed a  specific SSH key into a Droplet.
                        "name": "str",  # A human-readable display name for this key, used to
                          easily identify the SSH keys when they are displayed. Required.
                        "public_key": "str"  # The entire public key string that was
                          uploaded. Embedded into the root user's ``authorized_keys`` file if you
                          include this key during Droplet creation. Required.
                    }
                }
                # response body for status code(s): 401, 404, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """

    @overload
    def update(
        self,
        ssh_key_identifier: JSON,
        body: IO,
        *,
        content_type: str = "application/json",
        **kwargs: Any
    ) -> JSON:
        """Update an SSH Key's Name.

        To update the name of an SSH key, send a PUT request to either ``/v2/account/keys/$SSH_KEY_ID``
        or ``/v2/account/keys/$SSH_KEY_FINGERPRINT``. Set the ``name`` attribute to the new name you
        want to use.

        :param ssh_key_identifier: Either the ID or the fingerprint of an existing SSH key. Required.
        :type ssh_key_identifier: JSON
        :param body: Set the ``name`` attribute to the new name you want to use. Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "ssh_key": {
                        "fingerprint": "str",  # Optional. A unique identifier that
                          differentiates this key from other keys using  a format that SSH recognizes.
                          The fingerprint is created when the key is added to your account.
                        "id": 0,  # Optional. A unique identification number for this key.
                          Can be used to embed a  specific SSH key into a Droplet.
                        "name": "str",  # A human-readable display name for this key, used to
                          easily identify the SSH keys when they are displayed. Required.
                        "public_key": "str"  # The entire public key string that was
                          uploaded. Embedded into the root user's ``authorized_keys`` file if you
                          include this key during Droplet creation. Required.
                    }
                }
                # response body for status code(s): 401, 404, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """

    @distributed_trace
    def update(
        self, ssh_key_identifier: JSON, body: Union[JSON, IO], **kwargs: Any
    ) -> JSON:
        """Update an SSH Key's Name.

        To update the name of an SSH key, send a PUT request to either ``/v2/account/keys/$SSH_KEY_ID``
        or ``/v2/account/keys/$SSH_KEY_FINGERPRINT``. Set the ``name`` attribute to the new name you
        want to use.

        :param ssh_key_identifier: Either the ID or the fingerprint of an existing SSH key. Required.
        :type ssh_key_identifier: JSON
        :param body: Set the ``name`` attribute to the new name you want to use. Is either a model type
         or a IO type. Required.
        :type body: JSON or IO
        :keyword content_type: Body Parameter content-type. Known values are: 'application/json'.
         Default value is None.
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "ssh_key": {
                        "fingerprint": "str",  # Optional. A unique identifier that
                          differentiates this key from other keys using  a format that SSH recognizes.
                          The fingerprint is created when the key is added to your account.
                        "id": 0,  # Optional. A unique identification number for this key.
                          Can be used to embed a  specific SSH key into a Droplet.
                        "name": "str",  # A human-readable display name for this key, used to
                          easily identify the SSH keys when they are displayed. Required.
                        "public_key": "str"  # The entire public key string that was
                          uploaded. Embedded into the root user's ``authorized_keys`` file if you
                          include this key during Droplet creation. Required.
                    }
                }
                # response body for status code(s): 401, 404, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = case_insensitive_dict(kwargs.pop("headers", {}) or {})
        _params = kwargs.pop("params", {}) or {}

        content_type = kwargs.pop(
            "content_type", _headers.pop("Content-Type", None)
        )  # type: Optional[str]
        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        content_type = content_type or "application/json"
        _json = None
        _content = None
        if isinstance(body, (IO, bytes)):
            _content = body
        else:
            _json = body

        request = build_ssh_keys_update_request(
            ssh_key_identifier=ssh_key_identifier,
            content_type=content_type,
            json=_json,
            content=_content,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404, 429, 500]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 401:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 404:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 429:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 500:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)

        return cast(JSON, deserialized)

    @distributed_trace
    def delete(self, ssh_key_identifier: JSON, **kwargs: Any) -> Optional[JSON]:
        """Delete an SSH Key.

        To destroy a public SSH key that you have in your account, send a DELETE request to
        ``/v2/account/keys/$KEY_ID`` or ``/v2/account/keys/$KEY_FINGERPRINT``.
        A 204 status will be returned, indicating that the action was successful and that the response
        body is empty.

        :param ssh_key_identifier: Either the ID or the fingerprint of an existing SSH key. Required.
        :type ssh_key_identifier: JSON
        :return: JSON object or None
        :rtype: JSON or None
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 401, 404, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[Optional[JSON]]

        request = build_ssh_keys_delete_request(
            ssh_key_identifier=ssh_key_identifier,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [204, 401, 404, 429, 500]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        deserialized = None
        response_headers = {}
        if response.status_code == 204:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

        if response.status_code == 401:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 404:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 429:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 500:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, deserialized, response_headers)

        return deserialized


class ActionsOperations:
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~pydo.GeneratedClient`'s
        :attr:`actions` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @distributed_trace
    def list(self, *, per_page: int = 20, page: int = 1, **kwargs: Any) -> JSON:
        """List All Actions.

        This will be the entire list of actions taken on your account, so it will be quite large. As
        with any large collection returned by the API, the results will be paginated with only 20 on
        each page by default.

        :keyword per_page: Number of items returned per page. Default value is 20.
        :paramtype per_page: int
        :keyword page: Which 'page' of paginated results to return. Default value is 1.
        :paramtype page: int
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "actions": [
                        {
                            "completed_at": "2020-02-20 00:00:00",  # Optional. A time
                              value given in ISO8601 combined date and time format that represents when
                              the action was completed.
                            "id": 0,  # Optional. A unique numeric ID that can be used to
                              identify and reference an action.
                            "region": {
                                "available": bool,  # This is a boolean value that
                                  represents whether new Droplets can be created in this region.
                                  Required.
                                "features": {},  # This attribute is set to an array
                                  which contains features available in this region. Required.
                                "name": "str",  # The display name of the region.
                                  This will be a full name that is used in the control panel and other
                                  interfaces. Required.
                                "sizes": {},  # This attribute is set to an array
                                  which contains the identifying slugs for the sizes available in this
                                  region. Required.
                                "slug": "str"  # A human-readable string that is used
                                  as a unique identifier for each region. Required.
                            },
                            "region_slug": {},  # Optional. Any object.
                            "resource_id": 0,  # Optional. A unique identifier for the
                              resource that the action is associated with.
                            "resource_type": "str",  # Optional. The type of resource
                              that the action is associated with.
                            "started_at": "2020-02-20 00:00:00",  # Optional. A time
                              value given in ISO8601 combined date and time format that represents when
                              the action was initiated.
                            "status": "in-progress",  # Optional. Default value is
                              "in-progress". The current status of the action. This can be
                              "in-progress", "completed", or "errored". Known values are:
                              "in-progress", "completed", and "errored".
                            "type": "str"  # Optional. This is the type of action that
                              the object represents. For example, this could be "transfer" to represent
                              the state of an image transfer action.
                        }
                    ],
                    "links": {
                        "pages": {}
                    },
                    "meta": {
                        "total": 0  # Optional. Number of objects returned by the request.
                    }
                }
                # response body for status code(s): 401, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_actions_list_request(
            per_page=per_page,
            page=page,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 429, 500]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 401:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 429:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 500:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)

        return cast(JSON, deserialized)

    @distributed_trace
    def get(self, action_id: int, **kwargs: Any) -> JSON:
        """Retrieve an Existing Action.

        To retrieve a specific action object, send a GET request to ``/v2/actions/$ACTION_ID``.

        :param action_id: A unique numeric ID that can be used to identify and reference an action.
         Required.
        :type action_id: int
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "action": {
                        "completed_at": "2020-02-20 00:00:00",  # Optional. A time value
                          given in ISO8601 combined date and time format that represents when the
                          action was completed.
                        "id": 0,  # Optional. A unique numeric ID that can be used to
                          identify and reference an action.
                        "region": {
                            "available": bool,  # This is a boolean value that represents
                              whether new Droplets can be created in this region. Required.
                            "features": {},  # This attribute is set to an array which
                              contains features available in this region. Required.
                            "name": "str",  # The display name of the region.  This will
                              be a full name that is used in the control panel and other interfaces.
                              Required.
                            "sizes": {},  # This attribute is set to an array which
                              contains the identifying slugs for the sizes available in this region.
                              Required.
                            "slug": "str"  # A human-readable string that is used as a
                              unique identifier for each region. Required.
                        },
                        "region_slug": {},  # Optional. Any object.
                        "resource_id": 0,  # Optional. A unique identifier for the resource
                          that the action is associated with.
                        "resource_type": "str",  # Optional. The type of resource that the
                          action is associated with.
                        "started_at": "2020-02-20 00:00:00",  # Optional. A time value given
                          in ISO8601 combined date and time format that represents when the action was
                          initiated.
                        "status": "in-progress",  # Optional. Default value is "in-progress".
                          The current status of the action. This can be "in-progress", "completed", or
                          "errored". Known values are: "in-progress", "completed", and "errored".
                        "type": "str"  # Optional. This is the type of action that the object
                          represents. For example, this could be "transfer" to represent the state of
                          an image transfer action.
                    }
                }
                # response body for status code(s): 401, 404, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_actions_get_request(
            action_id=action_id,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 404, 429, 500]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 401:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 404:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 429:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 500:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)

        return cast(JSON, deserialized)


class AppsOperations:  # pylint: disable=too-many-public-methods
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~pydo.GeneratedClient`'s
        :attr:`apps` attribute.
    """

    def __init__(self, *args, **kwargs):
        input_args = list(args)
        self._client = input_args.pop(0) if input_args else kwargs.pop("client")
        self._config = input_args.pop(0) if input_args else kwargs.pop("config")
        self._serialize = input_args.pop(0) if input_args else kwargs.pop("serializer")
        self._deserialize = (
            input_args.pop(0) if input_args else kwargs.pop("deserializer")
        )

    @distributed_trace
    def list(self, *, page: int = 1, per_page: int = 20, **kwargs: Any) -> JSON:
        """List All Apps.

        List all apps on your account. Information about the current active deployment as well as any
        in progress ones will also be included for each app.

        :keyword page: Which 'page' of paginated results to return. Default value is 1.
        :paramtype page: int
        :keyword per_page: Number of items returned per page. Default value is 20.
        :paramtype per_page: int
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "apps": [
                        {
                            "active_deployment": {
                                "cause": "str",  # Optional. What caused this
                                  deployment to be created.
                                "cloned_from": "str",  # Optional. The ID of a
                                  previous deployment that this deployment was cloned from.
                                "created_at": "2020-02-20 00:00:00",  # Optional. The
                                  creation time of the deployment.
                                "functions": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this functions component.
                                        "namespace": "str",  # Optional. The
                                          namespace where the functions are deployed.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this functions component.
                                    }
                                ],
                                "id": "str",  # Optional. The ID of the deployment.
                                "jobs": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this job.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this job.
                                    }
                                ],
                                "phase": "UNKNOWN",  # Optional. Default value is
                                  "UNKNOWN". Known values are: "UNKNOWN", "PENDING_BUILD", "BUILDING",
                                  "PENDING_DEPLOY", "DEPLOYING", "ACTIVE", "SUPERSEDED", "ERROR", and
                                  "CANCELED".
                                "phase_last_updated_at": "2020-02-20 00:00:00",  #
                                  Optional. When the deployment phase was last updated.
                                "progress": {
                                    "error_steps": 0,  # Optional. Number of
                                      unsuccessful steps.
                                    "pending_steps": 0,  # Optional. Number of
                                      pending steps.
                                    "running_steps": 0,  # Optional. Number of
                                      currently running steps.
                                    "steps": [
                                        {
                                            "component_name": "str",  #
                                              Optional. The component name that this step is associated
                                              with.
                                            "ended_at": "2020-02-20
                                              00:00:00",  # Optional. The end time of this step.
                                            "message_base": "str",  #
                                              Optional. The base of a human-readable description of the
                                              step intended to be combined with the component name for
                                              presentation. For example:"n"n``message_base`` =
                                              "Building service""n``component_name`` = "api".
                                            "name": "str",  # Optional.
                                              The name of this step.
                                            "reason": {
                                                "code": "str",  #
                                                  Optional. The error code.
                                                "message": "str"  #
                                                  Optional. The error message.
                                            },
                                            "started_at": "2020-02-20
                                              00:00:00",  # Optional. The start time of this step.
                                            "status": "UNKNOWN",  #
                                              Optional. Default value is "UNKNOWN". Known values are:
                                              "UNKNOWN", "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                            "steps": [
                                                {}  # Optional. Child
                                                  steps of this step.
                                            ]
                                        }
                                    ],
                                    "success_steps": 0,  # Optional. Number of
                                      successful steps.
                                    "summary_steps": [
                                        {
                                            "component_name": "str",  #
                                              Optional. The component name that this step is associated
                                              with.
                                            "ended_at": "2020-02-20
                                              00:00:00",  # Optional. The end time of this step.
                                            "message_base": "str",  #
                                              Optional. The base of a human-readable description of the
                                              step intended to be combined with the component name for
                                              presentation. For example:"n"n``message_base`` =
                                              "Building service""n``component_name`` = "api".
                                            "name": "str",  # Optional.
                                              The name of this step.
                                            "reason": {
                                                "code": "str",  #
                                                  Optional. The error code.
                                                "message": "str"  #
                                                  Optional. The error message.
                                            },
                                            "started_at": "2020-02-20
                                              00:00:00",  # Optional. The start time of this step.
                                            "status": "UNKNOWN",  #
                                              Optional. Default value is "UNKNOWN". Known values are:
                                              "UNKNOWN", "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                            "steps": [
                                                {}  # Optional. Child
                                                  steps of this step.
                                            ]
                                        }
                                    ],
                                    "total_steps": 0  # Optional. Total number of
                                      steps.
                                },
                                "services": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this service.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this service.
                                    }
                                ],
                                "spec": {
                                    "databases": [
                                        {
                                            "cluster_name": "str",  #
                                              Optional. The name of the underlying DigitalOcean DBaaS
                                              cluster. This is required for production databases. For
                                              dev databases, if cluster_name is not set, a new cluster
                                              will be provisioned.
                                            "db_name": "str",  #
                                              Optional. The name of the MySQL or PostgreSQL database to
                                              configure.
                                            "db_user": "str",  #
                                              Optional. The name of the MySQL or PostgreSQL user to
                                              configure.
                                            "engine": "UNSET",  #
                                              Optional. Default value is "UNSET". * MYSQL: MySQL"n* PG:
                                              PostgreSQL"n* REDIS: Redis. Known values are: "UNSET",
                                              "MYSQL", "PG", and "REDIS".
                                            "name": "str",  # The name.
                                              Must be unique across all components within the same app.
                                              Required.
                                            "production": bool,  #
                                              Optional. Whether this is a production or dev database.
                                            "version": "str"  # Optional.
                                              The version of the database engine.
                                        }
                                    ],
                                    "domains": [
                                        {
                                            "domain": "str",  # The
                                              hostname for the domain. Required.
                                            "minimum_tls_version": "str",
                                              # Optional. The minimum version of TLS a client
                                              application can use to access resources for the domain.
                                              Must be one of the following values wrapped within
                                              quotations: ``"1.2"`` or ``"1.3"``. Known values are:
                                              "1.2" and "1.3".
                                            "type": "UNSPECIFIED",  #
                                              Optional. Default value is "UNSPECIFIED". * DEFAULT: The
                                              default ``.ondigitalocean.app`` domain assigned to this
                                              app"n* PRIMARY: The primary domain for this app that is
                                              displayed as the default in the control panel, used in
                                              bindable environment variables, and any other places that
                                              reference an app's live URL. Only one domain may be set
                                              as primary."n* ALIAS: A non-primary domain. Known values
                                              are: "UNSPECIFIED", "DEFAULT", "PRIMARY", and "ALIAS".
                                            "wildcard": bool,  #
                                              Optional. Indicates whether the domain includes all
                                              sub-domains, in addition to the given domain.
                                            "zone": "str"  # Optional.
                                              Optional. If the domain uses DigitalOcean DNS and you
                                              would like App"nPlatform to automatically manage it for
                                              you, set this to the name of the"ndomain on your
                                              account."n"nFor example, If the domain you are adding is
                                              ``app.domain.com``"" , the zone"ncould be ``domain.com``.
                                        }
                                    ],
                                    "functions": [
                                        {
                                            "alerts": [
                                                {
                                                    "disabled":
                                                      bool,  # Optional. Is the alert disabled?.
                                                    "operator":
                                                      "UNSPECIFIED_OPERATOR",  # Optional. Default
                                                      value is "UNSPECIFIED_OPERATOR". Known values
                                                      are: "UNSPECIFIED_OPERATOR", "GREATER_THAN", and
                                                      "LESS_THAN".
                                                    "rule":
                                                      "UNSPECIFIED_RULE",  # Optional. Default value is
                                                      "UNSPECIFIED_RULE". Known values are:
                                                      "UNSPECIFIED_RULE", "CPU_UTILIZATION",
                                                      "MEM_UTILIZATION", "RESTART_COUNT",
                                                      "DEPLOYMENT_FAILED", "DEPLOYMENT_LIVE",
                                                      "DOMAIN_FAILED", "DOMAIN_LIVE",
                                                      "FUNCTIONS_ACTIVATION_COUNT",
                                                      "FUNCTIONS_AVERAGE_DURATION_MS",
                                                      "FUNCTIONS_ERROR_RATE_PER_MINUTE",
                                                      "FUNCTIONS_AVERAGE_WAIT_TIME_MS",
                                                      "FUNCTIONS_ERROR_COUNT", and
                                                      "FUNCTIONS_GB_RATE_PER_SECOND".
                                                    "value": 0.0,
                                                      # Optional. Threshold value for alert.
                                                    "window":
                                                      "UNSPECIFIED_WINDOW"  # Optional. Default value
                                                      is "UNSPECIFIED_WINDOW". Known values are:
                                                      "UNSPECIFIED_WINDOW", "FIVE_MINUTES",
                                                      "TEN_MINUTES", "THIRTY_MINUTES", and "ONE_HOUR".
                                                }
                                            ],
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time"n* BUILD_TIME: Made
                                                      available only at build-time"n*
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable"n* SECRET: A secret encrypted
                                                      environment variable. Known values are: "GENERAL"
                                                      and "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "log_destinations": {
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "name": "str",  #
                                                  Required.
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            },
                                            "name": "str",  # The name.
                                              Must be unique across all components within the same app.
                                              Required.
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. An HTTP path prefix. Paths
                                                      must start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "jobs": [
                                        {
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://www.digitalocean.com/docs/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time"n* BUILD_TIME: Made
                                                      available only at build-time"n*
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable"n* SECRET: A secret encrypted
                                                      environment variable. Known values are: "GENERAL"
                                                      and "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type."n* DOCR: The DigitalOcean
                                                  container registry type. Known values are:
                                                  "DOCKER_HUB" and "DOCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1.
                                            "instance_size_slug":
                                              "basic-xxs",  # Optional. Default value is "basic-xxs".
                                              The instance size to use for this component. Default:
                                              ``basic-xxs``. Known values are: "basic-xxs", "basic-xs",
                                              "basic-s", "basic-m", "professional-xs",
                                              "professional-s", "professional-m", "professional-1l",
                                              "professional-l", and "professional-xl".
                                            "kind": "UNSPECIFIED",  #
                                              Optional. Default value is "UNSPECIFIED". * UNSPECIFIED:
                                              Default job type, will auto-complete to POST_DEPLOY
                                              kind."n* PRE_DEPLOY: Indicates a job that runs before an
                                              app deployment."n* POST_DEPLOY: Indicates a job that runs
                                              after an app deployment."n* FAILED_DEPLOY: Indicates a
                                              job that runs after a component fails to deploy. Known
                                              values are: "UNSPECIFIED", "PRE_DEPLOY", "POST_DEPLOY",
                                              and "FAILED_DEPLOY".
                                            "log_destinations": {
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "name": "str",  #
                                                  Required.
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            },
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "name": "str",  # The name of the app. Must
                                      be unique across all apps in the same account. Required.
                                    "region": "str",  # Optional. The slug form
                                      of the geographical origin of the app. Default: ``nearest
                                      available``. Known values are: "ams", "nyc", and "fra".
                                    "services": [
                                        {
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://www.digitalocean.com/docs/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time"n* BUILD_TIME: Made
                                                      available only at build-time"n*
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable"n* SECRET: A secret encrypted
                                                      environment variable. Known values are: "GENERAL"
                                                      and "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "health_check": {
                                                "failure_threshold":
                                                  0,  # Optional. The number of failed health checks
                                                  before considered unhealthy.
                                                "http_path": "str",
                                                  # Optional. The route path used for the HTTP health
                                                  check ping. If not set, the HTTP health check will be
                                                  disabled and a TCP health check used instead.
                "initial_delay_seconds": 0,  # Optional. The number
                                                  of seconds to wait before beginning health checks.
                                                "period_seconds": 0,
                                                  # Optional. The number of seconds to wait between
                                                  health checks.
                                                "port": 0,  #
                                                  Optional. The port on which the health check will be
                                                  performed. If not set, the health check will be
                                                  performed on the component's http_port.
                                                "success_threshold":
                                                  0,  # Optional. The number of successful health
                                                  checks before considered healthy.
                                                "timeout_seconds": 0
                                                  # Optional. The number of seconds after which the
                                                  check times out.
                                            },
                                            "http_port": 0,  # Optional.
                                              The internal port on which this service's run command
                                              will listen. Default: 8080"nIf there is not an
                                              environment variable with the name ``PORT``"" , one will
                                              be automatically added with its value set to the value of
                                              this field.
                                            "image": {
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type."n* DOCR: The DigitalOcean
                                                  container registry type. Known values are:
                                                  "DOCKER_HUB" and "DOCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1.
                                            "instance_size_slug":
                                              "basic-xxs",  # Optional. Default value is "basic-xxs".
                                              The instance size to use for this component. Default:
                                              ``basic-xxs``. Known values are: "basic-xxs", "basic-xs",
                                              "basic-s", "basic-m", "professional-xs",
                                              "professional-s", "professional-m", "professional-1l",
                                              "professional-l", and "professional-xl".
                                            "internal_ports": [
                                                0  # Optional. The
                                                  ports on which this service will listen for internal
                                                  traffic.
                                            ],
                                            "log_destinations": {
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "name": "str",  #
                                                  Required.
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            },
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. An HTTP path prefix. Paths
                                                      must start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "static_sites": [
                                        {
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "catchall_document": "str",
                                              # Optional. The name of the document to use as the
                                              fallback for any requests to documents that are not found
                                              when serving this static site. Only 1 of
                                              ``catchall_document`` or ``error_document`` can be set.
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://www.digitalocean.com/docs/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time"n* BUILD_TIME: Made
                                                      available only at build-time"n*
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable"n* SECRET: A secret encrypted
                                                      environment variable. Known values are: "GENERAL"
                                                      and "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "error_document": "404.html",
                                              # Optional. Default value is "404.html". The name of the
                                              error document to use when serving this static site.
                                              Default: 404.html. If no such file exists within the
                                              built assets, App Platform will supply one.
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type."n* DOCR: The DigitalOcean
                                                  container registry type. Known values are:
                                                  "DOCKER_HUB" and "DOCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided.
                                            },
                                            "index_document":
                                              "index.html",  # Optional. Default value is "index.html".
                                              The name of the index document to use when serving this
                                              static site. Default: index.html.
                                            "log_destinations": {
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "name": "str",  #
                                                  Required.
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            },
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "output_dir": "str",  #
                                              Optional. An optional path to where the built assets will
                                              be located, relative to the build context. If not set,
                                              App Platform will automatically scan for these directory
                                              names: ``_static``"" , ``dist``"" , ``public``"" ,
                                              ``build``.
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. An HTTP path prefix. Paths
                                                      must start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "workers": [
                                        {
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://www.digitalocean.com/docs/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time"n* BUILD_TIME: Made
                                                      available only at build-time"n*
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable"n* SECRET: A secret encrypted
                                                      environment variable. Known values are: "GENERAL"
                                                      and "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type."n* DOCR: The DigitalOcean
                                                  container registry type. Known values are:
                                                  "DOCKER_HUB" and "DOCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1.
                                            "instance_size_slug":
                                              "basic-xxs",  # Optional. Default value is "basic-xxs".
                                              The instance size to use for this component. Default:
                                              ``basic-xxs``. Known values are: "basic-xxs", "basic-xs",
                                              "basic-s", "basic-m", "professional-xs",
                                              "professional-s", "professional-m", "professional-1l",
                                              "professional-l", and "professional-xl".
                                            "log_destinations": {
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "name": "str",  #
                                                  Required.
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            },
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ]
                                },
                                "static_sites": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this static site.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this static site.
                                    }
                                ],
                                "tier_slug": "str",  # Optional. The current pricing
                                  tier slug of the deployment.
                                "updated_at": "2020-02-20 00:00:00",  # Optional.
                                  When the deployment was last updated.
                                "workers": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this worker.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this worker.
                                    }
                                ]
                            },
                            "created_at": "2020-02-20 00:00:00",  # Optional. The
                              creation time of the app.
                            "default_ingress": "str",  # Optional. The default hostname
                              on which the app is accessible.
                            "domains": [
                                {
                                    "id": "str",  # Optional. The ID of the
                                      domain.
                                    "phase": "UNKNOWN",  # Optional. Default
                                      value is "UNKNOWN". Known values are: "UNKNOWN", "PENDING",
                                      "CONFIGURING", "ACTIVE", and "ERROR".
                                    "progress": {
                                        "steps": [
                                            {}  # Optional. The steps of
                                              the domain's progress.
                                        ]
                                    },
                                    "spec": {
                                        "domain": "str",  # The hostname for
                                          the domain. Required.
                                        "minimum_tls_version": "str",  #
                                          Optional. The minimum version of TLS a client application can
                                          use to access resources for the domain.  Must be one of the
                                          following values wrapped within quotations: ``"1.2"`` or
                                          ``"1.3"``. Known values are: "1.2" and "1.3".
                                        "type": "UNSPECIFIED",  # Optional.
                                          Default value is "UNSPECIFIED". * DEFAULT: The default
                                          ``.ondigitalocean.app`` domain assigned to this app"n*
                                          PRIMARY: The primary domain for this app that is displayed as
                                          the default in the control panel, used in bindable
                                          environment variables, and any other places that reference an
                                          app's live URL. Only one domain may be set as primary."n*
                                          ALIAS: A non-primary domain. Known values are: "UNSPECIFIED",
                                          "DEFAULT", "PRIMARY", and "ALIAS".
                                        "wildcard": bool,  # Optional.
                                          Indicates whether the domain includes all sub-domains, in
                                          addition to the given domain.
                                        "zone": "str"  # Optional. Optional.
                                          If the domain uses DigitalOcean DNS and you would like
                                          App"nPlatform to automatically manage it for you, set this to
                                          the name of the"ndomain on your account."n"nFor example, If
                                          the domain you are adding is ``app.domain.com``"" , the
                                          zone"ncould be ``domain.com``.
                                    }
                                }
                            ],
                            "id": "str",  # Optional. The ID of the application.
                            "in_progress_deployment": {
                                "cause": "str",  # Optional. What caused this
                                  deployment to be created.
                                "cloned_from": "str",  # Optional. The ID of a
                                  previous deployment that this deployment was cloned from.
                                "created_at": "2020-02-20 00:00:00",  # Optional. The
                                  creation time of the deployment.
                                "functions": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this functions component.
                                        "namespace": "str",  # Optional. The
                                          namespace where the functions are deployed.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this functions component.
                                    }
                                ],
                                "id": "str",  # Optional. The ID of the deployment.
                                "jobs": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this job.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this job.
                                    }
                                ],
                                "phase": "UNKNOWN",  # Optional. Default value is
                                  "UNKNOWN". Known values are: "UNKNOWN", "PENDING_BUILD", "BUILDING",
                                  "PENDING_DEPLOY", "DEPLOYING", "ACTIVE", "SUPERSEDED", "ERROR", and
                                  "CANCELED".
                                "phase_last_updated_at": "2020-02-20 00:00:00",  #
                                  Optional. When the deployment phase was last updated.
                                "progress": {
                                    "error_steps": 0,  # Optional. Number of
                                      unsuccessful steps.
                                    "pending_steps": 0,  # Optional. Number of
                                      pending steps.
                                    "running_steps": 0,  # Optional. Number of
                                      currently running steps.
                                    "steps": [
                                        {
                                            "component_name": "str",  #
                                              Optional. The component name that this step is associated
                                              with.
                                            "ended_at": "2020-02-20
                                              00:00:00",  # Optional. The end time of this step.
                                            "message_base": "str",  #
                                              Optional. The base of a human-readable description of the
                                              step intended to be combined with the component name for
                                              presentation. For example:"n"n``message_base`` =
                                              "Building service""n``component_name`` = "api".
                                            "name": "str",  # Optional.
                                              The name of this step.
                                            "reason": {
                                                "code": "str",  #
                                                  Optional. The error code.
                                                "message": "str"  #
                                                  Optional. The error message.
                                            },
                                            "started_at": "2020-02-20
                                              00:00:00",  # Optional. The start time of this step.
                                            "status": "UNKNOWN",  #
                                              Optional. Default value is "UNKNOWN". Known values are:
                                              "UNKNOWN", "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                            "steps": [
                                                {}  # Optional. Child
                                                  steps of this step.
                                            ]
                                        }
                                    ],
                                    "success_steps": 0,  # Optional. Number of
                                      successful steps.
                                    "summary_steps": [
                                        {
                                            "component_name": "str",  #
                                              Optional. The component name that this step is associated
                                              with.
                                            "ended_at": "2020-02-20
                                              00:00:00",  # Optional. The end time of this step.
                                            "message_base": "str",  #
                                              Optional. The base of a human-readable description of the
                                              step intended to be combined with the component name for
                                              presentation. For example:"n"n``message_base`` =
                                              "Building service""n``component_name`` = "api".
                                            "name": "str",  # Optional.
                                              The name of this step.
                                            "reason": {
                                                "code": "str",  #
                                                  Optional. The error code.
                                                "message": "str"  #
                                                  Optional. The error message.
                                            },
                                            "started_at": "2020-02-20
                                              00:00:00",  # Optional. The start time of this step.
                                            "status": "UNKNOWN",  #
                                              Optional. Default value is "UNKNOWN". Known values are:
                                              "UNKNOWN", "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                            "steps": [
                                                {}  # Optional. Child
                                                  steps of this step.
                                            ]
                                        }
                                    ],
                                    "total_steps": 0  # Optional. Total number of
                                      steps.
                                },
                                "services": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this service.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this service.
                                    }
                                ],
                                "spec": {
                                    "databases": [
                                        {
                                            "cluster_name": "str",  #
                                              Optional. The name of the underlying DigitalOcean DBaaS
                                              cluster. This is required for production databases. For
                                              dev databases, if cluster_name is not set, a new cluster
                                              will be provisioned.
                                            "db_name": "str",  #
                                              Optional. The name of the MySQL or PostgreSQL database to
                                              configure.
                                            "db_user": "str",  #
                                              Optional. The name of the MySQL or PostgreSQL user to
                                              configure.
                                            "engine": "UNSET",  #
                                              Optional. Default value is "UNSET". * MYSQL: MySQL"n* PG:
                                              PostgreSQL"n* REDIS: Redis. Known values are: "UNSET",
                                              "MYSQL", "PG", and "REDIS".
                                            "name": "str",  # The name.
                                              Must be unique across all components within the same app.
                                              Required.
                                            "production": bool,  #
                                              Optional. Whether this is a production or dev database.
                                            "version": "str"  # Optional.
                                              The version of the database engine.
                                        }
                                    ],
                                    "domains": [
                                        {
                                            "domain": "str",  # The
                                              hostname for the domain. Required.
                                            "minimum_tls_version": "str",
                                              # Optional. The minimum version of TLS a client
                                              application can use to access resources for the domain.
                                              Must be one of the following values wrapped within
                                              quotations: ``"1.2"`` or ``"1.3"``. Known values are:
                                              "1.2" and "1.3".
                                            "type": "UNSPECIFIED",  #
                                              Optional. Default value is "UNSPECIFIED". * DEFAULT: The
                                              default ``.ondigitalocean.app`` domain assigned to this
                                              app"n* PRIMARY: The primary domain for this app that is
                                              displayed as the default in the control panel, used in
                                              bindable environment variables, and any other places that
                                              reference an app's live URL. Only one domain may be set
                                              as primary."n* ALIAS: A non-primary domain. Known values
                                              are: "UNSPECIFIED", "DEFAULT", "PRIMARY", and "ALIAS".
                                            "wildcard": bool,  #
                                              Optional. Indicates whether the domain includes all
                                              sub-domains, in addition to the given domain.
                                            "zone": "str"  # Optional.
                                              Optional. If the domain uses DigitalOcean DNS and you
                                              would like App"nPlatform to automatically manage it for
                                              you, set this to the name of the"ndomain on your
                                              account."n"nFor example, If the domain you are adding is
                                              ``app.domain.com``"" , the zone"ncould be ``domain.com``.
                                        }
                                    ],
                                    "functions": [
                                        {
                                            "alerts": [
                                                {
                                                    "disabled":
                                                      bool,  # Optional. Is the alert disabled?.
                                                    "operator":
                                                      "UNSPECIFIED_OPERATOR",  # Optional. Default
                                                      value is "UNSPECIFIED_OPERATOR". Known values
                                                      are: "UNSPECIFIED_OPERATOR", "GREATER_THAN", and
                                                      "LESS_THAN".
                                                    "rule":
                                                      "UNSPECIFIED_RULE",  # Optional. Default value is
                                                      "UNSPECIFIED_RULE". Known values are:
                                                      "UNSPECIFIED_RULE", "CPU_UTILIZATION",
                                                      "MEM_UTILIZATION", "RESTART_COUNT",
                                                      "DEPLOYMENT_FAILED", "DEPLOYMENT_LIVE",
                                                      "DOMAIN_FAILED", "DOMAIN_LIVE",
                                                      "FUNCTIONS_ACTIVATION_COUNT",
                                                      "FUNCTIONS_AVERAGE_DURATION_MS",
                                                      "FUNCTIONS_ERROR_RATE_PER_MINUTE",
                                                      "FUNCTIONS_AVERAGE_WAIT_TIME_MS",
                                                      "FUNCTIONS_ERROR_COUNT", and
                                                      "FUNCTIONS_GB_RATE_PER_SECOND".
                                                    "value": 0.0,
                                                      # Optional. Threshold value for alert.
                                                    "window":
                                                      "UNSPECIFIED_WINDOW"  # Optional. Default value
                                                      is "UNSPECIFIED_WINDOW". Known values are:
                                                      "UNSPECIFIED_WINDOW", "FIVE_MINUTES",
                                                      "TEN_MINUTES", "THIRTY_MINUTES", and "ONE_HOUR".
                                                }
                                            ],
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time"n* BUILD_TIME: Made
                                                      available only at build-time"n*
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable"n* SECRET: A secret encrypted
                                                      environment variable. Known values are: "GENERAL"
                                                      and "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "log_destinations": {
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "name": "str",  #
                                                  Required.
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            },
                                            "name": "str",  # The name.
                                              Must be unique across all components within the same app.
                                              Required.
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. An HTTP path prefix. Paths
                                                      must start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "jobs": [
                                        {
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://www.digitalocean.com/docs/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time"n* BUILD_TIME: Made
                                                      available only at build-time"n*
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable"n* SECRET: A secret encrypted
                                                      environment variable. Known values are: "GENERAL"
                                                      and "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type."n* DOCR: The DigitalOcean
                                                  container registry type. Known values are:
                                                  "DOCKER_HUB" and "DOCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1.
                                            "instance_size_slug":
                                              "basic-xxs",  # Optional. Default value is "basic-xxs".
                                              The instance size to use for this component. Default:
                                              ``basic-xxs``. Known values are: "basic-xxs", "basic-xs",
                                              "basic-s", "basic-m", "professional-xs",
                                              "professional-s", "professional-m", "professional-1l",
                                              "professional-l", and "professional-xl".
                                            "kind": "UNSPECIFIED",  #
                                              Optional. Default value is "UNSPECIFIED". * UNSPECIFIED:
                                              Default job type, will auto-complete to POST_DEPLOY
                                              kind."n* PRE_DEPLOY: Indicates a job that runs before an
                                              app deployment."n* POST_DEPLOY: Indicates a job that runs
                                              after an app deployment."n* FAILED_DEPLOY: Indicates a
                                              job that runs after a component fails to deploy. Known
                                              values are: "UNSPECIFIED", "PRE_DEPLOY", "POST_DEPLOY",
                                              and "FAILED_DEPLOY".
                                            "log_destinations": {
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "name": "str",  #
                                                  Required.
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            },
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "name": "str",  # The name of the app. Must
                                      be unique across all apps in the same account. Required.
                                    "region": "str",  # Optional. The slug form
                                      of the geographical origin of the app. Default: ``nearest
                                      available``. Known values are: "ams", "nyc", and "fra".
                                    "services": [
                                        {
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://www.digitalocean.com/docs/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time"n* BUILD_TIME: Made
                                                      available only at build-time"n*
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable"n* SECRET: A secret encrypted
                                                      environment variable. Known values are: "GENERAL"
                                                      and "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "health_check": {
                                                "failure_threshold":
                                                  0,  # Optional. The number of failed health checks
                                                  before considered unhealthy.
                                                "http_path": "str",
                                                  # Optional. The route path used for the HTTP health
                                                  check ping. If not set, the HTTP health check will be
                                                  disabled and a TCP health check used instead.
                "initial_delay_seconds": 0,  # Optional. The number
                                                  of seconds to wait before beginning health checks.
                                                "period_seconds": 0,
                                                  # Optional. The number of seconds to wait between
                                                  health checks.
                                                "port": 0,  #
                                                  Optional. The port on which the health check will be
                                                  performed. If not set, the health check will be
                                                  performed on the component's http_port.
                                                "success_threshold":
                                                  0,  # Optional. The number of successful health
                                                  checks before considered healthy.
                                                "timeout_seconds": 0
                                                  # Optional. The number of seconds after which the
                                                  check times out.
                                            },
                                            "http_port": 0,  # Optional.
                                              The internal port on which this service's run command
                                              will listen. Default: 8080"nIf there is not an
                                              environment variable with the name ``PORT``"" , one will
                                              be automatically added with its value set to the value of
                                              this field.
                                            "image": {
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type."n* DOCR: The DigitalOcean
                                                  container registry type. Known values are:
                                                  "DOCKER_HUB" and "DOCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1.
                                            "instance_size_slug":
                                              "basic-xxs",  # Optional. Default value is "basic-xxs".
                                              The instance size to use for this component. Default:
                                              ``basic-xxs``. Known values are: "basic-xxs", "basic-xs",
                                              "basic-s", "basic-m", "professional-xs",
                                              "professional-s", "professional-m", "professional-1l",
                                              "professional-l", and "professional-xl".
                                            "internal_ports": [
                                                0  # Optional. The
                                                  ports on which this service will listen for internal
                                                  traffic.
                                            ],
                                            "log_destinations": {
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "name": "str",  #
                                                  Required.
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            },
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. An HTTP path prefix. Paths
                                                      must start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "static_sites": [
                                        {
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "catchall_document": "str",
                                              # Optional. The name of the document to use as the
                                              fallback for any requests to documents that are not found
                                              when serving this static site. Only 1 of
                                              ``catchall_document`` or ``error_document`` can be set.
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://www.digitalocean.com/docs/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time"n* BUILD_TIME: Made
                                                      available only at build-time"n*
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable"n* SECRET: A secret encrypted
                                                      environment variable. Known values are: "GENERAL"
                                                      and "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "error_document": "404.html",
                                              # Optional. Default value is "404.html". The name of the
                                              error document to use when serving this static site.
                                              Default: 404.html. If no such file exists within the
                                              built assets, App Platform will supply one.
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type."n* DOCR: The DigitalOcean
                                                  container registry type. Known values are:
                                                  "DOCKER_HUB" and "DOCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided.
                                            },
                                            "index_document":
                                              "index.html",  # Optional. Default value is "index.html".
                                              The name of the index document to use when serving this
                                              static site. Default: index.html.
                                            "log_destinations": {
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "name": "str",  #
                                                  Required.
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            },
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "output_dir": "str",  #
                                              Optional. An optional path to where the built assets will
                                              be located, relative to the build context. If not set,
                                              App Platform will automatically scan for these directory
                                              names: ``_static``"" , ``dist``"" , ``public``"" ,
                                              ``build``.
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. An HTTP path prefix. Paths
                                                      must start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "workers": [
                                        {
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://www.digitalocean.com/docs/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time"n* BUILD_TIME: Made
                                                      available only at build-time"n*
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable"n* SECRET: A secret encrypted
                                                      environment variable. Known values are: "GENERAL"
                                                      and "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type."n* DOCR: The DigitalOcean
                                                  container registry type. Known values are:
                                                  "DOCKER_HUB" and "DOCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1.
                                            "instance_size_slug":
                                              "basic-xxs",  # Optional. Default value is "basic-xxs".
                                              The instance size to use for this component. Default:
                                              ``basic-xxs``. Known values are: "basic-xxs", "basic-xs",
                                              "basic-s", "basic-m", "professional-xs",
                                              "professional-s", "professional-m", "professional-1l",
                                              "professional-l", and "professional-xl".
                                            "log_destinations": {
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "name": "str",  #
                                                  Required.
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            },
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ]
                                },
                                "static_sites": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this static site.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this static site.
                                    }
                                ],
                                "tier_slug": "str",  # Optional. The current pricing
                                  tier slug of the deployment.
                                "updated_at": "2020-02-20 00:00:00",  # Optional.
                                  When the deployment was last updated.
                                "workers": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this worker.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this worker.
                                    }
                                ]
                            },
                            "last_deployment_created_at": "2020-02-20 00:00:00",  #
                              Optional. The creation time of the last deployment.
                            "live_domain": "str",  # Optional. The live domain of the
                              app.
                            "live_url": "str",  # Optional. The live URL of the app.
                            "live_url_base": "str",  # Optional. The live URL base of the
                              app, the URL excluding the path.
                            "owner_uuid": "str",  # Optional. The ID of the account to
                              which the application belongs.
                            "pinned_deployment": {
                                "cause": "str",  # Optional. What caused this
                                  deployment to be created.
                                "cloned_from": "str",  # Optional. The ID of a
                                  previous deployment that this deployment was cloned from.
                                "created_at": "2020-02-20 00:00:00",  # Optional. The
                                  creation time of the deployment.
                                "functions": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this functions component.
                                        "namespace": "str",  # Optional. The
                                          namespace where the functions are deployed.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this functions component.
                                    }
                                ],
                                "id": "str",  # Optional. The ID of the deployment.
                                "jobs": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this job.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this job.
                                    }
                                ],
                                "phase": "UNKNOWN",  # Optional. Default value is
                                  "UNKNOWN". Known values are: "UNKNOWN", "PENDING_BUILD", "BUILDING",
                                  "PENDING_DEPLOY", "DEPLOYING", "ACTIVE", "SUPERSEDED", "ERROR", and
                                  "CANCELED".
                                "phase_last_updated_at": "2020-02-20 00:00:00",  #
                                  Optional. When the deployment phase was last updated.
                                "progress": {
                                    "error_steps": 0,  # Optional. Number of
                                      unsuccessful steps.
                                    "pending_steps": 0,  # Optional. Number of
                                      pending steps.
                                    "running_steps": 0,  # Optional. Number of
                                      currently running steps.
                                    "steps": [
                                        {
                                            "component_name": "str",  #
                                              Optional. The component name that this step is associated
                                              with.
                                            "ended_at": "2020-02-20
                                              00:00:00",  # Optional. The end time of this step.
                                            "message_base": "str",  #
                                              Optional. The base of a human-readable description of the
                                              step intended to be combined with the component name for
                                              presentation. For example:"n"n``message_base`` =
                                              "Building service""n``component_name`` = "api".
                                            "name": "str",  # Optional.
                                              The name of this step.
                                            "reason": {
                                                "code": "str",  #
                                                  Optional. The error code.
                                                "message": "str"  #
                                                  Optional. The error message.
                                            },
                                            "started_at": "2020-02-20
                                              00:00:00",  # Optional. The start time of this step.
                                            "status": "UNKNOWN",  #
                                              Optional. Default value is "UNKNOWN". Known values are:
                                              "UNKNOWN", "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                            "steps": [
                                                {}  # Optional. Child
                                                  steps of this step.
                                            ]
                                        }
                                    ],
                                    "success_steps": 0,  # Optional. Number of
                                      successful steps.
                                    "summary_steps": [
                                        {
                                            "component_name": "str",  #
                                              Optional. The component name that this step is associated
                                              with.
                                            "ended_at": "2020-02-20
                                              00:00:00",  # Optional. The end time of this step.
                                            "message_base": "str",  #
                                              Optional. The base of a human-readable description of the
                                              step intended to be combined with the component name for
                                              presentation. For example:"n"n``message_base`` =
                                              "Building service""n``component_name`` = "api".
                                            "name": "str",  # Optional.
                                              The name of this step.
                                            "reason": {
                                                "code": "str",  #
                                                  Optional. The error code.
                                                "message": "str"  #
                                                  Optional. The error message.
                                            },
                                            "started_at": "2020-02-20
                                              00:00:00",  # Optional. The start time of this step.
                                            "status": "UNKNOWN",  #
                                              Optional. Default value is "UNKNOWN". Known values are:
                                              "UNKNOWN", "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                            "steps": [
                                                {}  # Optional. Child
                                                  steps of this step.
                                            ]
                                        }
                                    ],
                                    "total_steps": 0  # Optional. Total number of
                                      steps.
                                },
                                "services": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this service.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this service.
                                    }
                                ],
                                "spec": {
                                    "databases": [
                                        {
                                            "cluster_name": "str",  #
                                              Optional. The name of the underlying DigitalOcean DBaaS
                                              cluster. This is required for production databases. For
                                              dev databases, if cluster_name is not set, a new cluster
                                              will be provisioned.
                                            "db_name": "str",  #
                                              Optional. The name of the MySQL or PostgreSQL database to
                                              configure.
                                            "db_user": "str",  #
                                              Optional. The name of the MySQL or PostgreSQL user to
                                              configure.
                                            "engine": "UNSET",  #
                                              Optional. Default value is "UNSET". * MYSQL: MySQL"n* PG:
                                              PostgreSQL"n* REDIS: Redis. Known values are: "UNSET",
                                              "MYSQL", "PG", and "REDIS".
                                            "name": "str",  # The name.
                                              Must be unique across all components within the same app.
                                              Required.
                                            "production": bool,  #
                                              Optional. Whether this is a production or dev database.
                                            "version": "str"  # Optional.
                                              The version of the database engine.
                                        }
                                    ],
                                    "domains": [
                                        {
                                            "domain": "str",  # The
                                              hostname for the domain. Required.
                                            "minimum_tls_version": "str",
                                              # Optional. The minimum version of TLS a client
                                              application can use to access resources for the domain.
                                              Must be one of the following values wrapped within
                                              quotations: ``"1.2"`` or ``"1.3"``. Known values are:
                                              "1.2" and "1.3".
                                            "type": "UNSPECIFIED",  #
                                              Optional. Default value is "UNSPECIFIED". * DEFAULT: The
                                              default ``.ondigitalocean.app`` domain assigned to this
                                              app"n* PRIMARY: The primary domain for this app that is
                                              displayed as the default in the control panel, used in
                                              bindable environment variables, and any other places that
                                              reference an app's live URL. Only one domain may be set
                                              as primary."n* ALIAS: A non-primary domain. Known values
                                              are: "UNSPECIFIED", "DEFAULT", "PRIMARY", and "ALIAS".
                                            "wildcard": bool,  #
                                              Optional. Indicates whether the domain includes all
                                              sub-domains, in addition to the given domain.
                                            "zone": "str"  # Optional.
                                              Optional. If the domain uses DigitalOcean DNS and you
                                              would like App"nPlatform to automatically manage it for
                                              you, set this to the name of the"ndomain on your
                                              account."n"nFor example, If the domain you are adding is
                                              ``app.domain.com``"" , the zone"ncould be ``domain.com``.
                                        }
                                    ],
                                    "functions": [
                                        {
                                            "alerts": [
                                                {
                                                    "disabled":
                                                      bool,  # Optional. Is the alert disabled?.
                                                    "operator":
                                                      "UNSPECIFIED_OPERATOR",  # Optional. Default
                                                      value is "UNSPECIFIED_OPERATOR". Known values
                                                      are: "UNSPECIFIED_OPERATOR", "GREATER_THAN", and
                                                      "LESS_THAN".
                                                    "rule":
                                                      "UNSPECIFIED_RULE",  # Optional. Default value is
                                                      "UNSPECIFIED_RULE". Known values are:
                                                      "UNSPECIFIED_RULE", "CPU_UTILIZATION",
                                                      "MEM_UTILIZATION", "RESTART_COUNT",
                                                      "DEPLOYMENT_FAILED", "DEPLOYMENT_LIVE",
                                                      "DOMAIN_FAILED", "DOMAIN_LIVE",
                                                      "FUNCTIONS_ACTIVATION_COUNT",
                                                      "FUNCTIONS_AVERAGE_DURATION_MS",
                                                      "FUNCTIONS_ERROR_RATE_PER_MINUTE",
                                                      "FUNCTIONS_AVERAGE_WAIT_TIME_MS",
                                                      "FUNCTIONS_ERROR_COUNT", and
                                                      "FUNCTIONS_GB_RATE_PER_SECOND".
                                                    "value": 0.0,
                                                      # Optional. Threshold value for alert.
                                                    "window":
                                                      "UNSPECIFIED_WINDOW"  # Optional. Default value
                                                      is "UNSPECIFIED_WINDOW". Known values are:
                                                      "UNSPECIFIED_WINDOW", "FIVE_MINUTES",
                                                      "TEN_MINUTES", "THIRTY_MINUTES", and "ONE_HOUR".
                                                }
                                            ],
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time"n* BUILD_TIME: Made
                                                      available only at build-time"n*
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable"n* SECRET: A secret encrypted
                                                      environment variable. Known values are: "GENERAL"
                                                      and "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "log_destinations": {
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "name": "str",  #
                                                  Required.
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            },
                                            "name": "str",  # The name.
                                              Must be unique across all components within the same app.
                                              Required.
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. An HTTP path prefix. Paths
                                                      must start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "jobs": [
                                        {
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://www.digitalocean.com/docs/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time"n* BUILD_TIME: Made
                                                      available only at build-time"n*
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable"n* SECRET: A secret encrypted
                                                      environment variable. Known values are: "GENERAL"
                                                      and "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type."n* DOCR: The DigitalOcean
                                                  container registry type. Known values are:
                                                  "DOCKER_HUB" and "DOCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1.
                                            "instance_size_slug":
                                              "basic-xxs",  # Optional. Default value is "basic-xxs".
                                              The instance size to use for this component. Default:
                                              ``basic-xxs``. Known values are: "basic-xxs", "basic-xs",
                                              "basic-s", "basic-m", "professional-xs",
                                              "professional-s", "professional-m", "professional-1l",
                                              "professional-l", and "professional-xl".
                                            "kind": "UNSPECIFIED",  #
                                              Optional. Default value is "UNSPECIFIED". * UNSPECIFIED:
                                              Default job type, will auto-complete to POST_DEPLOY
                                              kind."n* PRE_DEPLOY: Indicates a job that runs before an
                                              app deployment."n* POST_DEPLOY: Indicates a job that runs
                                              after an app deployment."n* FAILED_DEPLOY: Indicates a
                                              job that runs after a component fails to deploy. Known
                                              values are: "UNSPECIFIED", "PRE_DEPLOY", "POST_DEPLOY",
                                              and "FAILED_DEPLOY".
                                            "log_destinations": {
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "name": "str",  #
                                                  Required.
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            },
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "name": "str",  # The name of the app. Must
                                      be unique across all apps in the same account. Required.
                                    "region": "str",  # Optional. The slug form
                                      of the geographical origin of the app. Default: ``nearest
                                      available``. Known values are: "ams", "nyc", and "fra".
                                    "services": [
                                        {
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://www.digitalocean.com/docs/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time"n* BUILD_TIME: Made
                                                      available only at build-time"n*
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable"n* SECRET: A secret encrypted
                                                      environment variable. Known values are: "GENERAL"
                                                      and "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "health_check": {
                                                "failure_threshold":
                                                  0,  # Optional. The number of failed health checks
                                                  before considered unhealthy.
                                                "http_path": "str",
                                                  # Optional. The route path used for the HTTP health
                                                  check ping. If not set, the HTTP health check will be
                                                  disabled and a TCP health check used instead.
                "initial_delay_seconds": 0,  # Optional. The number
                                                  of seconds to wait before beginning health checks.
                                                "period_seconds": 0,
                                                  # Optional. The number of seconds to wait between
                                                  health checks.
                                                "port": 0,  #
                                                  Optional. The port on which the health check will be
                                                  performed. If not set, the health check will be
                                                  performed on the component's http_port.
                                                "success_threshold":
                                                  0,  # Optional. The number of successful health
                                                  checks before considered healthy.
                                                "timeout_seconds": 0
                                                  # Optional. The number of seconds after which the
                                                  check times out.
                                            },
                                            "http_port": 0,  # Optional.
                                              The internal port on which this service's run command
                                              will listen. Default: 8080"nIf there is not an
                                              environment variable with the name ``PORT``"" , one will
                                              be automatically added with its value set to the value of
                                              this field.
                                            "image": {
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type."n* DOCR: The DigitalOcean
                                                  container registry type. Known values are:
                                                  "DOCKER_HUB" and "DOCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1.
                                            "instance_size_slug":
                                              "basic-xxs",  # Optional. Default value is "basic-xxs".
                                              The instance size to use for this component. Default:
                                              ``basic-xxs``. Known values are: "basic-xxs", "basic-xs",
                                              "basic-s", "basic-m", "professional-xs",
                                              "professional-s", "professional-m", "professional-1l",
                                              "professional-l", and "professional-xl".
                                            "internal_ports": [
                                                0  # Optional. The
                                                  ports on which this service will listen for internal
                                                  traffic.
                                            ],
                                            "log_destinations": {
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "name": "str",  #
                                                  Required.
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            },
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. An HTTP path prefix. Paths
                                                      must start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "static_sites": [
                                        {
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "catchall_document": "str",
                                              # Optional. The name of the document to use as the
                                              fallback for any requests to documents that are not found
                                              when serving this static site. Only 1 of
                                              ``catchall_document`` or ``error_document`` can be set.
                                            "cors": {
                                                "allow_credentials":
                                                  bool,  # Optional. Whether browsers should expose the
                                                  response to the client-side JavaScript code when the
                                                  request"u2019s credentials mode is include. This
                                                  configures the ``Access-Control-Allow-Credentials``
                                                  header.
                                                "allow_headers": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP request
                                                      headers. This configures the
                                                      ``Access-Control-Allow-Headers`` header.
                                                ],
                                                "allow_methods": [
                                                    "str"  #
                                                      Optional. The set of allowed HTTP methods. This
                                                      configures the ``Access-Control-Allow-Methods``
                                                      header.
                                                ],
                                                "allow_origins": [
                                                    {
                "exact": "str",  # Optional. Exact string
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "prefix": "str",  # Optional. Prefix-based
                                                          match. Only 1 of ``exact``"" , ``prefix``"" ,
                                                          or ``regex`` must be set.
                "regex": "str"  # Optional. RE2 style
                                                          regex-based match. Only 1 of ``exact``"" ,
                                                          ``prefix``"" , or ``regex`` must be set. For
                                                          more information about RE2 syntax, see:
                                                          https://github.com/google/re2/wiki/Syntax.
                                                    }
                                                ],
                                                "expose_headers": [
                                                    "str"  #
                                                      Optional. The set of HTTP response headers that
                                                      browsers are allowed to access. This configures
                                                      the ``Access-Control-Expose-Headers`` header.
                                                ],
                                                "max_age": "str"  #
                                                  Optional. An optional duration specifying how long
                                                  browsers can cache the results of a preflight
                                                  request. This configures the
                                                  ``Access-Control-Max-Age`` header.
                                            },
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://www.digitalocean.com/docs/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time"n* BUILD_TIME: Made
                                                      available only at build-time"n*
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable"n* SECRET: A secret encrypted
                                                      environment variable. Known values are: "GENERAL"
                                                      and "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "error_document": "404.html",
                                              # Optional. Default value is "404.html". The name of the
                                              error document to use when serving this static site.
                                              Default: 404.html. If no such file exists within the
                                              built assets, App Platform will supply one.
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type."n* DOCR: The DigitalOcean
                                                  container registry type. Known values are:
                                                  "DOCKER_HUB" and "DOCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided.
                                            },
                                            "index_document":
                                              "index.html",  # Optional. Default value is "index.html".
                                              The name of the index document to use when serving this
                                              static site. Default: index.html.
                                            "log_destinations": {
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "name": "str",  #
                                                  Required.
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            },
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "output_dir": "str",  #
                                              Optional. An optional path to where the built assets will
                                              be located, relative to the build context. If not set,
                                              App Platform will automatically scan for these directory
                                              names: ``_static``"" , ``dist``"" , ``public``"" ,
                                              ``build``.
                                            "routes": [
                                                {
                                                    "path":
                                                      "str",  # Optional. An HTTP path prefix. Paths
                                                      must start with / and must be unique across all
                                                      components within an app.
                "preserve_path_prefix": bool  # Optional. An
                                                      optional flag to preserve the path that is
                                                      forwarded to the backend service. By default, the
                                                      HTTP request path will be trimmed from the left
                                                      when forwarded to the component. For example, a
                                                      component with ``path=/api`` will have requests
                                                      to ``/api/list`` trimmed to ``/list``. If this
                                                      value is ``true``"" , the path will remain
                                                      ``/api/list``.
                                                }
                                            ],
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ],
                                    "workers": [
                                        {
                                            "build_command": "str",  #
                                              Optional. An optional build command to run while building
                                              this component from source.
                                            "dockerfile_path": "str",  #
                                              Optional. The path to the Dockerfile relative to the root
                                              of the repo. If set, it will be used to build this
                                              component. Otherwise, App Platform will attempt to build
                                              it using buildpacks.
                                            "environment_slug": "str",  #
                                              Optional. An environment slug describing the type of this
                                              app. For a full list, please refer to `the product
                                              documentation
                                              <https://www.digitalocean.com/docs/app-platform/>`_.
                                            "envs": [
                                                {
                                                    "key": "str",
                                                      # The variable name. Required.
                                                    "scope":
                                                      "RUN_AND_BUILD_TIME",  # Optional. Default value
                                                      is "RUN_AND_BUILD_TIME". * RUN_TIME: Made
                                                      available only at run-time"n* BUILD_TIME: Made
                                                      available only at build-time"n*
                                                      RUN_AND_BUILD_TIME: Made available at both build
                                                      and run-time. Known values are: "UNSET",
                                                      "RUN_TIME", "BUILD_TIME", and
                                                      "RUN_AND_BUILD_TIME".
                                                    "type":
                                                      "GENERAL",  # Optional. Default value is
                                                      "GENERAL". * GENERAL: A plain-text environment
                                                      variable"n* SECRET: A secret encrypted
                                                      environment variable. Known values are: "GENERAL"
                                                      and "SECRET".
                                                    "value":
                                                      "str"  # Optional. The value. If the type is
                                                      ``SECRET``"" , the value will be encrypted on
                                                      first submission. On following submissions, the
                                                      encrypted value should be used.
                                                }
                                            ],
                                            "git": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "repo_clone_url":
                                                  "str"  # Optional. The clone URL of the repo.
                                                  Example:
                                                  ``https://github.com/digitalocean/sample-golang.git``.
                                            },
                                            "github": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "gitlab": {
                                                "branch": "str",  #
                                                  Optional. The name of the branch to use.
                                                "deploy_on_push":
                                                  bool,  # Optional. Whether to automatically deploy
                                                  new commits made to the repo.
                                                "repo": "str"  #
                                                  Optional. The name of the repo in the format
                                                  owner/repo. Example: ``digitalocean/sample-golang``.
                                            },
                                            "image": {
                                                "registry": "str",  #
                                                  Optional. The registry name. Must be left empty for
                                                  the ``DOCR`` registry type.
                                                "registry_type":
                                                  "str",  # Optional. * DOCKER_HUB: The DockerHub
                                                  container registry type."n* DOCR: The DigitalOcean
                                                  container registry type. Known values are:
                                                  "DOCKER_HUB" and "DOCR".
                                                "repository": "str",
                                                  # Optional. The repository name.
                                                "tag": "latest"  #
                                                  Optional. Default value is "latest". The repository
                                                  tag. Defaults to ``latest`` if not provided.
                                            },
                                            "instance_count": 1,  #
                                              Optional. Default value is 1. The amount of instances
                                              that this component should be scaled to. Default: 1.
                                            "instance_size_slug":
                                              "basic-xxs",  # Optional. Default value is "basic-xxs".
                                              The instance size to use for this component. Default:
                                              ``basic-xxs``. Known values are: "basic-xxs", "basic-xs",
                                              "basic-s", "basic-m", "professional-xs",
                                              "professional-s", "professional-m", "professional-1l",
                                              "professional-l", and "professional-xl".
                                            "log_destinations": {
                                                "datadog": {
                                                    "api_key":
                                                      "str",  # Datadog API key. Required.
                                                    "endpoint":
                                                      "str"  # Optional. Datadog HTTP log intake
                                                      endpoint.
                                                },
                                                "logtail": {
                                                    "token":
                                                      "str"  # Optional. Logtail token.
                                                },
                                                "name": "str",  #
                                                  Required.
                                                "papertrail": {
                                                    "endpoint":
                                                      "str"  # Papertrail syslog endpoint. Required.
                                                }
                                            },
                                            "name": "str",  # Optional.
                                              The name. Must be unique across all components within the
                                              same app.
                                            "run_command": "str",  #
                                              Optional. An optional run command to override the
                                              component's default.
                                            "source_dir": "str"  #
                                              Optional. An optional path to the working directory to
                                              use for the build. For Dockerfile builds, this will be
                                              used as the build context. Must be relative to the root
                                              of the repo.
                                        }
                                    ]
                                },
                                "static_sites": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this static site.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this static site.
                                    }
                                ],
                                "tier_slug": "str",  # Optional. The current pricing
                                  tier slug of the deployment.
                                "updated_at": "2020-02-20 00:00:00",  # Optional.
                                  When the deployment was last updated.
                                "workers": [
                                    {
                                        "name": "str",  # Optional. The name
                                          of this worker.
                                        "source_commit_hash": "str"  #
                                          Optional. The commit hash of the repository that was used to
                                          build this worker.
                                    }
                                ]
                            },
                            "region": {
                                "continent": "str",  # Optional. The continent that
                                  this region is in.
                                "data_centers": [
                                    "str"  # Optional. Data centers that are in
                                      this region.
                                ],
                                "default": bool,  # Optional. Whether or not the
                                  region is presented as the default.
                                "disabled": bool,  # Optional. Whether or not the
                                  region is open for new apps.
                                "flag": "str",  # Optional. The flag of this region.
                                "label": "str",  # Optional. A human-readable name of
                                  the region.
                                "reason": "str",  # Optional. Reason that this region
                                  is not available.
                                "slug": "str"  # Optional. The slug form of the
                                  region name.
                            },
                            "spec": {
                                "databases": [
                                    {
                                        "cluster_name": "str",  # Optional.
                                          The name of the underlying DigitalOcean DBaaS cluster. This
                                          is required for production databases. For dev databases, if
                                          cluster_name is not set, a new cluster will be provisioned.
                                        "db_name": "str",  # Optional. The
                                          name of the MySQL or PostgreSQL database to configure.
                                        "db_user": "str",  # Optional. The
                                          name of the MySQL or PostgreSQL user to configure.
                                        "engine": "UNSET",  # Optional.
                                          Default value is "UNSET". * MYSQL: MySQL"n* PG: PostgreSQL"n*
                                          REDIS: Redis. Known values are: "UNSET", "MYSQL", "PG", and
                                          "REDIS".
                                        "name": "str",  # The name. Must be
                                          unique across all components within the same app. Required.
                                        "production": bool,  # Optional.
                                          Whether this is a production or dev database.
                                        "version": "str"  # Optional. The
                                          version of the database engine.
                                    }
                                ],
                                "domains": [
                                    {
                                        "domain": "str",  # The hostname for
                                          the domain. Required.
                                        "minimum_tls_version": "str",  #
                                          Optional. The minimum version of TLS a client application can
                                          use to access resources for the domain.  Must be one of the
                                          following values wrapped within quotations: ``"1.2"`` or
                                          ``"1.3"``. Known values are: "1.2" and "1.3".
                                        "type": "UNSPECIFIED",  # Optional.
                                          Default value is "UNSPECIFIED". * DEFAULT: The default
                                          ``.ondigitalocean.app`` domain assigned to this app"n*
                                          PRIMARY: The primary domain for this app that is displayed as
                                          the default in the control panel, used in bindable
                                          environment variables, and any other places that reference an
                                          app's live URL. Only one domain may be set as primary."n*
                                          ALIAS: A non-primary domain. Known values are: "UNSPECIFIED",
                                          "DEFAULT", "PRIMARY", and "ALIAS".
                                        "wildcard": bool,  # Optional.
                                          Indicates whether the domain includes all sub-domains, in
                                          addition to the given domain.
                                        "zone": "str"  # Optional. Optional.
                                          If the domain uses DigitalOcean DNS and you would like
                                          App"nPlatform to automatically manage it for you, set this to
                                          the name of the"ndomain on your account."n"nFor example, If
                                          the domain you are adding is ``app.domain.com``"" , the
                                          zone"ncould be ``domain.com``.
                                    }
                                ],
                                "functions": [
                                    {
                                        "alerts": [
                                            {
                                                "disabled": bool,  #
                                                  Optional. Is the alert disabled?.
                                                "operator":
                                                  "UNSPECIFIED_OPERATOR",  # Optional. Default value is
                                                  "UNSPECIFIED_OPERATOR". Known values are:
                                                  "UNSPECIFIED_OPERATOR", "GREATER_THAN", and
                                                  "LESS_THAN".
                                                "rule":
                                                  "UNSPECIFIED_RULE",  # Optional. Default value is
                                                  "UNSPECIFIED_RULE". Known values are:
                                                  "UNSPECIFIED_RULE", "CPU_UTILIZATION",
                                                  "MEM_UTILIZATION", "RESTART_COUNT",
                                                  "DEPLOYMENT_FAILED", "DEPLOYMENT_LIVE",
                                                  "DOMAIN_FAILED", "DOMAIN_LIVE",
                                                  "FUNCTIONS_ACTIVATION_COUNT",
                                                  "FUNCTIONS_AVERAGE_DURATION_MS",
                                                  "FUNCTIONS_ERROR_RATE_PER_MINUTE",
                                                  "FUNCTIONS_AVERAGE_WAIT_TIME_MS",
                                                  "FUNCTIONS_ERROR_COUNT", and
                                                  "FUNCTIONS_GB_RATE_PER_SECOND".
                                                "value": 0.0,  #
                                                  Optional. Threshold value for alert.
                                                "window":
                                                  "UNSPECIFIED_WINDOW"  # Optional. Default value is
                                                  "UNSPECIFIED_WINDOW". Known values are:
                                                  "UNSPECIFIED_WINDOW", "FIVE_MINUTES", "TEN_MINUTES",
                                                  "THIRTY_MINUTES", and "ONE_HOUR".
                                            }
                                        ],
                                        "cors": {
                                            "allow_credentials": bool,  #
                                              Optional. Whether browsers should expose the response to
                                              the client-side JavaScript code when the request"u2019s
                                              credentials mode is include. This configures the
                                              ``Access-Control-Allow-Credentials`` header.
                                            "allow_headers": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP request headers. This
                                                  configures the ``Access-Control-Allow-Headers``
                                                  header.
                                            ],
                                            "allow_methods": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP methods. This configures the
                                                  ``Access-Control-Allow-Methods`` header.
                                            ],
                                            "allow_origins": [
                                                {
                                                    "exact":
                                                      "str",  # Optional. Exact string match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "prefix":
                                                      "str",  # Optional. Prefix-based match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "regex":
                                                      "str"  # Optional. RE2 style regex-based match.
                                                      Only 1 of ``exact``"" , ``prefix``"" , or
                                                      ``regex`` must be set. For more information about
                                                      RE2 syntax, see:
                                                      https://github.com/google/re2/wiki/Syntax.
                                                }
                                            ],
                                            "expose_headers": [
                                                "str"  # Optional.
                                                  The set of HTTP response headers that browsers are
                                                  allowed to access. This configures the
                                                  ``Access-Control-Expose-Headers`` header.
                                            ],
                                            "max_age": "str"  # Optional.
                                              An optional duration specifying how long browsers can
                                              cache the results of a preflight request. This configures
                                              the ``Access-Control-Max-Age`` header.
                                        },
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # The name. Must be
                                          unique across all components within the same app. Required.
                                        "routes": [
                                            {
                                                "path": "str",  #
                                                  Optional. An HTTP path prefix. Paths must start with
                                                  / and must be unique across all components within an
                                                  app.
                "preserve_path_prefix": bool  # Optional. An optional
                                                  flag to preserve the path that is forwarded to the
                                                  backend service. By default, the HTTP request path
                                                  will be trimmed from the left when forwarded to the
                                                  component. For example, a component with
                                                  ``path=/api`` will have requests to ``/api/list``
                                                  trimmed to ``/list``. If this value is ``true``"" ,
                                                  the path will remain ``/api/list``.
                                            }
                                        ],
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "jobs": [
                                    {
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://www.digitalocean.com/docs/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "image": {
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type."n* DOCR: The DigitalOcean container registry type.
                                              Known values are: "DOCKER_HUB" and "DOCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided.
                                        },
                                        "instance_count": 1,  # Optional.
                                          Default value is 1. The amount of instances that this
                                          component should be scaled to. Default: 1.
                                        "instance_size_slug": "basic-xxs",  #
                                          Optional. Default value is "basic-xxs". The instance size to
                                          use for this component. Default: ``basic-xxs``. Known values
                                          are: "basic-xxs", "basic-xs", "basic-s", "basic-m",
                                          "professional-xs", "professional-s", "professional-m",
                                          "professional-1l", "professional-l", and "professional-xl".
                                        "kind": "UNSPECIFIED",  # Optional.
                                          Default value is "UNSPECIFIED". * UNSPECIFIED: Default job
                                          type, will auto-complete to POST_DEPLOY kind."n* PRE_DEPLOY:
                                          Indicates a job that runs before an app deployment."n*
                                          POST_DEPLOY: Indicates a job that runs after an app
                                          deployment."n* FAILED_DEPLOY: Indicates a job that runs after
                                          a component fails to deploy. Known values are: "UNSPECIFIED",
                                          "PRE_DEPLOY", "POST_DEPLOY", and "FAILED_DEPLOY".
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "name": "str",  # The name of the app. Must be unique
                                  across all apps in the same account. Required.
                                "region": "str",  # Optional. The slug form of the
                                  geographical origin of the app. Default: ``nearest available``. Known
                                  values are: "ams", "nyc", and "fra".
                                "services": [
                                    {
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "cors": {
                                            "allow_credentials": bool,  #
                                              Optional. Whether browsers should expose the response to
                                              the client-side JavaScript code when the request"u2019s
                                              credentials mode is include. This configures the
                                              ``Access-Control-Allow-Credentials`` header.
                                            "allow_headers": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP request headers. This
                                                  configures the ``Access-Control-Allow-Headers``
                                                  header.
                                            ],
                                            "allow_methods": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP methods. This configures the
                                                  ``Access-Control-Allow-Methods`` header.
                                            ],
                                            "allow_origins": [
                                                {
                                                    "exact":
                                                      "str",  # Optional. Exact string match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "prefix":
                                                      "str",  # Optional. Prefix-based match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "regex":
                                                      "str"  # Optional. RE2 style regex-based match.
                                                      Only 1 of ``exact``"" , ``prefix``"" , or
                                                      ``regex`` must be set. For more information about
                                                      RE2 syntax, see:
                                                      https://github.com/google/re2/wiki/Syntax.
                                                }
                                            ],
                                            "expose_headers": [
                                                "str"  # Optional.
                                                  The set of HTTP response headers that browsers are
                                                  allowed to access. This configures the
                                                  ``Access-Control-Expose-Headers`` header.
                                            ],
                                            "max_age": "str"  # Optional.
                                              An optional duration specifying how long browsers can
                                              cache the results of a preflight request. This configures
                                              the ``Access-Control-Max-Age`` header.
                                        },
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://www.digitalocean.com/docs/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "health_check": {
                                            "failure_threshold": 0,  #
                                              Optional. The number of failed health checks before
                                              considered unhealthy.
                                            "http_path": "str",  #
                                              Optional. The route path used for the HTTP health check
                                              ping. If not set, the HTTP health check will be disabled
                                              and a TCP health check used instead.
                                            "initial_delay_seconds": 0,
                                              # Optional. The number of seconds to wait before
                                              beginning health checks.
                                            "period_seconds": 0,  #
                                              Optional. The number of seconds to wait between health
                                              checks.
                                            "port": 0,  # Optional. The
                                              port on which the health check will be performed. If not
                                              set, the health check will be performed on the
                                              component's http_port.
                                            "success_threshold": 0,  #
                                              Optional. The number of successful health checks before
                                              considered healthy.
                                            "timeout_seconds": 0  #
                                              Optional. The number of seconds after which the check
                                              times out.
                                        },
                                        "http_port": 0,  # Optional. The
                                          internal port on which this service's run command will
                                          listen. Default: 8080"nIf there is not an environment
                                          variable with the name ``PORT``"" , one will be automatically
                                          added with its value set to the value of this field.
                                        "image": {
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type."n* DOCR: The DigitalOcean container registry type.
                                              Known values are: "DOCKER_HUB" and "DOCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided.
                                        },
                                        "instance_count": 1,  # Optional.
                                          Default value is 1. The amount of instances that this
                                          component should be scaled to. Default: 1.
                                        "instance_size_slug": "basic-xxs",  #
                                          Optional. Default value is "basic-xxs". The instance size to
                                          use for this component. Default: ``basic-xxs``. Known values
                                          are: "basic-xxs", "basic-xs", "basic-s", "basic-m",
                                          "professional-xs", "professional-s", "professional-m",
                                          "professional-1l", "professional-l", and "professional-xl".
                                        "internal_ports": [
                                            0  # Optional. The ports on
                                              which this service will listen for internal traffic.
                                        ],
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "routes": [
                                            {
                                                "path": "str",  #
                                                  Optional. An HTTP path prefix. Paths must start with
                                                  / and must be unique across all components within an
                                                  app.
                "preserve_path_prefix": bool  # Optional. An optional
                                                  flag to preserve the path that is forwarded to the
                                                  backend service. By default, the HTTP request path
                                                  will be trimmed from the left when forwarded to the
                                                  component. For example, a component with
                                                  ``path=/api`` will have requests to ``/api/list``
                                                  trimmed to ``/list``. If this value is ``true``"" ,
                                                  the path will remain ``/api/list``.
                                            }
                                        ],
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "static_sites": [
                                    {
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "catchall_document": "str",  #
                                          Optional. The name of the document to use as the fallback for
                                          any requests to documents that are not found when serving
                                          this static site. Only 1 of ``catchall_document`` or
                                          ``error_document`` can be set.
                                        "cors": {
                                            "allow_credentials": bool,  #
                                              Optional. Whether browsers should expose the response to
                                              the client-side JavaScript code when the request"u2019s
                                              credentials mode is include. This configures the
                                              ``Access-Control-Allow-Credentials`` header.
                                            "allow_headers": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP request headers. This
                                                  configures the ``Access-Control-Allow-Headers``
                                                  header.
                                            ],
                                            "allow_methods": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP methods. This configures the
                                                  ``Access-Control-Allow-Methods`` header.
                                            ],
                                            "allow_origins": [
                                                {
                                                    "exact":
                                                      "str",  # Optional. Exact string match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "prefix":
                                                      "str",  # Optional. Prefix-based match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "regex":
                                                      "str"  # Optional. RE2 style regex-based match.
                                                      Only 1 of ``exact``"" , ``prefix``"" , or
                                                      ``regex`` must be set. For more information about
                                                      RE2 syntax, see:
                                                      https://github.com/google/re2/wiki/Syntax.
                                                }
                                            ],
                                            "expose_headers": [
                                                "str"  # Optional.
                                                  The set of HTTP response headers that browsers are
                                                  allowed to access. This configures the
                                                  ``Access-Control-Expose-Headers`` header.
                                            ],
                                            "max_age": "str"  # Optional.
                                              An optional duration specifying how long browsers can
                                              cache the results of a preflight request. This configures
                                              the ``Access-Control-Max-Age`` header.
                                        },
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://www.digitalocean.com/docs/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "error_document": "404.html",  #
                                          Optional. Default value is "404.html". The name of the error
                                          document to use when serving this static site. Default:
                                          404.html. If no such file exists within the built assets, App
                                          Platform will supply one.
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "image": {
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type."n* DOCR: The DigitalOcean container registry type.
                                              Known values are: "DOCKER_HUB" and "DOCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided.
                                        },
                                        "index_document": "index.html",  #
                                          Optional. Default value is "index.html". The name of the
                                          index document to use when serving this static site. Default:
                                          index.html.
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "output_dir": "str",  # Optional. An
                                          optional path to where the built assets will be located,
                                          relative to the build context. If not set, App Platform will
                                          automatically scan for these directory names: ``_static``"" ,
                                          ``dist``"" , ``public``"" , ``build``.
                                        "routes": [
                                            {
                                                "path": "str",  #
                                                  Optional. An HTTP path prefix. Paths must start with
                                                  / and must be unique across all components within an
                                                  app.
                "preserve_path_prefix": bool  # Optional. An optional
                                                  flag to preserve the path that is forwarded to the
                                                  backend service. By default, the HTTP request path
                                                  will be trimmed from the left when forwarded to the
                                                  component. For example, a component with
                                                  ``path=/api`` will have requests to ``/api/list``
                                                  trimmed to ``/list``. If this value is ``true``"" ,
                                                  the path will remain ``/api/list``.
                                            }
                                        ],
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "workers": [
                                    {
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://www.digitalocean.com/docs/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "image": {
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type."n* DOCR: The DigitalOcean container registry type.
                                              Known values are: "DOCKER_HUB" and "DOCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided.
                                        },
                                        "instance_count": 1,  # Optional.
                                          Default value is 1. The amount of instances that this
                                          component should be scaled to. Default: 1.
                                        "instance_size_slug": "basic-xxs",  #
                                          Optional. Default value is "basic-xxs". The instance size to
                                          use for this component. Default: ``basic-xxs``. Known values
                                          are: "basic-xxs", "basic-xs", "basic-s", "basic-m",
                                          "professional-xs", "professional-s", "professional-m",
                                          "professional-1l", "professional-l", and "professional-xl".
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ]
                            },
                            "tier_slug": "str",  # Optional. The current pricing tier
                              slug of the app.
                            "updated_at": "2020-02-20 00:00:00"  # Optional. Time of the
                              app's last configuration update.
                        }
                    ],
                    "links": {
                        "pages": {}
                    },
                    "meta": {
                        "total": 0  # Optional. Number of objects returned by the request.
                    }
                }
                # response body for status code(s): 401, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """
        error_map = {
            401: ClientAuthenticationError,
            404: ResourceNotFoundError,
            409: ResourceExistsError,
        }
        error_map.update(kwargs.pop("error_map", {}) or {})

        _headers = kwargs.pop("headers", {}) or {}
        _params = kwargs.pop("params", {}) or {}

        cls = kwargs.pop("cls", None)  # type: ClsType[JSON]

        request = build_apps_list_request(
            page=page,
            per_page=per_page,
            headers=_headers,
            params=_params,
        )
        request.url = self._client.format_url(request.url)  # type: ignore

        pipeline_response = self._client._pipeline.run(  # type: ignore # pylint: disable=protected-access
            request, stream=False, **kwargs
        )

        response = pipeline_response.http_response

        if response.status_code not in [200, 401, 429, 500]:
            map_error(
                status_code=response.status_code, response=response, error_map=error_map
            )
            raise HttpResponseError(response=response)

        response_headers = {}
        if response.status_code == 200:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 401:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 429:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if response.status_code == 500:
            response_headers["ratelimit-limit"] = self._deserialize(
                "int", response.headers.get("ratelimit-limit")
            )
            response_headers["ratelimit-remaining"] = self._deserialize(
                "int", response.headers.get("ratelimit-remaining")
            )
            response_headers["ratelimit-reset"] = self._deserialize(
                "int", response.headers.get("ratelimit-reset")
            )

            if response.content:
                deserialized = response.json()
            else:
                deserialized = None

        if cls:
            return cls(pipeline_response, cast(JSON, deserialized), response_headers)

        return cast(JSON, deserialized)

    @overload
    def create(
        self, body: JSON, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a New App.

        Create a new app by submitting an app specification. For documentation on app specifications (\
        ``AppSpec`` objects), please refer to `the product documentation
        <https://docs.digitalocean.com/products/app-platform/reference/app-spec/>`_.

        :param body: Required.
        :type body: JSON
        :keyword content_type: Body Parameter content-type. Content type parameter for JSON body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # JSON input template you can fill out and use as your body input.
                body = {
                    "spec": {
                        "databases": [
                            {
                                "cluster_name": "str",  # Optional. The name of the
                                  underlying DigitalOcean DBaaS cluster. This is required for
                                  production databases. For dev databases, if cluster_name is not set,
                                  a new cluster will be provisioned.
                                "db_name": "str",  # Optional. The name of the MySQL
                                  or PostgreSQL database to configure.
                                "db_user": "str",  # Optional. The name of the MySQL
                                  or PostgreSQL user to configure.
                                "engine": "UNSET",  # Optional. Default value is
                                  "UNSET". * MYSQL: MySQL"n* PG: PostgreSQL"n* REDIS: Redis. Known
                                  values are: "UNSET", "MYSQL", "PG", and "REDIS".
                                "name": "str",  # The name. Must be unique across all
                                  components within the same app. Required.
                                "production": bool,  # Optional. Whether this is a
                                  production or dev database.
                                "version": "str"  # Optional. The version of the
                                  database engine.
                            }
                        ],
                        "domains": [
                            {
                                "domain": "str",  # The hostname for the domain.
                                  Required.
                                "minimum_tls_version": "str",  # Optional. The
                                  minimum version of TLS a client application can use to access
                                  resources for the domain.  Must be one of the following values
                                  wrapped within quotations: ``"1.2"`` or ``"1.3"``. Known values are:
                                  "1.2" and "1.3".
                                "type": "UNSPECIFIED",  # Optional. Default value is
                                  "UNSPECIFIED". * DEFAULT: The default ``.ondigitalocean.app`` domain
                                  assigned to this app"n* PRIMARY: The primary domain for this app that
                                  is displayed as the default in the control panel, used in bindable
                                  environment variables, and any other places that reference an app's
                                  live URL. Only one domain may be set as primary."n* ALIAS: A
                                  non-primary domain. Known values are: "UNSPECIFIED", "DEFAULT",
                                  "PRIMARY", and "ALIAS".
                                "wildcard": bool,  # Optional. Indicates whether the
                                  domain includes all sub-domains, in addition to the given domain.
                                "zone": "str"  # Optional. Optional. If the domain
                                  uses DigitalOcean DNS and you would like App"nPlatform to
                                  automatically manage it for you, set this to the name of the"ndomain
                                  on your account."n"nFor example, If the domain you are adding is
                                  ``app.domain.com``"" , the zone"ncould be ``domain.com``.
                            }
                        ],
                        "functions": [
                            {
                                "alerts": [
                                    {
                                        "disabled": bool,  # Optional. Is the
                                          alert disabled?.
                                        "operator": "UNSPECIFIED_OPERATOR",
                                          # Optional. Default value is "UNSPECIFIED_OPERATOR". Known
                                          values are: "UNSPECIFIED_OPERATOR", "GREATER_THAN", and
                                          "LESS_THAN".
                                        "rule": "UNSPECIFIED_RULE",  #
                                          Optional. Default value is "UNSPECIFIED_RULE". Known values
                                          are: "UNSPECIFIED_RULE", "CPU_UTILIZATION",
                                          "MEM_UTILIZATION", "RESTART_COUNT", "DEPLOYMENT_FAILED",
                                          "DEPLOYMENT_LIVE", "DOMAIN_FAILED", "DOMAIN_LIVE",
                                          "FUNCTIONS_ACTIVATION_COUNT",
                                          "FUNCTIONS_AVERAGE_DURATION_MS",
                                          "FUNCTIONS_ERROR_RATE_PER_MINUTE",
                                          "FUNCTIONS_AVERAGE_WAIT_TIME_MS", "FUNCTIONS_ERROR_COUNT",
                                          and "FUNCTIONS_GB_RATE_PER_SECOND".
                                        "value": 0.0,  # Optional. Threshold
                                          value for alert.
                                        "window": "UNSPECIFIED_WINDOW"  #
                                          Optional. Default value is "UNSPECIFIED_WINDOW". Known values
                                          are: "UNSPECIFIED_WINDOW", "FIVE_MINUTES", "TEN_MINUTES",
                                          "THIRTY_MINUTES", and "ONE_HOUR".
                                    }
                                ],
                                "cors": {
                                    "allow_credentials": bool,  # Optional.
                                      Whether browsers should expose the response to the client-side
                                      JavaScript code when the request"u2019s credentials mode is
                                      include. This configures the ``Access-Control-Allow-Credentials``
                                      header.
                                    "allow_headers": [
                                        "str"  # Optional. The set of allowed
                                          HTTP request headers. This configures the
                                          ``Access-Control-Allow-Headers`` header.
                                    ],
                                    "allow_methods": [
                                        "str"  # Optional. The set of allowed
                                          HTTP methods. This configures the
                                          ``Access-Control-Allow-Methods`` header.
                                    ],
                                    "allow_origins": [
                                        {
                                            "exact": "str",  # Optional.
                                              Exact string match. Only 1 of ``exact``"" , ``prefix``""
                                              , or ``regex`` must be set.
                                            "prefix": "str",  # Optional.
                                              Prefix-based match. Only 1 of ``exact``"" , ``prefix``""
                                              , or ``regex`` must be set.
                                            "regex": "str"  # Optional.
                                              RE2 style regex-based match. Only 1 of ``exact``"" ,
                                              ``prefix``"" , or ``regex`` must be set. For more
                                              information about RE2 syntax, see:
                                              https://github.com/google/re2/wiki/Syntax.
                                        }
                                    ],
                                    "expose_headers": [
                                        "str"  # Optional. The set of HTTP
                                          response headers that browsers are allowed to access. This
                                          configures the ``Access-Control-Expose-Headers`` header.
                                    ],
                                    "max_age": "str"  # Optional. An optional
                                      duration specifying how long browsers can cache the results of a
                                      preflight request. This configures the ``Access-Control-Max-Age``
                                      header.
                                },
                                "envs": [
                                    {
                                        "key": "str",  # The variable name.
                                          Required.
                                        "scope": "RUN_AND_BUILD_TIME",  #
                                          Optional. Default value is "RUN_AND_BUILD_TIME". * RUN_TIME:
                                          Made available only at run-time"n* BUILD_TIME: Made available
                                          only at build-time"n* RUN_AND_BUILD_TIME: Made available at
                                          both build and run-time. Known values are: "UNSET",
                                          "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                        "type": "GENERAL",  # Optional.
                                          Default value is "GENERAL". * GENERAL: A plain-text
                                          environment variable"n* SECRET: A secret encrypted
                                          environment variable. Known values are: "GENERAL" and
                                          "SECRET".
                                        "value": "str"  # Optional. The
                                          value. If the type is ``SECRET``"" , the value will be
                                          encrypted on first submission. On following submissions, the
                                          encrypted value should be used.
                                    }
                                ],
                                "git": {
                                    "branch": "str",  # Optional. The name of the
                                      branch to use.
                                    "repo_clone_url": "str"  # Optional. The
                                      clone URL of the repo. Example:
                                      ``https://github.com/digitalocean/sample-golang.git``.
                                },
                                "github": {
                                    "branch": "str",  # Optional. The name of the
                                      branch to use.
                                    "deploy_on_push": bool,  # Optional. Whether
                                      to automatically deploy new commits made to the repo.
                                    "repo": "str"  # Optional. The name of the
                                      repo in the format owner/repo. Example:
                                      ``digitalocean/sample-golang``.
                                },
                                "gitlab": {
                                    "branch": "str",  # Optional. The name of the
                                      branch to use.
                                    "deploy_on_push": bool,  # Optional. Whether
                                      to automatically deploy new commits made to the repo.
                                    "repo": "str"  # Optional. The name of the
                                      repo in the format owner/repo. Example:
                                      ``digitalocean/sample-golang``.
                                },
                                "log_destinations": {
                                    "datadog": {
                                        "api_key": "str",  # Datadog API key.
                                          Required.
                                        "endpoint": "str"  # Optional.
                                          Datadog HTTP log intake endpoint.
                                    },
                                    "logtail": {
                                        "token": "str"  # Optional. Logtail
                                          token.
                                    },
                                    "name": "str",  # Required.
                                    "papertrail": {
                                        "endpoint": "str"  # Papertrail
                                          syslog endpoint. Required.
                                    }
                                },
                                "name": "str",  # The name. Must be unique across all
                                  components within the same app. Required.
                                "routes": [
                                    {
                                        "path": "str",  # Optional. An HTTP
                                          path prefix. Paths must start with / and must be unique
                                          across all components within an app.
                                        "preserve_path_prefix": bool  #
                                          Optional. An optional flag to preserve the path that is
                                          forwarded to the backend service. By default, the HTTP
                                          request path will be trimmed from the left when forwarded to
                                          the component. For example, a component with ``path=/api``
                                          will have requests to ``/api/list`` trimmed to ``/list``. If
                                          this value is ``true``"" , the path will remain
                                          ``/api/list``.
                                    }
                                ],
                                "source_dir": "str"  # Optional. An optional path to
                                  the working directory to use for the build. For Dockerfile builds,
                                  this will be used as the build context. Must be relative to the root
                                  of the repo.
                            }
                        ],
                        "jobs": [
                            {
                                "build_command": "str",  # Optional. An optional
                                  build command to run while building this component from source.
                                "dockerfile_path": "str",  # Optional. The path to
                                  the Dockerfile relative to the root of the repo. If set, it will be
                                  used to build this component. Otherwise, App Platform will attempt to
                                  build it using buildpacks.
                                "environment_slug": "str",  # Optional. An
                                  environment slug describing the type of this app. For a full list,
                                  please refer to `the product documentation
                                  <https://www.digitalocean.com/docs/app-platform/>`_.
                                "envs": [
                                    {
                                        "key": "str",  # The variable name.
                                          Required.
                                        "scope": "RUN_AND_BUILD_TIME",  #
                                          Optional. Default value is "RUN_AND_BUILD_TIME". * RUN_TIME:
                                          Made available only at run-time"n* BUILD_TIME: Made available
                                          only at build-time"n* RUN_AND_BUILD_TIME: Made available at
                                          both build and run-time. Known values are: "UNSET",
                                          "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                        "type": "GENERAL",  # Optional.
                                          Default value is "GENERAL". * GENERAL: A plain-text
                                          environment variable"n* SECRET: A secret encrypted
                                          environment variable. Known values are: "GENERAL" and
                                          "SECRET".
                                        "value": "str"  # Optional. The
                                          value. If the type is ``SECRET``"" , the value will be
                                          encrypted on first submission. On following submissions, the
                                          encrypted value should be used.
                                    }
                                ],
                                "git": {
                                    "branch": "str",  # Optional. The name of the
                                      branch to use.
                                    "repo_clone_url": "str"  # Optional. The
                                      clone URL of the repo. Example:
                                      ``https://github.com/digitalocean/sample-golang.git``.
                                },
                                "github": {
                                    "branch": "str",  # Optional. The name of the
                                      branch to use.
                                    "deploy_on_push": bool,  # Optional. Whether
                                      to automatically deploy new commits made to the repo.
                                    "repo": "str"  # Optional. The name of the
                                      repo in the format owner/repo. Example:
                                      ``digitalocean/sample-golang``.
                                },
                                "gitlab": {
                                    "branch": "str",  # Optional. The name of the
                                      branch to use.
                                    "deploy_on_push": bool,  # Optional. Whether
                                      to automatically deploy new commits made to the repo.
                                    "repo": "str"  # Optional. The name of the
                                      repo in the format owner/repo. Example:
                                      ``digitalocean/sample-golang``.
                                },
                                "image": {
                                    "registry": "str",  # Optional. The registry
                                      name. Must be left empty for the ``DOCR`` registry type.
                                    "registry_type": "str",  # Optional. *
                                      DOCKER_HUB: The DockerHub container registry type."n* DOCR: The
                                      DigitalOcean container registry type. Known values are:
                                      "DOCKER_HUB" and "DOCR".
                                    "repository": "str",  # Optional. The
                                      repository name.
                                    "tag": "latest"  # Optional. Default value is
                                      "latest". The repository tag. Defaults to ``latest`` if not
                                      provided.
                                },
                                "instance_count": 1,  # Optional. Default value is 1.
                                  The amount of instances that this component should be scaled to.
                                  Default: 1.
                                "instance_size_slug": "basic-xxs",  # Optional.
                                  Default value is "basic-xxs". The instance size to use for this
                                  component. Default: ``basic-xxs``. Known values are: "basic-xxs",
                                  "basic-xs", "basic-s", "basic-m", "professional-xs",
                                  "professional-s", "professional-m", "professional-1l",
                                  "professional-l", and "professional-xl".
                                "kind": "UNSPECIFIED",  # Optional. Default value is
                                  "UNSPECIFIED". * UNSPECIFIED: Default job type, will auto-complete to
                                  POST_DEPLOY kind."n* PRE_DEPLOY: Indicates a job that runs before an
                                  app deployment."n* POST_DEPLOY: Indicates a job that runs after an
                                  app deployment."n* FAILED_DEPLOY: Indicates a job that runs after a
                                  component fails to deploy. Known values are: "UNSPECIFIED",
                                  "PRE_DEPLOY", "POST_DEPLOY", and "FAILED_DEPLOY".
                                "log_destinations": {
                                    "datadog": {
                                        "api_key": "str",  # Datadog API key.
                                          Required.
                                        "endpoint": "str"  # Optional.
                                          Datadog HTTP log intake endpoint.
                                    },
                                    "logtail": {
                                        "token": "str"  # Optional. Logtail
                                          token.
                                    },
                                    "name": "str",  # Required.
                                    "papertrail": {
                                        "endpoint": "str"  # Papertrail
                                          syslog endpoint. Required.
                                    }
                                },
                                "name": "str",  # Optional. The name. Must be unique
                                  across all components within the same app.
                                "run_command": "str",  # Optional. An optional run
                                  command to override the component's default.
                                "source_dir": "str"  # Optional. An optional path to
                                  the working directory to use for the build. For Dockerfile builds,
                                  this will be used as the build context. Must be relative to the root
                                  of the repo.
                            }
                        ],
                        "name": "str",  # The name of the app. Must be unique across all apps
                          in the same account. Required.
                        "region": "str",  # Optional. The slug form of the geographical
                          origin of the app. Default: ``nearest available``. Known values are: "ams",
                          "nyc", and "fra".
                        "services": [
                            {
                                "build_command": "str",  # Optional. An optional
                                  build command to run while building this component from source.
                                "cors": {
                                    "allow_credentials": bool,  # Optional.
                                      Whether browsers should expose the response to the client-side
                                      JavaScript code when the request"u2019s credentials mode is
                                      include. This configures the ``Access-Control-Allow-Credentials``
                                      header.
                                    "allow_headers": [
                                        "str"  # Optional. The set of allowed
                                          HTTP request headers. This configures the
                                          ``Access-Control-Allow-Headers`` header.
                                    ],
                                    "allow_methods": [
                                        "str"  # Optional. The set of allowed
                                          HTTP methods. This configures the
                                          ``Access-Control-Allow-Methods`` header.
                                    ],
                                    "allow_origins": [
                                        {
                                            "exact": "str",  # Optional.
                                              Exact string match. Only 1 of ``exact``"" , ``prefix``""
                                              , or ``regex`` must be set.
                                            "prefix": "str",  # Optional.
                                              Prefix-based match. Only 1 of ``exact``"" , ``prefix``""
                                              , or ``regex`` must be set.
                                            "regex": "str"  # Optional.
                                              RE2 style regex-based match. Only 1 of ``exact``"" ,
                                              ``prefix``"" , or ``regex`` must be set. For more
                                              information about RE2 syntax, see:
                                              https://github.com/google/re2/wiki/Syntax.
                                        }
                                    ],
                                    "expose_headers": [
                                        "str"  # Optional. The set of HTTP
                                          response headers that browsers are allowed to access. This
                                          configures the ``Access-Control-Expose-Headers`` header.
                                    ],
                                    "max_age": "str"  # Optional. An optional
                                      duration specifying how long browsers can cache the results of a
                                      preflight request. This configures the ``Access-Control-Max-Age``
                                      header.
                                },
                                "dockerfile_path": "str",  # Optional. The path to
                                  the Dockerfile relative to the root of the repo. If set, it will be
                                  used to build this component. Otherwise, App Platform will attempt to
                                  build it using buildpacks.
                                "environment_slug": "str",  # Optional. An
                                  environment slug describing the type of this app. For a full list,
                                  please refer to `the product documentation
                                  <https://www.digitalocean.com/docs/app-platform/>`_.
                                "envs": [
                                    {
                                        "key": "str",  # The variable name.
                                          Required.
                                        "scope": "RUN_AND_BUILD_TIME",  #
                                          Optional. Default value is "RUN_AND_BUILD_TIME". * RUN_TIME:
                                          Made available only at run-time"n* BUILD_TIME: Made available
                                          only at build-time"n* RUN_AND_BUILD_TIME: Made available at
                                          both build and run-time. Known values are: "UNSET",
                                          "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                        "type": "GENERAL",  # Optional.
                                          Default value is "GENERAL". * GENERAL: A plain-text
                                          environment variable"n* SECRET: A secret encrypted
                                          environment variable. Known values are: "GENERAL" and
                                          "SECRET".
                                        "value": "str"  # Optional. The
                                          value. If the type is ``SECRET``"" , the value will be
                                          encrypted on first submission. On following submissions, the
                                          encrypted value should be used.
                                    }
                                ],
                                "git": {
                                    "branch": "str",  # Optional. The name of the
                                      branch to use.
                                    "repo_clone_url": "str"  # Optional. The
                                      clone URL of the repo. Example:
                                      ``https://github.com/digitalocean/sample-golang.git``.
                                },
                                "github": {
                                    "branch": "str",  # Optional. The name of the
                                      branch to use.
                                    "deploy_on_push": bool,  # Optional. Whether
                                      to automatically deploy new commits made to the repo.
                                    "repo": "str"  # Optional. The name of the
                                      repo in the format owner/repo. Example:
                                      ``digitalocean/sample-golang``.
                                },
                                "gitlab": {
                                    "branch": "str",  # Optional. The name of the
                                      branch to use.
                                    "deploy_on_push": bool,  # Optional. Whether
                                      to automatically deploy new commits made to the repo.
                                    "repo": "str"  # Optional. The name of the
                                      repo in the format owner/repo. Example:
                                      ``digitalocean/sample-golang``.
                                },
                                "health_check": {
                                    "failure_threshold": 0,  # Optional. The
                                      number of failed health checks before considered unhealthy.
                                    "http_path": "str",  # Optional. The route
                                      path used for the HTTP health check ping. If not set, the HTTP
                                      health check will be disabled and a TCP health check used
                                      instead.
                                    "initial_delay_seconds": 0,  # Optional. The
                                      number of seconds to wait before beginning health checks.
                                    "period_seconds": 0,  # Optional. The number
                                      of seconds to wait between health checks.
                                    "port": 0,  # Optional. The port on which the
                                      health check will be performed. If not set, the health check will
                                      be performed on the component's http_port.
                                    "success_threshold": 0,  # Optional. The
                                      number of successful health checks before considered healthy.
                                    "timeout_seconds": 0  # Optional. The number
                                      of seconds after which the check times out.
                                },
                                "http_port": 0,  # Optional. The internal port on
                                  which this service's run command will listen. Default: 8080"nIf there
                                  is not an environment variable with the name ``PORT``"" , one will be
                                  automatically added with its value set to the value of this field.
                                "image": {
                                    "registry": "str",  # Optional. The registry
                                      name. Must be left empty for the ``DOCR`` registry type.
                                    "registry_type": "str",  # Optional. *
                                      DOCKER_HUB: The DockerHub container registry type."n* DOCR: The
                                      DigitalOcean container registry type. Known values are:
                                      "DOCKER_HUB" and "DOCR".
                                    "repository": "str",  # Optional. The
                                      repository name.
                                    "tag": "latest"  # Optional. Default value is
                                      "latest". The repository tag. Defaults to ``latest`` if not
                                      provided.
                                },
                                "instance_count": 1,  # Optional. Default value is 1.
                                  The amount of instances that this component should be scaled to.
                                  Default: 1.
                                "instance_size_slug": "basic-xxs",  # Optional.
                                  Default value is "basic-xxs". The instance size to use for this
                                  component. Default: ``basic-xxs``. Known values are: "basic-xxs",
                                  "basic-xs", "basic-s", "basic-m", "professional-xs",
                                  "professional-s", "professional-m", "professional-1l",
                                  "professional-l", and "professional-xl".
                                "internal_ports": [
                                    0  # Optional. The ports on which this
                                      service will listen for internal traffic.
                                ],
                                "log_destinations": {
                                    "datadog": {
                                        "api_key": "str",  # Datadog API key.
                                          Required.
                                        "endpoint": "str"  # Optional.
                                          Datadog HTTP log intake endpoint.
                                    },
                                    "logtail": {
                                        "token": "str"  # Optional. Logtail
                                          token.
                                    },
                                    "name": "str",  # Required.
                                    "papertrail": {
                                        "endpoint": "str"  # Papertrail
                                          syslog endpoint. Required.
                                    }
                                },
                                "name": "str",  # Optional. The name. Must be unique
                                  across all components within the same app.
                                "routes": [
                                    {
                                        "path": "str",  # Optional. An HTTP
                                          path prefix. Paths must start with / and must be unique
                                          across all components within an app.
                                        "preserve_path_prefix": bool  #
                                          Optional. An optional flag to preserve the path that is
                                          forwarded to the backend service. By default, the HTTP
                                          request path will be trimmed from the left when forwarded to
                                          the component. For example, a component with ``path=/api``
                                          will have requests to ``/api/list`` trimmed to ``/list``. If
                                          this value is ``true``"" , the path will remain
                                          ``/api/list``.
                                    }
                                ],
                                "run_command": "str",  # Optional. An optional run
                                  command to override the component's default.
                                "source_dir": "str"  # Optional. An optional path to
                                  the working directory to use for the build. For Dockerfile builds,
                                  this will be used as the build context. Must be relative to the root
                                  of the repo.
                            }
                        ],
                        "static_sites": [
                            {
                                "build_command": "str",  # Optional. An optional
                                  build command to run while building this component from source.
                                "catchall_document": "str",  # Optional. The name of
                                  the document to use as the fallback for any requests to documents
                                  that are not found when serving this static site. Only 1 of
                                  ``catchall_document`` or ``error_document`` can be set.
                                "cors": {
                                    "allow_credentials": bool,  # Optional.
                                      Whether browsers should expose the response to the client-side
                                      JavaScript code when the request"u2019s credentials mode is
                                      include. This configures the ``Access-Control-Allow-Credentials``
                                      header.
                                    "allow_headers": [
                                        "str"  # Optional. The set of allowed
                                          HTTP request headers. This configures the
                                          ``Access-Control-Allow-Headers`` header.
                                    ],
                                    "allow_methods": [
                                        "str"  # Optional. The set of allowed
                                          HTTP methods. This configures the
                                          ``Access-Control-Allow-Methods`` header.
                                    ],
                                    "allow_origins": [
                                        {
                                            "exact": "str",  # Optional.
                                              Exact string match. Only 1 of ``exact``"" , ``prefix``""
                                              , or ``regex`` must be set.
                                            "prefix": "str",  # Optional.
                                              Prefix-based match. Only 1 of ``exact``"" , ``prefix``""
                                              , or ``regex`` must be set.
                                            "regex": "str"  # Optional.
                                              RE2 style regex-based match. Only 1 of ``exact``"" ,
                                              ``prefix``"" , or ``regex`` must be set. For more
                                              information about RE2 syntax, see:
                                              https://github.com/google/re2/wiki/Syntax.
                                        }
                                    ],
                                    "expose_headers": [
                                        "str"  # Optional. The set of HTTP
                                          response headers that browsers are allowed to access. This
                                          configures the ``Access-Control-Expose-Headers`` header.
                                    ],
                                    "max_age": "str"  # Optional. An optional
                                      duration specifying how long browsers can cache the results of a
                                      preflight request. This configures the ``Access-Control-Max-Age``
                                      header.
                                },
                                "dockerfile_path": "str",  # Optional. The path to
                                  the Dockerfile relative to the root of the repo. If set, it will be
                                  used to build this component. Otherwise, App Platform will attempt to
                                  build it using buildpacks.
                                "environment_slug": "str",  # Optional. An
                                  environment slug describing the type of this app. For a full list,
                                  please refer to `the product documentation
                                  <https://www.digitalocean.com/docs/app-platform/>`_.
                                "envs": [
                                    {
                                        "key": "str",  # The variable name.
                                          Required.
                                        "scope": "RUN_AND_BUILD_TIME",  #
                                          Optional. Default value is "RUN_AND_BUILD_TIME". * RUN_TIME:
                                          Made available only at run-time"n* BUILD_TIME: Made available
                                          only at build-time"n* RUN_AND_BUILD_TIME: Made available at
                                          both build and run-time. Known values are: "UNSET",
                                          "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                        "type": "GENERAL",  # Optional.
                                          Default value is "GENERAL". * GENERAL: A plain-text
                                          environment variable"n* SECRET: A secret encrypted
                                          environment variable. Known values are: "GENERAL" and
                                          "SECRET".
                                        "value": "str"  # Optional. The
                                          value. If the type is ``SECRET``"" , the value will be
                                          encrypted on first submission. On following submissions, the
                                          encrypted value should be used.
                                    }
                                ],
                                "error_document": "404.html",  # Optional. Default
                                  value is "404.html". The name of the error document to use when
                                  serving this static site. Default: 404.html. If no such file exists
                                  within the built assets, App Platform will supply one.
                                "git": {
                                    "branch": "str",  # Optional. The name of the
                                      branch to use.
                                    "repo_clone_url": "str"  # Optional. The
                                      clone URL of the repo. Example:
                                      ``https://github.com/digitalocean/sample-golang.git``.
                                },
                                "github": {
                                    "branch": "str",  # Optional. The name of the
                                      branch to use.
                                    "deploy_on_push": bool,  # Optional. Whether
                                      to automatically deploy new commits made to the repo.
                                    "repo": "str"  # Optional. The name of the
                                      repo in the format owner/repo. Example:
                                      ``digitalocean/sample-golang``.
                                },
                                "gitlab": {
                                    "branch": "str",  # Optional. The name of the
                                      branch to use.
                                    "deploy_on_push": bool,  # Optional. Whether
                                      to automatically deploy new commits made to the repo.
                                    "repo": "str"  # Optional. The name of the
                                      repo in the format owner/repo. Example:
                                      ``digitalocean/sample-golang``.
                                },
                                "image": {
                                    "registry": "str",  # Optional. The registry
                                      name. Must be left empty for the ``DOCR`` registry type.
                                    "registry_type": "str",  # Optional. *
                                      DOCKER_HUB: The DockerHub container registry type."n* DOCR: The
                                      DigitalOcean container registry type. Known values are:
                                      "DOCKER_HUB" and "DOCR".
                                    "repository": "str",  # Optional. The
                                      repository name.
                                    "tag": "latest"  # Optional. Default value is
                                      "latest". The repository tag. Defaults to ``latest`` if not
                                      provided.
                                },
                                "index_document": "index.html",  # Optional. Default
                                  value is "index.html". The name of the index document to use when
                                  serving this static site. Default: index.html.
                                "log_destinations": {
                                    "datadog": {
                                        "api_key": "str",  # Datadog API key.
                                          Required.
                                        "endpoint": "str"  # Optional.
                                          Datadog HTTP log intake endpoint.
                                    },
                                    "logtail": {
                                        "token": "str"  # Optional. Logtail
                                          token.
                                    },
                                    "name": "str",  # Required.
                                    "papertrail": {
                                        "endpoint": "str"  # Papertrail
                                          syslog endpoint. Required.
                                    }
                                },
                                "name": "str",  # Optional. The name. Must be unique
                                  across all components within the same app.
                                "output_dir": "str",  # Optional. An optional path to
                                  where the built assets will be located, relative to the build
                                  context. If not set, App Platform will automatically scan for these
                                  directory names: ``_static``"" , ``dist``"" , ``public``"" ,
                                  ``build``.
                                "routes": [
                                    {
                                        "path": "str",  # Optional. An HTTP
                                          path prefix. Paths must start with / and must be unique
                                          across all components within an app.
                                        "preserve_path_prefix": bool  #
                                          Optional. An optional flag to preserve the path that is
                                          forwarded to the backend service. By default, the HTTP
                                          request path will be trimmed from the left when forwarded to
                                          the component. For example, a component with ``path=/api``
                                          will have requests to ``/api/list`` trimmed to ``/list``. If
                                          this value is ``true``"" , the path will remain
                                          ``/api/list``.
                                    }
                                ],
                                "run_command": "str",  # Optional. An optional run
                                  command to override the component's default.
                                "source_dir": "str"  # Optional. An optional path to
                                  the working directory to use for the build. For Dockerfile builds,
                                  this will be used as the build context. Must be relative to the root
                                  of the repo.
                            }
                        ],
                        "workers": [
                            {
                                "build_command": "str",  # Optional. An optional
                                  build command to run while building this component from source.
                                "dockerfile_path": "str",  # Optional. The path to
                                  the Dockerfile relative to the root of the repo. If set, it will be
                                  used to build this component. Otherwise, App Platform will attempt to
                                  build it using buildpacks.
                                "environment_slug": "str",  # Optional. An
                                  environment slug describing the type of this app. For a full list,
                                  please refer to `the product documentation
                                  <https://www.digitalocean.com/docs/app-platform/>`_.
                                "envs": [
                                    {
                                        "key": "str",  # The variable name.
                                          Required.
                                        "scope": "RUN_AND_BUILD_TIME",  #
                                          Optional. Default value is "RUN_AND_BUILD_TIME". * RUN_TIME:
                                          Made available only at run-time"n* BUILD_TIME: Made available
                                          only at build-time"n* RUN_AND_BUILD_TIME: Made available at
                                          both build and run-time. Known values are: "UNSET",
                                          "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                        "type": "GENERAL",  # Optional.
                                          Default value is "GENERAL". * GENERAL: A plain-text
                                          environment variable"n* SECRET: A secret encrypted
                                          environment variable. Known values are: "GENERAL" and
                                          "SECRET".
                                        "value": "str"  # Optional. The
                                          value. If the type is ``SECRET``"" , the value will be
                                          encrypted on first submission. On following submissions, the
                                          encrypted value should be used.
                                    }
                                ],
                                "git": {
                                    "branch": "str",  # Optional. The name of the
                                      branch to use.
                                    "repo_clone_url": "str"  # Optional. The
                                      clone URL of the repo. Example:
                                      ``https://github.com/digitalocean/sample-golang.git``.
                                },
                                "github": {
                                    "branch": "str",  # Optional. The name of the
                                      branch to use.
                                    "deploy_on_push": bool,  # Optional. Whether
                                      to automatically deploy new commits made to the repo.
                                    "repo": "str"  # Optional. The name of the
                                      repo in the format owner/repo. Example:
                                      ``digitalocean/sample-golang``.
                                },
                                "gitlab": {
                                    "branch": "str",  # Optional. The name of the
                                      branch to use.
                                    "deploy_on_push": bool,  # Optional. Whether
                                      to automatically deploy new commits made to the repo.
                                    "repo": "str"  # Optional. The name of the
                                      repo in the format owner/repo. Example:
                                      ``digitalocean/sample-golang``.
                                },
                                "image": {
                                    "registry": "str",  # Optional. The registry
                                      name. Must be left empty for the ``DOCR`` registry type.
                                    "registry_type": "str",  # Optional. *
                                      DOCKER_HUB: The DockerHub container registry type."n* DOCR: The
                                      DigitalOcean container registry type. Known values are:
                                      "DOCKER_HUB" and "DOCR".
                                    "repository": "str",  # Optional. The
                                      repository name.
                                    "tag": "latest"  # Optional. Default value is
                                      "latest". The repository tag. Defaults to ``latest`` if not
                                      provided.
                                },
                                "instance_count": 1,  # Optional. Default value is 1.
                                  The amount of instances that this component should be scaled to.
                                  Default: 1.
                                "instance_size_slug": "basic-xxs",  # Optional.
                                  Default value is "basic-xxs". The instance size to use for this
                                  component. Default: ``basic-xxs``. Known values are: "basic-xxs",
                                  "basic-xs", "basic-s", "basic-m", "professional-xs",
                                  "professional-s", "professional-m", "professional-1l",
                                  "professional-l", and "professional-xl".
                                "log_destinations": {
                                    "datadog": {
                                        "api_key": "str",  # Datadog API key.
                                          Required.
                                        "endpoint": "str"  # Optional.
                                          Datadog HTTP log intake endpoint.
                                    },
                                    "logtail": {
                                        "token": "str"  # Optional. Logtail
                                          token.
                                    },
                                    "name": "str",  # Required.
                                    "papertrail": {
                                        "endpoint": "str"  # Papertrail
                                          syslog endpoint. Required.
                                    }
                                },
                                "name": "str",  # Optional. The name. Must be unique
                                  across all components within the same app.
                                "run_command": "str",  # Optional. An optional run
                                  command to override the component's default.
                                "source_dir": "str"  # Optional. An optional path to
                                  the working directory to use for the build. For Dockerfile builds,
                                  this will be used as the build context. Must be relative to the root
                                  of the repo.
                            }
                        ]
                    }
                }

                # response body for status code(s): 200
                response == {
                    "app": {
                        "active_deployment": {
                            "cause": "str",  # Optional. What caused this deployment to
                              be created.
                            "cloned_from": "str",  # Optional. The ID of a previous
                              deployment that this deployment was cloned from.
                            "created_at": "2020-02-20 00:00:00",  # Optional. The
                              creation time of the deployment.
                            "functions": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      functions component.
                                    "namespace": "str",  # Optional. The
                                      namespace where the functions are deployed.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this
                                      functions component.
                                }
                            ],
                            "id": "str",  # Optional. The ID of the deployment.
                            "jobs": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      job.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this job.
                                }
                            ],
                            "phase": "UNKNOWN",  # Optional. Default value is "UNKNOWN".
                              Known values are: "UNKNOWN", "PENDING_BUILD", "BUILDING",
                              "PENDING_DEPLOY", "DEPLOYING", "ACTIVE", "SUPERSEDED", "ERROR", and
                              "CANCELED".
                            "phase_last_updated_at": "2020-02-20 00:00:00",  # Optional.
                              When the deployment phase was last updated.
                            "progress": {
                                "error_steps": 0,  # Optional. Number of unsuccessful
                                  steps.
                                "pending_steps": 0,  # Optional. Number of pending
                                  steps.
                                "running_steps": 0,  # Optional. Number of currently
                                  running steps.
                                "steps": [
                                    {
                                        "component_name": "str",  # Optional.
                                          The component name that this step is associated with.
                                        "ended_at": "2020-02-20 00:00:00",  #
                                          Optional. The end time of this step.
                                        "message_base": "str",  # Optional.
                                          The base of a human-readable description of the step intended
                                          to be combined with the component name for presentation. For
                                          example:"n"n``message_base`` = "Building
                                          service""n``component_name`` = "api".
                                        "name": "str",  # Optional. The name
                                          of this step.
                                        "reason": {
                                            "code": "str",  # Optional.
                                              The error code.
                                            "message": "str"  # Optional.
                                              The error message.
                                        },
                                        "started_at": "2020-02-20 00:00:00",
                                          # Optional. The start time of this step.
                                        "status": "UNKNOWN",  # Optional.
                                          Default value is "UNKNOWN". Known values are: "UNKNOWN",
                                          "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                        "steps": [
                                            {}  # Optional. Child steps
                                              of this step.
                                        ]
                                    }
                                ],
                                "success_steps": 0,  # Optional. Number of successful
                                  steps.
                                "summary_steps": [
                                    {
                                        "component_name": "str",  # Optional.
                                          The component name that this step is associated with.
                                        "ended_at": "2020-02-20 00:00:00",  #
                                          Optional. The end time of this step.
                                        "message_base": "str",  # Optional.
                                          The base of a human-readable description of the step intended
                                          to be combined with the component name for presentation. For
                                          example:"n"n``message_base`` = "Building
                                          service""n``component_name`` = "api".
                                        "name": "str",  # Optional. The name
                                          of this step.
                                        "reason": {
                                            "code": "str",  # Optional.
                                              The error code.
                                            "message": "str"  # Optional.
                                              The error message.
                                        },
                                        "started_at": "2020-02-20 00:00:00",
                                          # Optional. The start time of this step.
                                        "status": "UNKNOWN",  # Optional.
                                          Default value is "UNKNOWN". Known values are: "UNKNOWN",
                                          "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                        "steps": [
                                            {}  # Optional. Child steps
                                              of this step.
                                        ]
                                    }
                                ],
                                "total_steps": 0  # Optional. Total number of steps.
                            },
                            "services": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      service.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this
                                      service.
                                }
                            ],
                            "spec": {
                                "databases": [
                                    {
                                        "cluster_name": "str",  # Optional.
                                          The name of the underlying DigitalOcean DBaaS cluster. This
                                          is required for production databases. For dev databases, if
                                          cluster_name is not set, a new cluster will be provisioned.
                                        "db_name": "str",  # Optional. The
                                          name of the MySQL or PostgreSQL database to configure.
                                        "db_user": "str",  # Optional. The
                                          name of the MySQL or PostgreSQL user to configure.
                                        "engine": "UNSET",  # Optional.
                                          Default value is "UNSET". * MYSQL: MySQL"n* PG: PostgreSQL"n*
                                          REDIS: Redis. Known values are: "UNSET", "MYSQL", "PG", and
                                          "REDIS".
                                        "name": "str",  # The name. Must be
                                          unique across all components within the same app. Required.
                                        "production": bool,  # Optional.
                                          Whether this is a production or dev database.
                                        "version": "str"  # Optional. The
                                          version of the database engine.
                                    }
                                ],
                                "domains": [
                                    {
                                        "domain": "str",  # The hostname for
                                          the domain. Required.
                                        "minimum_tls_version": "str",  #
                                          Optional. The minimum version of TLS a client application can
                                          use to access resources for the domain.  Must be one of the
                                          following values wrapped within quotations: ``"1.2"`` or
                                          ``"1.3"``. Known values are: "1.2" and "1.3".
                                        "type": "UNSPECIFIED",  # Optional.
                                          Default value is "UNSPECIFIED". * DEFAULT: The default
                                          ``.ondigitalocean.app`` domain assigned to this app"n*
                                          PRIMARY: The primary domain for this app that is displayed as
                                          the default in the control panel, used in bindable
                                          environment variables, and any other places that reference an
                                          app's live URL. Only one domain may be set as primary."n*
                                          ALIAS: A non-primary domain. Known values are: "UNSPECIFIED",
                                          "DEFAULT", "PRIMARY", and "ALIAS".
                                        "wildcard": bool,  # Optional.
                                          Indicates whether the domain includes all sub-domains, in
                                          addition to the given domain.
                                        "zone": "str"  # Optional. Optional.
                                          If the domain uses DigitalOcean DNS and you would like
                                          App"nPlatform to automatically manage it for you, set this to
                                          the name of the"ndomain on your account."n"nFor example, If
                                          the domain you are adding is ``app.domain.com``"" , the
                                          zone"ncould be ``domain.com``.
                                    }
                                ],
                                "functions": [
                                    {
                                        "alerts": [
                                            {
                                                "disabled": bool,  #
                                                  Optional. Is the alert disabled?.
                                                "operator":
                                                  "UNSPECIFIED_OPERATOR",  # Optional. Default value is
                                                  "UNSPECIFIED_OPERATOR". Known values are:
                                                  "UNSPECIFIED_OPERATOR", "GREATER_THAN", and
                                                  "LESS_THAN".
                                                "rule":
                                                  "UNSPECIFIED_RULE",  # Optional. Default value is
                                                  "UNSPECIFIED_RULE". Known values are:
                                                  "UNSPECIFIED_RULE", "CPU_UTILIZATION",
                                                  "MEM_UTILIZATION", "RESTART_COUNT",
                                                  "DEPLOYMENT_FAILED", "DEPLOYMENT_LIVE",
                                                  "DOMAIN_FAILED", "DOMAIN_LIVE",
                                                  "FUNCTIONS_ACTIVATION_COUNT",
                                                  "FUNCTIONS_AVERAGE_DURATION_MS",
                                                  "FUNCTIONS_ERROR_RATE_PER_MINUTE",
                                                  "FUNCTIONS_AVERAGE_WAIT_TIME_MS",
                                                  "FUNCTIONS_ERROR_COUNT", and
                                                  "FUNCTIONS_GB_RATE_PER_SECOND".
                                                "value": 0.0,  #
                                                  Optional. Threshold value for alert.
                                                "window":
                                                  "UNSPECIFIED_WINDOW"  # Optional. Default value is
                                                  "UNSPECIFIED_WINDOW". Known values are:
                                                  "UNSPECIFIED_WINDOW", "FIVE_MINUTES", "TEN_MINUTES",
                                                  "THIRTY_MINUTES", and "ONE_HOUR".
                                            }
                                        ],
                                        "cors": {
                                            "allow_credentials": bool,  #
                                              Optional. Whether browsers should expose the response to
                                              the client-side JavaScript code when the request"u2019s
                                              credentials mode is include. This configures the
                                              ``Access-Control-Allow-Credentials`` header.
                                            "allow_headers": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP request headers. This
                                                  configures the ``Access-Control-Allow-Headers``
                                                  header.
                                            ],
                                            "allow_methods": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP methods. This configures the
                                                  ``Access-Control-Allow-Methods`` header.
                                            ],
                                            "allow_origins": [
                                                {
                                                    "exact":
                                                      "str",  # Optional. Exact string match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "prefix":
                                                      "str",  # Optional. Prefix-based match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "regex":
                                                      "str"  # Optional. RE2 style regex-based match.
                                                      Only 1 of ``exact``"" , ``prefix``"" , or
                                                      ``regex`` must be set. For more information about
                                                      RE2 syntax, see:
                                                      https://github.com/google/re2/wiki/Syntax.
                                                }
                                            ],
                                            "expose_headers": [
                                                "str"  # Optional.
                                                  The set of HTTP response headers that browsers are
                                                  allowed to access. This configures the
                                                  ``Access-Control-Expose-Headers`` header.
                                            ],
                                            "max_age": "str"  # Optional.
                                              An optional duration specifying how long browsers can
                                              cache the results of a preflight request. This configures
                                              the ``Access-Control-Max-Age`` header.
                                        },
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # The name. Must be
                                          unique across all components within the same app. Required.
                                        "routes": [
                                            {
                                                "path": "str",  #
                                                  Optional. An HTTP path prefix. Paths must start with
                                                  / and must be unique across all components within an
                                                  app.
                "preserve_path_prefix": bool  # Optional. An optional
                                                  flag to preserve the path that is forwarded to the
                                                  backend service. By default, the HTTP request path
                                                  will be trimmed from the left when forwarded to the
                                                  component. For example, a component with
                                                  ``path=/api`` will have requests to ``/api/list``
                                                  trimmed to ``/list``. If this value is ``true``"" ,
                                                  the path will remain ``/api/list``.
                                            }
                                        ],
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "jobs": [
                                    {
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://www.digitalocean.com/docs/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "image": {
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type."n* DOCR: The DigitalOcean container registry type.
                                              Known values are: "DOCKER_HUB" and "DOCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided.
                                        },
                                        "instance_count": 1,  # Optional.
                                          Default value is 1. The amount of instances that this
                                          component should be scaled to. Default: 1.
                                        "instance_size_slug": "basic-xxs",  #
                                          Optional. Default value is "basic-xxs". The instance size to
                                          use for this component. Default: ``basic-xxs``. Known values
                                          are: "basic-xxs", "basic-xs", "basic-s", "basic-m",
                                          "professional-xs", "professional-s", "professional-m",
                                          "professional-1l", "professional-l", and "professional-xl".
                                        "kind": "UNSPECIFIED",  # Optional.
                                          Default value is "UNSPECIFIED". * UNSPECIFIED: Default job
                                          type, will auto-complete to POST_DEPLOY kind."n* PRE_DEPLOY:
                                          Indicates a job that runs before an app deployment."n*
                                          POST_DEPLOY: Indicates a job that runs after an app
                                          deployment."n* FAILED_DEPLOY: Indicates a job that runs after
                                          a component fails to deploy. Known values are: "UNSPECIFIED",
                                          "PRE_DEPLOY", "POST_DEPLOY", and "FAILED_DEPLOY".
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "name": "str",  # The name of the app. Must be unique
                                  across all apps in the same account. Required.
                                "region": "str",  # Optional. The slug form of the
                                  geographical origin of the app. Default: ``nearest available``. Known
                                  values are: "ams", "nyc", and "fra".
                                "services": [
                                    {
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "cors": {
                                            "allow_credentials": bool,  #
                                              Optional. Whether browsers should expose the response to
                                              the client-side JavaScript code when the request"u2019s
                                              credentials mode is include. This configures the
                                              ``Access-Control-Allow-Credentials`` header.
                                            "allow_headers": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP request headers. This
                                                  configures the ``Access-Control-Allow-Headers``
                                                  header.
                                            ],
                                            "allow_methods": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP methods. This configures the
                                                  ``Access-Control-Allow-Methods`` header.
                                            ],
                                            "allow_origins": [
                                                {
                                                    "exact":
                                                      "str",  # Optional. Exact string match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "prefix":
                                                      "str",  # Optional. Prefix-based match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "regex":
                                                      "str"  # Optional. RE2 style regex-based match.
                                                      Only 1 of ``exact``"" , ``prefix``"" , or
                                                      ``regex`` must be set. For more information about
                                                      RE2 syntax, see:
                                                      https://github.com/google/re2/wiki/Syntax.
                                                }
                                            ],
                                            "expose_headers": [
                                                "str"  # Optional.
                                                  The set of HTTP response headers that browsers are
                                                  allowed to access. This configures the
                                                  ``Access-Control-Expose-Headers`` header.
                                            ],
                                            "max_age": "str"  # Optional.
                                              An optional duration specifying how long browsers can
                                              cache the results of a preflight request. This configures
                                              the ``Access-Control-Max-Age`` header.
                                        },
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://www.digitalocean.com/docs/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "health_check": {
                                            "failure_threshold": 0,  #
                                              Optional. The number of failed health checks before
                                              considered unhealthy.
                                            "http_path": "str",  #
                                              Optional. The route path used for the HTTP health check
                                              ping. If not set, the HTTP health check will be disabled
                                              and a TCP health check used instead.
                                            "initial_delay_seconds": 0,
                                              # Optional. The number of seconds to wait before
                                              beginning health checks.
                                            "period_seconds": 0,  #
                                              Optional. The number of seconds to wait between health
                                              checks.
                                            "port": 0,  # Optional. The
                                              port on which the health check will be performed. If not
                                              set, the health check will be performed on the
                                              component's http_port.
                                            "success_threshold": 0,  #
                                              Optional. The number of successful health checks before
                                              considered healthy.
                                            "timeout_seconds": 0  #
                                              Optional. The number of seconds after which the check
                                              times out.
                                        },
                                        "http_port": 0,  # Optional. The
                                          internal port on which this service's run command will
                                          listen. Default: 8080"nIf there is not an environment
                                          variable with the name ``PORT``"" , one will be automatically
                                          added with its value set to the value of this field.
                                        "image": {
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type."n* DOCR: The DigitalOcean container registry type.
                                              Known values are: "DOCKER_HUB" and "DOCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided.
                                        },
                                        "instance_count": 1,  # Optional.
                                          Default value is 1. The amount of instances that this
                                          component should be scaled to. Default: 1.
                                        "instance_size_slug": "basic-xxs",  #
                                          Optional. Default value is "basic-xxs". The instance size to
                                          use for this component. Default: ``basic-xxs``. Known values
                                          are: "basic-xxs", "basic-xs", "basic-s", "basic-m",
                                          "professional-xs", "professional-s", "professional-m",
                                          "professional-1l", "professional-l", and "professional-xl".
                                        "internal_ports": [
                                            0  # Optional. The ports on
                                              which this service will listen for internal traffic.
                                        ],
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "routes": [
                                            {
                                                "path": "str",  #
                                                  Optional. An HTTP path prefix. Paths must start with
                                                  / and must be unique across all components within an
                                                  app.
                "preserve_path_prefix": bool  # Optional. An optional
                                                  flag to preserve the path that is forwarded to the
                                                  backend service. By default, the HTTP request path
                                                  will be trimmed from the left when forwarded to the
                                                  component. For example, a component with
                                                  ``path=/api`` will have requests to ``/api/list``
                                                  trimmed to ``/list``. If this value is ``true``"" ,
                                                  the path will remain ``/api/list``.
                                            }
                                        ],
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "static_sites": [
                                    {
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "catchall_document": "str",  #
                                          Optional. The name of the document to use as the fallback for
                                          any requests to documents that are not found when serving
                                          this static site. Only 1 of ``catchall_document`` or
                                          ``error_document`` can be set.
                                        "cors": {
                                            "allow_credentials": bool,  #
                                              Optional. Whether browsers should expose the response to
                                              the client-side JavaScript code when the request"u2019s
                                              credentials mode is include. This configures the
                                              ``Access-Control-Allow-Credentials`` header.
                                            "allow_headers": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP request headers. This
                                                  configures the ``Access-Control-Allow-Headers``
                                                  header.
                                            ],
                                            "allow_methods": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP methods. This configures the
                                                  ``Access-Control-Allow-Methods`` header.
                                            ],
                                            "allow_origins": [
                                                {
                                                    "exact":
                                                      "str",  # Optional. Exact string match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "prefix":
                                                      "str",  # Optional. Prefix-based match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "regex":
                                                      "str"  # Optional. RE2 style regex-based match.
                                                      Only 1 of ``exact``"" , ``prefix``"" , or
                                                      ``regex`` must be set. For more information about
                                                      RE2 syntax, see:
                                                      https://github.com/google/re2/wiki/Syntax.
                                                }
                                            ],
                                            "expose_headers": [
                                                "str"  # Optional.
                                                  The set of HTTP response headers that browsers are
                                                  allowed to access. This configures the
                                                  ``Access-Control-Expose-Headers`` header.
                                            ],
                                            "max_age": "str"  # Optional.
                                              An optional duration specifying how long browsers can
                                              cache the results of a preflight request. This configures
                                              the ``Access-Control-Max-Age`` header.
                                        },
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://www.digitalocean.com/docs/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "error_document": "404.html",  #
                                          Optional. Default value is "404.html". The name of the error
                                          document to use when serving this static site. Default:
                                          404.html. If no such file exists within the built assets, App
                                          Platform will supply one.
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "image": {
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type."n* DOCR: The DigitalOcean container registry type.
                                              Known values are: "DOCKER_HUB" and "DOCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided.
                                        },
                                        "index_document": "index.html",  #
                                          Optional. Default value is "index.html". The name of the
                                          index document to use when serving this static site. Default:
                                          index.html.
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "output_dir": "str",  # Optional. An
                                          optional path to where the built assets will be located,
                                          relative to the build context. If not set, App Platform will
                                          automatically scan for these directory names: ``_static``"" ,
                                          ``dist``"" , ``public``"" , ``build``.
                                        "routes": [
                                            {
                                                "path": "str",  #
                                                  Optional. An HTTP path prefix. Paths must start with
                                                  / and must be unique across all components within an
                                                  app.
                "preserve_path_prefix": bool  # Optional. An optional
                                                  flag to preserve the path that is forwarded to the
                                                  backend service. By default, the HTTP request path
                                                  will be trimmed from the left when forwarded to the
                                                  component. For example, a component with
                                                  ``path=/api`` will have requests to ``/api/list``
                                                  trimmed to ``/list``. If this value is ``true``"" ,
                                                  the path will remain ``/api/list``.
                                            }
                                        ],
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "workers": [
                                    {
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://www.digitalocean.com/docs/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "image": {
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type."n* DOCR: The DigitalOcean container registry type.
                                              Known values are: "DOCKER_HUB" and "DOCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided.
                                        },
                                        "instance_count": 1,  # Optional.
                                          Default value is 1. The amount of instances that this
                                          component should be scaled to. Default: 1.
                                        "instance_size_slug": "basic-xxs",  #
                                          Optional. Default value is "basic-xxs". The instance size to
                                          use for this component. Default: ``basic-xxs``. Known values
                                          are: "basic-xxs", "basic-xs", "basic-s", "basic-m",
                                          "professional-xs", "professional-s", "professional-m",
                                          "professional-1l", "professional-l", and "professional-xl".
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ]
                            },
                            "static_sites": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      static site.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this static
                                      site.
                                }
                            ],
                            "tier_slug": "str",  # Optional. The current pricing tier
                              slug of the deployment.
                            "updated_at": "2020-02-20 00:00:00",  # Optional. When the
                              deployment was last updated.
                            "workers": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      worker.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this worker.
                                }
                            ]
                        },
                        "created_at": "2020-02-20 00:00:00",  # Optional. The creation time
                          of the app.
                        "default_ingress": "str",  # Optional. The default hostname on which
                          the app is accessible.
                        "domains": [
                            {
                                "id": "str",  # Optional. The ID of the domain.
                                "phase": "UNKNOWN",  # Optional. Default value is
                                  "UNKNOWN". Known values are: "UNKNOWN", "PENDING", "CONFIGURING",
                                  "ACTIVE", and "ERROR".
                                "progress": {
                                    "steps": [
                                        {}  # Optional. The steps of the
                                          domain's progress.
                                    ]
                                },
                                "spec": {
                                    "domain": "str",  # The hostname for the
                                      domain. Required.
                                    "minimum_tls_version": "str",  # Optional.
                                      The minimum version of TLS a client application can use to access
                                      resources for the domain.  Must be one of the following values
                                      wrapped within quotations: ``"1.2"`` or ``"1.3"``. Known values
                                      are: "1.2" and "1.3".
                                    "type": "UNSPECIFIED",  # Optional. Default
                                      value is "UNSPECIFIED". * DEFAULT: The default
                                      ``.ondigitalocean.app`` domain assigned to this app"n* PRIMARY:
                                      The primary domain for this app that is displayed as the default
                                      in the control panel, used in bindable environment variables, and
                                      any other places that reference an app's live URL. Only one
                                      domain may be set as primary."n* ALIAS: A non-primary domain.
                                      Known values are: "UNSPECIFIED", "DEFAULT", "PRIMARY", and
                                      "ALIAS".
                                    "wildcard": bool,  # Optional. Indicates
                                      whether the domain includes all sub-domains, in addition to the
                                      given domain.
                                    "zone": "str"  # Optional. Optional. If the
                                      domain uses DigitalOcean DNS and you would like App"nPlatform to
                                      automatically manage it for you, set this to the name of
                                      the"ndomain on your account."n"nFor example, If the domain you
                                      are adding is ``app.domain.com``"" , the zone"ncould be
                                      ``domain.com``.
                                }
                            }
                        ],
                        "id": "str",  # Optional. The ID of the application.
                        "in_progress_deployment": {
                            "cause": "str",  # Optional. What caused this deployment to
                              be created.
                            "cloned_from": "str",  # Optional. The ID of a previous
                              deployment that this deployment was cloned from.
                            "created_at": "2020-02-20 00:00:00",  # Optional. The
                              creation time of the deployment.
                            "functions": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      functions component.
                                    "namespace": "str",  # Optional. The
                                      namespace where the functions are deployed.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this
                                      functions component.
                                }
                            ],
                            "id": "str",  # Optional. The ID of the deployment.
                            "jobs": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      job.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this job.
                                }
                            ],
                            "phase": "UNKNOWN",  # Optional. Default value is "UNKNOWN".
                              Known values are: "UNKNOWN", "PENDING_BUILD", "BUILDING",
                              "PENDING_DEPLOY", "DEPLOYING", "ACTIVE", "SUPERSEDED", "ERROR", and
                              "CANCELED".
                            "phase_last_updated_at": "2020-02-20 00:00:00",  # Optional.
                              When the deployment phase was last updated.
                            "progress": {
                                "error_steps": 0,  # Optional. Number of unsuccessful
                                  steps.
                                "pending_steps": 0,  # Optional. Number of pending
                                  steps.
                                "running_steps": 0,  # Optional. Number of currently
                                  running steps.
                                "steps": [
                                    {
                                        "component_name": "str",  # Optional.
                                          The component name that this step is associated with.
                                        "ended_at": "2020-02-20 00:00:00",  #
                                          Optional. The end time of this step.
                                        "message_base": "str",  # Optional.
                                          The base of a human-readable description of the step intended
                                          to be combined with the component name for presentation. For
                                          example:"n"n``message_base`` = "Building
                                          service""n``component_name`` = "api".
                                        "name": "str",  # Optional. The name
                                          of this step.
                                        "reason": {
                                            "code": "str",  # Optional.
                                              The error code.
                                            "message": "str"  # Optional.
                                              The error message.
                                        },
                                        "started_at": "2020-02-20 00:00:00",
                                          # Optional. The start time of this step.
                                        "status": "UNKNOWN",  # Optional.
                                          Default value is "UNKNOWN". Known values are: "UNKNOWN",
                                          "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                        "steps": [
                                            {}  # Optional. Child steps
                                              of this step.
                                        ]
                                    }
                                ],
                                "success_steps": 0,  # Optional. Number of successful
                                  steps.
                                "summary_steps": [
                                    {
                                        "component_name": "str",  # Optional.
                                          The component name that this step is associated with.
                                        "ended_at": "2020-02-20 00:00:00",  #
                                          Optional. The end time of this step.
                                        "message_base": "str",  # Optional.
                                          The base of a human-readable description of the step intended
                                          to be combined with the component name for presentation. For
                                          example:"n"n``message_base`` = "Building
                                          service""n``component_name`` = "api".
                                        "name": "str",  # Optional. The name
                                          of this step.
                                        "reason": {
                                            "code": "str",  # Optional.
                                              The error code.
                                            "message": "str"  # Optional.
                                              The error message.
                                        },
                                        "started_at": "2020-02-20 00:00:00",
                                          # Optional. The start time of this step.
                                        "status": "UNKNOWN",  # Optional.
                                          Default value is "UNKNOWN". Known values are: "UNKNOWN",
                                          "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                        "steps": [
                                            {}  # Optional. Child steps
                                              of this step.
                                        ]
                                    }
                                ],
                                "total_steps": 0  # Optional. Total number of steps.
                            },
                            "services": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      service.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this
                                      service.
                                }
                            ],
                            "spec": {
                                "databases": [
                                    {
                                        "cluster_name": "str",  # Optional.
                                          The name of the underlying DigitalOcean DBaaS cluster. This
                                          is required for production databases. For dev databases, if
                                          cluster_name is not set, a new cluster will be provisioned.
                                        "db_name": "str",  # Optional. The
                                          name of the MySQL or PostgreSQL database to configure.
                                        "db_user": "str",  # Optional. The
                                          name of the MySQL or PostgreSQL user to configure.
                                        "engine": "UNSET",  # Optional.
                                          Default value is "UNSET". * MYSQL: MySQL"n* PG: PostgreSQL"n*
                                          REDIS: Redis. Known values are: "UNSET", "MYSQL", "PG", and
                                          "REDIS".
                                        "name": "str",  # The name. Must be
                                          unique across all components within the same app. Required.
                                        "production": bool,  # Optional.
                                          Whether this is a production or dev database.
                                        "version": "str"  # Optional. The
                                          version of the database engine.
                                    }
                                ],
                                "domains": [
                                    {
                                        "domain": "str",  # The hostname for
                                          the domain. Required.
                                        "minimum_tls_version": "str",  #
                                          Optional. The minimum version of TLS a client application can
                                          use to access resources for the domain.  Must be one of the
                                          following values wrapped within quotations: ``"1.2"`` or
                                          ``"1.3"``. Known values are: "1.2" and "1.3".
                                        "type": "UNSPECIFIED",  # Optional.
                                          Default value is "UNSPECIFIED". * DEFAULT: The default
                                          ``.ondigitalocean.app`` domain assigned to this app"n*
                                          PRIMARY: The primary domain for this app that is displayed as
                                          the default in the control panel, used in bindable
                                          environment variables, and any other places that reference an
                                          app's live URL. Only one domain may be set as primary."n*
                                          ALIAS: A non-primary domain. Known values are: "UNSPECIFIED",
                                          "DEFAULT", "PRIMARY", and "ALIAS".
                                        "wildcard": bool,  # Optional.
                                          Indicates whether the domain includes all sub-domains, in
                                          addition to the given domain.
                                        "zone": "str"  # Optional. Optional.
                                          If the domain uses DigitalOcean DNS and you would like
                                          App"nPlatform to automatically manage it for you, set this to
                                          the name of the"ndomain on your account."n"nFor example, If
                                          the domain you are adding is ``app.domain.com``"" , the
                                          zone"ncould be ``domain.com``.
                                    }
                                ],
                                "functions": [
                                    {
                                        "alerts": [
                                            {
                                                "disabled": bool,  #
                                                  Optional. Is the alert disabled?.
                                                "operator":
                                                  "UNSPECIFIED_OPERATOR",  # Optional. Default value is
                                                  "UNSPECIFIED_OPERATOR". Known values are:
                                                  "UNSPECIFIED_OPERATOR", "GREATER_THAN", and
                                                  "LESS_THAN".
                                                "rule":
                                                  "UNSPECIFIED_RULE",  # Optional. Default value is
                                                  "UNSPECIFIED_RULE". Known values are:
                                                  "UNSPECIFIED_RULE", "CPU_UTILIZATION",
                                                  "MEM_UTILIZATION", "RESTART_COUNT",
                                                  "DEPLOYMENT_FAILED", "DEPLOYMENT_LIVE",
                                                  "DOMAIN_FAILED", "DOMAIN_LIVE",
                                                  "FUNCTIONS_ACTIVATION_COUNT",
                                                  "FUNCTIONS_AVERAGE_DURATION_MS",
                                                  "FUNCTIONS_ERROR_RATE_PER_MINUTE",
                                                  "FUNCTIONS_AVERAGE_WAIT_TIME_MS",
                                                  "FUNCTIONS_ERROR_COUNT", and
                                                  "FUNCTIONS_GB_RATE_PER_SECOND".
                                                "value": 0.0,  #
                                                  Optional. Threshold value for alert.
                                                "window":
                                                  "UNSPECIFIED_WINDOW"  # Optional. Default value is
                                                  "UNSPECIFIED_WINDOW". Known values are:
                                                  "UNSPECIFIED_WINDOW", "FIVE_MINUTES", "TEN_MINUTES",
                                                  "THIRTY_MINUTES", and "ONE_HOUR".
                                            }
                                        ],
                                        "cors": {
                                            "allow_credentials": bool,  #
                                              Optional. Whether browsers should expose the response to
                                              the client-side JavaScript code when the request"u2019s
                                              credentials mode is include. This configures the
                                              ``Access-Control-Allow-Credentials`` header.
                                            "allow_headers": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP request headers. This
                                                  configures the ``Access-Control-Allow-Headers``
                                                  header.
                                            ],
                                            "allow_methods": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP methods. This configures the
                                                  ``Access-Control-Allow-Methods`` header.
                                            ],
                                            "allow_origins": [
                                                {
                                                    "exact":
                                                      "str",  # Optional. Exact string match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "prefix":
                                                      "str",  # Optional. Prefix-based match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "regex":
                                                      "str"  # Optional. RE2 style regex-based match.
                                                      Only 1 of ``exact``"" , ``prefix``"" , or
                                                      ``regex`` must be set. For more information about
                                                      RE2 syntax, see:
                                                      https://github.com/google/re2/wiki/Syntax.
                                                }
                                            ],
                                            "expose_headers": [
                                                "str"  # Optional.
                                                  The set of HTTP response headers that browsers are
                                                  allowed to access. This configures the
                                                  ``Access-Control-Expose-Headers`` header.
                                            ],
                                            "max_age": "str"  # Optional.
                                              An optional duration specifying how long browsers can
                                              cache the results of a preflight request. This configures
                                              the ``Access-Control-Max-Age`` header.
                                        },
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # The name. Must be
                                          unique across all components within the same app. Required.
                                        "routes": [
                                            {
                                                "path": "str",  #
                                                  Optional. An HTTP path prefix. Paths must start with
                                                  / and must be unique across all components within an
                                                  app.
                "preserve_path_prefix": bool  # Optional. An optional
                                                  flag to preserve the path that is forwarded to the
                                                  backend service. By default, the HTTP request path
                                                  will be trimmed from the left when forwarded to the
                                                  component. For example, a component with
                                                  ``path=/api`` will have requests to ``/api/list``
                                                  trimmed to ``/list``. If this value is ``true``"" ,
                                                  the path will remain ``/api/list``.
                                            }
                                        ],
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "jobs": [
                                    {
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://www.digitalocean.com/docs/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "image": {
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type."n* DOCR: The DigitalOcean container registry type.
                                              Known values are: "DOCKER_HUB" and "DOCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided.
                                        },
                                        "instance_count": 1,  # Optional.
                                          Default value is 1. The amount of instances that this
                                          component should be scaled to. Default: 1.
                                        "instance_size_slug": "basic-xxs",  #
                                          Optional. Default value is "basic-xxs". The instance size to
                                          use for this component. Default: ``basic-xxs``. Known values
                                          are: "basic-xxs", "basic-xs", "basic-s", "basic-m",
                                          "professional-xs", "professional-s", "professional-m",
                                          "professional-1l", "professional-l", and "professional-xl".
                                        "kind": "UNSPECIFIED",  # Optional.
                                          Default value is "UNSPECIFIED". * UNSPECIFIED: Default job
                                          type, will auto-complete to POST_DEPLOY kind."n* PRE_DEPLOY:
                                          Indicates a job that runs before an app deployment."n*
                                          POST_DEPLOY: Indicates a job that runs after an app
                                          deployment."n* FAILED_DEPLOY: Indicates a job that runs after
                                          a component fails to deploy. Known values are: "UNSPECIFIED",
                                          "PRE_DEPLOY", "POST_DEPLOY", and "FAILED_DEPLOY".
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "name": "str",  # The name of the app. Must be unique
                                  across all apps in the same account. Required.
                                "region": "str",  # Optional. The slug form of the
                                  geographical origin of the app. Default: ``nearest available``. Known
                                  values are: "ams", "nyc", and "fra".
                                "services": [
                                    {
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "cors": {
                                            "allow_credentials": bool,  #
                                              Optional. Whether browsers should expose the response to
                                              the client-side JavaScript code when the request"u2019s
                                              credentials mode is include. This configures the
                                              ``Access-Control-Allow-Credentials`` header.
                                            "allow_headers": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP request headers. This
                                                  configures the ``Access-Control-Allow-Headers``
                                                  header.
                                            ],
                                            "allow_methods": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP methods. This configures the
                                                  ``Access-Control-Allow-Methods`` header.
                                            ],
                                            "allow_origins": [
                                                {
                                                    "exact":
                                                      "str",  # Optional. Exact string match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "prefix":
                                                      "str",  # Optional. Prefix-based match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "regex":
                                                      "str"  # Optional. RE2 style regex-based match.
                                                      Only 1 of ``exact``"" , ``prefix``"" , or
                                                      ``regex`` must be set. For more information about
                                                      RE2 syntax, see:
                                                      https://github.com/google/re2/wiki/Syntax.
                                                }
                                            ],
                                            "expose_headers": [
                                                "str"  # Optional.
                                                  The set of HTTP response headers that browsers are
                                                  allowed to access. This configures the
                                                  ``Access-Control-Expose-Headers`` header.
                                            ],
                                            "max_age": "str"  # Optional.
                                              An optional duration specifying how long browsers can
                                              cache the results of a preflight request. This configures
                                              the ``Access-Control-Max-Age`` header.
                                        },
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://www.digitalocean.com/docs/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "health_check": {
                                            "failure_threshold": 0,  #
                                              Optional. The number of failed health checks before
                                              considered unhealthy.
                                            "http_path": "str",  #
                                              Optional. The route path used for the HTTP health check
                                              ping. If not set, the HTTP health check will be disabled
                                              and a TCP health check used instead.
                                            "initial_delay_seconds": 0,
                                              # Optional. The number of seconds to wait before
                                              beginning health checks.
                                            "period_seconds": 0,  #
                                              Optional. The number of seconds to wait between health
                                              checks.
                                            "port": 0,  # Optional. The
                                              port on which the health check will be performed. If not
                                              set, the health check will be performed on the
                                              component's http_port.
                                            "success_threshold": 0,  #
                                              Optional. The number of successful health checks before
                                              considered healthy.
                                            "timeout_seconds": 0  #
                                              Optional. The number of seconds after which the check
                                              times out.
                                        },
                                        "http_port": 0,  # Optional. The
                                          internal port on which this service's run command will
                                          listen. Default: 8080"nIf there is not an environment
                                          variable with the name ``PORT``"" , one will be automatically
                                          added with its value set to the value of this field.
                                        "image": {
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type."n* DOCR: The DigitalOcean container registry type.
                                              Known values are: "DOCKER_HUB" and "DOCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided.
                                        },
                                        "instance_count": 1,  # Optional.
                                          Default value is 1. The amount of instances that this
                                          component should be scaled to. Default: 1.
                                        "instance_size_slug": "basic-xxs",  #
                                          Optional. Default value is "basic-xxs". The instance size to
                                          use for this component. Default: ``basic-xxs``. Known values
                                          are: "basic-xxs", "basic-xs", "basic-s", "basic-m",
                                          "professional-xs", "professional-s", "professional-m",
                                          "professional-1l", "professional-l", and "professional-xl".
                                        "internal_ports": [
                                            0  # Optional. The ports on
                                              which this service will listen for internal traffic.
                                        ],
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "routes": [
                                            {
                                                "path": "str",  #
                                                  Optional. An HTTP path prefix. Paths must start with
                                                  / and must be unique across all components within an
                                                  app.
                "preserve_path_prefix": bool  # Optional. An optional
                                                  flag to preserve the path that is forwarded to the
                                                  backend service. By default, the HTTP request path
                                                  will be trimmed from the left when forwarded to the
                                                  component. For example, a component with
                                                  ``path=/api`` will have requests to ``/api/list``
                                                  trimmed to ``/list``. If this value is ``true``"" ,
                                                  the path will remain ``/api/list``.
                                            }
                                        ],
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "static_sites": [
                                    {
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "catchall_document": "str",  #
                                          Optional. The name of the document to use as the fallback for
                                          any requests to documents that are not found when serving
                                          this static site. Only 1 of ``catchall_document`` or
                                          ``error_document`` can be set.
                                        "cors": {
                                            "allow_credentials": bool,  #
                                              Optional. Whether browsers should expose the response to
                                              the client-side JavaScript code when the request"u2019s
                                              credentials mode is include. This configures the
                                              ``Access-Control-Allow-Credentials`` header.
                                            "allow_headers": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP request headers. This
                                                  configures the ``Access-Control-Allow-Headers``
                                                  header.
                                            ],
                                            "allow_methods": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP methods. This configures the
                                                  ``Access-Control-Allow-Methods`` header.
                                            ],
                                            "allow_origins": [
                                                {
                                                    "exact":
                                                      "str",  # Optional. Exact string match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "prefix":
                                                      "str",  # Optional. Prefix-based match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "regex":
                                                      "str"  # Optional. RE2 style regex-based match.
                                                      Only 1 of ``exact``"" , ``prefix``"" , or
                                                      ``regex`` must be set. For more information about
                                                      RE2 syntax, see:
                                                      https://github.com/google/re2/wiki/Syntax.
                                                }
                                            ],
                                            "expose_headers": [
                                                "str"  # Optional.
                                                  The set of HTTP response headers that browsers are
                                                  allowed to access. This configures the
                                                  ``Access-Control-Expose-Headers`` header.
                                            ],
                                            "max_age": "str"  # Optional.
                                              An optional duration specifying how long browsers can
                                              cache the results of a preflight request. This configures
                                              the ``Access-Control-Max-Age`` header.
                                        },
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://www.digitalocean.com/docs/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "error_document": "404.html",  #
                                          Optional. Default value is "404.html". The name of the error
                                          document to use when serving this static site. Default:
                                          404.html. If no such file exists within the built assets, App
                                          Platform will supply one.
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "image": {
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type."n* DOCR: The DigitalOcean container registry type.
                                              Known values are: "DOCKER_HUB" and "DOCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided.
                                        },
                                        "index_document": "index.html",  #
                                          Optional. Default value is "index.html". The name of the
                                          index document to use when serving this static site. Default:
                                          index.html.
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "output_dir": "str",  # Optional. An
                                          optional path to where the built assets will be located,
                                          relative to the build context. If not set, App Platform will
                                          automatically scan for these directory names: ``_static``"" ,
                                          ``dist``"" , ``public``"" , ``build``.
                                        "routes": [
                                            {
                                                "path": "str",  #
                                                  Optional. An HTTP path prefix. Paths must start with
                                                  / and must be unique across all components within an
                                                  app.
                "preserve_path_prefix": bool  # Optional. An optional
                                                  flag to preserve the path that is forwarded to the
                                                  backend service. By default, the HTTP request path
                                                  will be trimmed from the left when forwarded to the
                                                  component. For example, a component with
                                                  ``path=/api`` will have requests to ``/api/list``
                                                  trimmed to ``/list``. If this value is ``true``"" ,
                                                  the path will remain ``/api/list``.
                                            }
                                        ],
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "workers": [
                                    {
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://www.digitalocean.com/docs/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "image": {
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type."n* DOCR: The DigitalOcean container registry type.
                                              Known values are: "DOCKER_HUB" and "DOCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided.
                                        },
                                        "instance_count": 1,  # Optional.
                                          Default value is 1. The amount of instances that this
                                          component should be scaled to. Default: 1.
                                        "instance_size_slug": "basic-xxs",  #
                                          Optional. Default value is "basic-xxs". The instance size to
                                          use for this component. Default: ``basic-xxs``. Known values
                                          are: "basic-xxs", "basic-xs", "basic-s", "basic-m",
                                          "professional-xs", "professional-s", "professional-m",
                                          "professional-1l", "professional-l", and "professional-xl".
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ]
                            },
                            "static_sites": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      static site.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this static
                                      site.
                                }
                            ],
                            "tier_slug": "str",  # Optional. The current pricing tier
                              slug of the deployment.
                            "updated_at": "2020-02-20 00:00:00",  # Optional. When the
                              deployment was last updated.
                            "workers": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      worker.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this worker.
                                }
                            ]
                        },
                        "last_deployment_created_at": "2020-02-20 00:00:00",  # Optional. The
                          creation time of the last deployment.
                        "live_domain": "str",  # Optional. The live domain of the app.
                        "live_url": "str",  # Optional. The live URL of the app.
                        "live_url_base": "str",  # Optional. The live URL base of the app,
                          the URL excluding the path.
                        "owner_uuid": "str",  # Optional. The ID of the account to which the
                          application belongs.
                        "pinned_deployment": {
                            "cause": "str",  # Optional. What caused this deployment to
                              be created.
                            "cloned_from": "str",  # Optional. The ID of a previous
                              deployment that this deployment was cloned from.
                            "created_at": "2020-02-20 00:00:00",  # Optional. The
                              creation time of the deployment.
                            "functions": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      functions component.
                                    "namespace": "str",  # Optional. The
                                      namespace where the functions are deployed.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this
                                      functions component.
                                }
                            ],
                            "id": "str",  # Optional. The ID of the deployment.
                            "jobs": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      job.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this job.
                                }
                            ],
                            "phase": "UNKNOWN",  # Optional. Default value is "UNKNOWN".
                              Known values are: "UNKNOWN", "PENDING_BUILD", "BUILDING",
                              "PENDING_DEPLOY", "DEPLOYING", "ACTIVE", "SUPERSEDED", "ERROR", and
                              "CANCELED".
                            "phase_last_updated_at": "2020-02-20 00:00:00",  # Optional.
                              When the deployment phase was last updated.
                            "progress": {
                                "error_steps": 0,  # Optional. Number of unsuccessful
                                  steps.
                                "pending_steps": 0,  # Optional. Number of pending
                                  steps.
                                "running_steps": 0,  # Optional. Number of currently
                                  running steps.
                                "steps": [
                                    {
                                        "component_name": "str",  # Optional.
                                          The component name that this step is associated with.
                                        "ended_at": "2020-02-20 00:00:00",  #
                                          Optional. The end time of this step.
                                        "message_base": "str",  # Optional.
                                          The base of a human-readable description of the step intended
                                          to be combined with the component name for presentation. For
                                          example:"n"n``message_base`` = "Building
                                          service""n``component_name`` = "api".
                                        "name": "str",  # Optional. The name
                                          of this step.
                                        "reason": {
                                            "code": "str",  # Optional.
                                              The error code.
                                            "message": "str"  # Optional.
                                              The error message.
                                        },
                                        "started_at": "2020-02-20 00:00:00",
                                          # Optional. The start time of this step.
                                        "status": "UNKNOWN",  # Optional.
                                          Default value is "UNKNOWN". Known values are: "UNKNOWN",
                                          "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                        "steps": [
                                            {}  # Optional. Child steps
                                              of this step.
                                        ]
                                    }
                                ],
                                "success_steps": 0,  # Optional. Number of successful
                                  steps.
                                "summary_steps": [
                                    {
                                        "component_name": "str",  # Optional.
                                          The component name that this step is associated with.
                                        "ended_at": "2020-02-20 00:00:00",  #
                                          Optional. The end time of this step.
                                        "message_base": "str",  # Optional.
                                          The base of a human-readable description of the step intended
                                          to be combined with the component name for presentation. For
                                          example:"n"n``message_base`` = "Building
                                          service""n``component_name`` = "api".
                                        "name": "str",  # Optional. The name
                                          of this step.
                                        "reason": {
                                            "code": "str",  # Optional.
                                              The error code.
                                            "message": "str"  # Optional.
                                              The error message.
                                        },
                                        "started_at": "2020-02-20 00:00:00",
                                          # Optional. The start time of this step.
                                        "status": "UNKNOWN",  # Optional.
                                          Default value is "UNKNOWN". Known values are: "UNKNOWN",
                                          "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                        "steps": [
                                            {}  # Optional. Child steps
                                              of this step.
                                        ]
                                    }
                                ],
                                "total_steps": 0  # Optional. Total number of steps.
                            },
                            "services": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      service.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this
                                      service.
                                }
                            ],
                            "spec": {
                                "databases": [
                                    {
                                        "cluster_name": "str",  # Optional.
                                          The name of the underlying DigitalOcean DBaaS cluster. This
                                          is required for production databases. For dev databases, if
                                          cluster_name is not set, a new cluster will be provisioned.
                                        "db_name": "str",  # Optional. The
                                          name of the MySQL or PostgreSQL database to configure.
                                        "db_user": "str",  # Optional. The
                                          name of the MySQL or PostgreSQL user to configure.
                                        "engine": "UNSET",  # Optional.
                                          Default value is "UNSET". * MYSQL: MySQL"n* PG: PostgreSQL"n*
                                          REDIS: Redis. Known values are: "UNSET", "MYSQL", "PG", and
                                          "REDIS".
                                        "name": "str",  # The name. Must be
                                          unique across all components within the same app. Required.
                                        "production": bool,  # Optional.
                                          Whether this is a production or dev database.
                                        "version": "str"  # Optional. The
                                          version of the database engine.
                                    }
                                ],
                                "domains": [
                                    {
                                        "domain": "str",  # The hostname for
                                          the domain. Required.
                                        "minimum_tls_version": "str",  #
                                          Optional. The minimum version of TLS a client application can
                                          use to access resources for the domain.  Must be one of the
                                          following values wrapped within quotations: ``"1.2"`` or
                                          ``"1.3"``. Known values are: "1.2" and "1.3".
                                        "type": "UNSPECIFIED",  # Optional.
                                          Default value is "UNSPECIFIED". * DEFAULT: The default
                                          ``.ondigitalocean.app`` domain assigned to this app"n*
                                          PRIMARY: The primary domain for this app that is displayed as
                                          the default in the control panel, used in bindable
                                          environment variables, and any other places that reference an
                                          app's live URL. Only one domain may be set as primary."n*
                                          ALIAS: A non-primary domain. Known values are: "UNSPECIFIED",
                                          "DEFAULT", "PRIMARY", and "ALIAS".
                                        "wildcard": bool,  # Optional.
                                          Indicates whether the domain includes all sub-domains, in
                                          addition to the given domain.
                                        "zone": "str"  # Optional. Optional.
                                          If the domain uses DigitalOcean DNS and you would like
                                          App"nPlatform to automatically manage it for you, set this to
                                          the name of the"ndomain on your account."n"nFor example, If
                                          the domain you are adding is ``app.domain.com``"" , the
                                          zone"ncould be ``domain.com``.
                                    }
                                ],
                                "functions": [
                                    {
                                        "alerts": [
                                            {
                                                "disabled": bool,  #
                                                  Optional. Is the alert disabled?.
                                                "operator":
                                                  "UNSPECIFIED_OPERATOR",  # Optional. Default value is
                                                  "UNSPECIFIED_OPERATOR". Known values are:
                                                  "UNSPECIFIED_OPERATOR", "GREATER_THAN", and
                                                  "LESS_THAN".
                                                "rule":
                                                  "UNSPECIFIED_RULE",  # Optional. Default value is
                                                  "UNSPECIFIED_RULE". Known values are:
                                                  "UNSPECIFIED_RULE", "CPU_UTILIZATION",
                                                  "MEM_UTILIZATION", "RESTART_COUNT",
                                                  "DEPLOYMENT_FAILED", "DEPLOYMENT_LIVE",
                                                  "DOMAIN_FAILED", "DOMAIN_LIVE",
                                                  "FUNCTIONS_ACTIVATION_COUNT",
                                                  "FUNCTIONS_AVERAGE_DURATION_MS",
                                                  "FUNCTIONS_ERROR_RATE_PER_MINUTE",
                                                  "FUNCTIONS_AVERAGE_WAIT_TIME_MS",
                                                  "FUNCTIONS_ERROR_COUNT", and
                                                  "FUNCTIONS_GB_RATE_PER_SECOND".
                                                "value": 0.0,  #
                                                  Optional. Threshold value for alert.
                                                "window":
                                                  "UNSPECIFIED_WINDOW"  # Optional. Default value is
                                                  "UNSPECIFIED_WINDOW". Known values are:
                                                  "UNSPECIFIED_WINDOW", "FIVE_MINUTES", "TEN_MINUTES",
                                                  "THIRTY_MINUTES", and "ONE_HOUR".
                                            }
                                        ],
                                        "cors": {
                                            "allow_credentials": bool,  #
                                              Optional. Whether browsers should expose the response to
                                              the client-side JavaScript code when the request"u2019s
                                              credentials mode is include. This configures the
                                              ``Access-Control-Allow-Credentials`` header.
                                            "allow_headers": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP request headers. This
                                                  configures the ``Access-Control-Allow-Headers``
                                                  header.
                                            ],
                                            "allow_methods": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP methods. This configures the
                                                  ``Access-Control-Allow-Methods`` header.
                                            ],
                                            "allow_origins": [
                                                {
                                                    "exact":
                                                      "str",  # Optional. Exact string match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "prefix":
                                                      "str",  # Optional. Prefix-based match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "regex":
                                                      "str"  # Optional. RE2 style regex-based match.
                                                      Only 1 of ``exact``"" , ``prefix``"" , or
                                                      ``regex`` must be set. For more information about
                                                      RE2 syntax, see:
                                                      https://github.com/google/re2/wiki/Syntax.
                                                }
                                            ],
                                            "expose_headers": [
                                                "str"  # Optional.
                                                  The set of HTTP response headers that browsers are
                                                  allowed to access. This configures the
                                                  ``Access-Control-Expose-Headers`` header.
                                            ],
                                            "max_age": "str"  # Optional.
                                              An optional duration specifying how long browsers can
                                              cache the results of a preflight request. This configures
                                              the ``Access-Control-Max-Age`` header.
                                        },
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # The name. Must be
                                          unique across all components within the same app. Required.
                                        "routes": [
                                            {
                                                "path": "str",  #
                                                  Optional. An HTTP path prefix. Paths must start with
                                                  / and must be unique across all components within an
                                                  app.
                "preserve_path_prefix": bool  # Optional. An optional
                                                  flag to preserve the path that is forwarded to the
                                                  backend service. By default, the HTTP request path
                                                  will be trimmed from the left when forwarded to the
                                                  component. For example, a component with
                                                  ``path=/api`` will have requests to ``/api/list``
                                                  trimmed to ``/list``. If this value is ``true``"" ,
                                                  the path will remain ``/api/list``.
                                            }
                                        ],
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "jobs": [
                                    {
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://www.digitalocean.com/docs/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "image": {
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type."n* DOCR: The DigitalOcean container registry type.
                                              Known values are: "DOCKER_HUB" and "DOCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided.
                                        },
                                        "instance_count": 1,  # Optional.
                                          Default value is 1. The amount of instances that this
                                          component should be scaled to. Default: 1.
                                        "instance_size_slug": "basic-xxs",  #
                                          Optional. Default value is "basic-xxs". The instance size to
                                          use for this component. Default: ``basic-xxs``. Known values
                                          are: "basic-xxs", "basic-xs", "basic-s", "basic-m",
                                          "professional-xs", "professional-s", "professional-m",
                                          "professional-1l", "professional-l", and "professional-xl".
                                        "kind": "UNSPECIFIED",  # Optional.
                                          Default value is "UNSPECIFIED". * UNSPECIFIED: Default job
                                          type, will auto-complete to POST_DEPLOY kind."n* PRE_DEPLOY:
                                          Indicates a job that runs before an app deployment."n*
                                          POST_DEPLOY: Indicates a job that runs after an app
                                          deployment."n* FAILED_DEPLOY: Indicates a job that runs after
                                          a component fails to deploy. Known values are: "UNSPECIFIED",
                                          "PRE_DEPLOY", "POST_DEPLOY", and "FAILED_DEPLOY".
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "name": "str",  # The name of the app. Must be unique
                                  across all apps in the same account. Required.
                                "region": "str",  # Optional. The slug form of the
                                  geographical origin of the app. Default: ``nearest available``. Known
                                  values are: "ams", "nyc", and "fra".
                                "services": [
                                    {
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "cors": {
                                            "allow_credentials": bool,  #
                                              Optional. Whether browsers should expose the response to
                                              the client-side JavaScript code when the request"u2019s
                                              credentials mode is include. This configures the
                                              ``Access-Control-Allow-Credentials`` header.
                                            "allow_headers": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP request headers. This
                                                  configures the ``Access-Control-Allow-Headers``
                                                  header.
                                            ],
                                            "allow_methods": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP methods. This configures the
                                                  ``Access-Control-Allow-Methods`` header.
                                            ],
                                            "allow_origins": [
                                                {
                                                    "exact":
                                                      "str",  # Optional. Exact string match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "prefix":
                                                      "str",  # Optional. Prefix-based match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "regex":
                                                      "str"  # Optional. RE2 style regex-based match.
                                                      Only 1 of ``exact``"" , ``prefix``"" , or
                                                      ``regex`` must be set. For more information about
                                                      RE2 syntax, see:
                                                      https://github.com/google/re2/wiki/Syntax.
                                                }
                                            ],
                                            "expose_headers": [
                                                "str"  # Optional.
                                                  The set of HTTP response headers that browsers are
                                                  allowed to access. This configures the
                                                  ``Access-Control-Expose-Headers`` header.
                                            ],
                                            "max_age": "str"  # Optional.
                                              An optional duration specifying how long browsers can
                                              cache the results of a preflight request. This configures
                                              the ``Access-Control-Max-Age`` header.
                                        },
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://www.digitalocean.com/docs/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "health_check": {
                                            "failure_threshold": 0,  #
                                              Optional. The number of failed health checks before
                                              considered unhealthy.
                                            "http_path": "str",  #
                                              Optional. The route path used for the HTTP health check
                                              ping. If not set, the HTTP health check will be disabled
                                              and a TCP health check used instead.
                                            "initial_delay_seconds": 0,
                                              # Optional. The number of seconds to wait before
                                              beginning health checks.
                                            "period_seconds": 0,  #
                                              Optional. The number of seconds to wait between health
                                              checks.
                                            "port": 0,  # Optional. The
                                              port on which the health check will be performed. If not
                                              set, the health check will be performed on the
                                              component's http_port.
                                            "success_threshold": 0,  #
                                              Optional. The number of successful health checks before
                                              considered healthy.
                                            "timeout_seconds": 0  #
                                              Optional. The number of seconds after which the check
                                              times out.
                                        },
                                        "http_port": 0,  # Optional. The
                                          internal port on which this service's run command will
                                          listen. Default: 8080"nIf there is not an environment
                                          variable with the name ``PORT``"" , one will be automatically
                                          added with its value set to the value of this field.
                                        "image": {
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type."n* DOCR: The DigitalOcean container registry type.
                                              Known values are: "DOCKER_HUB" and "DOCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided.
                                        },
                                        "instance_count": 1,  # Optional.
                                          Default value is 1. The amount of instances that this
                                          component should be scaled to. Default: 1.
                                        "instance_size_slug": "basic-xxs",  #
                                          Optional. Default value is "basic-xxs". The instance size to
                                          use for this component. Default: ``basic-xxs``. Known values
                                          are: "basic-xxs", "basic-xs", "basic-s", "basic-m",
                                          "professional-xs", "professional-s", "professional-m",
                                          "professional-1l", "professional-l", and "professional-xl".
                                        "internal_ports": [
                                            0  # Optional. The ports on
                                              which this service will listen for internal traffic.
                                        ],
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "routes": [
                                            {
                                                "path": "str",  #
                                                  Optional. An HTTP path prefix. Paths must start with
                                                  / and must be unique across all components within an
                                                  app.
                "preserve_path_prefix": bool  # Optional. An optional
                                                  flag to preserve the path that is forwarded to the
                                                  backend service. By default, the HTTP request path
                                                  will be trimmed from the left when forwarded to the
                                                  component. For example, a component with
                                                  ``path=/api`` will have requests to ``/api/list``
                                                  trimmed to ``/list``. If this value is ``true``"" ,
                                                  the path will remain ``/api/list``.
                                            }
                                        ],
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "static_sites": [
                                    {
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "catchall_document": "str",  #
                                          Optional. The name of the document to use as the fallback for
                                          any requests to documents that are not found when serving
                                          this static site. Only 1 of ``catchall_document`` or
                                          ``error_document`` can be set.
                                        "cors": {
                                            "allow_credentials": bool,  #
                                              Optional. Whether browsers should expose the response to
                                              the client-side JavaScript code when the request"u2019s
                                              credentials mode is include. This configures the
                                              ``Access-Control-Allow-Credentials`` header.
                                            "allow_headers": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP request headers. This
                                                  configures the ``Access-Control-Allow-Headers``
                                                  header.
                                            ],
                                            "allow_methods": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP methods. This configures the
                                                  ``Access-Control-Allow-Methods`` header.
                                            ],
                                            "allow_origins": [
                                                {
                                                    "exact":
                                                      "str",  # Optional. Exact string match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "prefix":
                                                      "str",  # Optional. Prefix-based match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "regex":
                                                      "str"  # Optional. RE2 style regex-based match.
                                                      Only 1 of ``exact``"" , ``prefix``"" , or
                                                      ``regex`` must be set. For more information about
                                                      RE2 syntax, see:
                                                      https://github.com/google/re2/wiki/Syntax.
                                                }
                                            ],
                                            "expose_headers": [
                                                "str"  # Optional.
                                                  The set of HTTP response headers that browsers are
                                                  allowed to access. This configures the
                                                  ``Access-Control-Expose-Headers`` header.
                                            ],
                                            "max_age": "str"  # Optional.
                                              An optional duration specifying how long browsers can
                                              cache the results of a preflight request. This configures
                                              the ``Access-Control-Max-Age`` header.
                                        },
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://www.digitalocean.com/docs/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "error_document": "404.html",  #
                                          Optional. Default value is "404.html". The name of the error
                                          document to use when serving this static site. Default:
                                          404.html. If no such file exists within the built assets, App
                                          Platform will supply one.
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "image": {
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type."n* DOCR: The DigitalOcean container registry type.
                                              Known values are: "DOCKER_HUB" and "DOCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided.
                                        },
                                        "index_document": "index.html",  #
                                          Optional. Default value is "index.html". The name of the
                                          index document to use when serving this static site. Default:
                                          index.html.
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "output_dir": "str",  # Optional. An
                                          optional path to where the built assets will be located,
                                          relative to the build context. If not set, App Platform will
                                          automatically scan for these directory names: ``_static``"" ,
                                          ``dist``"" , ``public``"" , ``build``.
                                        "routes": [
                                            {
                                                "path": "str",  #
                                                  Optional. An HTTP path prefix. Paths must start with
                                                  / and must be unique across all components within an
                                                  app.
                "preserve_path_prefix": bool  # Optional. An optional
                                                  flag to preserve the path that is forwarded to the
                                                  backend service. By default, the HTTP request path
                                                  will be trimmed from the left when forwarded to the
                                                  component. For example, a component with
                                                  ``path=/api`` will have requests to ``/api/list``
                                                  trimmed to ``/list``. If this value is ``true``"" ,
                                                  the path will remain ``/api/list``.
                                            }
                                        ],
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ],
                                "workers": [
                                    {
                                        "build_command": "str",  # Optional.
                                          An optional build command to run while building this
                                          component from source.
                                        "dockerfile_path": "str",  #
                                          Optional. The path to the Dockerfile relative to the root of
                                          the repo. If set, it will be used to build this component.
                                          Otherwise, App Platform will attempt to build it using
                                          buildpacks.
                                        "environment_slug": "str",  #
                                          Optional. An environment slug describing the type of this
                                          app. For a full list, please refer to `the product
                                          documentation
                                          <https://www.digitalocean.com/docs/app-platform/>`_.
                                        "envs": [
                                            {
                                                "key": "str",  # The
                                                  variable name. Required.
                                                "scope":
                                                  "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                                  "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only
                                                  at run-time"n* BUILD_TIME: Made available only at
                                                  build-time"n* RUN_AND_BUILD_TIME: Made available at
                                                  both build and run-time. Known values are: "UNSET",
                                                  "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                                "type": "GENERAL",  #
                                                  Optional. Default value is "GENERAL". * GENERAL: A
                                                  plain-text environment variable"n* SECRET: A secret
                                                  encrypted environment variable. Known values are:
                                                  "GENERAL" and "SECRET".
                                                "value": "str"  #
                                                  Optional. The value. If the type is ``SECRET``"" ,
                                                  the value will be encrypted on first submission. On
                                                  following submissions, the encrypted value should be
                                                  used.
                                            }
                                        ],
                                        "git": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "repo_clone_url": "str"  #
                                              Optional. The clone URL of the repo. Example:
                                              ``https://github.com/digitalocean/sample-golang.git``.
                                        },
                                        "github": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "gitlab": {
                                            "branch": "str",  # Optional.
                                              The name of the branch to use.
                                            "deploy_on_push": bool,  #
                                              Optional. Whether to automatically deploy new commits
                                              made to the repo.
                                            "repo": "str"  # Optional.
                                              The name of the repo in the format owner/repo. Example:
                                              ``digitalocean/sample-golang``.
                                        },
                                        "image": {
                                            "registry": "str",  #
                                              Optional. The registry name. Must be left empty for the
                                              ``DOCR`` registry type.
                                            "registry_type": "str",  #
                                              Optional. * DOCKER_HUB: The DockerHub container registry
                                              type."n* DOCR: The DigitalOcean container registry type.
                                              Known values are: "DOCKER_HUB" and "DOCR".
                                            "repository": "str",  #
                                              Optional. The repository name.
                                            "tag": "latest"  # Optional.
                                              Default value is "latest". The repository tag. Defaults
                                              to ``latest`` if not provided.
                                        },
                                        "instance_count": 1,  # Optional.
                                          Default value is 1. The amount of instances that this
                                          component should be scaled to. Default: 1.
                                        "instance_size_slug": "basic-xxs",  #
                                          Optional. Default value is "basic-xxs". The instance size to
                                          use for this component. Default: ``basic-xxs``. Known values
                                          are: "basic-xxs", "basic-xs", "basic-s", "basic-m",
                                          "professional-xs", "professional-s", "professional-m",
                                          "professional-1l", "professional-l", and "professional-xl".
                                        "log_destinations": {
                                            "datadog": {
                                                "api_key": "str",  #
                                                  Datadog API key. Required.
                                                "endpoint": "str"  #
                                                  Optional. Datadog HTTP log intake endpoint.
                                            },
                                            "logtail": {
                                                "token": "str"  #
                                                  Optional. Logtail token.
                                            },
                                            "name": "str",  # Required.
                                            "papertrail": {
                                                "endpoint": "str"  #
                                                  Papertrail syslog endpoint. Required.
                                            }
                                        },
                                        "name": "str",  # Optional. The name.
                                          Must be unique across all components within the same app.
                                        "run_command": "str",  # Optional. An
                                          optional run command to override the component's default.
                                        "source_dir": "str"  # Optional. An
                                          optional path to the working directory to use for the build.
                                          For Dockerfile builds, this will be used as the build
                                          context. Must be relative to the root of the repo.
                                    }
                                ]
                            },
                            "static_sites": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      static site.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this static
                                      site.
                                }
                            ],
                            "tier_slug": "str",  # Optional. The current pricing tier
                              slug of the deployment.
                            "updated_at": "2020-02-20 00:00:00",  # Optional. When the
                              deployment was last updated.
                            "workers": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      worker.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this worker.
                                }
                            ]
                        },
                        "region": {
                            "continent": "str",  # Optional. The continent that this
                              region is in.
                            "data_centers": [
                                "str"  # Optional. Data centers that are in this
                                  region.
                            ],
                            "default": bool,  # Optional. Whether or not the region is
                              presented as the default.
                            "disabled": bool,  # Optional. Whether or not the region is
                              open for new apps.
                            "flag": "str",  # Optional. The flag of this region.
                            "label": "str",  # Optional. A human-readable name of the
                              region.
                            "reason": "str",  # Optional. Reason that this region is not
                              available.
                            "slug": "str"  # Optional. The slug form of the region name.
                        },
                        "spec": {
                            "databases": [
                                {
                                    "cluster_name": "str",  # Optional. The name
                                      of the underlying DigitalOcean DBaaS cluster. This is required
                                      for production databases. For dev databases, if cluster_name is
                                      not set, a new cluster will be provisioned.
                                    "db_name": "str",  # Optional. The name of
                                      the MySQL or PostgreSQL database to configure.
                                    "db_user": "str",  # Optional. The name of
                                      the MySQL or PostgreSQL user to configure.
                                    "engine": "UNSET",  # Optional. Default value
                                      is "UNSET". * MYSQL: MySQL"n* PG: PostgreSQL"n* REDIS: Redis.
                                      Known values are: "UNSET", "MYSQL", "PG", and "REDIS".
                                    "name": "str",  # The name. Must be unique
                                      across all components within the same app. Required.
                                    "production": bool,  # Optional. Whether this
                                      is a production or dev database.
                                    "version": "str"  # Optional. The version of
                                      the database engine.
                                }
                            ],
                            "domains": [
                                {
                                    "domain": "str",  # The hostname for the
                                      domain. Required.
                                    "minimum_tls_version": "str",  # Optional.
                                      The minimum version of TLS a client application can use to access
                                      resources for the domain.  Must be one of the following values
                                      wrapped within quotations: ``"1.2"`` or ``"1.3"``. Known values
                                      are: "1.2" and "1.3".
                                    "type": "UNSPECIFIED",  # Optional. Default
                                      value is "UNSPECIFIED". * DEFAULT: The default
                                      ``.ondigitalocean.app`` domain assigned to this app"n* PRIMARY:
                                      The primary domain for this app that is displayed as the default
                                      in the control panel, used in bindable environment variables, and
                                      any other places that reference an app's live URL. Only one
                                      domain may be set as primary."n* ALIAS: A non-primary domain.
                                      Known values are: "UNSPECIFIED", "DEFAULT", "PRIMARY", and
                                      "ALIAS".
                                    "wildcard": bool,  # Optional. Indicates
                                      whether the domain includes all sub-domains, in addition to the
                                      given domain.
                                    "zone": "str"  # Optional. Optional. If the
                                      domain uses DigitalOcean DNS and you would like App"nPlatform to
                                      automatically manage it for you, set this to the name of
                                      the"ndomain on your account."n"nFor example, If the domain you
                                      are adding is ``app.domain.com``"" , the zone"ncould be
                                      ``domain.com``.
                                }
                            ],
                            "functions": [
                                {
                                    "alerts": [
                                        {
                                            "disabled": bool,  #
                                              Optional. Is the alert disabled?.
                                            "operator":
                                              "UNSPECIFIED_OPERATOR",  # Optional. Default value is
                                              "UNSPECIFIED_OPERATOR". Known values are:
                                              "UNSPECIFIED_OPERATOR", "GREATER_THAN", and "LESS_THAN".
                                            "rule": "UNSPECIFIED_RULE",
                                              # Optional. Default value is "UNSPECIFIED_RULE". Known
                                              values are: "UNSPECIFIED_RULE", "CPU_UTILIZATION",
                                              "MEM_UTILIZATION", "RESTART_COUNT", "DEPLOYMENT_FAILED",
                                              "DEPLOYMENT_LIVE", "DOMAIN_FAILED", "DOMAIN_LIVE",
                                              "FUNCTIONS_ACTIVATION_COUNT",
                                              "FUNCTIONS_AVERAGE_DURATION_MS",
                                              "FUNCTIONS_ERROR_RATE_PER_MINUTE",
                                              "FUNCTIONS_AVERAGE_WAIT_TIME_MS",
                                              "FUNCTIONS_ERROR_COUNT", and
                                              "FUNCTIONS_GB_RATE_PER_SECOND".
                                            "value": 0.0,  # Optional.
                                              Threshold value for alert.
                                            "window":
                                              "UNSPECIFIED_WINDOW"  # Optional. Default value is
                                              "UNSPECIFIED_WINDOW". Known values are:
                                              "UNSPECIFIED_WINDOW", "FIVE_MINUTES", "TEN_MINUTES",
                                              "THIRTY_MINUTES", and "ONE_HOUR".
                                        }
                                    ],
                                    "cors": {
                                        "allow_credentials": bool,  #
                                          Optional. Whether browsers should expose the response to the
                                          client-side JavaScript code when the request"u2019s
                                          credentials mode is include. This configures the
                                          ``Access-Control-Allow-Credentials`` header.
                                        "allow_headers": [
                                            "str"  # Optional. The set of
                                              allowed HTTP request headers. This configures the
                                              ``Access-Control-Allow-Headers`` header.
                                        ],
                                        "allow_methods": [
                                            "str"  # Optional. The set of
                                              allowed HTTP methods. This configures the
                                              ``Access-Control-Allow-Methods`` header.
                                        ],
                                        "allow_origins": [
                                            {
                                                "exact": "str",  #
                                                  Optional. Exact string match. Only 1 of ``exact``"" ,
                                                  ``prefix``"" , or ``regex`` must be set.
                                                "prefix": "str",  #
                                                  Optional. Prefix-based match. Only 1 of ``exact``"" ,
                                                  ``prefix``"" , or ``regex`` must be set.
                                                "regex": "str"  #
                                                  Optional. RE2 style regex-based match. Only 1 of
                                                  ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                  set. For more information about RE2 syntax, see:
                                                  https://github.com/google/re2/wiki/Syntax.
                                            }
                                        ],
                                        "expose_headers": [
                                            "str"  # Optional. The set of
                                              HTTP response headers that browsers are allowed to
                                              access. This configures the
                                              ``Access-Control-Expose-Headers`` header.
                                        ],
                                        "max_age": "str"  # Optional. An
                                          optional duration specifying how long browsers can cache the
                                          results of a preflight request. This configures the
                                          ``Access-Control-Max-Age`` header.
                                    },
                                    "envs": [
                                        {
                                            "key": "str",  # The variable
                                              name. Required.
                                            "scope":
                                              "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                              "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only at
                                              run-time"n* BUILD_TIME: Made available only at
                                              build-time"n* RUN_AND_BUILD_TIME: Made available at both
                                              build and run-time. Known values are: "UNSET",
                                              "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                            "type": "GENERAL",  #
                                              Optional. Default value is "GENERAL". * GENERAL: A
                                              plain-text environment variable"n* SECRET: A secret
                                              encrypted environment variable. Known values are:
                                              "GENERAL" and "SECRET".
                                            "value": "str"  # Optional.
                                              The value. If the type is ``SECRET``"" , the value will
                                              be encrypted on first submission. On following
                                              submissions, the encrypted value should be used.
                                        }
                                    ],
                                    "git": {
                                        "branch": "str",  # Optional. The
                                          name of the branch to use.
                                        "repo_clone_url": "str"  # Optional.
                                          The clone URL of the repo. Example:
                                          ``https://github.com/digitalocean/sample-golang.git``.
                                    },
                                    "github": {
                                        "branch": "str",  # Optional. The
                                          name of the branch to use.
                                        "deploy_on_push": bool,  # Optional.
                                          Whether to automatically deploy new commits made to the repo.
                                        "repo": "str"  # Optional. The name
                                          of the repo in the format owner/repo. Example:
                                          ``digitalocean/sample-golang``.
                                    },
                                    "gitlab": {
                                        "branch": "str",  # Optional. The
                                          name of the branch to use.
                                        "deploy_on_push": bool,  # Optional.
                                          Whether to automatically deploy new commits made to the repo.
                                        "repo": "str"  # Optional. The name
                                          of the repo in the format owner/repo. Example:
                                          ``digitalocean/sample-golang``.
                                    },
                                    "log_destinations": {
                                        "datadog": {
                                            "api_key": "str",  # Datadog
                                              API key. Required.
                                            "endpoint": "str"  #
                                              Optional. Datadog HTTP log intake endpoint.
                                        },
                                        "logtail": {
                                            "token": "str"  # Optional.
                                              Logtail token.
                                        },
                                        "name": "str",  # Required.
                                        "papertrail": {
                                            "endpoint": "str"  #
                                              Papertrail syslog endpoint. Required.
                                        }
                                    },
                                    "name": "str",  # The name. Must be unique
                                      across all components within the same app. Required.
                                    "routes": [
                                        {
                                            "path": "str",  # Optional.
                                              An HTTP path prefix. Paths must start with / and must be
                                              unique across all components within an app.
                                            "preserve_path_prefix": bool
                                              # Optional. An optional flag to preserve the path that is
                                              forwarded to the backend service. By default, the HTTP
                                              request path will be trimmed from the left when forwarded
                                              to the component. For example, a component with
                                              ``path=/api`` will have requests to ``/api/list`` trimmed
                                              to ``/list``. If this value is ``true``"" , the path will
                                              remain ``/api/list``.
                                        }
                                    ],
                                    "source_dir": "str"  # Optional. An optional
                                      path to the working directory to use for the build. For
                                      Dockerfile builds, this will be used as the build context. Must
                                      be relative to the root of the repo.
                                }
                            ],
                            "jobs": [
                                {
                                    "build_command": "str",  # Optional. An
                                      optional build command to run while building this component from
                                      source.
                                    "dockerfile_path": "str",  # Optional. The
                                      path to the Dockerfile relative to the root of the repo. If set,
                                      it will be used to build this component. Otherwise, App Platform
                                      will attempt to build it using buildpacks.
                                    "environment_slug": "str",  # Optional. An
                                      environment slug describing the type of this app. For a full
                                      list, please refer to `the product documentation
                                      <https://www.digitalocean.com/docs/app-platform/>`_.
                                    "envs": [
                                        {
                                            "key": "str",  # The variable
                                              name. Required.
                                            "scope":
                                              "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                              "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only at
                                              run-time"n* BUILD_TIME: Made available only at
                                              build-time"n* RUN_AND_BUILD_TIME: Made available at both
                                              build and run-time. Known values are: "UNSET",
                                              "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                            "type": "GENERAL",  #
                                              Optional. Default value is "GENERAL". * GENERAL: A
                                              plain-text environment variable"n* SECRET: A secret
                                              encrypted environment variable. Known values are:
                                              "GENERAL" and "SECRET".
                                            "value": "str"  # Optional.
                                              The value. If the type is ``SECRET``"" , the value will
                                              be encrypted on first submission. On following
                                              submissions, the encrypted value should be used.
                                        }
                                    ],
                                    "git": {
                                        "branch": "str",  # Optional. The
                                          name of the branch to use.
                                        "repo_clone_url": "str"  # Optional.
                                          The clone URL of the repo. Example:
                                          ``https://github.com/digitalocean/sample-golang.git``.
                                    },
                                    "github": {
                                        "branch": "str",  # Optional. The
                                          name of the branch to use.
                                        "deploy_on_push": bool,  # Optional.
                                          Whether to automatically deploy new commits made to the repo.
                                        "repo": "str"  # Optional. The name
                                          of the repo in the format owner/repo. Example:
                                          ``digitalocean/sample-golang``.
                                    },
                                    "gitlab": {
                                        "branch": "str",  # Optional. The
                                          name of the branch to use.
                                        "deploy_on_push": bool,  # Optional.
                                          Whether to automatically deploy new commits made to the repo.
                                        "repo": "str"  # Optional. The name
                                          of the repo in the format owner/repo. Example:
                                          ``digitalocean/sample-golang``.
                                    },
                                    "image": {
                                        "registry": "str",  # Optional. The
                                          registry name. Must be left empty for the ``DOCR`` registry
                                          type.
                                        "registry_type": "str",  # Optional.
                                          * DOCKER_HUB: The DockerHub container registry type."n* DOCR:
                                          The DigitalOcean container registry type. Known values are:
                                          "DOCKER_HUB" and "DOCR".
                                        "repository": "str",  # Optional. The
                                          repository name.
                                        "tag": "latest"  # Optional. Default
                                          value is "latest". The repository tag. Defaults to ``latest``
                                          if not provided.
                                    },
                                    "instance_count": 1,  # Optional. Default
                                      value is 1. The amount of instances that this component should be
                                      scaled to. Default: 1.
                                    "instance_size_slug": "basic-xxs",  #
                                      Optional. Default value is "basic-xxs". The instance size to use
                                      for this component. Default: ``basic-xxs``. Known values are:
                                      "basic-xxs", "basic-xs", "basic-s", "basic-m", "professional-xs",
                                      "professional-s", "professional-m", "professional-1l",
                                      "professional-l", and "professional-xl".
                                    "kind": "UNSPECIFIED",  # Optional. Default
                                      value is "UNSPECIFIED". * UNSPECIFIED: Default job type, will
                                      auto-complete to POST_DEPLOY kind."n* PRE_DEPLOY: Indicates a job
                                      that runs before an app deployment."n* POST_DEPLOY: Indicates a
                                      job that runs after an app deployment."n* FAILED_DEPLOY:
                                      Indicates a job that runs after a component fails to deploy.
                                      Known values are: "UNSPECIFIED", "PRE_DEPLOY", "POST_DEPLOY", and
                                      "FAILED_DEPLOY".
                                    "log_destinations": {
                                        "datadog": {
                                            "api_key": "str",  # Datadog
                                              API key. Required.
                                            "endpoint": "str"  #
                                              Optional. Datadog HTTP log intake endpoint.
                                        },
                                        "logtail": {
                                            "token": "str"  # Optional.
                                              Logtail token.
                                        },
                                        "name": "str",  # Required.
                                        "papertrail": {
                                            "endpoint": "str"  #
                                              Papertrail syslog endpoint. Required.
                                        }
                                    },
                                    "name": "str",  # Optional. The name. Must be
                                      unique across all components within the same app.
                                    "run_command": "str",  # Optional. An
                                      optional run command to override the component's default.
                                    "source_dir": "str"  # Optional. An optional
                                      path to the working directory to use for the build. For
                                      Dockerfile builds, this will be used as the build context. Must
                                      be relative to the root of the repo.
                                }
                            ],
                            "name": "str",  # The name of the app. Must be unique across
                              all apps in the same account. Required.
                            "region": "str",  # Optional. The slug form of the
                              geographical origin of the app. Default: ``nearest available``. Known
                              values are: "ams", "nyc", and "fra".
                            "services": [
                                {
                                    "build_command": "str",  # Optional. An
                                      optional build command to run while building this component from
                                      source.
                                    "cors": {
                                        "allow_credentials": bool,  #
                                          Optional. Whether browsers should expose the response to the
                                          client-side JavaScript code when the request"u2019s
                                          credentials mode is include. This configures the
                                          ``Access-Control-Allow-Credentials`` header.
                                        "allow_headers": [
                                            "str"  # Optional. The set of
                                              allowed HTTP request headers. This configures the
                                              ``Access-Control-Allow-Headers`` header.
                                        ],
                                        "allow_methods": [
                                            "str"  # Optional. The set of
                                              allowed HTTP methods. This configures the
                                              ``Access-Control-Allow-Methods`` header.
                                        ],
                                        "allow_origins": [
                                            {
                                                "exact": "str",  #
                                                  Optional. Exact string match. Only 1 of ``exact``"" ,
                                                  ``prefix``"" , or ``regex`` must be set.
                                                "prefix": "str",  #
                                                  Optional. Prefix-based match. Only 1 of ``exact``"" ,
                                                  ``prefix``"" , or ``regex`` must be set.
                                                "regex": "str"  #
                                                  Optional. RE2 style regex-based match. Only 1 of
                                                  ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                  set. For more information about RE2 syntax, see:
                                                  https://github.com/google/re2/wiki/Syntax.
                                            }
                                        ],
                                        "expose_headers": [
                                            "str"  # Optional. The set of
                                              HTTP response headers that browsers are allowed to
                                              access. This configures the
                                              ``Access-Control-Expose-Headers`` header.
                                        ],
                                        "max_age": "str"  # Optional. An
                                          optional duration specifying how long browsers can cache the
                                          results of a preflight request. This configures the
                                          ``Access-Control-Max-Age`` header.
                                    },
                                    "dockerfile_path": "str",  # Optional. The
                                      path to the Dockerfile relative to the root of the repo. If set,
                                      it will be used to build this component. Otherwise, App Platform
                                      will attempt to build it using buildpacks.
                                    "environment_slug": "str",  # Optional. An
                                      environment slug describing the type of this app. For a full
                                      list, please refer to `the product documentation
                                      <https://www.digitalocean.com/docs/app-platform/>`_.
                                    "envs": [
                                        {
                                            "key": "str",  # The variable
                                              name. Required.
                                            "scope":
                                              "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                              "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only at
                                              run-time"n* BUILD_TIME: Made available only at
                                              build-time"n* RUN_AND_BUILD_TIME: Made available at both
                                              build and run-time. Known values are: "UNSET",
                                              "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                            "type": "GENERAL",  #
                                              Optional. Default value is "GENERAL". * GENERAL: A
                                              plain-text environment variable"n* SECRET: A secret
                                              encrypted environment variable. Known values are:
                                              "GENERAL" and "SECRET".
                                            "value": "str"  # Optional.
                                              The value. If the type is ``SECRET``"" , the value will
                                              be encrypted on first submission. On following
                                              submissions, the encrypted value should be used.
                                        }
                                    ],
                                    "git": {
                                        "branch": "str",  # Optional. The
                                          name of the branch to use.
                                        "repo_clone_url": "str"  # Optional.
                                          The clone URL of the repo. Example:
                                          ``https://github.com/digitalocean/sample-golang.git``.
                                    },
                                    "github": {
                                        "branch": "str",  # Optional. The
                                          name of the branch to use.
                                        "deploy_on_push": bool,  # Optional.
                                          Whether to automatically deploy new commits made to the repo.
                                        "repo": "str"  # Optional. The name
                                          of the repo in the format owner/repo. Example:
                                          ``digitalocean/sample-golang``.
                                    },
                                    "gitlab": {
                                        "branch": "str",  # Optional. The
                                          name of the branch to use.
                                        "deploy_on_push": bool,  # Optional.
                                          Whether to automatically deploy new commits made to the repo.
                                        "repo": "str"  # Optional. The name
                                          of the repo in the format owner/repo. Example:
                                          ``digitalocean/sample-golang``.
                                    },
                                    "health_check": {
                                        "failure_threshold": 0,  # Optional.
                                          The number of failed health checks before considered
                                          unhealthy.
                                        "http_path": "str",  # Optional. The
                                          route path used for the HTTP health check ping. If not set,
                                          the HTTP health check will be disabled and a TCP health check
                                          used instead.
                                        "initial_delay_seconds": 0,  #
                                          Optional. The number of seconds to wait before beginning
                                          health checks.
                                        "period_seconds": 0,  # Optional. The
                                          number of seconds to wait between health checks.
                                        "port": 0,  # Optional. The port on
                                          which the health check will be performed. If not set, the
                                          health check will be performed on the component's http_port.
                                        "success_threshold": 0,  # Optional.
                                          The number of successful health checks before considered
                                          healthy.
                                        "timeout_seconds": 0  # Optional. The
                                          number of seconds after which the check times out.
                                    },
                                    "http_port": 0,  # Optional. The internal
                                      port on which this service's run command will listen. Default:
                                      8080"nIf there is not an environment variable with the name
                                      ``PORT``"" , one will be automatically added with its value set
                                      to the value of this field.
                                    "image": {
                                        "registry": "str",  # Optional. The
                                          registry name. Must be left empty for the ``DOCR`` registry
                                          type.
                                        "registry_type": "str",  # Optional.
                                          * DOCKER_HUB: The DockerHub container registry type."n* DOCR:
                                          The DigitalOcean container registry type. Known values are:
                                          "DOCKER_HUB" and "DOCR".
                                        "repository": "str",  # Optional. The
                                          repository name.
                                        "tag": "latest"  # Optional. Default
                                          value is "latest". The repository tag. Defaults to ``latest``
                                          if not provided.
                                    },
                                    "instance_count": 1,  # Optional. Default
                                      value is 1. The amount of instances that this component should be
                                      scaled to. Default: 1.
                                    "instance_size_slug": "basic-xxs",  #
                                      Optional. Default value is "basic-xxs". The instance size to use
                                      for this component. Default: ``basic-xxs``. Known values are:
                                      "basic-xxs", "basic-xs", "basic-s", "basic-m", "professional-xs",
                                      "professional-s", "professional-m", "professional-1l",
                                      "professional-l", and "professional-xl".
                                    "internal_ports": [
                                        0  # Optional. The ports on which
                                          this service will listen for internal traffic.
                                    ],
                                    "log_destinations": {
                                        "datadog": {
                                            "api_key": "str",  # Datadog
                                              API key. Required.
                                            "endpoint": "str"  #
                                              Optional. Datadog HTTP log intake endpoint.
                                        },
                                        "logtail": {
                                            "token": "str"  # Optional.
                                              Logtail token.
                                        },
                                        "name": "str",  # Required.
                                        "papertrail": {
                                            "endpoint": "str"  #
                                              Papertrail syslog endpoint. Required.
                                        }
                                    },
                                    "name": "str",  # Optional. The name. Must be
                                      unique across all components within the same app.
                                    "routes": [
                                        {
                                            "path": "str",  # Optional.
                                              An HTTP path prefix. Paths must start with / and must be
                                              unique across all components within an app.
                                            "preserve_path_prefix": bool
                                              # Optional. An optional flag to preserve the path that is
                                              forwarded to the backend service. By default, the HTTP
                                              request path will be trimmed from the left when forwarded
                                              to the component. For example, a component with
                                              ``path=/api`` will have requests to ``/api/list`` trimmed
                                              to ``/list``. If this value is ``true``"" , the path will
                                              remain ``/api/list``.
                                        }
                                    ],
                                    "run_command": "str",  # Optional. An
                                      optional run command to override the component's default.
                                    "source_dir": "str"  # Optional. An optional
                                      path to the working directory to use for the build. For
                                      Dockerfile builds, this will be used as the build context. Must
                                      be relative to the root of the repo.
                                }
                            ],
                            "static_sites": [
                                {
                                    "build_command": "str",  # Optional. An
                                      optional build command to run while building this component from
                                      source.
                                    "catchall_document": "str",  # Optional. The
                                      name of the document to use as the fallback for any requests to
                                      documents that are not found when serving this static site. Only
                                      1 of ``catchall_document`` or ``error_document`` can be set.
                                    "cors": {
                                        "allow_credentials": bool,  #
                                          Optional. Whether browsers should expose the response to the
                                          client-side JavaScript code when the request"u2019s
                                          credentials mode is include. This configures the
                                          ``Access-Control-Allow-Credentials`` header.
                                        "allow_headers": [
                                            "str"  # Optional. The set of
                                              allowed HTTP request headers. This configures the
                                              ``Access-Control-Allow-Headers`` header.
                                        ],
                                        "allow_methods": [
                                            "str"  # Optional. The set of
                                              allowed HTTP methods. This configures the
                                              ``Access-Control-Allow-Methods`` header.
                                        ],
                                        "allow_origins": [
                                            {
                                                "exact": "str",  #
                                                  Optional. Exact string match. Only 1 of ``exact``"" ,
                                                  ``prefix``"" , or ``regex`` must be set.
                                                "prefix": "str",  #
                                                  Optional. Prefix-based match. Only 1 of ``exact``"" ,
                                                  ``prefix``"" , or ``regex`` must be set.
                                                "regex": "str"  #
                                                  Optional. RE2 style regex-based match. Only 1 of
                                                  ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                  set. For more information about RE2 syntax, see:
                                                  https://github.com/google/re2/wiki/Syntax.
                                            }
                                        ],
                                        "expose_headers": [
                                            "str"  # Optional. The set of
                                              HTTP response headers that browsers are allowed to
                                              access. This configures the
                                              ``Access-Control-Expose-Headers`` header.
                                        ],
                                        "max_age": "str"  # Optional. An
                                          optional duration specifying how long browsers can cache the
                                          results of a preflight request. This configures the
                                          ``Access-Control-Max-Age`` header.
                                    },
                                    "dockerfile_path": "str",  # Optional. The
                                      path to the Dockerfile relative to the root of the repo. If set,
                                      it will be used to build this component. Otherwise, App Platform
                                      will attempt to build it using buildpacks.
                                    "environment_slug": "str",  # Optional. An
                                      environment slug describing the type of this app. For a full
                                      list, please refer to `the product documentation
                                      <https://www.digitalocean.com/docs/app-platform/>`_.
                                    "envs": [
                                        {
                                            "key": "str",  # The variable
                                              name. Required.
                                            "scope":
                                              "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                              "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only at
                                              run-time"n* BUILD_TIME: Made available only at
                                              build-time"n* RUN_AND_BUILD_TIME: Made available at both
                                              build and run-time. Known values are: "UNSET",
                                              "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                            "type": "GENERAL",  #
                                              Optional. Default value is "GENERAL". * GENERAL: A
                                              plain-text environment variable"n* SECRET: A secret
                                              encrypted environment variable. Known values are:
                                              "GENERAL" and "SECRET".
                                            "value": "str"  # Optional.
                                              The value. If the type is ``SECRET``"" , the value will
                                              be encrypted on first submission. On following
                                              submissions, the encrypted value should be used.
                                        }
                                    ],
                                    "error_document": "404.html",  # Optional.
                                      Default value is "404.html". The name of the error document to
                                      use when serving this static site. Default: 404.html. If no such
                                      file exists within the built assets, App Platform will supply
                                      one.
                                    "git": {
                                        "branch": "str",  # Optional. The
                                          name of the branch to use.
                                        "repo_clone_url": "str"  # Optional.
                                          The clone URL of the repo. Example:
                                          ``https://github.com/digitalocean/sample-golang.git``.
                                    },
                                    "github": {
                                        "branch": "str",  # Optional. The
                                          name of the branch to use.
                                        "deploy_on_push": bool,  # Optional.
                                          Whether to automatically deploy new commits made to the repo.
                                        "repo": "str"  # Optional. The name
                                          of the repo in the format owner/repo. Example:
                                          ``digitalocean/sample-golang``.
                                    },
                                    "gitlab": {
                                        "branch": "str",  # Optional. The
                                          name of the branch to use.
                                        "deploy_on_push": bool,  # Optional.
                                          Whether to automatically deploy new commits made to the repo.
                                        "repo": "str"  # Optional. The name
                                          of the repo in the format owner/repo. Example:
                                          ``digitalocean/sample-golang``.
                                    },
                                    "image": {
                                        "registry": "str",  # Optional. The
                                          registry name. Must be left empty for the ``DOCR`` registry
                                          type.
                                        "registry_type": "str",  # Optional.
                                          * DOCKER_HUB: The DockerHub container registry type."n* DOCR:
                                          The DigitalOcean container registry type. Known values are:
                                          "DOCKER_HUB" and "DOCR".
                                        "repository": "str",  # Optional. The
                                          repository name.
                                        "tag": "latest"  # Optional. Default
                                          value is "latest". The repository tag. Defaults to ``latest``
                                          if not provided.
                                    },
                                    "index_document": "index.html",  # Optional.
                                      Default value is "index.html". The name of the index document to
                                      use when serving this static site. Default: index.html.
                                    "log_destinations": {
                                        "datadog": {
                                            "api_key": "str",  # Datadog
                                              API key. Required.
                                            "endpoint": "str"  #
                                              Optional. Datadog HTTP log intake endpoint.
                                        },
                                        "logtail": {
                                            "token": "str"  # Optional.
                                              Logtail token.
                                        },
                                        "name": "str",  # Required.
                                        "papertrail": {
                                            "endpoint": "str"  #
                                              Papertrail syslog endpoint. Required.
                                        }
                                    },
                                    "name": "str",  # Optional. The name. Must be
                                      unique across all components within the same app.
                                    "output_dir": "str",  # Optional. An optional
                                      path to where the built assets will be located, relative to the
                                      build context. If not set, App Platform will automatically scan
                                      for these directory names: ``_static``"" , ``dist``"" ,
                                      ``public``"" , ``build``.
                                    "routes": [
                                        {
                                            "path": "str",  # Optional.
                                              An HTTP path prefix. Paths must start with / and must be
                                              unique across all components within an app.
                                            "preserve_path_prefix": bool
                                              # Optional. An optional flag to preserve the path that is
                                              forwarded to the backend service. By default, the HTTP
                                              request path will be trimmed from the left when forwarded
                                              to the component. For example, a component with
                                              ``path=/api`` will have requests to ``/api/list`` trimmed
                                              to ``/list``. If this value is ``true``"" , the path will
                                              remain ``/api/list``.
                                        }
                                    ],
                                    "run_command": "str",  # Optional. An
                                      optional run command to override the component's default.
                                    "source_dir": "str"  # Optional. An optional
                                      path to the working directory to use for the build. For
                                      Dockerfile builds, this will be used as the build context. Must
                                      be relative to the root of the repo.
                                }
                            ],
                            "workers": [
                                {
                                    "build_command": "str",  # Optional. An
                                      optional build command to run while building this component from
                                      source.
                                    "dockerfile_path": "str",  # Optional. The
                                      path to the Dockerfile relative to the root of the repo. If set,
                                      it will be used to build this component. Otherwise, App Platform
                                      will attempt to build it using buildpacks.
                                    "environment_slug": "str",  # Optional. An
                                      environment slug describing the type of this app. For a full
                                      list, please refer to `the product documentation
                                      <https://www.digitalocean.com/docs/app-platform/>`_.
                                    "envs": [
                                        {
                                            "key": "str",  # The variable
                                              name. Required.
                                            "scope":
                                              "RUN_AND_BUILD_TIME",  # Optional. Default value is
                                              "RUN_AND_BUILD_TIME". * RUN_TIME: Made available only at
                                              run-time"n* BUILD_TIME: Made available only at
                                              build-time"n* RUN_AND_BUILD_TIME: Made available at both
                                              build and run-time. Known values are: "UNSET",
                                              "RUN_TIME", "BUILD_TIME", and "RUN_AND_BUILD_TIME".
                                            "type": "GENERAL",  #
                                              Optional. Default value is "GENERAL". * GENERAL: A
                                              plain-text environment variable"n* SECRET: A secret
                                              encrypted environment variable. Known values are:
                                              "GENERAL" and "SECRET".
                                            "value": "str"  # Optional.
                                              The value. If the type is ``SECRET``"" , the value will
                                              be encrypted on first submission. On following
                                              submissions, the encrypted value should be used.
                                        }
                                    ],
                                    "git": {
                                        "branch": "str",  # Optional. The
                                          name of the branch to use.
                                        "repo_clone_url": "str"  # Optional.
                                          The clone URL of the repo. Example:
                                          ``https://github.com/digitalocean/sample-golang.git``.
                                    },
                                    "github": {
                                        "branch": "str",  # Optional. The
                                          name of the branch to use.
                                        "deploy_on_push": bool,  # Optional.
                                          Whether to automatically deploy new commits made to the repo.
                                        "repo": "str"  # Optional. The name
                                          of the repo in the format owner/repo. Example:
                                          ``digitalocean/sample-golang``.
                                    },
                                    "gitlab": {
                                        "branch": "str",  # Optional. The
                                          name of the branch to use.
                                        "deploy_on_push": bool,  # Optional.
                                          Whether to automatically deploy new commits made to the repo.
                                        "repo": "str"  # Optional. The name
                                          of the repo in the format owner/repo. Example:
                                          ``digitalocean/sample-golang``.
                                    },
                                    "image": {
                                        "registry": "str",  # Optional. The
                                          registry name. Must be left empty for the ``DOCR`` registry
                                          type.
                                        "registry_type": "str",  # Optional.
                                          * DOCKER_HUB: The DockerHub container registry type."n* DOCR:
                                          The DigitalOcean container registry type. Known values are:
                                          "DOCKER_HUB" and "DOCR".
                                        "repository": "str",  # Optional. The
                                          repository name.
                                        "tag": "latest"  # Optional. Default
                                          value is "latest". The repository tag. Defaults to ``latest``
                                          if not provided.
                                    },
                                    "instance_count": 1,  # Optional. Default
                                      value is 1. The amount of instances that this component should be
                                      scaled to. Default: 1.
                                    "instance_size_slug": "basic-xxs",  #
                                      Optional. Default value is "basic-xxs". The instance size to use
                                      for this component. Default: ``basic-xxs``. Known values are:
                                      "basic-xxs", "basic-xs", "basic-s", "basic-m", "professional-xs",
                                      "professional-s", "professional-m", "professional-1l",
                                      "professional-l", and "professional-xl".
                                    "log_destinations": {
                                        "datadog": {
                                            "api_key": "str",  # Datadog
                                              API key. Required.
                                            "endpoint": "str"  #
                                              Optional. Datadog HTTP log intake endpoint.
                                        },
                                        "logtail": {
                                            "token": "str"  # Optional.
                                              Logtail token.
                                        },
                                        "name": "str",  # Required.
                                        "papertrail": {
                                            "endpoint": "str"  #
                                              Papertrail syslog endpoint. Required.
                                        }
                                    },
                                    "name": "str",  # Optional. The name. Must be
                                      unique across all components within the same app.
                                    "run_command": "str",  # Optional. An
                                      optional run command to override the component's default.
                                    "source_dir": "str"  # Optional. An optional
                                      path to the working directory to use for the build. For
                                      Dockerfile builds, this will be used as the build context. Must
                                      be relative to the root of the repo.
                                }
                            ]
                        },
                        "tier_slug": "str",  # Optional. The current pricing tier slug of the
                          app.
                        "updated_at": "2020-02-20 00:00:00"  # Optional. Time of the app's
                          last configuration update.
                    }
                }
                # response body for status code(s): 401, 429, 500
                response == {
                    "id": "str",  # A short identifier corresponding to the HTTP status code
                      returned. For  example, the ID for a response returning a 404 status code would
                      be "not_found.". Required.
                    "message": "str",  # A message providing additional information about the
                      error, including  details to help resolve it when possible. Required.
                    "request_id": "str"  # Optional. Optionally, some endpoints may include a
                      request ID that should be  provided when reporting bugs or opening support
                      tickets to help  identify the issue.
                }
        """

    @overload
    def create(
        self, body: IO, *, content_type: str = "application/json", **kwargs: Any
    ) -> JSON:
        """Create a New App.

        Create a new app by submitting an app specification. For documentation on app specifications (\
        ``AppSpec`` objects), please refer to `the product documentation
        <https://docs.digitalocean.com/products/app-platform/reference/app-spec/>`_.

        :param body: Required.
        :type body: IO
        :keyword content_type: Body Parameter content-type. Content type parameter for binary body.
         Default value is "application/json".
        :paramtype content_type: str
        :return: JSON object
        :rtype: JSON
        :raises ~azure.core.exceptions.HttpResponseError:

        Example:
            .. code-block:: python

                # response body for status code(s): 200
                response == {
                    "app": {
                        "active_deployment": {
                            "cause": "str",  # Optional. What caused this deployment to
                              be created.
                            "cloned_from": "str",  # Optional. The ID of a previous
                              deployment that this deployment was cloned from.
                            "created_at": "2020-02-20 00:00:00",  # Optional. The
                              creation time of the deployment.
                            "functions": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      functions component.
                                    "namespace": "str",  # Optional. The
                                      namespace where the functions are deployed.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this
                                      functions component.
                                }
                            ],
                            "id": "str",  # Optional. The ID of the deployment.
                            "jobs": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      job.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this job.
                                }
                            ],
                            "phase": "UNKNOWN",  # Optional. Default value is "UNKNOWN".
                              Known values are: "UNKNOWN", "PENDING_BUILD", "BUILDING",
                              "PENDING_DEPLOY", "DEPLOYING", "ACTIVE", "SUPERSEDED", "ERROR", and
                              "CANCELED".
                            "phase_last_updated_at": "2020-02-20 00:00:00",  # Optional.
                              When the deployment phase was last updated.
                            "progress": {
                                "error_steps": 0,  # Optional. Number of unsuccessful
                                  steps.
                                "pending_steps": 0,  # Optional. Number of pending
                                  steps.
                                "running_steps": 0,  # Optional. Number of currently
                                  running steps.
                                "steps": [
                                    {
                                        "component_name": "str",  # Optional.
                                          The component name that this step is associated with.
                                        "ended_at": "2020-02-20 00:00:00",  #
                                          Optional. The end time of this step.
                                        "message_base": "str",  # Optional.
                                          The base of a human-readable description of the step intended
                                          to be combined with the component name for presentation. For
                                          example:"n"n``message_base`` = "Building
                                          service""n``component_name`` = "api".
                                        "name": "str",  # Optional. The name
                                          of this step.
                                        "reason": {
                                            "code": "str",  # Optional.
                                              The error code.
                                            "message": "str"  # Optional.
                                              The error message.
                                        },
                                        "started_at": "2020-02-20 00:00:00",
                                          # Optional. The start time of this step.
                                        "status": "UNKNOWN",  # Optional.
                                          Default value is "UNKNOWN". Known values are: "UNKNOWN",
                                          "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                        "steps": [
                                            {}  # Optional. Child steps
                                              of this step.
                                        ]
                                    }
                                ],
                                "success_steps": 0,  # Optional. Number of successful
                                  steps.
                                "summary_steps": [
                                    {
                                        "component_name": "str",  # Optional.
                                          The component name that this step is associated with.
                                        "ended_at": "2020-02-20 00:00:00",  #
                                          Optional. The end time of this step.
                                        "message_base": "str",  # Optional.
                                          The base of a human-readable description of the step intended
                                          to be combined with the component name for presentation. For
                                          example:"n"n``message_base`` = "Building
                                          service""n``component_name`` = "api".
                                        "name": "str",  # Optional. The name
                                          of this step.
                                        "reason": {
                                            "code": "str",  # Optional.
                                              The error code.
                                            "message": "str"  # Optional.
                                              The error message.
                                        },
                                        "started_at": "2020-02-20 00:00:00",
                                          # Optional. The start time of this step.
                                        "status": "UNKNOWN",  # Optional.
                                          Default value is "UNKNOWN". Known values are: "UNKNOWN",
                                          "PENDING", "RUNNING", "ERROR", and "SUCCESS".
                                        "steps": [
                                            {}  # Optional. Child steps
                                              of this step.
                                        ]
                                    }
                                ],
                                "total_steps": 0  # Optional. Total number of steps.
                            },
                            "services": [
                                {
                                    "name": "str",  # Optional. The name of this
                                      service.
                                    "source_commit_hash": "str"  # Optional. The
                                      commit hash of the repository that was used to build this
                                      service.
                                }
                            ],
                            "spec": {
                                "databases": [
                                    {
                                        "cluster_name": "str",  # Optional.
                                          The name of the underlying DigitalOcean DBaaS cluster. This
                                          is required for production databases. For dev databases, if
                                          cluster_name is not set, a new cluster will be provisioned.
                                        "db_name": "str",  # Optional. The
                                          name of the MySQL or PostgreSQL database to configure.
                                        "db_user": "str",  # Optional. The
                                          name of the MySQL or PostgreSQL user to configure.
                                        "engine": "UNSET",  # Optional.
                                          Default value is "UNSET". * MYSQL: MySQL"n* PG: PostgreSQL"n*
                                          REDIS: Redis. Known values are: "UNSET", "MYSQL", "PG", and
                                          "REDIS".
                                        "name": "str",  # The name. Must be
                                          unique across all components within the same app. Required.
                                        "production": bool,  # Optional.
                                          Whether this is a production or dev database.
                                        "version": "str"  # Optional. The
                                          version of the database engine.
                                    }
                                ],
                                "domains": [
                                    {
                                        "domain": "str",  # The hostname for
                                          the domain. Required.
                                        "minimum_tls_version": "str",  #
                                          Optional. The minimum version of TLS a client application can
                                          use to access resources for the domain.  Must be one of the
                                          following values wrapped within quotations: ``"1.2"`` or
                                          ``"1.3"``. Known values are: "1.2" and "1.3".
                                        "type": "UNSPECIFIED",  # Optional.
                                          Default value is "UNSPECIFIED". * DEFAULT: The default
                                          ``.ondigitalocean.app`` domain assigned to this app"n*
                                          PRIMARY: The primary domain for this app that is displayed as
                                          the default in the control panel, used in bindable
                                          environment variables, and any other places that reference an
                                          app's live URL. Only one domain may be set as primary."n*
                                          ALIAS: A non-primary domain. Known values are: "UNSPECIFIED",
                                          "DEFAULT", "PRIMARY", and "ALIAS".
                                        "wildcard": bool,  # Optional.
                                          Indicates whether the domain includes all sub-domains, in
                                          addition to the given domain.
                                        "zone": "str"  # Optional. Optional.
                                          If the domain uses DigitalOcean DNS and you would like
                                          App"nPlatform to automatically manage it for you, set this to
                                          the name of the"ndomain on your account."n"nFor example, If
                                          the domain you are adding is ``app.domain.com``"" , the
                                          zone"ncould be ``domain.com``.
                                    }
                                ],
                                "functions": [
                                    {
                                        "alerts": [
                                            {
                                                "disabled": bool,  #
                                                  Optional. Is the alert disabled?.
                                                "operator":
                                                  "UNSPECIFIED_OPERATOR",  # Optional. Default value is
                                                  "UNSPECIFIED_OPERATOR". Known values are:
                                                  "UNSPECIFIED_OPERATOR", "GREATER_THAN", and
                                                  "LESS_THAN".
                                                "rule":
                                                  "UNSPECIFIED_RULE",  # Optional. Default value is
                                                  "UNSPECIFIED_RULE". Known values are:
                                                  "UNSPECIFIED_RULE", "CPU_UTILIZATION",
                                                  "MEM_UTILIZATION", "RESTART_COUNT",
                                                  "DEPLOYMENT_FAILED", "DEPLOYMENT_LIVE",
                                                  "DOMAIN_FAILED", "DOMAIN_LIVE",
                                                  "FUNCTIONS_ACTIVATION_COUNT",
                                                  "FUNCTIONS_AVERAGE_DURATION_MS",
                                                  "FUNCTIONS_ERROR_RATE_PER_MINUTE",
                                                  "FUNCTIONS_AVERAGE_WAIT_TIME_MS",
                                                  "FUNCTIONS_ERROR_COUNT", and
                                                  "FUNCTIONS_GB_RATE_PER_SECOND".
                                                "value": 0.0,  #
                                                  Optional. Threshold value for alert.
                                                "window":
                                                  "UNSPECIFIED_WINDOW"  # Optional. Default value is
                                                  "UNSPECIFIED_WINDOW". Known values are:
                                                  "UNSPECIFIED_WINDOW", "FIVE_MINUTES", "TEN_MINUTES",
                                                  "THIRTY_MINUTES", and "ONE_HOUR".
                                            }
                                        ],
                                        "cors": {
                                            "allow_credentials": bool,  #
                                              Optional. Whether browsers should expose the response to
                                              the client-side JavaScript code when the request"u2019s
                                              credentials mode is include. This configures the
                                              ``Access-Control-Allow-Credentials`` header.
                                            "allow_headers": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP request headers. This
                                                  configures the ``Access-Control-Allow-Headers``
                                                  header.
                                            ],
                                            "allow_methods": [
                                                "str"  # Optional.
                                                  The set of allowed HTTP methods. This configures the
                                                  ``Access-Control-Allow-Methods`` header.
                                            ],
                                            "allow_origins": [
                                                {
                                                    "exact":
                                                      "str",  # Optional. Exact string match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "prefix":
                                                      "str",  # Optional. Prefix-based match. Only 1 of
                                                      ``exact``"" , ``prefix``"" , or ``regex`` must be
                                                      set.
                                                    "regex":
                                                      "str"  # Optional. RE2 style regex-based match.
                                                      Only 1 of ``exact``"" , ``prefix``"" , or
                                                      ``regex`` must be set. For more information about
                                                      RE2 syntax, see:
                                                      https://github.com/google/re2/wiki/Syntax.
                                                }
                                            