#!/usr/bin/env python3
# --------------------( LICENSE                           )--------------------
# Copyright (c) 2014-2020 Cecil Curry.
# See "LICENSE" for further details.

'''
**Beartype callable utilities.**

This private submodule implements supplementary callable-specific utility
functions required by various :mod:`beartype` facilities, including callables
generated by the :func:`beartype.beartype` decorator.

This private submodule is *not* intended for importation by downstream callers.
'''

# ....................{ IMPORTS                            }....................
from collections.abc import Callable

# ....................{ CONSTANTS                          }....................
MODULE_NAME_BUILTINS = 'builtins'
'''
Fully-qualified name of the module declaring all **builtins** (i.e., objects
defined by the standard :mod:`builtins` module and thus globally available by
default *without* requiring explicit importation).
'''


SENTINEL = object()
'''
Sentinel object of arbitrary value.

This object is internally leveraged by various utility functions to identify
erroneous and edge-case input (e.g., iterables of insufficient length).
'''

# ....................{ GETTERS                           }....................
#FIXME: Implement us up.
#FIXME: Unit test us up.
def get_callable_filename_or_placeholder(func: Callable) -> str:
    '''
    Absolute filename of the uncompiled Python script or module physically
    declaring the passed callable if any *or* the placeholder string
    ``"<string>"`` implying this callable to have been dynamically declared
    in-memory otherwise.

    Parameters
    ----------
    func : Callable
        Callable to be inspected.

    Returns
    ----------
    str
        Either:

        * If this callable is physically declared by an uncompiled Python
          script or module, the absolute filename of this script or module.
        * Else, the placeholder string ``"<string>"`` implying this callable to
          have been dynamically declared in-memory.

    See Also
    ----------
    :func:`inspect.getsourcefile`
        Inefficient stdlib function strongly inspiring this implementation,
        which has been highly optimized for use by the performance-sensitive
        :func:`beartype.beartype` decorator.
    '''

    pass
