#!/usr/bin/env python3
# --------------------( LICENSE                           )--------------------
# Copyright 2014-2020 by Cecil Curry.
# See "LICENSE" for further details.

'''
**:mod:`pytest` test-marking decorators.**

This submodule provides decorators *not* conditionally marking their decorated
tests as either failed, parametrized, or skipped.
'''

# ....................{ IMPORTS                           }....................
#!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# WARNING: To raise human-readable test errors, avoid importing from
# package-specific submodules at module scope.
#!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

import pytest

# ....................{ MARKS                             }....................
noop = pytest.mark.noop
'''
Preserve the decorated test or test parameter as is with *no* modification.

Caveats
----------
This decorator has the unintended side effect of also marking all tests and
test parameters decorated by this decorated with the ``noop`` tag. This
harmless albeit unfortunate side effect is the result of the :mod:`pytest.mark`
API, which strictly requires that *all* decorators passed to the ``marks``
parameter of the :mod:`pytest.param` function be strictly generated by the
:mod:`pytest.mark` API, which then imposes this seemingly arbitrary constraint.

In other words, there's absolutely nothing to see here, folks.
'''
