# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class ActiveBaseSecurityAdminRule(_serialization.Model):
    """Network base admin rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ActiveSecurityAdminRule, ActiveDefaultSecurityAdminRule

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar commit_time: Deployment time string.
    :vartype commit_time: ~datetime.datetime
    :ivar region: Deployment region.
    :vartype region: str
    :ivar configuration_display_name: A display name of the security admin configuration.
    :vartype configuration_display_name: str
    :ivar configuration_description: A description of the security admin configuration.
    :vartype configuration_description: str
    :ivar rule_collection_display_name: A display name of the rule collection.
    :vartype rule_collection_display_name: str
    :ivar rule_collection_description: A description of the rule collection.
    :vartype rule_collection_description: str
    :ivar rule_collection_applies_to_groups: Groups for rule collection.
    :vartype rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :ivar rule_groups: Effective configuration groups.
    :vartype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveAdminRuleKind
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "commit_time": {"key": "commitTime", "type": "iso-8601"},
        "region": {"key": "region", "type": "str"},
        "configuration_display_name": {"key": "configurationDisplayName", "type": "str"},
        "configuration_description": {"key": "configurationDescription", "type": "str"},
        "rule_collection_display_name": {"key": "ruleCollectionDisplayName", "type": "str"},
        "rule_collection_description": {"key": "ruleCollectionDescription", "type": "str"},
        "rule_collection_applies_to_groups": {
            "key": "ruleCollectionAppliesToGroups",
            "type": "[NetworkManagerSecurityGroupItem]",
        },
        "rule_groups": {"key": "ruleGroups", "type": "[ConfigurationGroup]"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"Custom": "ActiveSecurityAdminRule", "Default": "ActiveDefaultSecurityAdminRule"}}

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["_models.NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["_models.ConfigurationGroup"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword commit_time: Deployment time string.
        :paramtype commit_time: ~datetime.datetime
        :keyword region: Deployment region.
        :paramtype region: str
        :keyword configuration_display_name: A display name of the security admin configuration.
        :paramtype configuration_display_name: str
        :keyword configuration_description: A description of the security admin configuration.
        :paramtype configuration_description: str
        :keyword rule_collection_display_name: A display name of the rule collection.
        :paramtype rule_collection_display_name: str
        :keyword rule_collection_description: A description of the rule collection.
        :paramtype rule_collection_description: str
        :keyword rule_collection_applies_to_groups: Groups for rule collection.
        :paramtype rule_collection_applies_to_groups:
         list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
        :keyword rule_groups: Effective configuration groups.
        :paramtype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
        """
        super().__init__(**kwargs)
        self.id = id
        self.commit_time = commit_time
        self.region = region
        self.configuration_display_name = configuration_display_name
        self.configuration_description = configuration_description
        self.rule_collection_display_name = rule_collection_display_name
        self.rule_collection_description = rule_collection_description
        self.rule_collection_applies_to_groups = rule_collection_applies_to_groups
        self.rule_groups = rule_groups
        self.kind = None  # type: Optional[str]


class ActiveBaseSecurityUserRule(_serialization.Model):
    """Network base rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    ActiveSecurityUserRule, ActiveDefaultSecurityUserRule

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar commit_time: Deployment time string.
    :vartype commit_time: ~datetime.datetime
    :ivar region: Deployment region.
    :vartype region: str
    :ivar configuration_display_name: A display name of the security user configuration.
    :vartype configuration_display_name: str
    :ivar configuration_description: A description of the security user configuration.
    :vartype configuration_description: str
    :ivar rule_collection_display_name: A display name of the rule collection.
    :vartype rule_collection_display_name: str
    :ivar rule_collection_description: A description of the rule collection.
    :vartype rule_collection_description: str
    :ivar rule_collection_applies_to_groups: Groups for rule collection.
    :vartype rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :ivar rule_groups: Effective configuration groups.
    :vartype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveUserRuleKind
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "commit_time": {"key": "commitTime", "type": "iso-8601"},
        "region": {"key": "region", "type": "str"},
        "configuration_display_name": {"key": "configurationDisplayName", "type": "str"},
        "configuration_description": {"key": "configurationDescription", "type": "str"},
        "rule_collection_display_name": {"key": "ruleCollectionDisplayName", "type": "str"},
        "rule_collection_description": {"key": "ruleCollectionDescription", "type": "str"},
        "rule_collection_applies_to_groups": {
            "key": "ruleCollectionAppliesToGroups",
            "type": "[NetworkManagerSecurityGroupItem]",
        },
        "rule_groups": {"key": "ruleGroups", "type": "[ConfigurationGroup]"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"Custom": "ActiveSecurityUserRule", "Default": "ActiveDefaultSecurityUserRule"}}

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["_models.NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["_models.ConfigurationGroup"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword commit_time: Deployment time string.
        :paramtype commit_time: ~datetime.datetime
        :keyword region: Deployment region.
        :paramtype region: str
        :keyword configuration_display_name: A display name of the security user configuration.
        :paramtype configuration_display_name: str
        :keyword configuration_description: A description of the security user configuration.
        :paramtype configuration_description: str
        :keyword rule_collection_display_name: A display name of the rule collection.
        :paramtype rule_collection_display_name: str
        :keyword rule_collection_description: A description of the rule collection.
        :paramtype rule_collection_description: str
        :keyword rule_collection_applies_to_groups: Groups for rule collection.
        :paramtype rule_collection_applies_to_groups:
         list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
        :keyword rule_groups: Effective configuration groups.
        :paramtype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
        """
        super().__init__(**kwargs)
        self.id = id
        self.commit_time = commit_time
        self.region = region
        self.configuration_display_name = configuration_display_name
        self.configuration_description = configuration_description
        self.rule_collection_display_name = rule_collection_display_name
        self.rule_collection_description = rule_collection_description
        self.rule_collection_applies_to_groups = rule_collection_applies_to_groups
        self.rule_groups = rule_groups
        self.kind = None  # type: Optional[str]


class ActiveConfigurationParameter(_serialization.Model):
    """Effective Virtual Networks Parameter.

    :ivar regions: List of regions.
    :vartype regions: list[str]
    :ivar skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :vartype skip_token: str
    """

    _attribute_map = {
        "regions": {"key": "regions", "type": "[str]"},
        "skip_token": {"key": "skipToken", "type": "str"},
    }

    def __init__(self, *, regions: Optional[List[str]] = None, skip_token: Optional[str] = None, **kwargs):
        """
        :keyword regions: List of regions.
        :paramtype regions: list[str]
        :keyword skip_token: When present, the value can be passed to a subsequent query call (together
         with the same query and scopes used in the current request) to retrieve the next page of data.
        :paramtype skip_token: str
        """
        super().__init__(**kwargs)
        self.regions = regions
        self.skip_token = skip_token


class EffectiveConnectivityConfiguration(_serialization.Model):
    """The network manager effective connectivity configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar configuration_groups: Effective configuration groups.
    :vartype configuration_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :ivar display_name: A friendly name for the resource.
    :vartype display_name: str
    :ivar description: A description of the connectivity configuration.
    :vartype description: str
    :ivar connectivity_topology: Connectivity topology type. Known values are: "HubAndSpoke" and
     "Mesh".
    :vartype connectivity_topology: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityTopology
    :ivar hubs: List of hubItems.
    :vartype hubs: list[~azure.mgmt.network.v2021_02_01_preview.models.Hub]
    :ivar is_global: Flag if global mesh is supported. Known values are: "False" and "True".
    :vartype is_global: str or ~azure.mgmt.network.v2021_02_01_preview.models.IsGlobal
    :ivar applies_to_groups: Groups for configuration.
    :vartype applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityGroupItem]
    :ivar provisioning_state: The provisioning state of the connectivity configuration resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    :ivar delete_existing_peering: Flag if need to remove current existing peerings. Known values
     are: "False" and "True".
    :vartype delete_existing_peering: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.DeleteExistingPeering
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "configuration_groups": {"key": "configurationGroups", "type": "[ConfigurationGroup]"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "connectivity_topology": {"key": "properties.connectivityTopology", "type": "str"},
        "hubs": {"key": "properties.hubs", "type": "[Hub]"},
        "is_global": {"key": "properties.isGlobal", "type": "str"},
        "applies_to_groups": {"key": "properties.appliesToGroups", "type": "[ConnectivityGroupItem]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "delete_existing_peering": {"key": "properties.deleteExistingPeering", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        configuration_groups: Optional[List["_models.ConfigurationGroup"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        connectivity_topology: Optional[Union[str, "_models.ConnectivityTopology"]] = None,
        hubs: Optional[List["_models.Hub"]] = None,
        is_global: Optional[Union[str, "_models.IsGlobal"]] = None,
        applies_to_groups: Optional[List["_models.ConnectivityGroupItem"]] = None,
        delete_existing_peering: Optional[Union[str, "_models.DeleteExistingPeering"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword configuration_groups: Effective configuration groups.
        :paramtype configuration_groups:
         list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
        :keyword display_name: A friendly name for the resource.
        :paramtype display_name: str
        :keyword description: A description of the connectivity configuration.
        :paramtype description: str
        :keyword connectivity_topology: Connectivity topology type. Known values are: "HubAndSpoke" and
         "Mesh".
        :paramtype connectivity_topology: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityTopology
        :keyword hubs: List of hubItems.
        :paramtype hubs: list[~azure.mgmt.network.v2021_02_01_preview.models.Hub]
        :keyword is_global: Flag if global mesh is supported. Known values are: "False" and "True".
        :paramtype is_global: str or ~azure.mgmt.network.v2021_02_01_preview.models.IsGlobal
        :keyword applies_to_groups: Groups for configuration.
        :paramtype applies_to_groups:
         list[~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityGroupItem]
        :keyword delete_existing_peering: Flag if need to remove current existing peerings. Known
         values are: "False" and "True".
        :paramtype delete_existing_peering: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.DeleteExistingPeering
        """
        super().__init__(**kwargs)
        self.id = id
        self.configuration_groups = configuration_groups
        self.display_name = display_name
        self.description = description
        self.connectivity_topology = connectivity_topology
        self.hubs = hubs
        self.is_global = is_global
        self.applies_to_groups = applies_to_groups
        self.provisioning_state = None
        self.delete_existing_peering = delete_existing_peering


class ActiveConnectivityConfiguration(
    EffectiveConnectivityConfiguration
):  # pylint: disable=too-many-instance-attributes
    """Active connectivity configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar configuration_groups: Effective configuration groups.
    :vartype configuration_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :ivar display_name: A friendly name for the resource.
    :vartype display_name: str
    :ivar description: A description of the connectivity configuration.
    :vartype description: str
    :ivar connectivity_topology: Connectivity topology type. Known values are: "HubAndSpoke" and
     "Mesh".
    :vartype connectivity_topology: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityTopology
    :ivar hubs: List of hubItems.
    :vartype hubs: list[~azure.mgmt.network.v2021_02_01_preview.models.Hub]
    :ivar is_global: Flag if global mesh is supported. Known values are: "False" and "True".
    :vartype is_global: str or ~azure.mgmt.network.v2021_02_01_preview.models.IsGlobal
    :ivar applies_to_groups: Groups for configuration.
    :vartype applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityGroupItem]
    :ivar provisioning_state: The provisioning state of the connectivity configuration resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    :ivar delete_existing_peering: Flag if need to remove current existing peerings. Known values
     are: "False" and "True".
    :vartype delete_existing_peering: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.DeleteExistingPeering
    :ivar commit_time: Deployment time string.
    :vartype commit_time: ~datetime.datetime
    :ivar region: Deployment region.
    :vartype region: str
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "configuration_groups": {"key": "configurationGroups", "type": "[ConfigurationGroup]"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "connectivity_topology": {"key": "properties.connectivityTopology", "type": "str"},
        "hubs": {"key": "properties.hubs", "type": "[Hub]"},
        "is_global": {"key": "properties.isGlobal", "type": "str"},
        "applies_to_groups": {"key": "properties.appliesToGroups", "type": "[ConnectivityGroupItem]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "delete_existing_peering": {"key": "properties.deleteExistingPeering", "type": "str"},
        "commit_time": {"key": "commitTime", "type": "iso-8601"},
        "region": {"key": "region", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        configuration_groups: Optional[List["_models.ConfigurationGroup"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        connectivity_topology: Optional[Union[str, "_models.ConnectivityTopology"]] = None,
        hubs: Optional[List["_models.Hub"]] = None,
        is_global: Optional[Union[str, "_models.IsGlobal"]] = None,
        applies_to_groups: Optional[List["_models.ConnectivityGroupItem"]] = None,
        delete_existing_peering: Optional[Union[str, "_models.DeleteExistingPeering"]] = None,
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword configuration_groups: Effective configuration groups.
        :paramtype configuration_groups:
         list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
        :keyword display_name: A friendly name for the resource.
        :paramtype display_name: str
        :keyword description: A description of the connectivity configuration.
        :paramtype description: str
        :keyword connectivity_topology: Connectivity topology type. Known values are: "HubAndSpoke" and
         "Mesh".
        :paramtype connectivity_topology: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityTopology
        :keyword hubs: List of hubItems.
        :paramtype hubs: list[~azure.mgmt.network.v2021_02_01_preview.models.Hub]
        :keyword is_global: Flag if global mesh is supported. Known values are: "False" and "True".
        :paramtype is_global: str or ~azure.mgmt.network.v2021_02_01_preview.models.IsGlobal
        :keyword applies_to_groups: Groups for configuration.
        :paramtype applies_to_groups:
         list[~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityGroupItem]
        :keyword delete_existing_peering: Flag if need to remove current existing peerings. Known
         values are: "False" and "True".
        :paramtype delete_existing_peering: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.DeleteExistingPeering
        :keyword commit_time: Deployment time string.
        :paramtype commit_time: ~datetime.datetime
        :keyword region: Deployment region.
        :paramtype region: str
        """
        super().__init__(
            id=id,
            configuration_groups=configuration_groups,
            display_name=display_name,
            description=description,
            connectivity_topology=connectivity_topology,
            hubs=hubs,
            is_global=is_global,
            applies_to_groups=applies_to_groups,
            delete_existing_peering=delete_existing_peering,
            **kwargs
        )
        self.commit_time = commit_time
        self.region = region


class ActiveConnectivityConfigurationsListResult(_serialization.Model):
    """Result of the request to list active connectivity configurations. It contains a list of active connectivity configurations and a skiptoken to get the next set of results.

    :ivar value: Gets a page of active connectivity configurations.
    :vartype value:
     list[~azure.mgmt.network.v2021_02_01_preview.models.ActiveConnectivityConfiguration]
    :ivar skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :vartype skip_token: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ActiveConnectivityConfiguration]"},
        "skip_token": {"key": "skipToken", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ActiveConnectivityConfiguration"]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Gets a page of active connectivity configurations.
        :paramtype value:
         list[~azure.mgmt.network.v2021_02_01_preview.models.ActiveConnectivityConfiguration]
        :keyword skip_token: When present, the value can be passed to a subsequent query call (together
         with the same query and scopes used in the current request) to retrieve the next page of data.
        :paramtype skip_token: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class ActiveDefaultSecurityAdminRule(ActiveBaseSecurityAdminRule):  # pylint: disable=too-many-instance-attributes
    """Network default admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar commit_time: Deployment time string.
    :vartype commit_time: ~datetime.datetime
    :ivar region: Deployment region.
    :vartype region: str
    :ivar configuration_display_name: A display name of the security admin configuration.
    :vartype configuration_display_name: str
    :ivar configuration_description: A description of the security admin configuration.
    :vartype configuration_description: str
    :ivar rule_collection_display_name: A display name of the rule collection.
    :vartype rule_collection_display_name: str
    :ivar rule_collection_description: A description of the rule collection.
    :vartype rule_collection_description: str
    :ivar rule_collection_applies_to_groups: Groups for rule collection.
    :vartype rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :ivar rule_groups: Effective configuration groups.
    :vartype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveAdminRuleKind
    :ivar display_name: A friendly name for the rule.
    :vartype display_name: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar flag: Default rule flag.
    :vartype flag: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "Any", and "Ah".
    :vartype protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: Indicates the access allowed for this particular rule. Known values are: "Allow",
     "Deny", and "AlwaysAllow".
    :vartype access: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleAccess
    :ivar priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Known values are: "Inbound" and "Outbound".
    :vartype direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        "kind": {"required": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "protocol": {"readonly": True},
        "sources": {"readonly": True},
        "destinations": {"readonly": True},
        "source_port_ranges": {"readonly": True},
        "destination_port_ranges": {"readonly": True},
        "access": {"readonly": True},
        "priority": {"readonly": True},
        "direction": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "commit_time": {"key": "commitTime", "type": "iso-8601"},
        "region": {"key": "region", "type": "str"},
        "configuration_display_name": {"key": "configurationDisplayName", "type": "str"},
        "configuration_description": {"key": "configurationDescription", "type": "str"},
        "rule_collection_display_name": {"key": "ruleCollectionDisplayName", "type": "str"},
        "rule_collection_description": {"key": "ruleCollectionDescription", "type": "str"},
        "rule_collection_applies_to_groups": {
            "key": "ruleCollectionAppliesToGroups",
            "type": "[NetworkManagerSecurityGroupItem]",
        },
        "rule_groups": {"key": "ruleGroups", "type": "[ConfigurationGroup]"},
        "kind": {"key": "kind", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "flag": {"key": "properties.flag", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "sources": {"key": "properties.sources", "type": "[AddressPrefixItem]"},
        "destinations": {"key": "properties.destinations", "type": "[AddressPrefixItem]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "access": {"key": "properties.access", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["_models.NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["_models.ConfigurationGroup"]] = None,
        flag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword commit_time: Deployment time string.
        :paramtype commit_time: ~datetime.datetime
        :keyword region: Deployment region.
        :paramtype region: str
        :keyword configuration_display_name: A display name of the security admin configuration.
        :paramtype configuration_display_name: str
        :keyword configuration_description: A description of the security admin configuration.
        :paramtype configuration_description: str
        :keyword rule_collection_display_name: A display name of the rule collection.
        :paramtype rule_collection_display_name: str
        :keyword rule_collection_description: A description of the rule collection.
        :paramtype rule_collection_description: str
        :keyword rule_collection_applies_to_groups: Groups for rule collection.
        :paramtype rule_collection_applies_to_groups:
         list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
        :keyword rule_groups: Effective configuration groups.
        :paramtype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
        :keyword flag: Default rule flag.
        :paramtype flag: str
        """
        super().__init__(
            id=id,
            commit_time=commit_time,
            region=region,
            configuration_display_name=configuration_display_name,
            configuration_description=configuration_description,
            rule_collection_display_name=rule_collection_display_name,
            rule_collection_description=rule_collection_description,
            rule_collection_applies_to_groups=rule_collection_applies_to_groups,
            rule_groups=rule_groups,
            **kwargs
        )
        self.kind = "Default"  # type: str
        self.display_name = None
        self.description = None
        self.flag = flag
        self.protocol = None
        self.sources = None
        self.destinations = None
        self.source_port_ranges = None
        self.destination_port_ranges = None
        self.access = None
        self.priority = None
        self.direction = None
        self.provisioning_state = None


class ActiveDefaultSecurityUserRule(ActiveBaseSecurityUserRule):  # pylint: disable=too-many-instance-attributes
    """Network security default user rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar commit_time: Deployment time string.
    :vartype commit_time: ~datetime.datetime
    :ivar region: Deployment region.
    :vartype region: str
    :ivar configuration_display_name: A display name of the security user configuration.
    :vartype configuration_display_name: str
    :ivar configuration_description: A description of the security user configuration.
    :vartype configuration_description: str
    :ivar rule_collection_display_name: A display name of the rule collection.
    :vartype rule_collection_display_name: str
    :ivar rule_collection_description: A description of the rule collection.
    :vartype rule_collection_description: str
    :ivar rule_collection_applies_to_groups: Groups for rule collection.
    :vartype rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :ivar rule_groups: Effective configuration groups.
    :vartype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveUserRuleKind
    :ivar display_name: A friendly name for the rule.
    :vartype display_name: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar flag: Default rule flag.
    :vartype flag: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "Any", and "Ah".
    :vartype protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Known values are: "Inbound" and "Outbound".
    :vartype direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the security configuration user rule
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        "kind": {"required": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "protocol": {"readonly": True},
        "sources": {"readonly": True},
        "destinations": {"readonly": True},
        "source_port_ranges": {"readonly": True},
        "destination_port_ranges": {"readonly": True},
        "direction": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "commit_time": {"key": "commitTime", "type": "iso-8601"},
        "region": {"key": "region", "type": "str"},
        "configuration_display_name": {"key": "configurationDisplayName", "type": "str"},
        "configuration_description": {"key": "configurationDescription", "type": "str"},
        "rule_collection_display_name": {"key": "ruleCollectionDisplayName", "type": "str"},
        "rule_collection_description": {"key": "ruleCollectionDescription", "type": "str"},
        "rule_collection_applies_to_groups": {
            "key": "ruleCollectionAppliesToGroups",
            "type": "[NetworkManagerSecurityGroupItem]",
        },
        "rule_groups": {"key": "ruleGroups", "type": "[ConfigurationGroup]"},
        "kind": {"key": "kind", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "flag": {"key": "properties.flag", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "sources": {"key": "properties.sources", "type": "[AddressPrefixItem]"},
        "destinations": {"key": "properties.destinations", "type": "[AddressPrefixItem]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["_models.NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["_models.ConfigurationGroup"]] = None,
        flag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword commit_time: Deployment time string.
        :paramtype commit_time: ~datetime.datetime
        :keyword region: Deployment region.
        :paramtype region: str
        :keyword configuration_display_name: A display name of the security user configuration.
        :paramtype configuration_display_name: str
        :keyword configuration_description: A description of the security user configuration.
        :paramtype configuration_description: str
        :keyword rule_collection_display_name: A display name of the rule collection.
        :paramtype rule_collection_display_name: str
        :keyword rule_collection_description: A description of the rule collection.
        :paramtype rule_collection_description: str
        :keyword rule_collection_applies_to_groups: Groups for rule collection.
        :paramtype rule_collection_applies_to_groups:
         list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
        :keyword rule_groups: Effective configuration groups.
        :paramtype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
        :keyword flag: Default rule flag.
        :paramtype flag: str
        """
        super().__init__(
            id=id,
            commit_time=commit_time,
            region=region,
            configuration_display_name=configuration_display_name,
            configuration_description=configuration_description,
            rule_collection_display_name=rule_collection_display_name,
            rule_collection_description=rule_collection_description,
            rule_collection_applies_to_groups=rule_collection_applies_to_groups,
            rule_groups=rule_groups,
            **kwargs
        )
        self.kind = "Default"  # type: str
        self.display_name = None
        self.description = None
        self.flag = flag
        self.protocol = None
        self.sources = None
        self.destinations = None
        self.source_port_ranges = None
        self.destination_port_ranges = None
        self.direction = None
        self.provisioning_state = None


class ActiveSecurityAdminRule(ActiveBaseSecurityAdminRule):  # pylint: disable=too-many-instance-attributes
    """Network admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar commit_time: Deployment time string.
    :vartype commit_time: ~datetime.datetime
    :ivar region: Deployment region.
    :vartype region: str
    :ivar configuration_display_name: A display name of the security admin configuration.
    :vartype configuration_display_name: str
    :ivar configuration_description: A description of the security admin configuration.
    :vartype configuration_description: str
    :ivar rule_collection_display_name: A display name of the rule collection.
    :vartype rule_collection_display_name: str
    :ivar rule_collection_description: A description of the rule collection.
    :vartype rule_collection_description: str
    :ivar rule_collection_applies_to_groups: Groups for rule collection.
    :vartype rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :ivar rule_groups: Effective configuration groups.
    :vartype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveAdminRuleKind
    :ivar display_name: A friendly name for the rule.
    :vartype display_name: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "Any", and "Ah".
    :vartype protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: Indicates the access allowed for this particular rule. Known values are: "Allow",
     "Deny", and "AlwaysAllow".
    :vartype access: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleAccess
    :ivar priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Known values are: "Inbound" and "Outbound".
    :vartype direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        "kind": {"required": True},
        "priority": {"maximum": 4096, "minimum": 1},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "commit_time": {"key": "commitTime", "type": "iso-8601"},
        "region": {"key": "region", "type": "str"},
        "configuration_display_name": {"key": "configurationDisplayName", "type": "str"},
        "configuration_description": {"key": "configurationDescription", "type": "str"},
        "rule_collection_display_name": {"key": "ruleCollectionDisplayName", "type": "str"},
        "rule_collection_description": {"key": "ruleCollectionDescription", "type": "str"},
        "rule_collection_applies_to_groups": {
            "key": "ruleCollectionAppliesToGroups",
            "type": "[NetworkManagerSecurityGroupItem]",
        },
        "rule_groups": {"key": "ruleGroups", "type": "[ConfigurationGroup]"},
        "kind": {"key": "kind", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "sources": {"key": "properties.sources", "type": "[AddressPrefixItem]"},
        "destinations": {"key": "properties.destinations", "type": "[AddressPrefixItem]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "access": {"key": "properties.access", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["_models.NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["_models.ConfigurationGroup"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "_models.SecurityConfigurationRuleProtocol"]] = None,
        sources: Optional[List["_models.AddressPrefixItem"]] = None,
        destinations: Optional[List["_models.AddressPrefixItem"]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        access: Optional[Union[str, "_models.SecurityConfigurationRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "_models.SecurityConfigurationRuleDirection"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword commit_time: Deployment time string.
        :paramtype commit_time: ~datetime.datetime
        :keyword region: Deployment region.
        :paramtype region: str
        :keyword configuration_display_name: A display name of the security admin configuration.
        :paramtype configuration_display_name: str
        :keyword configuration_description: A description of the security admin configuration.
        :paramtype configuration_description: str
        :keyword rule_collection_display_name: A display name of the rule collection.
        :paramtype rule_collection_display_name: str
        :keyword rule_collection_description: A description of the rule collection.
        :paramtype rule_collection_description: str
        :keyword rule_collection_applies_to_groups: Groups for rule collection.
        :paramtype rule_collection_applies_to_groups:
         list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
        :keyword rule_groups: Effective configuration groups.
        :paramtype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
        :keyword display_name: A friendly name for the rule.
        :paramtype display_name: str
        :keyword description: A description for this rule. Restricted to 140 chars.
        :paramtype description: str
        :keyword protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp",
         "Icmp", "Esp", "Any", and "Ah".
        :paramtype protocol: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
        :keyword sources: The CIDR or source IP ranges.
        :paramtype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
        :keyword destinations: The destination address prefixes. CIDR or destination IP ranges.
        :paramtype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
        :keyword source_port_ranges: The source port ranges.
        :paramtype source_port_ranges: list[str]
        :keyword destination_port_ranges: The destination port ranges.
        :paramtype destination_port_ranges: list[str]
        :keyword access: Indicates the access allowed for this particular rule. Known values are:
         "Allow", "Deny", and "AlwaysAllow".
        :paramtype access: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleAccess
        :keyword priority: The priority of the rule. The value can be between 1 and 4096. The priority
         number must be unique for each rule in the collection. The lower the priority number, the
         higher the priority of the rule.
        :paramtype priority: int
        :keyword direction: Indicates if the traffic matched against the rule in inbound or outbound.
         Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
        """
        super().__init__(
            id=id,
            commit_time=commit_time,
            region=region,
            configuration_display_name=configuration_display_name,
            configuration_description=configuration_description,
            rule_collection_display_name=rule_collection_display_name,
            rule_collection_description=rule_collection_description,
            rule_collection_applies_to_groups=rule_collection_applies_to_groups,
            rule_groups=rule_groups,
            **kwargs
        )
        self.kind = "Custom"  # type: str
        self.display_name = display_name
        self.description = description
        self.protocol = protocol
        self.sources = sources
        self.destinations = destinations
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.access = access
        self.priority = priority
        self.direction = direction
        self.provisioning_state = None


class ActiveSecurityAdminRulesListResult(_serialization.Model):
    """Result of the request to list active security admin rules. It contains a list of active security admin rules and a skiptoken to get the next set of results.

    :ivar value: Gets a page of active security admin rules.
    :vartype value:
     list[~azure.mgmt.network.v2021_02_01_preview.models.ActiveBaseSecurityAdminRule]
    :ivar skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :vartype skip_token: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ActiveBaseSecurityAdminRule]"},
        "skip_token": {"key": "skipToken", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ActiveBaseSecurityAdminRule"]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Gets a page of active security admin rules.
        :paramtype value:
         list[~azure.mgmt.network.v2021_02_01_preview.models.ActiveBaseSecurityAdminRule]
        :keyword skip_token: When present, the value can be passed to a subsequent query call (together
         with the same query and scopes used in the current request) to retrieve the next page of data.
        :paramtype skip_token: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class ActiveSecurityUserRule(ActiveBaseSecurityUserRule):  # pylint: disable=too-many-instance-attributes
    """Network security user rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar commit_time: Deployment time string.
    :vartype commit_time: ~datetime.datetime
    :ivar region: Deployment region.
    :vartype region: str
    :ivar configuration_display_name: A display name of the security user configuration.
    :vartype configuration_display_name: str
    :ivar configuration_description: A description of the security user configuration.
    :vartype configuration_description: str
    :ivar rule_collection_display_name: A display name of the rule collection.
    :vartype rule_collection_display_name: str
    :ivar rule_collection_description: A description of the rule collection.
    :vartype rule_collection_description: str
    :ivar rule_collection_applies_to_groups: Groups for rule collection.
    :vartype rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :ivar rule_groups: Effective configuration groups.
    :vartype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveUserRuleKind
    :ivar display_name: A friendly name for the rule.
    :vartype display_name: str
    :ivar description: A description for this rule.
    :vartype description: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "Any", and "Ah".
    :vartype protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Known values are: "Inbound" and "Outbound".
    :vartype direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the security configuration user rule
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        "kind": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "commit_time": {"key": "commitTime", "type": "iso-8601"},
        "region": {"key": "region", "type": "str"},
        "configuration_display_name": {"key": "configurationDisplayName", "type": "str"},
        "configuration_description": {"key": "configurationDescription", "type": "str"},
        "rule_collection_display_name": {"key": "ruleCollectionDisplayName", "type": "str"},
        "rule_collection_description": {"key": "ruleCollectionDescription", "type": "str"},
        "rule_collection_applies_to_groups": {
            "key": "ruleCollectionAppliesToGroups",
            "type": "[NetworkManagerSecurityGroupItem]",
        },
        "rule_groups": {"key": "ruleGroups", "type": "[ConfigurationGroup]"},
        "kind": {"key": "kind", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "sources": {"key": "properties.sources", "type": "[AddressPrefixItem]"},
        "destinations": {"key": "properties.destinations", "type": "[AddressPrefixItem]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["_models.NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["_models.ConfigurationGroup"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "_models.SecurityConfigurationRuleProtocol"]] = None,
        sources: Optional[List["_models.AddressPrefixItem"]] = None,
        destinations: Optional[List["_models.AddressPrefixItem"]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        direction: Optional[Union[str, "_models.SecurityConfigurationRuleDirection"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword commit_time: Deployment time string.
        :paramtype commit_time: ~datetime.datetime
        :keyword region: Deployment region.
        :paramtype region: str
        :keyword configuration_display_name: A display name of the security user configuration.
        :paramtype configuration_display_name: str
        :keyword configuration_description: A description of the security user configuration.
        :paramtype configuration_description: str
        :keyword rule_collection_display_name: A display name of the rule collection.
        :paramtype rule_collection_display_name: str
        :keyword rule_collection_description: A description of the rule collection.
        :paramtype rule_collection_description: str
        :keyword rule_collection_applies_to_groups: Groups for rule collection.
        :paramtype rule_collection_applies_to_groups:
         list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
        :keyword rule_groups: Effective configuration groups.
        :paramtype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
        :keyword display_name: A friendly name for the rule.
        :paramtype display_name: str
        :keyword description: A description for this rule.
        :paramtype description: str
        :keyword protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp",
         "Icmp", "Esp", "Any", and "Ah".
        :paramtype protocol: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
        :keyword sources: The CIDR or source IP ranges.
        :paramtype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
        :keyword destinations: The destination address prefixes. CIDR or destination IP ranges.
        :paramtype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
        :keyword source_port_ranges: The source port ranges.
        :paramtype source_port_ranges: list[str]
        :keyword destination_port_ranges: The destination port ranges.
        :paramtype destination_port_ranges: list[str]
        :keyword direction: Indicates if the traffic matched against the rule in inbound or outbound.
         Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
        """
        super().__init__(
            id=id,
            commit_time=commit_time,
            region=region,
            configuration_display_name=configuration_display_name,
            configuration_description=configuration_description,
            rule_collection_display_name=rule_collection_display_name,
            rule_collection_description=rule_collection_description,
            rule_collection_applies_to_groups=rule_collection_applies_to_groups,
            rule_groups=rule_groups,
            **kwargs
        )
        self.kind = "Custom"  # type: str
        self.display_name = display_name
        self.description = description
        self.protocol = protocol
        self.sources = sources
        self.destinations = destinations
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.direction = direction
        self.provisioning_state = None


class ActiveSecurityUserRulesListResult(_serialization.Model):
    """Result of the request to list active security user rules. It contains a list of active security user rules and a skiptoken to get the next set of results.

    :ivar value: Gets a page of active security user rules.
    :vartype value: list[~azure.mgmt.network.v2021_02_01_preview.models.ActiveBaseSecurityUserRule]
    :ivar skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :vartype skip_token: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ActiveBaseSecurityUserRule]"},
        "skip_token": {"key": "skipToken", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ActiveBaseSecurityUserRule"]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Gets a page of active security user rules.
        :paramtype value:
         list[~azure.mgmt.network.v2021_02_01_preview.models.ActiveBaseSecurityUserRule]
        :keyword skip_token: When present, the value can be passed to a subsequent query call (together
         with the same query and scopes used in the current request) to retrieve the next page of data.
        :paramtype skip_token: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class AddressPrefixItem(_serialization.Model):
    """Address prefix item.

    :ivar address_prefix: Address prefix.
    :vartype address_prefix: str
    :ivar address_prefix_type: Address prefix type. Known values are: "IPPrefix" and "ServiceTag".
    :vartype address_prefix_type: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixType
    """

    _attribute_map = {
        "address_prefix": {"key": "addressPrefix", "type": "str"},
        "address_prefix_type": {"key": "addressPrefixType", "type": "str"},
    }

    def __init__(
        self,
        *,
        address_prefix: Optional[str] = None,
        address_prefix_type: Optional[Union[str, "_models.AddressPrefixType"]] = None,
        **kwargs
    ):
        """
        :keyword address_prefix: Address prefix.
        :paramtype address_prefix: str
        :keyword address_prefix_type: Address prefix type. Known values are: "IPPrefix" and
         "ServiceTag".
        :paramtype address_prefix_type: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixType
        """
        super().__init__(**kwargs)
        self.address_prefix = address_prefix
        self.address_prefix_type = address_prefix_type


class ProxyResource(_serialization.Model):
    """Proxy resource representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
    }

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.etag = None


class BaseAdminRule(ProxyResource):
    """Network base admin rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AdminRule, DefaultAdminRule

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.AdminRuleKind
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    _subtype_map = {"kind": {"Custom": "AdminRule", "Default": "DefaultAdminRule"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind = None  # type: Optional[str]
        self.system_data = None


class AdminRule(BaseAdminRule):  # pylint: disable=too-many-instance-attributes
    """Network admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.AdminRuleKind
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :ivar display_name: A friendly name for the rule.
    :vartype display_name: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "Any", and "Ah".
    :vartype protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: Indicates the access allowed for this particular rule. Known values are: "Allow",
     "Deny", and "AlwaysAllow".
    :vartype access: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleAccess
    :ivar priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Known values are: "Inbound" and "Outbound".
    :vartype direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
        "priority": {"maximum": 4096, "minimum": 1},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "sources": {"key": "properties.sources", "type": "[AddressPrefixItem]"},
        "destinations": {"key": "properties.destinations", "type": "[AddressPrefixItem]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "access": {"key": "properties.access", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "_models.SecurityConfigurationRuleProtocol"]] = None,
        sources: Optional[List["_models.AddressPrefixItem"]] = None,
        destinations: Optional[List["_models.AddressPrefixItem"]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        access: Optional[Union[str, "_models.SecurityConfigurationRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "_models.SecurityConfigurationRuleDirection"]] = None,
        **kwargs
    ):
        """
        :keyword display_name: A friendly name for the rule.
        :paramtype display_name: str
        :keyword description: A description for this rule. Restricted to 140 chars.
        :paramtype description: str
        :keyword protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp",
         "Icmp", "Esp", "Any", and "Ah".
        :paramtype protocol: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
        :keyword sources: The CIDR or source IP ranges.
        :paramtype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
        :keyword destinations: The destination address prefixes. CIDR or destination IP ranges.
        :paramtype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
        :keyword source_port_ranges: The source port ranges.
        :paramtype source_port_ranges: list[str]
        :keyword destination_port_ranges: The destination port ranges.
        :paramtype destination_port_ranges: list[str]
        :keyword access: Indicates the access allowed for this particular rule. Known values are:
         "Allow", "Deny", and "AlwaysAllow".
        :paramtype access: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleAccess
        :keyword priority: The priority of the rule. The value can be between 1 and 4096. The priority
         number must be unique for each rule in the collection. The lower the priority number, the
         higher the priority of the rule.
        :paramtype priority: int
        :keyword direction: Indicates if the traffic matched against the rule in inbound or outbound.
         Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
        """
        super().__init__(**kwargs)
        self.kind = "Custom"  # type: str
        self.display_name = display_name
        self.description = description
        self.protocol = protocol
        self.sources = sources
        self.destinations = destinations
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.access = access
        self.priority = priority
        self.direction = direction
        self.provisioning_state = None


class AdminRuleListResult(_serialization.Model):
    """security configuration admin rule list result.

    :ivar value: A list of admin rules.
    :vartype value: list[~azure.mgmt.network.v2021_02_01_preview.models.BaseAdminRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BaseAdminRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.BaseAdminRule"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of admin rules.
        :paramtype value: list[~azure.mgmt.network.v2021_02_01_preview.models.BaseAdminRule]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class BaseUserRule(ProxyResource):
    """Network base rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    UserRule, DefaultUserRule

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.UserRuleKind
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
    }

    _subtype_map = {"kind": {"Custom": "UserRule", "Default": "DefaultUserRule"}}

    def __init__(self, **kwargs):
        """ """
        super().__init__(**kwargs)
        self.kind = None  # type: Optional[str]
        self.system_data = None


class CloudErrorBody(_serialization.Model):
    """An error response from the service.

    :ivar code: An identifier for the error. Codes are invariant and are intended to be consumed
     programmatically.
    :vartype code: str
    :ivar message: A message describing the error, intended to be suitable for display in a user
     interface.
    :vartype message: str
    :ivar target: The target of the particular error. For example, the name of the property in
     error.
    :vartype target: str
    :ivar details: A list of additional details about the error.
    :vartype details: list[~azure.mgmt.network.v2021_02_01_preview.models.CloudErrorBody]
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.CloudErrorBody"]] = None,
        **kwargs
    ):
        """
        :keyword code: An identifier for the error. Codes are invariant and are intended to be consumed
         programmatically.
        :paramtype code: str
        :keyword message: A message describing the error, intended to be suitable for display in a user
         interface.
        :paramtype message: str
        :keyword target: The target of the particular error. For example, the name of the property in
         error.
        :paramtype target: str
        :keyword details: A list of additional details about the error.
        :paramtype details: list[~azure.mgmt.network.v2021_02_01_preview.models.CloudErrorBody]
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details


class ConfigurationGroup(_serialization.Model):
    """The network configuration group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar display_name: A friendly name for the network group.
    :vartype display_name: str
    :ivar description: A description of the network group.
    :vartype description: str
    :ivar member_type: Group member type.
    :vartype member_type: str
    :ivar group_members: Group members of network group.
    :vartype group_members: list[~azure.mgmt.network.v2021_02_01_preview.models.GroupMembersItem]
    :ivar conditional_membership: Network group conditional filter.
    :vartype conditional_membership: str
    :ivar provisioning_state: The provisioning state of the scope assignment resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "member_type": {"key": "properties.memberType", "type": "str"},
        "group_members": {"key": "properties.groupMembers", "type": "[GroupMembersItem]"},
        "conditional_membership": {"key": "properties.conditionalMembership", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        member_type: Optional[str] = None,
        group_members: Optional[List["_models.GroupMembersItem"]] = None,
        conditional_membership: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword display_name: A friendly name for the network group.
        :paramtype display_name: str
        :keyword description: A description of the network group.
        :paramtype description: str
        :keyword member_type: Group member type.
        :paramtype member_type: str
        :keyword group_members: Group members of network group.
        :paramtype group_members: list[~azure.mgmt.network.v2021_02_01_preview.models.GroupMembersItem]
        :keyword conditional_membership: Network group conditional filter.
        :paramtype conditional_membership: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.display_name = display_name
        self.description = description
        self.member_type = member_type
        self.group_members = group_members
        self.conditional_membership = conditional_membership
        self.provisioning_state = None


class ConnectivityConfiguration(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The network manager connectivity configuration resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :ivar display_name: A friendly name for the resource.
    :vartype display_name: str
    :ivar description: A description of the connectivity configuration.
    :vartype description: str
    :ivar connectivity_topology: Connectivity topology type. Known values are: "HubAndSpoke" and
     "Mesh".
    :vartype connectivity_topology: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityTopology
    :ivar hubs: List of hubItems.
    :vartype hubs: list[~azure.mgmt.network.v2021_02_01_preview.models.Hub]
    :ivar is_global: Flag if global mesh is supported. Known values are: "False" and "True".
    :vartype is_global: str or ~azure.mgmt.network.v2021_02_01_preview.models.IsGlobal
    :ivar applies_to_groups: Groups for configuration.
    :vartype applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityGroupItem]
    :ivar provisioning_state: The provisioning state of the connectivity configuration resource.
     Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    :ivar delete_existing_peering: Flag if need to remove current existing peerings. Known values
     are: "False" and "True".
    :vartype delete_existing_peering: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.DeleteExistingPeering
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "connectivity_topology": {"key": "properties.connectivityTopology", "type": "str"},
        "hubs": {"key": "properties.hubs", "type": "[Hub]"},
        "is_global": {"key": "properties.isGlobal", "type": "str"},
        "applies_to_groups": {"key": "properties.appliesToGroups", "type": "[ConnectivityGroupItem]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "delete_existing_peering": {"key": "properties.deleteExistingPeering", "type": "str"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        connectivity_topology: Optional[Union[str, "_models.ConnectivityTopology"]] = None,
        hubs: Optional[List["_models.Hub"]] = None,
        is_global: Optional[Union[str, "_models.IsGlobal"]] = None,
        applies_to_groups: Optional[List["_models.ConnectivityGroupItem"]] = None,
        delete_existing_peering: Optional[Union[str, "_models.DeleteExistingPeering"]] = None,
        **kwargs
    ):
        """
        :keyword display_name: A friendly name for the resource.
        :paramtype display_name: str
        :keyword description: A description of the connectivity configuration.
        :paramtype description: str
        :keyword connectivity_topology: Connectivity topology type. Known values are: "HubAndSpoke" and
         "Mesh".
        :paramtype connectivity_topology: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityTopology
        :keyword hubs: List of hubItems.
        :paramtype hubs: list[~azure.mgmt.network.v2021_02_01_preview.models.Hub]
        :keyword is_global: Flag if global mesh is supported. Known values are: "False" and "True".
        :paramtype is_global: str or ~azure.mgmt.network.v2021_02_01_preview.models.IsGlobal
        :keyword applies_to_groups: Groups for configuration.
        :paramtype applies_to_groups:
         list[~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityGroupItem]
        :keyword delete_existing_peering: Flag if need to remove current existing peerings. Known
         values are: "False" and "True".
        :paramtype delete_existing_peering: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.DeleteExistingPeering
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.display_name = display_name
        self.description = description
        self.connectivity_topology = connectivity_topology
        self.hubs = hubs
        self.is_global = is_global
        self.applies_to_groups = applies_to_groups
        self.provisioning_state = None
        self.delete_existing_peering = delete_existing_peering


class ConnectivityConfigurationListResult(_serialization.Model):
    """Result of the request to list network manager connectivity configurations. It contains a list of configurations and a link to get the next set of results.

    :ivar value: Gets a page of Connectivity Configurations.
    :vartype value: list[~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityConfiguration]
    :ivar next_link: Gets the URL to get the next page of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ConnectivityConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ConnectivityConfiguration"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Gets a page of Connectivity Configurations.
        :paramtype value:
         list[~azure.mgmt.network.v2021_02_01_preview.models.ConnectivityConfiguration]
        :keyword next_link: Gets the URL to get the next page of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ConnectivityGroupItem(_serialization.Model):
    """ConnectivityGroupItem.

    :ivar network_group_id: Network group Id.
    :vartype network_group_id: str
    :ivar use_hub_gateway: Flag if need to use hub gateway. Known values are: "False" and "True".
    :vartype use_hub_gateway: str or ~azure.mgmt.network.v2021_02_01_preview.models.UseHubGateway
    :ivar is_global: Flag if global is supported. Known values are: "False" and "True".
    :vartype is_global: str or ~azure.mgmt.network.v2021_02_01_preview.models.IsGlobal
    :ivar group_connectivity: Group connectivity type. Known values are: "None" and
     "DirectlyConnected".
    :vartype group_connectivity: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.GroupConnectivity
    """

    _attribute_map = {
        "network_group_id": {"key": "networkGroupId", "type": "str"},
        "use_hub_gateway": {"key": "useHubGateway", "type": "str"},
        "is_global": {"key": "isGlobal", "type": "str"},
        "group_connectivity": {"key": "groupConnectivity", "type": "str"},
    }

    def __init__(
        self,
        *,
        network_group_id: Optional[str] = None,
        use_hub_gateway: Optional[Union[str, "_models.UseHubGateway"]] = None,
        is_global: Optional[Union[str, "_models.IsGlobal"]] = None,
        group_connectivity: Optional[Union[str, "_models.GroupConnectivity"]] = None,
        **kwargs
    ):
        """
        :keyword network_group_id: Network group Id.
        :paramtype network_group_id: str
        :keyword use_hub_gateway: Flag if need to use hub gateway. Known values are: "False" and
         "True".
        :paramtype use_hub_gateway: str or ~azure.mgmt.network.v2021_02_01_preview.models.UseHubGateway
        :keyword is_global: Flag if global is supported. Known values are: "False" and "True".
        :paramtype is_global: str or ~azure.mgmt.network.v2021_02_01_preview.models.IsGlobal
        :keyword group_connectivity: Group connectivity type. Known values are: "None" and
         "DirectlyConnected".
        :paramtype group_connectivity: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.GroupConnectivity
        """
        super().__init__(**kwargs)
        self.network_group_id = network_group_id
        self.use_hub_gateway = use_hub_gateway
        self.is_global = is_global
        self.group_connectivity = group_connectivity


class DefaultAdminRule(BaseAdminRule):  # pylint: disable=too-many-instance-attributes
    """Network default admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.AdminRuleKind
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :ivar display_name: A friendly name for the rule.
    :vartype display_name: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar flag: Default rule flag.
    :vartype flag: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "Any", and "Ah".
    :vartype protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: Indicates the access allowed for this particular rule. Known values are: "Allow",
     "Deny", and "AlwaysAllow".
    :vartype access: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleAccess
    :ivar priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Known values are: "Inbound" and "Outbound".
    :vartype direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "protocol": {"readonly": True},
        "sources": {"readonly": True},
        "destinations": {"readonly": True},
        "source_port_ranges": {"readonly": True},
        "destination_port_ranges": {"readonly": True},
        "access": {"readonly": True},
        "priority": {"readonly": True},
        "direction": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "flag": {"key": "properties.flag", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "sources": {"key": "properties.sources", "type": "[AddressPrefixItem]"},
        "destinations": {"key": "properties.destinations", "type": "[AddressPrefixItem]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "access": {"key": "properties.access", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, flag: Optional[str] = None, **kwargs):
        """
        :keyword flag: Default rule flag.
        :paramtype flag: str
        """
        super().__init__(**kwargs)
        self.kind = "Default"  # type: str
        self.display_name = None
        self.description = None
        self.flag = flag
        self.protocol = None
        self.sources = None
        self.destinations = None
        self.source_port_ranges = None
        self.destination_port_ranges = None
        self.access = None
        self.priority = None
        self.direction = None
        self.provisioning_state = None


class DefaultUserRule(BaseUserRule):  # pylint: disable=too-many-instance-attributes
    """Network security default user rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.UserRuleKind
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :ivar display_name: A friendly name for the rule.
    :vartype display_name: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar flag: Default rule flag.
    :vartype flag: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "Any", and "Ah".
    :vartype protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Known values are: "Inbound" and "Outbound".
    :vartype direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the security configuration user rule
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "protocol": {"readonly": True},
        "sources": {"readonly": True},
        "destinations": {"readonly": True},
        "source_port_ranges": {"readonly": True},
        "destination_port_ranges": {"readonly": True},
        "direction": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "flag": {"key": "properties.flag", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "sources": {"key": "properties.sources", "type": "[AddressPrefixItem]"},
        "destinations": {"key": "properties.destinations", "type": "[AddressPrefixItem]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, *, flag: Optional[str] = None, **kwargs):
        """
        :keyword flag: Default rule flag.
        :paramtype flag: str
        """
        super().__init__(**kwargs)
        self.kind = "Default"  # type: str
        self.display_name = None
        self.description = None
        self.flag = flag
        self.protocol = None
        self.sources = None
        self.destinations = None
        self.source_port_ranges = None
        self.destination_port_ranges = None
        self.direction = None
        self.provisioning_state = None


class EffectiveBaseSecurityAdminRule(_serialization.Model):
    """Network base admin rule.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    EffectiveSecurityAdminRule, EffectiveDefaultSecurityAdminRule

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar configuration_display_name: A display name of the security admin configuration.
    :vartype configuration_display_name: str
    :ivar configuration_description: A description of the security admin configuration.
    :vartype configuration_description: str
    :ivar rule_collection_display_name: A display name of the rule collection.
    :vartype rule_collection_display_name: str
    :ivar rule_collection_description: A description of the rule collection.
    :vartype rule_collection_description: str
    :ivar rule_collection_applies_to_groups: Groups for rule collection.
    :vartype rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :ivar rule_groups: Effective configuration groups.
    :vartype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveAdminRuleKind
    """

    _validation = {
        "kind": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "configuration_display_name": {"key": "configurationDisplayName", "type": "str"},
        "configuration_description": {"key": "configurationDescription", "type": "str"},
        "rule_collection_display_name": {"key": "ruleCollectionDisplayName", "type": "str"},
        "rule_collection_description": {"key": "ruleCollectionDescription", "type": "str"},
        "rule_collection_applies_to_groups": {
            "key": "ruleCollectionAppliesToGroups",
            "type": "[NetworkManagerSecurityGroupItem]",
        },
        "rule_groups": {"key": "ruleGroups", "type": "[ConfigurationGroup]"},
        "kind": {"key": "kind", "type": "str"},
    }

    _subtype_map = {"kind": {"Custom": "EffectiveSecurityAdminRule", "Default": "EffectiveDefaultSecurityAdminRule"}}

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["_models.NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["_models.ConfigurationGroup"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword configuration_display_name: A display name of the security admin configuration.
        :paramtype configuration_display_name: str
        :keyword configuration_description: A description of the security admin configuration.
        :paramtype configuration_description: str
        :keyword rule_collection_display_name: A display name of the rule collection.
        :paramtype rule_collection_display_name: str
        :keyword rule_collection_description: A description of the rule collection.
        :paramtype rule_collection_description: str
        :keyword rule_collection_applies_to_groups: Groups for rule collection.
        :paramtype rule_collection_applies_to_groups:
         list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
        :keyword rule_groups: Effective configuration groups.
        :paramtype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
        """
        super().__init__(**kwargs)
        self.id = id
        self.configuration_display_name = configuration_display_name
        self.configuration_description = configuration_description
        self.rule_collection_display_name = rule_collection_display_name
        self.rule_collection_description = rule_collection_description
        self.rule_collection_applies_to_groups = rule_collection_applies_to_groups
        self.rule_groups = rule_groups
        self.kind = None  # type: Optional[str]


class EffectiveDefaultSecurityAdminRule(EffectiveBaseSecurityAdminRule):  # pylint: disable=too-many-instance-attributes
    """Network default admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar configuration_display_name: A display name of the security admin configuration.
    :vartype configuration_display_name: str
    :ivar configuration_description: A description of the security admin configuration.
    :vartype configuration_description: str
    :ivar rule_collection_display_name: A display name of the rule collection.
    :vartype rule_collection_display_name: str
    :ivar rule_collection_description: A description of the rule collection.
    :vartype rule_collection_description: str
    :ivar rule_collection_applies_to_groups: Groups for rule collection.
    :vartype rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :ivar rule_groups: Effective configuration groups.
    :vartype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveAdminRuleKind
    :ivar display_name: A friendly name for the rule.
    :vartype display_name: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar flag: Default rule flag.
    :vartype flag: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "Any", and "Ah".
    :vartype protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: Indicates the access allowed for this particular rule. Known values are: "Allow",
     "Deny", and "AlwaysAllow".
    :vartype access: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleAccess
    :ivar priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Known values are: "Inbound" and "Outbound".
    :vartype direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        "kind": {"required": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True},
        "protocol": {"readonly": True},
        "sources": {"readonly": True},
        "destinations": {"readonly": True},
        "source_port_ranges": {"readonly": True},
        "destination_port_ranges": {"readonly": True},
        "access": {"readonly": True},
        "priority": {"readonly": True},
        "direction": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "configuration_display_name": {"key": "configurationDisplayName", "type": "str"},
        "configuration_description": {"key": "configurationDescription", "type": "str"},
        "rule_collection_display_name": {"key": "ruleCollectionDisplayName", "type": "str"},
        "rule_collection_description": {"key": "ruleCollectionDescription", "type": "str"},
        "rule_collection_applies_to_groups": {
            "key": "ruleCollectionAppliesToGroups",
            "type": "[NetworkManagerSecurityGroupItem]",
        },
        "rule_groups": {"key": "ruleGroups", "type": "[ConfigurationGroup]"},
        "kind": {"key": "kind", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "flag": {"key": "properties.flag", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "sources": {"key": "properties.sources", "type": "[AddressPrefixItem]"},
        "destinations": {"key": "properties.destinations", "type": "[AddressPrefixItem]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "access": {"key": "properties.access", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["_models.NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["_models.ConfigurationGroup"]] = None,
        flag: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword configuration_display_name: A display name of the security admin configuration.
        :paramtype configuration_display_name: str
        :keyword configuration_description: A description of the security admin configuration.
        :paramtype configuration_description: str
        :keyword rule_collection_display_name: A display name of the rule collection.
        :paramtype rule_collection_display_name: str
        :keyword rule_collection_description: A description of the rule collection.
        :paramtype rule_collection_description: str
        :keyword rule_collection_applies_to_groups: Groups for rule collection.
        :paramtype rule_collection_applies_to_groups:
         list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
        :keyword rule_groups: Effective configuration groups.
        :paramtype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
        :keyword flag: Default rule flag.
        :paramtype flag: str
        """
        super().__init__(
            id=id,
            configuration_display_name=configuration_display_name,
            configuration_description=configuration_description,
            rule_collection_display_name=rule_collection_display_name,
            rule_collection_description=rule_collection_description,
            rule_collection_applies_to_groups=rule_collection_applies_to_groups,
            rule_groups=rule_groups,
            **kwargs
        )
        self.kind = "Default"  # type: str
        self.display_name = None
        self.description = None
        self.flag = flag
        self.protocol = None
        self.sources = None
        self.destinations = None
        self.source_port_ranges = None
        self.destination_port_ranges = None
        self.access = None
        self.priority = None
        self.direction = None
        self.provisioning_state = None


class EffectiveSecurityAdminRule(EffectiveBaseSecurityAdminRule):  # pylint: disable=too-many-instance-attributes
    """Network admin rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar configuration_display_name: A display name of the security admin configuration.
    :vartype configuration_display_name: str
    :ivar configuration_description: A description of the security admin configuration.
    :vartype configuration_description: str
    :ivar rule_collection_display_name: A display name of the rule collection.
    :vartype rule_collection_display_name: str
    :ivar rule_collection_description: A description of the rule collection.
    :vartype rule_collection_description: str
    :ivar rule_collection_applies_to_groups: Groups for rule collection.
    :vartype rule_collection_applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :ivar rule_groups: Effective configuration groups.
    :vartype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.EffectiveAdminRuleKind
    :ivar display_name: A friendly name for the rule.
    :vartype display_name: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "Any", and "Ah".
    :vartype protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar access: Indicates the access allowed for this particular rule. Known values are: "Allow",
     "Deny", and "AlwaysAllow".
    :vartype access: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleAccess
    :ivar priority: The priority of the rule. The value can be between 1 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Known values are: "Inbound" and "Outbound".
    :vartype direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        "kind": {"required": True},
        "priority": {"maximum": 4096, "minimum": 1},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "configuration_display_name": {"key": "configurationDisplayName", "type": "str"},
        "configuration_description": {"key": "configurationDescription", "type": "str"},
        "rule_collection_display_name": {"key": "ruleCollectionDisplayName", "type": "str"},
        "rule_collection_description": {"key": "ruleCollectionDescription", "type": "str"},
        "rule_collection_applies_to_groups": {
            "key": "ruleCollectionAppliesToGroups",
            "type": "[NetworkManagerSecurityGroupItem]",
        },
        "rule_groups": {"key": "ruleGroups", "type": "[ConfigurationGroup]"},
        "kind": {"key": "kind", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "sources": {"key": "properties.sources", "type": "[AddressPrefixItem]"},
        "destinations": {"key": "properties.destinations", "type": "[AddressPrefixItem]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "access": {"key": "properties.access", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        configuration_display_name: Optional[str] = None,
        configuration_description: Optional[str] = None,
        rule_collection_display_name: Optional[str] = None,
        rule_collection_description: Optional[str] = None,
        rule_collection_applies_to_groups: Optional[List["_models.NetworkManagerSecurityGroupItem"]] = None,
        rule_groups: Optional[List["_models.ConfigurationGroup"]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "_models.SecurityConfigurationRuleProtocol"]] = None,
        sources: Optional[List["_models.AddressPrefixItem"]] = None,
        destinations: Optional[List["_models.AddressPrefixItem"]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        access: Optional[Union[str, "_models.SecurityConfigurationRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "_models.SecurityConfigurationRuleDirection"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword configuration_display_name: A display name of the security admin configuration.
        :paramtype configuration_display_name: str
        :keyword configuration_description: A description of the security admin configuration.
        :paramtype configuration_description: str
        :keyword rule_collection_display_name: A display name of the rule collection.
        :paramtype rule_collection_display_name: str
        :keyword rule_collection_description: A description of the rule collection.
        :paramtype rule_collection_description: str
        :keyword rule_collection_applies_to_groups: Groups for rule collection.
        :paramtype rule_collection_applies_to_groups:
         list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
        :keyword rule_groups: Effective configuration groups.
        :paramtype rule_groups: list[~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationGroup]
        :keyword display_name: A friendly name for the rule.
        :paramtype display_name: str
        :keyword description: A description for this rule. Restricted to 140 chars.
        :paramtype description: str
        :keyword protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp",
         "Icmp", "Esp", "Any", and "Ah".
        :paramtype protocol: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
        :keyword sources: The CIDR or source IP ranges.
        :paramtype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
        :keyword destinations: The destination address prefixes. CIDR or destination IP ranges.
        :paramtype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
        :keyword source_port_ranges: The source port ranges.
        :paramtype source_port_ranges: list[str]
        :keyword destination_port_ranges: The destination port ranges.
        :paramtype destination_port_ranges: list[str]
        :keyword access: Indicates the access allowed for this particular rule. Known values are:
         "Allow", "Deny", and "AlwaysAllow".
        :paramtype access: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleAccess
        :keyword priority: The priority of the rule. The value can be between 1 and 4096. The priority
         number must be unique for each rule in the collection. The lower the priority number, the
         higher the priority of the rule.
        :paramtype priority: int
        :keyword direction: Indicates if the traffic matched against the rule in inbound or outbound.
         Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
        """
        super().__init__(
            id=id,
            configuration_display_name=configuration_display_name,
            configuration_description=configuration_description,
            rule_collection_display_name=rule_collection_display_name,
            rule_collection_description=rule_collection_description,
            rule_collection_applies_to_groups=rule_collection_applies_to_groups,
            rule_groups=rule_groups,
            **kwargs
        )
        self.kind = "Custom"  # type: str
        self.display_name = display_name
        self.description = description
        self.protocol = protocol
        self.sources = sources
        self.destinations = destinations
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.access = access
        self.priority = priority
        self.direction = direction
        self.provisioning_state = None


class EffectiveVirtualNetwork(_serialization.Model):
    """Effective Virtual Network.

    :ivar id: Effective vnet Id.
    :vartype id: str
    :ivar location: Location of vnet.
    :vartype location: str
    :ivar membership_type: Membership Type. Known values are: "Static" and "Dynamic".
    :vartype membership_type: str or ~azure.mgmt.network.v2021_02_01_preview.models.MembershipType
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "membership_type": {"key": "membershipType", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        membership_type: Optional[Union[str, "_models.MembershipType"]] = None,
        **kwargs
    ):
        """
        :keyword id: Effective vnet Id.
        :paramtype id: str
        :keyword location: Location of vnet.
        :paramtype location: str
        :keyword membership_type: Membership Type. Known values are: "Static" and "Dynamic".
        :paramtype membership_type: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.MembershipType
        """
        super().__init__(**kwargs)
        self.id = id
        self.location = location
        self.membership_type = membership_type


class EffectiveVirtualNetworksListResult(_serialization.Model):
    """Result of the request to list Effective Virtual Network. It contains a list of groups and a URL link to get the next set of results.

    :ivar value: Gets a page of EffectiveVirtualNetwork.
    :vartype value: list[~azure.mgmt.network.v2021_02_01_preview.models.EffectiveVirtualNetwork]
    :ivar skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :vartype skip_token: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EffectiveVirtualNetwork]"},
        "skip_token": {"key": "skipToken", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.EffectiveVirtualNetwork"]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Gets a page of EffectiveVirtualNetwork.
        :paramtype value: list[~azure.mgmt.network.v2021_02_01_preview.models.EffectiveVirtualNetwork]
        :keyword skip_token: When present, the value can be passed to a subsequent query call (together
         with the same query and scopes used in the current request) to retrieve the next page of data.
        :paramtype skip_token: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class EffectiveVirtualNetworksParameter(_serialization.Model):
    """Effective Virtual Networks Parameter.

    :ivar conditional_members: Conditional Members.
    :vartype conditional_members: str
    :ivar skip_token: Continuation token for pagination, capturing the next page size and offset,
     as well as the context of the query.
    :vartype skip_token: str
    """

    _attribute_map = {
        "conditional_members": {"key": "conditionalMembers", "type": "str"},
        "skip_token": {"key": "skipToken", "type": "str"},
    }

    def __init__(self, *, conditional_members: Optional[str] = None, skip_token: Optional[str] = None, **kwargs):
        """
        :keyword conditional_members: Conditional Members.
        :paramtype conditional_members: str
        :keyword skip_token: Continuation token for pagination, capturing the next page size and
         offset, as well as the context of the query.
        :paramtype skip_token: str
        """
        super().__init__(**kwargs)
        self.conditional_members = conditional_members
        self.skip_token = skip_token


class GroupMembersItem(_serialization.Model):
    """GroupMembers Item.

    :ivar resource_id: Resource Id.
    :vartype resource_id: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(self, *, resource_id: Optional[str] = None, **kwargs):
        """
        :keyword resource_id: Resource Id.
        :paramtype resource_id: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id


class Hub(_serialization.Model):
    """Hub Item.

    :ivar resource_id: Resource Id.
    :vartype resource_id: str
    :ivar resource_type: Resource Type.
    :vartype resource_type: str
    """

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "resource_type": {"key": "resourceType", "type": "str"},
    }

    def __init__(self, *, resource_id: Optional[str] = None, resource_type: Optional[str] = None, **kwargs):
        """
        :keyword resource_id: Resource Id.
        :paramtype resource_id: str
        :keyword resource_type: Resource Type.
        :paramtype resource_type: str
        """
        super().__init__(**kwargs)
        self.resource_id = resource_id
        self.resource_type = resource_type


class NetworkGroup(ProxyResource):  # pylint: disable=too-many-instance-attributes
    """The network group resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :ivar display_name: A friendly name for the network group.
    :vartype display_name: str
    :ivar description: A description of the network group.
    :vartype description: str
    :ivar member_type: Group member type.
    :vartype member_type: str
    :ivar group_members: Group members of network group.
    :vartype group_members: list[~azure.mgmt.network.v2021_02_01_preview.models.GroupMembersItem]
    :ivar conditional_membership: Network group conditional filter.
    :vartype conditional_membership: str
    :ivar provisioning_state: The provisioning state of the scope assignment resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "member_type": {"key": "properties.memberType", "type": "str"},
        "group_members": {"key": "properties.groupMembers", "type": "[GroupMembersItem]"},
        "conditional_membership": {"key": "properties.conditionalMembership", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        member_type: Optional[str] = None,
        group_members: Optional[List["_models.GroupMembersItem"]] = None,
        conditional_membership: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword display_name: A friendly name for the network group.
        :paramtype display_name: str
        :keyword description: A description of the network group.
        :paramtype description: str
        :keyword member_type: Group member type.
        :paramtype member_type: str
        :keyword group_members: Group members of network group.
        :paramtype group_members: list[~azure.mgmt.network.v2021_02_01_preview.models.GroupMembersItem]
        :keyword conditional_membership: Network group conditional filter.
        :paramtype conditional_membership: str
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.display_name = display_name
        self.description = description
        self.member_type = member_type
        self.group_members = group_members
        self.conditional_membership = conditional_membership
        self.provisioning_state = None


class NetworkGroupListResult(_serialization.Model):
    """Result of the request to list NetworkGroup. It contains a list of groups and a URL link to get the next set of results.

    :ivar value: Gets a page of NetworkGroup.
    :vartype value: list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkGroup]
    :ivar next_link: Gets the URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkGroup"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets a page of NetworkGroup.
        :paramtype value: list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkGroup]
        :keyword next_link: Gets the URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Resource(_serialization.Model):
    """Common resource representation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class NetworkManager(Resource):  # pylint: disable=too-many-instance-attributes
    """The Managed Network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :ivar display_name: A friendly name for the network manager.
    :vartype display_name: str
    :ivar description: A description of the network manager.
    :vartype description: str
    :ivar network_manager_scopes: Scope of Network Manager.
    :vartype network_manager_scopes:
     ~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerPropertiesNetworkManagerScopes
    :ivar network_manager_scope_accesses: Scope Access.
    :vartype network_manager_scope_accesses: list[str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationType]
    :ivar provisioning_state: The provisioning state of the scope assignment resource. Known values
     are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "network_manager_scopes": {
            "key": "properties.networkManagerScopes",
            "type": "NetworkManagerPropertiesNetworkManagerScopes",
        },
        "network_manager_scope_accesses": {"key": "properties.networkManagerScopeAccesses", "type": "[str]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        network_manager_scopes: Optional["_models.NetworkManagerPropertiesNetworkManagerScopes"] = None,
        network_manager_scope_accesses: Optional[List[Union[str, "_models.ConfigurationType"]]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword display_name: A friendly name for the network manager.
        :paramtype display_name: str
        :keyword description: A description of the network manager.
        :paramtype description: str
        :keyword network_manager_scopes: Scope of Network Manager.
        :paramtype network_manager_scopes:
         ~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerPropertiesNetworkManagerScopes
        :keyword network_manager_scope_accesses: Scope Access.
        :paramtype network_manager_scope_accesses: list[str or
         ~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationType]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = None
        self.system_data = None
        self.display_name = display_name
        self.description = description
        self.network_manager_scopes = network_manager_scopes
        self.network_manager_scope_accesses = network_manager_scope_accesses
        self.provisioning_state = None


class NetworkManagerCommit(_serialization.Model):
    """Network Manager Commit.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar commit_id: Commit Id.
    :vartype commit_id: str
    :ivar target_locations: List of target locations.
    :vartype target_locations: list[str]
    :ivar configuration_ids: List of configuration ids.
    :vartype configuration_ids: list[str]
    :ivar commit_type: Commit Type. Known values are: "SecurityAdmin", "SecurityUser", and
     "Connectivity".
    :vartype commit_type: str or ~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationType
    """

    _validation = {
        "commit_id": {"readonly": True},
    }

    _attribute_map = {
        "commit_id": {"key": "commitId", "type": "str"},
        "target_locations": {"key": "targetLocations", "type": "[str]"},
        "configuration_ids": {"key": "configurationIds", "type": "[str]"},
        "commit_type": {"key": "commitType", "type": "str"},
    }

    def __init__(
        self,
        *,
        target_locations: Optional[List[str]] = None,
        configuration_ids: Optional[List[str]] = None,
        commit_type: Optional[Union[str, "_models.ConfigurationType"]] = None,
        **kwargs
    ):
        """
        :keyword target_locations: List of target locations.
        :paramtype target_locations: list[str]
        :keyword configuration_ids: List of configuration ids.
        :paramtype configuration_ids: list[str]
        :keyword commit_type: Commit Type. Known values are: "SecurityAdmin", "SecurityUser", and
         "Connectivity".
        :paramtype commit_type: str or ~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationType
        """
        super().__init__(**kwargs)
        self.commit_id = None
        self.target_locations = target_locations
        self.configuration_ids = configuration_ids
        self.commit_type = commit_type


class NetworkManagerDeploymentStatus(_serialization.Model):
    """Network Manager Deployment Status.

    :ivar commit_time: Commit Time.
    :vartype commit_time: ~datetime.datetime
    :ivar region: Region Name.
    :vartype region: str
    :ivar deployment_status: Deployment Status. Known values are: "NotStarted", "Deploying",
     "Deployed", and "Failed".
    :vartype deployment_status: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.DeploymentStatus
    :ivar configuration_ids: List of configuration ids.
    :vartype configuration_ids: list[str]
    :ivar deployment_type: Configuration Deployment Type. Known values are: "SecurityAdmin",
     "SecurityUser", and "Connectivity".
    :vartype deployment_type: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationType
    :ivar error_message: Error Message.
    :vartype error_message: str
    """

    _attribute_map = {
        "commit_time": {"key": "commitTime", "type": "iso-8601"},
        "region": {"key": "region", "type": "str"},
        "deployment_status": {"key": "deploymentStatus", "type": "str"},
        "configuration_ids": {"key": "configurationIds", "type": "[str]"},
        "deployment_type": {"key": "deploymentType", "type": "str"},
        "error_message": {"key": "errorMessage", "type": "str"},
    }

    def __init__(
        self,
        *,
        commit_time: Optional[datetime.datetime] = None,
        region: Optional[str] = None,
        deployment_status: Optional[Union[str, "_models.DeploymentStatus"]] = None,
        configuration_ids: Optional[List[str]] = None,
        deployment_type: Optional[Union[str, "_models.ConfigurationType"]] = None,
        error_message: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword commit_time: Commit Time.
        :paramtype commit_time: ~datetime.datetime
        :keyword region: Region Name.
        :paramtype region: str
        :keyword deployment_status: Deployment Status. Known values are: "NotStarted", "Deploying",
         "Deployed", and "Failed".
        :paramtype deployment_status: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.DeploymentStatus
        :keyword configuration_ids: List of configuration ids.
        :paramtype configuration_ids: list[str]
        :keyword deployment_type: Configuration Deployment Type. Known values are: "SecurityAdmin",
         "SecurityUser", and "Connectivity".
        :paramtype deployment_type: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationType
        :keyword error_message: Error Message.
        :paramtype error_message: str
        """
        super().__init__(**kwargs)
        self.commit_time = commit_time
        self.region = region
        self.deployment_status = deployment_status
        self.configuration_ids = configuration_ids
        self.deployment_type = deployment_type
        self.error_message = error_message


class NetworkManagerDeploymentStatusListResult(_serialization.Model):
    """A list of Network Manager Deployment Status.

    :ivar value: Gets a page of Network Manager Deployment Status.
    :vartype value:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerDeploymentStatus]
    :ivar skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :vartype skip_token: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkManagerDeploymentStatus]"},
        "skip_token": {"key": "skipToken", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkManagerDeploymentStatus"]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Gets a page of Network Manager Deployment Status.
        :paramtype value:
         list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerDeploymentStatus]
        :keyword skip_token: When present, the value can be passed to a subsequent query call (together
         with the same query and scopes used in the current request) to retrieve the next page of data.
        :paramtype skip_token: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class NetworkManagerDeploymentStatusParameter(_serialization.Model):
    """Network Manager Deployment Status Parameter.

    :ivar regions: List of locations.
    :vartype regions: list[str]
    :ivar deployment_types: List of deployment types.
    :vartype deployment_types: list[str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationType]
    :ivar skip_token: Continuation token for pagination, capturing the next page size and offset,
     as well as the context of the query.
    :vartype skip_token: str
    """

    _attribute_map = {
        "regions": {"key": "regions", "type": "[str]"},
        "deployment_types": {"key": "deploymentTypes", "type": "[str]"},
        "skip_token": {"key": "skipToken", "type": "str"},
    }

    def __init__(
        self,
        *,
        regions: Optional[List[str]] = None,
        deployment_types: Optional[List[Union[str, "_models.ConfigurationType"]]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword regions: List of locations.
        :paramtype regions: list[str]
        :keyword deployment_types: List of deployment types.
        :paramtype deployment_types: list[str or
         ~azure.mgmt.network.v2021_02_01_preview.models.ConfigurationType]
        :keyword skip_token: Continuation token for pagination, capturing the next page size and
         offset, as well as the context of the query.
        :paramtype skip_token: str
        """
        super().__init__(**kwargs)
        self.regions = regions
        self.deployment_types = deployment_types
        self.skip_token = skip_token


class NetworkManagerEffectiveConnectivityConfigurationListResult(_serialization.Model):
    """Result of the request to list networkManagerEffectiveConnectivityConfiguration. It contains a list of groups and a skiptoken to get the next set of results.

    :ivar value: Gets a page of NetworkManagerEffectiveConnectivityConfiguration.
    :vartype value:
     list[~azure.mgmt.network.v2021_02_01_preview.models.EffectiveConnectivityConfiguration]
    :ivar skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :vartype skip_token: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EffectiveConnectivityConfiguration]"},
        "skip_token": {"key": "skipToken", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.EffectiveConnectivityConfiguration"]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Gets a page of NetworkManagerEffectiveConnectivityConfiguration.
        :paramtype value:
         list[~azure.mgmt.network.v2021_02_01_preview.models.EffectiveConnectivityConfiguration]
        :keyword skip_token: When present, the value can be passed to a subsequent query call (together
         with the same query and scopes used in the current request) to retrieve the next page of data.
        :paramtype skip_token: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class NetworkManagerEffectiveSecurityAdminRulesListResult(_serialization.Model):
    """Result of the request to list networkManagerEffectiveSecurityAdminRules. It contains a list of groups and a skiptoken to get the next set of results.

    :ivar value: Gets a page of NetworkManagerEffectiveSecurityAdminRules.
    :vartype value:
     list[~azure.mgmt.network.v2021_02_01_preview.models.EffectiveBaseSecurityAdminRule]
    :ivar skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :vartype skip_token: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[EffectiveBaseSecurityAdminRule]"},
        "skip_token": {"key": "skipToken", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.EffectiveBaseSecurityAdminRule"]] = None,
        skip_token: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Gets a page of NetworkManagerEffectiveSecurityAdminRules.
        :paramtype value:
         list[~azure.mgmt.network.v2021_02_01_preview.models.EffectiveBaseSecurityAdminRule]
        :keyword skip_token: When present, the value can be passed to a subsequent query call (together
         with the same query and scopes used in the current request) to retrieve the next page of data.
        :paramtype skip_token: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.skip_token = skip_token


class NetworkManagerListResult(_serialization.Model):
    """Result of the request to list NetworkManager. It contains a list of network managers and a URL link to get the next set of results.

    :ivar value: Gets a page of NetworkManager.
    :vartype value: list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManager]
    :ivar next_link: Gets the URL to get the next page of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkManager]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NetworkManager"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets a page of NetworkManager.
        :paramtype value: list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManager]
        :keyword next_link: Gets the URL to get the next page of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkManagerPropertiesNetworkManagerScopes(_serialization.Model):
    """Scope of Network Manager.

    :ivar management_groups: List of management groups.
    :vartype management_groups: list[str]
    :ivar subscriptions: List of subscriptions.
    :vartype subscriptions: list[str]
    """

    _attribute_map = {
        "management_groups": {"key": "managementGroups", "type": "[str]"},
        "subscriptions": {"key": "subscriptions", "type": "[str]"},
    }

    def __init__(
        self, *, management_groups: Optional[List[str]] = None, subscriptions: Optional[List[str]] = None, **kwargs
    ):
        """
        :keyword management_groups: List of management groups.
        :paramtype management_groups: list[str]
        :keyword subscriptions: List of subscriptions.
        :paramtype subscriptions: list[str]
        """
        super().__init__(**kwargs)
        self.management_groups = management_groups
        self.subscriptions = subscriptions


class NetworkManagerSecurityGroupItem(_serialization.Model):
    """Network manager security group item.

    :ivar network_group_id: Network manager group Id.
    :vartype network_group_id: str
    """

    _attribute_map = {
        "network_group_id": {"key": "networkGroupId", "type": "str"},
    }

    def __init__(self, *, network_group_id: Optional[str] = None, **kwargs):
        """
        :keyword network_group_id: Network manager group Id.
        :paramtype network_group_id: str
        """
        super().__init__(**kwargs)
        self.network_group_id = network_group_id


class NetworkSecurityPerimeter(Resource):
    """The Network Security Perimeter resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the scope assignment resource. Known values
     are: "Succeeded", "Creating", "Updating", "Deleting", "Accepted", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.NspProvisioningState
    :ivar perimeter_guid: perimeter guid of the network security perimeter.
    :vartype perimeter_guid: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "perimeter_guid": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "perimeter_guid": {"key": "properties.perimeterGuid", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.perimeter_guid = None


class NetworkSecurityPerimeterListResult(_serialization.Model):
    """Result of the request to list NetworkSecurityPerimeter. It contains a list of network security perimeters and a URL link to get the next set of results.

    :ivar value: Gets a page of NetworkSecurityPerimeter.
    :vartype value: list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkSecurityPerimeter]
    :ivar next_link: Gets the URL to get the next page of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkSecurityPerimeter]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkSecurityPerimeter"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Gets a page of NetworkSecurityPerimeter.
        :paramtype value: list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkSecurityPerimeter]
        :keyword next_link: Gets the URL to get the next page of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NspAccessRule(Resource):  # pylint: disable=too-many-instance-attributes
    """The NSP access rule resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the scope assignment resource. Known values
     are: "Succeeded", "Creating", "Updating", "Deleting", "Accepted", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.NspProvisioningState
    :ivar direction: Direction that specifies whether the access rules is inbound/outbound. Known
     values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.v2021_02_01_preview.models.AccessRuleDirection
    :ivar address_prefixes: Inbound address prefixes (IPv4/IPv6).
    :vartype address_prefixes: list[str]
    :ivar fully_qualified_domain_names: Outbound rules fully qualified domain name format.
    :vartype fully_qualified_domain_names: list[str]
    :ivar subscriptions: List of subscription ids.
    :vartype subscriptions: list[~azure.mgmt.network.v2021_02_01_preview.models.SubscriptionId]
    :ivar network_security_perimeters: Inbound rule specified by the perimeter id.
    :vartype network_security_perimeters:
     list[~azure.mgmt.network.v2021_02_01_preview.models.PerimeterBasedAccessRule]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "direction": {"key": "properties.direction", "type": "str"},
        "address_prefixes": {"key": "properties.addressPrefixes", "type": "[str]"},
        "fully_qualified_domain_names": {"key": "properties.fullyQualifiedDomainNames", "type": "[str]"},
        "subscriptions": {"key": "properties.subscriptions", "type": "[SubscriptionId]"},
        "network_security_perimeters": {
            "key": "properties.networkSecurityPerimeters",
            "type": "[PerimeterBasedAccessRule]",
        },
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        direction: Optional[Union[str, "_models.AccessRuleDirection"]] = None,
        address_prefixes: Optional[List[str]] = None,
        fully_qualified_domain_names: Optional[List[str]] = None,
        subscriptions: Optional[List["_models.SubscriptionId"]] = None,
        network_security_perimeters: Optional[List["_models.PerimeterBasedAccessRule"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword direction: Direction that specifies whether the access rules is inbound/outbound.
         Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.v2021_02_01_preview.models.AccessRuleDirection
        :keyword address_prefixes: Inbound address prefixes (IPv4/IPv6).
        :paramtype address_prefixes: list[str]
        :keyword fully_qualified_domain_names: Outbound rules fully qualified domain name format.
        :paramtype fully_qualified_domain_names: list[str]
        :keyword subscriptions: List of subscription ids.
        :paramtype subscriptions: list[~azure.mgmt.network.v2021_02_01_preview.models.SubscriptionId]
        :keyword network_security_perimeters: Inbound rule specified by the perimeter id.
        :paramtype network_security_perimeters:
         list[~azure.mgmt.network.v2021_02_01_preview.models.PerimeterBasedAccessRule]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.direction = direction
        self.address_prefixes = address_prefixes
        self.fully_qualified_domain_names = fully_qualified_domain_names
        self.subscriptions = subscriptions
        self.network_security_perimeters = network_security_perimeters


class NspAccessRuleListResult(_serialization.Model):
    """Result of the request to list NSP access rules. Contains a list of NSP access rules and a URL link to get the next set of results.

    :ivar value: Gets a page of NSP access rule.
    :vartype value: list[~azure.mgmt.network.v2021_02_01_preview.models.NspAccessRule]
    :ivar next_link: Gets the URL to get the next page of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NspAccessRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NspAccessRule"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets a page of NSP access rule.
        :paramtype value: list[~azure.mgmt.network.v2021_02_01_preview.models.NspAccessRule]
        :keyword next_link: Gets the URL to get the next page of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NspAssociation(Resource):
    """The NSP resource association resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar provisioning_state: The provisioning state of the resource  association resource. Known
     values are: "Succeeded", "Creating", "Updating", "Deleting", "Accepted", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.NspProvisioningState
    :ivar private_link_resource: The PaaS resource to be associated.
    :vartype private_link_resource: ~azure.mgmt.network.v2021_02_01_preview.models.SubResource
    :ivar profile: Profile id to which the PaaS resource is associated.
    :vartype profile: ~azure.mgmt.network.v2021_02_01_preview.models.SubResource
    :ivar access_mode: Access mode on the association. Known values are: "Learning", "Enforced",
     and "Audit".
    :vartype access_mode: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.AssociationAccessMode
    :ivar has_provisioning_issues: Specifies if there are provisioning issues.
    :vartype has_provisioning_issues: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
        "has_provisioning_issues": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "private_link_resource": {"key": "properties.privateLinkResource", "type": "SubResource"},
        "profile": {"key": "properties.profile", "type": "SubResource"},
        "access_mode": {"key": "properties.accessMode", "type": "str"},
        "has_provisioning_issues": {"key": "properties.hasProvisioningIssues", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        private_link_resource: Optional["_models.SubResource"] = None,
        profile: Optional["_models.SubResource"] = None,
        access_mode: Optional[Union[str, "_models.AssociationAccessMode"]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword private_link_resource: The PaaS resource to be associated.
        :paramtype private_link_resource: ~azure.mgmt.network.v2021_02_01_preview.models.SubResource
        :keyword profile: Profile id to which the PaaS resource is associated.
        :paramtype profile: ~azure.mgmt.network.v2021_02_01_preview.models.SubResource
        :keyword access_mode: Access mode on the association. Known values are: "Learning", "Enforced",
         and "Audit".
        :paramtype access_mode: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.AssociationAccessMode
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.provisioning_state = None
        self.private_link_resource = private_link_resource
        self.profile = profile
        self.access_mode = access_mode
        self.has_provisioning_issues = None


class NspAssociationsListResult(_serialization.Model):
    """Result of the request to list NSP resource associations. Contains a list of NSP resource associations and a URL link to get the next set of results.

    :ivar value: Gets a page of NSP resource associations.
    :vartype value: list[~azure.mgmt.network.v2021_02_01_preview.models.NspAssociation]
    :ivar next_link: Gets the URL to get the next page of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NspAssociation]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NspAssociation"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets a page of NSP resource associations.
        :paramtype value: list[~azure.mgmt.network.v2021_02_01_preview.models.NspAssociation]
        :keyword next_link: Gets the URL to get the next page of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NspProfile(Resource):
    """The network security perimeter profile resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar access_rules_version: Version number that increases with every update to access rules
     within the profile.
    :vartype access_rules_version: str
    :ivar diagnostic_settings_version: Version number that increases with every update to
     diagnostic settings within the profile.
    :vartype diagnostic_settings_version: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "access_rules_version": {"readonly": True},
        "diagnostic_settings_version": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "access_rules_version": {"key": "properties.accessRulesVersion", "type": "str"},
        "diagnostic_settings_version": {"key": "properties.diagnosticSettingsVersion", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.access_rules_version = None
        self.diagnostic_settings_version = None


class NspProfileListResult(_serialization.Model):
    """Result of the request to list NSP profiles. Contains a list of NSP profiles and a URL link to get the next set of results.

    :ivar value: Gets a page of NSP profile.
    :vartype value: list[~azure.mgmt.network.v2021_02_01_preview.models.NspProfile]
    :ivar next_link: Gets the URL to get the next page of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NspProfile]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.NspProfile"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: Gets a page of NSP profile.
        :paramtype value: list[~azure.mgmt.network.v2021_02_01_preview.models.NspProfile]
        :keyword next_link: Gets the URL to get the next page of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PerimeterAssociableResource(Resource):
    """Resource that is onboarded to use network security perimeter. Also referred as perimeter associable resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar display_name: A friendly name for the properties of perimeter associable resources.
    :vartype display_name: str
    :ivar resource_type: Resource type/provider name.
    :vartype resource_type: str
    :ivar public_dns_zones: Public DNS zone names of the resources.
    :vartype public_dns_zones: list[str]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "resource_type": {"readonly": True},
        "public_dns_zones": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "resource_type": {"key": "properties.resourceType", "type": "str"},
        "public_dns_zones": {"key": "properties.publicDnsZones", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        """
        :keyword id: Resource ID.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.display_name = None
        self.resource_type = None
        self.public_dns_zones = None


class PerimeterAssociableResourcesListResult(_serialization.Model):
    """Paged list of perimeter associable resources.

    :ivar value: Gets paged list of perimeter associable resources.
    :vartype value:
     list[~azure.mgmt.network.v2021_02_01_preview.models.PerimeterAssociableResource]
    :ivar next_link: Gets the URL to get the next page of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PerimeterAssociableResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.PerimeterAssociableResource"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Gets paged list of perimeter associable resources.
        :paramtype value:
         list[~azure.mgmt.network.v2021_02_01_preview.models.PerimeterAssociableResource]
        :keyword next_link: Gets the URL to get the next page of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class PerimeterBasedAccessRule(_serialization.Model):
    """PerimeterBasedAccessRule.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: NSP id in the ARM id format.
    :vartype id: str
    :ivar perimeter_guid: Resource guid of the NSP supplied.
    :vartype perimeter_guid: str
    :ivar location: Location of the NSP supplied.
    :vartype location: str
    """

    _validation = {
        "perimeter_guid": {"readonly": True},
        "location": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "perimeter_guid": {"key": "perimeterGuid", "type": "str"},
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: NSP id in the ARM id format.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.perimeter_guid = None
        self.location = None


class QueryRequestOptions(_serialization.Model):
    """Query Request Options.

    :ivar skip_token: When present, the value can be passed to a subsequent query call (together
     with the same query and scopes used in the current request) to retrieve the next page of data.
    :vartype skip_token: str
    """

    _attribute_map = {
        "skip_token": {"key": "skipToken", "type": "str"},
    }

    def __init__(self, *, skip_token: Optional[str] = None, **kwargs):
        """
        :keyword skip_token: When present, the value can be passed to a subsequent query call (together
         with the same query and scopes used in the current request) to retrieve the next page of data.
        :paramtype skip_token: str
        """
        super().__init__(**kwargs)
        self.skip_token = skip_token


class RuleCollection(ProxyResource):
    """Defines the rule collection.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :ivar display_name: A display name of the rule collection.
    :vartype display_name: str
    :ivar description: A description of the rule collection.
    :vartype description: str
    :ivar applies_to_groups: Groups for configuration.
    :vartype applies_to_groups:
     list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "applies_to_groups": {"key": "properties.appliesToGroups", "type": "[NetworkManagerSecurityGroupItem]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        applies_to_groups: Optional[List["_models.NetworkManagerSecurityGroupItem"]] = None,
        **kwargs
    ):
        """
        :keyword display_name: A display name of the rule collection.
        :paramtype display_name: str
        :keyword description: A description of the rule collection.
        :paramtype description: str
        :keyword applies_to_groups: Groups for configuration.
        :paramtype applies_to_groups:
         list[~azure.mgmt.network.v2021_02_01_preview.models.NetworkManagerSecurityGroupItem]
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.display_name = display_name
        self.description = description
        self.applies_to_groups = applies_to_groups
        self.provisioning_state = None


class RuleCollectionListResult(_serialization.Model):
    """Security configuration rule collection list result.

    :ivar value: A list of network manager security configuration rule collections.
    :vartype value: list[~azure.mgmt.network.v2021_02_01_preview.models.RuleCollection]
    :ivar next_link: Gets the URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RuleCollection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RuleCollection"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of network manager security configuration rule collections.
        :paramtype value: list[~azure.mgmt.network.v2021_02_01_preview.models.RuleCollection]
        :keyword next_link: Gets the URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SecurityConfiguration(ProxyResource):
    """Defines the security configuration.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :ivar display_name: A display name of the security configuration.
    :vartype display_name: str
    :ivar description: A description of the security configuration.
    :vartype description: str
    :ivar security_type: Security Type. Known values are: "AdminPolicy" and "UserPolicy".
    :vartype security_type: str or ~azure.mgmt.network.v2021_02_01_preview.models.SecurityType
    :ivar delete_existing_ns_gs: Flag if need to delete existing network security groups. Known
     values are: "False" and "True".
    :vartype delete_existing_ns_gs: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.DeleteExistingNSGs
    :ivar provisioning_state: The provisioning state of the resource. Known values are:
     "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "security_type": {"key": "properties.securityType", "type": "str"},
        "delete_existing_ns_gs": {"key": "properties.deleteExistingNSGs", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        security_type: Optional[Union[str, "_models.SecurityType"]] = None,
        delete_existing_ns_gs: Optional[Union[str, "_models.DeleteExistingNSGs"]] = None,
        **kwargs
    ):
        """
        :keyword display_name: A display name of the security configuration.
        :paramtype display_name: str
        :keyword description: A description of the security configuration.
        :paramtype description: str
        :keyword security_type: Security Type. Known values are: "AdminPolicy" and "UserPolicy".
        :paramtype security_type: str or ~azure.mgmt.network.v2021_02_01_preview.models.SecurityType
        :keyword delete_existing_ns_gs: Flag if need to delete existing network security groups. Known
         values are: "False" and "True".
        :paramtype delete_existing_ns_gs: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.DeleteExistingNSGs
        """
        super().__init__(**kwargs)
        self.system_data = None
        self.display_name = display_name
        self.description = description
        self.security_type = security_type
        self.delete_existing_ns_gs = delete_existing_ns_gs
        self.provisioning_state = None


class SecurityConfigurationListResult(_serialization.Model):
    """A list of network manager security configurations.

    :ivar value: Gets a page of security configurations.
    :vartype value: list[~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfiguration]
    :ivar next_link: Gets the URL to get the next page of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityConfiguration]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.SecurityConfiguration"]] = None,
        next_link: Optional[str] = None,
        **kwargs
    ):
        """
        :keyword value: Gets a page of security configurations.
        :paramtype value: list[~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfiguration]
        :keyword next_link: Gets the URL to get the next page of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SubResource(_serialization.Model):
    """Reference to another subresource.

    :ivar id: Resource ID.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource ID.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SubscriptionId(_serialization.Model):
    """SubscriptionId.

    :ivar id: Subscription id in the ARM id format.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs):  # pylint: disable=redefined-builtin
        """
        :keyword id: Subscription id in the ARM id format.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class SystemData(_serialization.Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.network.v2021_02_01_preview.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.CreatedByType
    :ivar last_modified_at: The type of identity that last modified the resource.
    :vartype last_modified_at: ~datetime.datetime
    """

    _attribute_map = {
        "created_by": {"key": "createdBy", "type": "str"},
        "created_by_type": {"key": "createdByType", "type": "str"},
        "created_at": {"key": "createdAt", "type": "iso-8601"},
        "last_modified_by": {"key": "lastModifiedBy", "type": "str"},
        "last_modified_by_type": {"key": "lastModifiedByType", "type": "str"},
        "last_modified_at": {"key": "lastModifiedAt", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
        **kwargs
    ):
        """
        :keyword created_by: The identity that created the resource.
        :paramtype created_by: str
        :keyword created_by_type: The type of identity that created the resource. Known values are:
         "User", "Application", "ManagedIdentity", and "Key".
        :paramtype created_by_type: str or ~azure.mgmt.network.v2021_02_01_preview.models.CreatedByType
        :keyword created_at: The timestamp of resource creation (UTC).
        :paramtype created_at: ~datetime.datetime
        :keyword last_modified_by: The identity that last modified the resource.
        :paramtype last_modified_by: str
        :keyword last_modified_by_type: The type of identity that last modified the resource. Known
         values are: "User", "Application", "ManagedIdentity", and "Key".
        :paramtype last_modified_by_type: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.CreatedByType
        :keyword last_modified_at: The type of identity that last modified the resource.
        :paramtype last_modified_at: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.created_by = created_by
        self.created_by_type = created_by_type
        self.created_at = created_at
        self.last_modified_by = last_modified_by
        self.last_modified_by_type = last_modified_by_type
        self.last_modified_at = last_modified_at


class TagsObject(_serialization.Model):
    """Tags object for patch operations.

    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _attribute_map = {
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(self, *, tags: Optional[Dict[str, str]] = None, **kwargs):
        """
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.tags = tags


class UserRule(BaseUserRule):  # pylint: disable=too-many-instance-attributes
    """Network security user rule.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar kind: Whether the rule is custom or default. Required. Known values are: "Custom" and
     "Default".
    :vartype kind: str or ~azure.mgmt.network.v2021_02_01_preview.models.UserRuleKind
    :ivar system_data: The system metadata related to this resource.
    :vartype system_data: ~azure.mgmt.network.v2021_02_01_preview.models.SystemData
    :ivar display_name: A friendly name for the rule.
    :vartype display_name: str
    :ivar description: A description for this rule.
    :vartype description: str
    :ivar protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp", "Icmp",
     "Esp", "Any", and "Ah".
    :vartype protocol: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
    :ivar sources: The CIDR or source IP ranges.
    :vartype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar destinations: The destination address prefixes. CIDR or destination IP ranges.
    :vartype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
    :ivar source_port_ranges: The source port ranges.
    :vartype source_port_ranges: list[str]
    :ivar destination_port_ranges: The destination port ranges.
    :vartype destination_port_ranges: list[str]
    :ivar direction: Indicates if the traffic matched against the rule in inbound or outbound.
     Known values are: "Inbound" and "Outbound".
    :vartype direction: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
    :ivar provisioning_state: The provisioning state of the security configuration user rule
     resource. Known values are: "Succeeded", "Updating", "Deleting", and "Failed".
    :vartype provisioning_state: str or
     ~azure.mgmt.network.v2021_02_01_preview.models.ProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "etag": {"readonly": True},
        "kind": {"required": True},
        "system_data": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "system_data": {"key": "systemData", "type": "SystemData"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "sources": {"key": "properties.sources", "type": "[AddressPrefixItem]"},
        "destinations": {"key": "properties.destinations", "type": "[AddressPrefixItem]"},
        "source_port_ranges": {"key": "properties.sourcePortRanges", "type": "[str]"},
        "destination_port_ranges": {"key": "properties.destinationPortRanges", "type": "[str]"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "_models.SecurityConfigurationRuleProtocol"]] = None,
        sources: Optional[List["_models.AddressPrefixItem"]] = None,
        destinations: Optional[List["_models.AddressPrefixItem"]] = None,
        source_port_ranges: Optional[List[str]] = None,
        destination_port_ranges: Optional[List[str]] = None,
        direction: Optional[Union[str, "_models.SecurityConfigurationRuleDirection"]] = None,
        **kwargs
    ):
        """
        :keyword display_name: A friendly name for the rule.
        :paramtype display_name: str
        :keyword description: A description for this rule.
        :paramtype description: str
        :keyword protocol: Network protocol this rule applies to. Known values are: "Tcp", "Udp",
         "Icmp", "Esp", "Any", and "Ah".
        :paramtype protocol: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleProtocol
        :keyword sources: The CIDR or source IP ranges.
        :paramtype sources: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
        :keyword destinations: The destination address prefixes. CIDR or destination IP ranges.
        :paramtype destinations: list[~azure.mgmt.network.v2021_02_01_preview.models.AddressPrefixItem]
        :keyword source_port_ranges: The source port ranges.
        :paramtype source_port_ranges: list[str]
        :keyword destination_port_ranges: The destination port ranges.
        :paramtype destination_port_ranges: list[str]
        :keyword direction: Indicates if the traffic matched against the rule in inbound or outbound.
         Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or
         ~azure.mgmt.network.v2021_02_01_preview.models.SecurityConfigurationRuleDirection
        """
        super().__init__(**kwargs)
        self.kind = "Custom"  # type: str
        self.display_name = display_name
        self.description = description
        self.protocol = protocol
        self.sources = sources
        self.destinations = destinations
        self.source_port_ranges = source_port_ranges
        self.destination_port_ranges = destination_port_ranges
        self.direction = direction
        self.provisioning_state = None


class UserRuleListResult(_serialization.Model):
    """security user rule list result.

    :ivar value: A list of user rules.
    :vartype value: list[~azure.mgmt.network.v2021_02_01_preview.models.BaseUserRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[BaseUserRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.BaseUserRule"]] = None, next_link: Optional[str] = None, **kwargs
    ):
        """
        :keyword value: A list of user rules.
        :paramtype value: list[~azure.mgmt.network.v2021_02_01_preview.models.BaseUserRule]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link
