# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!

import grpc

from google.cloud.secretmanager_v1beta1.proto import (
    resources_pb2 as google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2,
)
from google.cloud.secretmanager_v1beta1.proto import (
    service_pb2 as google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2,
)
from google.iam.v1 import iam_policy_pb2 as google_dot_iam_dot_v1_dot_iam__policy__pb2
from google.iam.v1 import policy_pb2 as google_dot_iam_dot_v1_dot_policy__pb2
from google.protobuf import empty_pb2 as google_dot_protobuf_dot_empty__pb2


class SecretManagerServiceStub(object):
    """`projects/*/secrets/*/versions/latest` is an alias to the `latest`
  [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].

  Secret Manager Service

  Manages secrets and operations using those secrets. Implements a REST
  model with the following objects:

  * [Secret][google.cloud.secrets.v1beta1.Secret]
  * [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion]
  """

    def __init__(self, channel):
        """Constructor.

    Args:
      channel: A grpc.Channel.
    """
        self.ListSecrets = channel.unary_unary(
            "/google.cloud.secrets.v1beta1.SecretManagerService/ListSecrets",
            request_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.ListSecretsRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.ListSecretsResponse.FromString,
        )
        self.CreateSecret = channel.unary_unary(
            "/google.cloud.secrets.v1beta1.SecretManagerService/CreateSecret",
            request_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.CreateSecretRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2.Secret.FromString,
        )
        self.AddSecretVersion = channel.unary_unary(
            "/google.cloud.secrets.v1beta1.SecretManagerService/AddSecretVersion",
            request_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.AddSecretVersionRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2.SecretVersion.FromString,
        )
        self.GetSecret = channel.unary_unary(
            "/google.cloud.secrets.v1beta1.SecretManagerService/GetSecret",
            request_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.GetSecretRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2.Secret.FromString,
        )
        self.UpdateSecret = channel.unary_unary(
            "/google.cloud.secrets.v1beta1.SecretManagerService/UpdateSecret",
            request_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.UpdateSecretRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2.Secret.FromString,
        )
        self.DeleteSecret = channel.unary_unary(
            "/google.cloud.secrets.v1beta1.SecretManagerService/DeleteSecret",
            request_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.DeleteSecretRequest.SerializeToString,
            response_deserializer=google_dot_protobuf_dot_empty__pb2.Empty.FromString,
        )
        self.ListSecretVersions = channel.unary_unary(
            "/google.cloud.secrets.v1beta1.SecretManagerService/ListSecretVersions",
            request_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.ListSecretVersionsRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.ListSecretVersionsResponse.FromString,
        )
        self.GetSecretVersion = channel.unary_unary(
            "/google.cloud.secrets.v1beta1.SecretManagerService/GetSecretVersion",
            request_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.GetSecretVersionRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2.SecretVersion.FromString,
        )
        self.AccessSecretVersion = channel.unary_unary(
            "/google.cloud.secrets.v1beta1.SecretManagerService/AccessSecretVersion",
            request_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.AccessSecretVersionRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.AccessSecretVersionResponse.FromString,
        )
        self.DisableSecretVersion = channel.unary_unary(
            "/google.cloud.secrets.v1beta1.SecretManagerService/DisableSecretVersion",
            request_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.DisableSecretVersionRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2.SecretVersion.FromString,
        )
        self.EnableSecretVersion = channel.unary_unary(
            "/google.cloud.secrets.v1beta1.SecretManagerService/EnableSecretVersion",
            request_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.EnableSecretVersionRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2.SecretVersion.FromString,
        )
        self.DestroySecretVersion = channel.unary_unary(
            "/google.cloud.secrets.v1beta1.SecretManagerService/DestroySecretVersion",
            request_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.DestroySecretVersionRequest.SerializeToString,
            response_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2.SecretVersion.FromString,
        )
        self.SetIamPolicy = channel.unary_unary(
            "/google.cloud.secrets.v1beta1.SecretManagerService/SetIamPolicy",
            request_serializer=google_dot_iam_dot_v1_dot_iam__policy__pb2.SetIamPolicyRequest.SerializeToString,
            response_deserializer=google_dot_iam_dot_v1_dot_policy__pb2.Policy.FromString,
        )
        self.GetIamPolicy = channel.unary_unary(
            "/google.cloud.secrets.v1beta1.SecretManagerService/GetIamPolicy",
            request_serializer=google_dot_iam_dot_v1_dot_iam__policy__pb2.GetIamPolicyRequest.SerializeToString,
            response_deserializer=google_dot_iam_dot_v1_dot_policy__pb2.Policy.FromString,
        )
        self.TestIamPermissions = channel.unary_unary(
            "/google.cloud.secrets.v1beta1.SecretManagerService/TestIamPermissions",
            request_serializer=google_dot_iam_dot_v1_dot_iam__policy__pb2.TestIamPermissionsRequest.SerializeToString,
            response_deserializer=google_dot_iam_dot_v1_dot_iam__policy__pb2.TestIamPermissionsResponse.FromString,
        )


class SecretManagerServiceServicer(object):
    """`projects/*/secrets/*/versions/latest` is an alias to the `latest`
  [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].

  Secret Manager Service

  Manages secrets and operations using those secrets. Implements a REST
  model with the following objects:

  * [Secret][google.cloud.secrets.v1beta1.Secret]
  * [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion]
  """

    def ListSecrets(self, request, context):
        """Lists [Secrets][google.cloud.secrets.v1beta1.Secret].
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def CreateSecret(self, request, context):
        """Creates a new [Secret][google.cloud.secrets.v1beta1.Secret] containing no [SecretVersions][google.cloud.secrets.v1beta1.SecretVersion].
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def AddSecretVersion(self, request, context):
        """Creates a new [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] containing secret data and attaches
    it to an existing [Secret][google.cloud.secrets.v1beta1.Secret].
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def GetSecret(self, request, context):
        """Gets metadata for a given [Secret][google.cloud.secrets.v1beta1.Secret].
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def UpdateSecret(self, request, context):
        """Updates metadata of an existing [Secret][google.cloud.secrets.v1beta1.Secret].
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def DeleteSecret(self, request, context):
        """Deletes a [Secret][google.cloud.secrets.v1beta1.Secret].
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def ListSecretVersions(self, request, context):
        """Lists [SecretVersions][google.cloud.secrets.v1beta1.SecretVersion]. This call does not return secret
    data.
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def GetSecretVersion(self, request, context):
        """Gets metadata for a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].

    `projects/*/secrets/*/versions/latest` is an alias to the `latest`
    [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def AccessSecretVersion(self, request, context):
        """Accesses a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion]. This call returns the secret data.

    `projects/*/secrets/*/versions/latest` is an alias to the `latest`
    [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def DisableSecretVersion(self, request, context):
        """Disables a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].

    Sets the [state][google.cloud.secrets.v1beta1.SecretVersion.state] of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] to
    [DISABLED][google.cloud.secrets.v1beta1.SecretVersion.State.DISABLED].
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def EnableSecretVersion(self, request, context):
        """Enables a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].

    Sets the [state][google.cloud.secrets.v1beta1.SecretVersion.state] of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] to
    [ENABLED][google.cloud.secrets.v1beta1.SecretVersion.State.ENABLED].
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def DestroySecretVersion(self, request, context):
        """Destroys a [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion].

    Sets the [state][google.cloud.secrets.v1beta1.SecretVersion.state] of the [SecretVersion][google.cloud.secrets.v1beta1.SecretVersion] to
    [DESTROYED][google.cloud.secrets.v1beta1.SecretVersion.State.DESTROYED] and irrevocably destroys the
    secret data.
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def SetIamPolicy(self, request, context):
        """Sets the access control policy on the specified secret. Replaces any
    existing policy.

    Permissions on [SecretVersions][google.cloud.secrets.v1beta1.SecretVersion] are enforced according
    to the policy set on the associated [Secret][google.cloud.secrets.v1beta1.Secret].
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def GetIamPolicy(self, request, context):
        """Gets the access control policy for a secret.
    Returns empty policy if the secret exists and does not have a policy set.
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")

    def TestIamPermissions(self, request, context):
        """Returns permissions that a caller has for the specified secret.
    If the secret does not exist, this call returns an empty set of
    permissions, not a NOT_FOUND error.

    Note: This operation is designed to be used for building permission-aware
    UIs and command-line tools, not for authorization checking. This operation
    may "fail open" without warning.
    """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details("Method not implemented!")
        raise NotImplementedError("Method not implemented!")


def add_SecretManagerServiceServicer_to_server(servicer, server):
    rpc_method_handlers = {
        "ListSecrets": grpc.unary_unary_rpc_method_handler(
            servicer.ListSecrets,
            request_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.ListSecretsRequest.FromString,
            response_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.ListSecretsResponse.SerializeToString,
        ),
        "CreateSecret": grpc.unary_unary_rpc_method_handler(
            servicer.CreateSecret,
            request_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.CreateSecretRequest.FromString,
            response_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2.Secret.SerializeToString,
        ),
        "AddSecretVersion": grpc.unary_unary_rpc_method_handler(
            servicer.AddSecretVersion,
            request_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.AddSecretVersionRequest.FromString,
            response_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2.SecretVersion.SerializeToString,
        ),
        "GetSecret": grpc.unary_unary_rpc_method_handler(
            servicer.GetSecret,
            request_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.GetSecretRequest.FromString,
            response_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2.Secret.SerializeToString,
        ),
        "UpdateSecret": grpc.unary_unary_rpc_method_handler(
            servicer.UpdateSecret,
            request_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.UpdateSecretRequest.FromString,
            response_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2.Secret.SerializeToString,
        ),
        "DeleteSecret": grpc.unary_unary_rpc_method_handler(
            servicer.DeleteSecret,
            request_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.DeleteSecretRequest.FromString,
            response_serializer=google_dot_protobuf_dot_empty__pb2.Empty.SerializeToString,
        ),
        "ListSecretVersions": grpc.unary_unary_rpc_method_handler(
            servicer.ListSecretVersions,
            request_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.ListSecretVersionsRequest.FromString,
            response_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.ListSecretVersionsResponse.SerializeToString,
        ),
        "GetSecretVersion": grpc.unary_unary_rpc_method_handler(
            servicer.GetSecretVersion,
            request_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.GetSecretVersionRequest.FromString,
            response_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2.SecretVersion.SerializeToString,
        ),
        "AccessSecretVersion": grpc.unary_unary_rpc_method_handler(
            servicer.AccessSecretVersion,
            request_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.AccessSecretVersionRequest.FromString,
            response_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.AccessSecretVersionResponse.SerializeToString,
        ),
        "DisableSecretVersion": grpc.unary_unary_rpc_method_handler(
            servicer.DisableSecretVersion,
            request_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.DisableSecretVersionRequest.FromString,
            response_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2.SecretVersion.SerializeToString,
        ),
        "EnableSecretVersion": grpc.unary_unary_rpc_method_handler(
            servicer.EnableSecretVersion,
            request_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.EnableSecretVersionRequest.FromString,
            response_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2.SecretVersion.SerializeToString,
        ),
        "DestroySecretVersion": grpc.unary_unary_rpc_method_handler(
            servicer.DestroySecretVersion,
            request_deserializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_service__pb2.DestroySecretVersionRequest.FromString,
            response_serializer=google_dot_cloud_dot_secrets__v1beta1_dot_proto_dot_resources__pb2.SecretVersion.SerializeToString,
        ),
        "SetIamPolicy": grpc.unary_unary_rpc_method_handler(
            servicer.SetIamPolicy,
            request_deserializer=google_dot_iam_dot_v1_dot_iam__policy__pb2.SetIamPolicyRequest.FromString,
            response_serializer=google_dot_iam_dot_v1_dot_policy__pb2.Policy.SerializeToString,
        ),
        "GetIamPolicy": grpc.unary_unary_rpc_method_handler(
            servicer.GetIamPolicy,
            request_deserializer=google_dot_iam_dot_v1_dot_iam__policy__pb2.GetIamPolicyRequest.FromString,
            response_serializer=google_dot_iam_dot_v1_dot_policy__pb2.Policy.SerializeToString,
        ),
        "TestIamPermissions": grpc.unary_unary_rpc_method_handler(
            servicer.TestIamPermissions,
            request_deserializer=google_dot_iam_dot_v1_dot_iam__policy__pb2.TestIamPermissionsRequest.FromString,
            response_serializer=google_dot_iam_dot_v1_dot_iam__policy__pb2.TestIamPermissionsResponse.SerializeToString,
        ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
        "google.cloud.secrets.v1beta1.SecretManagerService", rpc_method_handlers
    )
    server.add_generic_rpc_handlers((generic_handler,))
