#!/usr/bin/env python3
# --------------------( LICENSE                            )--------------------
# Copyright (c) 2014-2023 Beartype authors.
# See "LICENSE" for further details.

'''
Project-wide **type-checking function code snippets** (i.e., triple-quoted
pure-Python string constants formatted and concatenated together to dynamically
generate the implementations of functions type-checking arbitrary objects
against arbitrary PEP-compliant type hints).

This private submodule is *not* intended for importation by downstream callers.
'''

# ....................{ IMPORTS                            }....................
from beartype._check.checkmagic import (
    VAR_NAME_PITH_ROOT,
)

# ....................{ CODE ~ signature                   }....................
FUNC_TESTER_CODE_SIGNATURE = f'''{{code_signature_prefix}}def {{func_name}}(
    {VAR_NAME_PITH_ROOT}: object,
{{code_signature_args}}
) -> bool:'''
'''
Code snippet declaring the signature of all type-checking tester functions
created by the :func:`beartype._check.checkmagic.make_func_tester` factory.

Note that:

* This signature intentionally names the single public parameter accepted by
  this tester function ``{VAR_NAME_PITH_ROOT}``. Doing so trivially ensures that
  the memoized type-checking boolean expression generated by the
  :func:`beartype._check.expr.exprmake.make_check_expr` code factory implicitly
  type-checks the passed object *without* further modification (e.g., global
  search-and-replacement), ensuring that memoized expression may be efficiently
  reused as is *without* subsequent unmemoization. Clever, huh? Yeah... we know.
* ``code_signature_prefix`` is usually either:

  * For synchronous callables, the empty string.
  * For asynchronous callables (e.g., asynchronous generators, coroutines),
    the space-suffixed keyword ``"async "``.
'''

# ....................{ CODE ~ return                      }....................
FUNC_TESTER_CODE_RETURN = '''
    # Return true only if the passed object satisfies this type hint.
    return {code_check_expr}'''
'''
Code snippet returning the boolean result of type-checking the arbitrary object
passed to a type-checking tester function against the type hint passed to the
factory function creating that tester function.
'''
