# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AddressSpace(_serialization.Model):
    """AddressSpace contains an array of IP address ranges that can be used by subnets of the virtual
    network.

    :ivar address_prefixes: A list of address blocks reserved for this virtual network in CIDR
     notation.
    :vartype address_prefixes: list[str]
    """

    _attribute_map = {
        "address_prefixes": {"key": "addressPrefixes", "type": "[str]"},
    }

    def __init__(self, *, address_prefixes: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword address_prefixes: A list of address blocks reserved for this virtual network in CIDR
         notation.
        :paramtype address_prefixes: list[str]
        """
        super().__init__(**kwargs)
        self.address_prefixes = address_prefixes


class Resource(_serialization.Model):
    """Azure resource manager resource properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        """
        super().__init__(**kwargs)
        self.id = id
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class ApplicationGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """Application gateway resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar sku: SKU of the application gateway resource.
    :vartype sku: ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewaySku
    :ivar operational_state: Operational state of the application gateway resource. Possible values
     are: 'Stopped', 'Started', 'Running', and 'Stopping'. Known values are: "Stopped", "Starting",
     "Running", and "Stopping".
    :vartype operational_state: str or
     ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayOperationalState
    :ivar gateway_ip_configurations: Gets or sets subnets of application gateway resource.
    :vartype gateway_ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayIPConfiguration]
    :ivar ssl_certificates: SSL certificates of the application gateway resource.
    :vartype ssl_certificates:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewaySslCertificate]
    :ivar frontend_ip_configurations: Frontend IP addresses of the application gateway resource.
    :vartype frontend_ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayFrontendIPConfiguration]
    :ivar frontend_ports: Frontend ports of the application gateway resource.
    :vartype frontend_ports:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayFrontendPort]
    :ivar probes: Probes of the application gateway resource.
    :vartype probes: list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayProbe]
    :ivar backend_address_pools: Backend address pool of the application gateway resource.
    :vartype backend_address_pools:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayBackendAddressPool]
    :ivar backend_http_settings_collection: Backend http settings of the application gateway
     resource.
    :vartype backend_http_settings_collection:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayBackendHttpSettings]
    :ivar http_listeners: Http listeners of the application gateway resource.
    :vartype http_listeners:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayHttpListener]
    :ivar url_path_maps: URL path map of the application gateway resource.
    :vartype url_path_maps:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayUrlPathMap]
    :ivar request_routing_rules: Request routing rules of the application gateway resource.
    :vartype request_routing_rules:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayRequestRoutingRule]
    :ivar resource_guid: Resource GUID property of the application gateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: Provisioning state of the application gateway resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
        "operational_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "sku": {"key": "properties.sku", "type": "ApplicationGatewaySku"},
        "operational_state": {"key": "properties.operationalState", "type": "str"},
        "gateway_ip_configurations": {
            "key": "properties.gatewayIPConfigurations",
            "type": "[ApplicationGatewayIPConfiguration]",
        },
        "ssl_certificates": {"key": "properties.sslCertificates", "type": "[ApplicationGatewaySslCertificate]"},
        "frontend_ip_configurations": {
            "key": "properties.frontendIPConfigurations",
            "type": "[ApplicationGatewayFrontendIPConfiguration]",
        },
        "frontend_ports": {"key": "properties.frontendPorts", "type": "[ApplicationGatewayFrontendPort]"},
        "probes": {"key": "properties.probes", "type": "[ApplicationGatewayProbe]"},
        "backend_address_pools": {
            "key": "properties.backendAddressPools",
            "type": "[ApplicationGatewayBackendAddressPool]",
        },
        "backend_http_settings_collection": {
            "key": "properties.backendHttpSettingsCollection",
            "type": "[ApplicationGatewayBackendHttpSettings]",
        },
        "http_listeners": {"key": "properties.httpListeners", "type": "[ApplicationGatewayHttpListener]"},
        "url_path_maps": {"key": "properties.urlPathMaps", "type": "[ApplicationGatewayUrlPathMap]"},
        "request_routing_rules": {
            "key": "properties.requestRoutingRules",
            "type": "[ApplicationGatewayRequestRoutingRule]",
        },
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        sku: Optional["_models.ApplicationGatewaySku"] = None,
        gateway_ip_configurations: Optional[List["_models.ApplicationGatewayIPConfiguration"]] = None,
        ssl_certificates: Optional[List["_models.ApplicationGatewaySslCertificate"]] = None,
        frontend_ip_configurations: Optional[List["_models.ApplicationGatewayFrontendIPConfiguration"]] = None,
        frontend_ports: Optional[List["_models.ApplicationGatewayFrontendPort"]] = None,
        probes: Optional[List["_models.ApplicationGatewayProbe"]] = None,
        backend_address_pools: Optional[List["_models.ApplicationGatewayBackendAddressPool"]] = None,
        backend_http_settings_collection: Optional[List["_models.ApplicationGatewayBackendHttpSettings"]] = None,
        http_listeners: Optional[List["_models.ApplicationGatewayHttpListener"]] = None,
        url_path_maps: Optional[List["_models.ApplicationGatewayUrlPathMap"]] = None,
        request_routing_rules: Optional[List["_models.ApplicationGatewayRequestRoutingRule"]] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword sku: SKU of the application gateway resource.
        :paramtype sku: ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewaySku
        :keyword gateway_ip_configurations: Gets or sets subnets of application gateway resource.
        :paramtype gateway_ip_configurations:
         list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayIPConfiguration]
        :keyword ssl_certificates: SSL certificates of the application gateway resource.
        :paramtype ssl_certificates:
         list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewaySslCertificate]
        :keyword frontend_ip_configurations: Frontend IP addresses of the application gateway resource.
        :paramtype frontend_ip_configurations:
         list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayFrontendIPConfiguration]
        :keyword frontend_ports: Frontend ports of the application gateway resource.
        :paramtype frontend_ports:
         list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayFrontendPort]
        :keyword probes: Probes of the application gateway resource.
        :paramtype probes: list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayProbe]
        :keyword backend_address_pools: Backend address pool of the application gateway resource.
        :paramtype backend_address_pools:
         list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayBackendAddressPool]
        :keyword backend_http_settings_collection: Backend http settings of the application gateway
         resource.
        :paramtype backend_http_settings_collection:
         list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayBackendHttpSettings]
        :keyword http_listeners: Http listeners of the application gateway resource.
        :paramtype http_listeners:
         list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayHttpListener]
        :keyword url_path_maps: URL path map of the application gateway resource.
        :paramtype url_path_maps:
         list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayUrlPathMap]
        :keyword request_routing_rules: Request routing rules of the application gateway resource.
        :paramtype request_routing_rules:
         list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayRequestRoutingRule]
        :keyword resource_guid: Resource GUID property of the application gateway resource.
        :paramtype resource_guid: str
        :keyword provisioning_state: Provisioning state of the application gateway resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.sku = sku
        self.operational_state = None
        self.gateway_ip_configurations = gateway_ip_configurations
        self.ssl_certificates = ssl_certificates
        self.frontend_ip_configurations = frontend_ip_configurations
        self.frontend_ports = frontend_ports
        self.probes = probes
        self.backend_address_pools = backend_address_pools
        self.backend_http_settings_collection = backend_http_settings_collection
        self.http_listeners = http_listeners
        self.url_path_maps = url_path_maps
        self.request_routing_rules = request_routing_rules
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class ApplicationGatewayBackendAddress(_serialization.Model):
    """Backend address of an application gateway.

    :ivar fqdn: Fully qualified domain name (FQDN).
    :vartype fqdn: str
    :ivar ip_address: IP address.
    :vartype ip_address: str
    """

    _attribute_map = {
        "fqdn": {"key": "fqdn", "type": "str"},
        "ip_address": {"key": "ipAddress", "type": "str"},
    }

    def __init__(self, *, fqdn: Optional[str] = None, ip_address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword fqdn: Fully qualified domain name (FQDN).
        :paramtype fqdn: str
        :keyword ip_address: IP address.
        :paramtype ip_address: str
        """
        super().__init__(**kwargs)
        self.fqdn = fqdn
        self.ip_address = ip_address


class SubResource(_serialization.Model):
    """Azure resource manager sub resource properties.

    :ivar id: Resource Identifier.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class ApplicationGatewayBackendAddressPool(SubResource):
    """Backend Address Pool of an application gateway.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Resource that is unique within a resource group. This name can be used to access
     the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar backend_ip_configurations: Collection of references to IPs defined in network interfaces.
    :vartype backend_ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceIPConfiguration]
    :ivar backend_addresses: Backend addresses.
    :vartype backend_addresses:
     list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayBackendAddress]
    :ivar provisioning_state: Provisioning state of the backend address pool resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "backend_ip_configurations": {
            "key": "properties.backendIPConfigurations",
            "type": "[NetworkInterfaceIPConfiguration]",
        },
        "backend_addresses": {"key": "properties.backendAddresses", "type": "[ApplicationGatewayBackendAddress]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        backend_ip_configurations: Optional[List["_models.NetworkInterfaceIPConfiguration"]] = None,
        backend_addresses: Optional[List["_models.ApplicationGatewayBackendAddress"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: Resource that is unique within a resource group. This name can be used to access
         the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword backend_ip_configurations: Collection of references to IPs defined in network
         interfaces.
        :paramtype backend_ip_configurations:
         list[~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceIPConfiguration]
        :keyword backend_addresses: Backend addresses.
        :paramtype backend_addresses:
         list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayBackendAddress]
        :keyword provisioning_state: Provisioning state of the backend address pool resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.backend_ip_configurations = backend_ip_configurations
        self.backend_addresses = backend_addresses
        self.provisioning_state = provisioning_state


class ApplicationGatewayBackendHttpSettings(SubResource):
    """Backend address pool settings of an application gateway.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar port: Port.
    :vartype port: int
    :ivar protocol: Protocol. Possible values are: 'Http' and 'Https'. Known values are: "Http" and
     "Https".
    :vartype protocol: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayProtocol
    :ivar cookie_based_affinity: Cookie based affinity. Possible values are: 'Enabled' and
     'Disabled'. Known values are: "Enabled" and "Disabled".
    :vartype cookie_based_affinity: str or
     ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayCookieBasedAffinity
    :ivar request_timeout: Request timeout in seconds. Application Gateway will fail the request if
     response is not received within RequestTimeout. Acceptable values are from 1 second to 86400
     seconds.
    :vartype request_timeout: int
    :ivar probe: Probe resource of an application gateway.
    :vartype probe: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar provisioning_state: Gets or sets Provisioning state of the backend http settings resource
     Updating/Deleting/Failed.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "cookie_based_affinity": {"key": "properties.cookieBasedAffinity", "type": "str"},
        "request_timeout": {"key": "properties.requestTimeout", "type": "int"},
        "probe": {"key": "properties.probe", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        port: Optional[int] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        cookie_based_affinity: Optional[Union[str, "_models.ApplicationGatewayCookieBasedAffinity"]] = None,
        request_timeout: Optional[int] = None,
        probe: Optional["_models.SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword port: Port.
        :paramtype port: int
        :keyword protocol: Protocol. Possible values are: 'Http' and 'Https'. Known values are: "Http"
         and "Https".
        :paramtype protocol: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayProtocol
        :keyword cookie_based_affinity: Cookie based affinity. Possible values are: 'Enabled' and
         'Disabled'. Known values are: "Enabled" and "Disabled".
        :paramtype cookie_based_affinity: str or
         ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayCookieBasedAffinity
        :keyword request_timeout: Request timeout in seconds. Application Gateway will fail the request
         if response is not received within RequestTimeout. Acceptable values are from 1 second to 86400
         seconds.
        :paramtype request_timeout: int
        :keyword probe: Probe resource of an application gateway.
        :paramtype probe: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword provisioning_state: Gets or sets Provisioning state of the backend http settings
         resource Updating/Deleting/Failed.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.port = port
        self.protocol = protocol
        self.cookie_based_affinity = cookie_based_affinity
        self.request_timeout = request_timeout
        self.probe = probe
        self.provisioning_state = provisioning_state


class ApplicationGatewayFrontendIPConfiguration(SubResource):
    """Frontend IP configuration of an application gateway.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar private_ip_address: PrivateIPAddress of the network interface IP Configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: PrivateIP allocation method. Possible values are: 'Static'
     and 'Dynamic'. Known values are: "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :ivar subnet: Reference of the subnet resource.
    :vartype subnet: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar public_ip_address: Reference of the PublicIP resource.
    :vartype public_ip_address: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar provisioning_state: Provisioning state of the public IP resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.SubResource"] = None,
        public_ip_address: Optional["_models.SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword private_ip_address: PrivateIPAddress of the network interface IP Configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: PrivateIP allocation method. Possible values are:
         'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
        :keyword subnet: Reference of the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword public_ip_address: Reference of the PublicIP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword provisioning_state: Provisioning state of the public IP resource. Possible values are:
         'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class ApplicationGatewayFrontendPort(SubResource):
    """Frontend port of an application gateway.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar port: Frontend port.
    :vartype port: int
    :ivar provisioning_state: Provisioning state of the frontend port resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        port: Optional[int] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword port: Frontend port.
        :paramtype port: int
        :keyword provisioning_state: Provisioning state of the frontend port resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.port = port
        self.provisioning_state = provisioning_state


class ApplicationGatewayHttpListener(SubResource):
    """Http listener of an application gateway.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar frontend_ip_configuration: Frontend IP configuration resource of an application gateway.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar frontend_port: Frontend port resource of an application gateway.
    :vartype frontend_port: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar protocol: Protocol. Possible values are: 'Http' and 'Https'. Known values are: "Http" and
     "Https".
    :vartype protocol: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayProtocol
    :ivar host_name: Host name of HTTP listener.
    :vartype host_name: str
    :ivar ssl_certificate: SSL certificate resource of an application gateway.
    :vartype ssl_certificate: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar require_server_name_indication: Applicable only if protocol is https. Enables SNI for
     multi-hosting.
    :vartype require_server_name_indication: bool
    :ivar provisioning_state: Provisioning state of the HTTP listener resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "frontend_port": {"key": "properties.frontendPort", "type": "SubResource"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "host_name": {"key": "properties.hostName", "type": "str"},
        "ssl_certificate": {"key": "properties.sslCertificate", "type": "SubResource"},
        "require_server_name_indication": {"key": "properties.requireServerNameIndication", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        frontend_port: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        host_name: Optional[str] = None,
        ssl_certificate: Optional["_models.SubResource"] = None,
        require_server_name_indication: Optional[bool] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword frontend_ip_configuration: Frontend IP configuration resource of an application
         gateway.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword frontend_port: Frontend port resource of an application gateway.
        :paramtype frontend_port: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword protocol: Protocol. Possible values are: 'Http' and 'Https'. Known values are: "Http"
         and "Https".
        :paramtype protocol: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayProtocol
        :keyword host_name: Host name of HTTP listener.
        :paramtype host_name: str
        :keyword ssl_certificate: SSL certificate resource of an application gateway.
        :paramtype ssl_certificate: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword require_server_name_indication: Applicable only if protocol is https. Enables SNI for
         multi-hosting.
        :paramtype require_server_name_indication: bool
        :keyword provisioning_state: Provisioning state of the HTTP listener resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.frontend_ip_configuration = frontend_ip_configuration
        self.frontend_port = frontend_port
        self.protocol = protocol
        self.host_name = host_name
        self.ssl_certificate = ssl_certificate
        self.require_server_name_indication = require_server_name_indication
        self.provisioning_state = provisioning_state


class ApplicationGatewayIPConfiguration(SubResource):
    """IP configuration of an application gateway. Currently 1 public and 1 private IP configuration
    is allowed.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar subnet: Reference of the subnet resource. A subnet from where application gateway gets
     its private address.
    :vartype subnet: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar provisioning_state: Provisioning state of the application gateway subnet resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        subnet: Optional["_models.SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword subnet: Reference of the subnet resource. A subnet from where application gateway gets
         its private address.
        :paramtype subnet: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword provisioning_state: Provisioning state of the application gateway subnet resource.
         Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.subnet = subnet
        self.provisioning_state = provisioning_state


class ApplicationGatewayListResult(_serialization.Model):
    """Response for ListApplicationGateways API service call.

    :ivar value: List of an application gateways in a resource group.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.ApplicationGateway]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ApplicationGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ApplicationGateway"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: List of an application gateways in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.ApplicationGateway]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ApplicationGatewayPathRule(SubResource):
    """Path rule of URL path map of an application gateway.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar paths: Path rules of URL path map.
    :vartype paths: list[str]
    :ivar backend_address_pool: Backend address pool resource of URL path map.
    :vartype backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar backend_http_settings: Backend http settings resource of URL path map.
    :vartype backend_http_settings: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar provisioning_state: Path rule of URL path map resource. Possible values are: 'Updating',
     'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "paths": {"key": "properties.paths", "type": "[str]"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "backend_http_settings": {"key": "properties.backendHttpSettings", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        paths: Optional[List[str]] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        backend_http_settings: Optional["_models.SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword paths: Path rules of URL path map.
        :paramtype paths: list[str]
        :keyword backend_address_pool: Backend address pool resource of URL path map.
        :paramtype backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword backend_http_settings: Backend http settings resource of URL path map.
        :paramtype backend_http_settings: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword provisioning_state: Path rule of URL path map resource. Possible values are:
         'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.paths = paths
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.provisioning_state = provisioning_state


class ApplicationGatewayProbe(SubResource):
    """Probe of the application gateway.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar protocol: Protocol. Possible values are: 'Http' and 'Https'. Known values are: "Http" and
     "Https".
    :vartype protocol: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayProtocol
    :ivar host: Host name to send the probe to.
    :vartype host: str
    :ivar path: Relative path of probe. Valid path starts from '/'. Probe is sent to
     :code:`<Protocol>`://:code:`<host>`::code:`<port>`:code:`<path>`.
    :vartype path: str
    :ivar interval: The probing interval in seconds. This is the time interval between two
     consecutive probes. Acceptable values are from 1 second to 86400 seconds.
    :vartype interval: int
    :ivar timeout: the probe timeout in seconds. Probe marked as failed if valid response is not
     received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
    :vartype timeout: int
    :ivar unhealthy_threshold: The probe retry count. Backend server is marked down after
     consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second
     to 20.
    :vartype unhealthy_threshold: int
    :ivar provisioning_state: Provisioning state of the backend http settings resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "host": {"key": "properties.host", "type": "str"},
        "path": {"key": "properties.path", "type": "str"},
        "interval": {"key": "properties.interval", "type": "int"},
        "timeout": {"key": "properties.timeout", "type": "int"},
        "unhealthy_threshold": {"key": "properties.unhealthyThreshold", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        protocol: Optional[Union[str, "_models.ApplicationGatewayProtocol"]] = None,
        host: Optional[str] = None,
        path: Optional[str] = None,
        interval: Optional[int] = None,
        timeout: Optional[int] = None,
        unhealthy_threshold: Optional[int] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword protocol: Protocol. Possible values are: 'Http' and 'Https'. Known values are: "Http"
         and "Https".
        :paramtype protocol: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayProtocol
        :keyword host: Host name to send the probe to.
        :paramtype host: str
        :keyword path: Relative path of probe. Valid path starts from '/'. Probe is sent to
         :code:`<Protocol>`://:code:`<host>`::code:`<port>`:code:`<path>`.
        :paramtype path: str
        :keyword interval: The probing interval in seconds. This is the time interval between two
         consecutive probes. Acceptable values are from 1 second to 86400 seconds.
        :paramtype interval: int
        :keyword timeout: the probe timeout in seconds. Probe marked as failed if valid response is not
         received with this timeout period. Acceptable values are from 1 second to 86400 seconds.
        :paramtype timeout: int
        :keyword unhealthy_threshold: The probe retry count. Backend server is marked down after
         consecutive probe failure count reaches UnhealthyThreshold. Acceptable values are from 1 second
         to 20.
        :paramtype unhealthy_threshold: int
        :keyword provisioning_state: Provisioning state of the backend http settings resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.protocol = protocol
        self.host = host
        self.path = path
        self.interval = interval
        self.timeout = timeout
        self.unhealthy_threshold = unhealthy_threshold
        self.provisioning_state = provisioning_state


class ApplicationGatewayRequestRoutingRule(SubResource):
    """Request routing rule of an application gateway.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar rule_type: Rule type. Possible values are: 'Basic' and 'PathBasedRouting'. Known values
     are: "Basic" and "PathBasedRouting".
    :vartype rule_type: str or
     ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayRequestRoutingRuleType
    :ivar backend_address_pool: Backend address pool resource of the application gateway.
    :vartype backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar backend_http_settings: Frontend port resource of the application gateway.
    :vartype backend_http_settings: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar http_listener: Http listener resource of the application gateway.
    :vartype http_listener: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar url_path_map: URL path map resource of the application gateway.
    :vartype url_path_map: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar provisioning_state: Provisioning state of the request routing rule resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "rule_type": {"key": "properties.ruleType", "type": "str"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "backend_http_settings": {"key": "properties.backendHttpSettings", "type": "SubResource"},
        "http_listener": {"key": "properties.httpListener", "type": "SubResource"},
        "url_path_map": {"key": "properties.urlPathMap", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        rule_type: Optional[Union[str, "_models.ApplicationGatewayRequestRoutingRuleType"]] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        backend_http_settings: Optional["_models.SubResource"] = None,
        http_listener: Optional["_models.SubResource"] = None,
        url_path_map: Optional["_models.SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword rule_type: Rule type. Possible values are: 'Basic' and 'PathBasedRouting'. Known
         values are: "Basic" and "PathBasedRouting".
        :paramtype rule_type: str or
         ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayRequestRoutingRuleType
        :keyword backend_address_pool: Backend address pool resource of the application gateway.
        :paramtype backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword backend_http_settings: Frontend port resource of the application gateway.
        :paramtype backend_http_settings: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword http_listener: Http listener resource of the application gateway.
        :paramtype http_listener: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword url_path_map: URL path map resource of the application gateway.
        :paramtype url_path_map: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword provisioning_state: Provisioning state of the request routing rule resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.rule_type = rule_type
        self.backend_address_pool = backend_address_pool
        self.backend_http_settings = backend_http_settings
        self.http_listener = http_listener
        self.url_path_map = url_path_map
        self.provisioning_state = provisioning_state


class ApplicationGatewaySku(_serialization.Model):
    """SKU of application gateway.

    :ivar name: Name of an application gateway SKU. Possible values are: 'Standard_Small',
     'Standard_Medium', 'Standard_Large', 'WAF_Medium', and 'WAF_Large'. Known values are:
     "Standard_Small", "Standard_Medium", and "Standard_Large".
    :vartype name: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewaySkuName
    :ivar tier: Tier of an application gateway. "Standard"
    :vartype tier: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayTier
    :ivar capacity: Capacity (instance count) of an application gateway.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.ApplicationGatewaySkuName"]] = None,
        tier: Optional[Union[str, "_models.ApplicationGatewayTier"]] = None,
        capacity: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Name of an application gateway SKU. Possible values are: 'Standard_Small',
         'Standard_Medium', 'Standard_Large', 'WAF_Medium', and 'WAF_Large'. Known values are:
         "Standard_Small", "Standard_Medium", and "Standard_Large".
        :paramtype name: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewaySkuName
        :keyword tier: Tier of an application gateway. "Standard"
        :paramtype tier: str or ~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayTier
        :keyword capacity: Capacity (instance count) of an application gateway.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class ApplicationGatewaySslCertificate(SubResource):
    """SSL certificates of an application gateway.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
    :vartype data: str
    :ivar password: Password for the pfx file specified in data. Only applicable in PUT request.
    :vartype password: str
    :ivar public_cert_data: Base-64 encoded Public cert data corresponding to pfx specified in
     data. Only applicable in GET request.
    :vartype public_cert_data: str
    :ivar provisioning_state: Provisioning state of the SSL certificate resource Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "data": {"key": "properties.data", "type": "str"},
        "password": {"key": "properties.password", "type": "str"},
        "public_cert_data": {"key": "properties.publicCertData", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        data: Optional[str] = None,
        password: Optional[str] = None,
        public_cert_data: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword data: Base-64 encoded pfx certificate. Only applicable in PUT Request.
        :paramtype data: str
        :keyword password: Password for the pfx file specified in data. Only applicable in PUT request.
        :paramtype password: str
        :keyword public_cert_data: Base-64 encoded Public cert data corresponding to pfx specified in
         data. Only applicable in GET request.
        :paramtype public_cert_data: str
        :keyword provisioning_state: Provisioning state of the SSL certificate resource Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.data = data
        self.password = password
        self.public_cert_data = public_cert_data
        self.provisioning_state = provisioning_state


class ApplicationGatewayUrlPathMap(SubResource):
    """UrlPathMaps give a url path to the backend mapping information for PathBasedRouting.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Name of the resource that is unique within a resource group. This name can be used
     to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar default_backend_address_pool: Default backend address pool resource of URL path map.
    :vartype default_backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar default_backend_http_settings: Default backend http settings resource of URL path map.
    :vartype default_backend_http_settings: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar path_rules: Path rule of URL path map resource.
    :vartype path_rules: list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayPathRule]
    :ivar provisioning_state: Provisioning state of the backend http settings resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "default_backend_address_pool": {"key": "properties.defaultBackendAddressPool", "type": "SubResource"},
        "default_backend_http_settings": {"key": "properties.defaultBackendHttpSettings", "type": "SubResource"},
        "path_rules": {"key": "properties.pathRules", "type": "[ApplicationGatewayPathRule]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        default_backend_address_pool: Optional["_models.SubResource"] = None,
        default_backend_http_settings: Optional["_models.SubResource"] = None,
        path_rules: Optional[List["_models.ApplicationGatewayPathRule"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: Name of the resource that is unique within a resource group. This name can be
         used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword default_backend_address_pool: Default backend address pool resource of URL path map.
        :paramtype default_backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword default_backend_http_settings: Default backend http settings resource of URL path map.
        :paramtype default_backend_http_settings: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword path_rules: Path rule of URL path map resource.
        :paramtype path_rules: list[~azure.mgmt.network.v2015_06_15.models.ApplicationGatewayPathRule]
        :keyword provisioning_state: Provisioning state of the backend http settings resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.default_backend_address_pool = default_backend_address_pool
        self.default_backend_http_settings = default_backend_http_settings
        self.path_rules = path_rules
        self.provisioning_state = provisioning_state


class AuthorizationListResult(_serialization.Model):
    """Response for ListAuthorizations API service call retrieves all authorizations that belongs to
    an ExpressRouteCircuit.

    :ivar value: The authorizations in an ExpressRoute Circuit.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitAuthorization]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitAuthorization]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitAuthorization"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The authorizations in an ExpressRoute Circuit.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitAuthorization]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AzureAsyncOperationResult(_serialization.Model):
    """The response body contains the status of the specified asynchronous operation, indicating
    whether it has succeeded, is in progress, or has failed. Note that this status is distinct from
    the HTTP status code returned for the Get Operation Status operation itself. If the
    asynchronous operation succeeded, the response body includes the HTTP status code for the
    successful request. If the asynchronous operation failed, the response body includes the HTTP
    status code for the failed request and error information regarding the failure.

    :ivar status: Status of the Azure async operation. Possible values are: 'InProgress',
     'Succeeded', and 'Failed'. Known values are: "InProgress", "Succeeded", and "Failed".
    :vartype status: str or ~azure.mgmt.network.v2015_06_15.models.NetworkOperationStatus
    :ivar error: Error object properties.
    :vartype error: ~azure.mgmt.network.v2015_06_15.models.Error
    """

    _attribute_map = {
        "status": {"key": "status", "type": "str"},
        "error": {"key": "error", "type": "Error"},
    }

    def __init__(
        self,
        *,
        status: Optional[Union[str, "_models.NetworkOperationStatus"]] = None,
        error: Optional["_models.Error"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword status: Status of the Azure async operation. Possible values are: 'InProgress',
         'Succeeded', and 'Failed'. Known values are: "InProgress", "Succeeded", and "Failed".
        :paramtype status: str or ~azure.mgmt.network.v2015_06_15.models.NetworkOperationStatus
        :keyword error: Error object properties.
        :paramtype error: ~azure.mgmt.network.v2015_06_15.models.Error
        """
        super().__init__(**kwargs)
        self.status = status
        self.error = error


class BackendAddressPool(SubResource):
    """Pool of backend IP addresses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar backend_ip_configurations: Gets collection of references to IP addresses defined in
     network interfaces.
    :vartype backend_ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceIPConfiguration]
    :ivar load_balancing_rules: Gets load balancing rules that use this backend address pool.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :ivar outbound_nat_rule: Gets outbound rules that use this backend address pool.
    :vartype outbound_nat_rule: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar provisioning_state: Get provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "load_balancing_rules": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "backend_ip_configurations": {
            "key": "properties.backendIPConfigurations",
            "type": "[NetworkInterfaceIPConfiguration]",
        },
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[SubResource]"},
        "outbound_nat_rule": {"key": "properties.outboundNatRule", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        backend_ip_configurations: Optional[List["_models.NetworkInterfaceIPConfiguration"]] = None,
        outbound_nat_rule: Optional["_models.SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: Gets name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword backend_ip_configurations: Gets collection of references to IP addresses defined in
         network interfaces.
        :paramtype backend_ip_configurations:
         list[~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceIPConfiguration]
        :keyword outbound_nat_rule: Gets outbound rules that use this backend address pool.
        :paramtype outbound_nat_rule: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword provisioning_state: Get provisioning state of the public IP resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.backend_ip_configurations = backend_ip_configurations
        self.load_balancing_rules = None
        self.outbound_nat_rule = outbound_nat_rule
        self.provisioning_state = provisioning_state


class BgpSettings(_serialization.Model):
    """BgpSettings.

    :ivar asn: Gets or sets this BGP speaker's ASN.
    :vartype asn: int
    :ivar bgp_peering_address: Gets or sets the BGP peering address and BGP identifier of this BGP
     speaker.
    :vartype bgp_peering_address: str
    :ivar peer_weight: Gets or sets the weight added to routes learned from this BGP speaker.
    :vartype peer_weight: int
    """

    _attribute_map = {
        "asn": {"key": "asn", "type": "int"},
        "bgp_peering_address": {"key": "bgpPeeringAddress", "type": "str"},
        "peer_weight": {"key": "peerWeight", "type": "int"},
    }

    def __init__(
        self,
        *,
        asn: Optional[int] = None,
        bgp_peering_address: Optional[str] = None,
        peer_weight: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword asn: Gets or sets this BGP speaker's ASN.
        :paramtype asn: int
        :keyword bgp_peering_address: Gets or sets the BGP peering address and BGP identifier of this
         BGP speaker.
        :paramtype bgp_peering_address: str
        :keyword peer_weight: Gets or sets the weight added to routes learned from this BGP speaker.
        :paramtype peer_weight: int
        """
        super().__init__(**kwargs)
        self.asn = asn
        self.bgp_peering_address = bgp_peering_address
        self.peer_weight = peer_weight


class ConnectionResetSharedKey(_serialization.Model):
    """ConnectionResetSharedKey.

    :ivar key_length: The virtual network connection reset shared key length.
    :vartype key_length: int
    """

    _attribute_map = {
        "key_length": {"key": "keyLength", "type": "int"},
    }

    def __init__(self, *, key_length: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword key_length: The virtual network connection reset shared key length.
        :paramtype key_length: int
        """
        super().__init__(**kwargs)
        self.key_length = key_length


class ConnectionSharedKey(_serialization.Model):
    """Response for GetConnectionSharedKey API service call.

    :ivar value: The virtual network connection shared key value.
    :vartype value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The virtual network connection shared key value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.value = value


class ConnectionSharedKeyResult(_serialization.Model):
    """Response for CheckConnectionSharedKey API service call.

    :ivar value: The virtual network connection shared key value.
    :vartype value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: The virtual network connection shared key value.
        :paramtype value: str
        """
        super().__init__(**kwargs)
        self.value = value


class DhcpOptions(_serialization.Model):
    """DhcpOptions contains an array of DNS servers available to VMs deployed in the virtual network.
    Standard DHCP option for a subnet overrides VNET DHCP options.

    :ivar dns_servers: The list of DNS servers IP addresses.
    :vartype dns_servers: list[str]
    """

    _attribute_map = {
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
    }

    def __init__(self, *, dns_servers: Optional[List[str]] = None, **kwargs: Any) -> None:
        """
        :keyword dns_servers: The list of DNS servers IP addresses.
        :paramtype dns_servers: list[str]
        """
        super().__init__(**kwargs)
        self.dns_servers = dns_servers


class DnsNameAvailabilityResult(_serialization.Model):
    """Response for the CheckDnsNameAvailability API service call.

    :ivar available: Domain availability (True/False).
    :vartype available: bool
    """

    _attribute_map = {
        "available": {"key": "available", "type": "bool"},
    }

    def __init__(self, *, available: Optional[bool] = None, **kwargs: Any) -> None:
        """
        :keyword available: Domain availability (True/False).
        :paramtype available: bool
        """
        super().__init__(**kwargs)
        self.available = available


class Error(_serialization.Model):
    """Error object properties.

    :ivar code:
    :vartype code: str
    :ivar message:
    :vartype message: str
    :ivar target:
    :vartype target: str
    :ivar details:
    :vartype details: list[~azure.mgmt.network.v2015_06_15.models.ErrorDetails]
    :ivar inner_error:
    :vartype inner_error: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[ErrorDetails]"},
        "inner_error": {"key": "innerError", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        details: Optional[List["_models.ErrorDetails"]] = None,
        inner_error: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code:
        :paramtype code: str
        :keyword message:
        :paramtype message: str
        :keyword target:
        :paramtype target: str
        :keyword details:
        :paramtype details: list[~azure.mgmt.network.v2015_06_15.models.ErrorDetails]
        :keyword inner_error:
        :paramtype inner_error: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target
        self.details = details
        self.inner_error = inner_error


class ErrorDetails(_serialization.Model):
    """Error details properties.

    :ivar code:
    :vartype code: str
    :ivar target:
    :vartype target: str
    :ivar message:
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(
        self, *, code: Optional[str] = None, target: Optional[str] = None, message: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword code:
        :paramtype code: str
        :keyword target:
        :paramtype target: str
        :keyword message:
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class ExpressRouteCircuit(Resource):  # pylint: disable=too-many-instance-attributes
    """ExpressRouteCircuit resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar sku: The SKU.
    :vartype sku: ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitSku
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar circuit_provisioning_state: The CircuitProvisioningState state of the resource.
    :vartype circuit_provisioning_state: str
    :ivar service_provider_provisioning_state: The ServiceProviderProvisioningState state of the
     resource. Possible values are 'NotProvisioned', 'Provisioning', 'Provisioned', and
     'Deprovisioning'. Known values are: "NotProvisioned", "Provisioning", "Provisioned", and
     "Deprovisioning".
    :vartype service_provider_provisioning_state: str or
     ~azure.mgmt.network.v2015_06_15.models.ServiceProviderProvisioningState
    :ivar authorizations: The list of authorizations.
    :vartype authorizations:
     list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitAuthorization]
    :ivar peerings: The list of peerings.
    :vartype peerings: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeering]
    :ivar service_key: The ServiceKey.
    :vartype service_key: str
    :ivar service_provider_notes: The ServiceProviderNotes.
    :vartype service_provider_notes: str
    :ivar service_provider_properties: The ServiceProviderProperties.
    :vartype service_provider_properties:
     ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitServiceProviderProperties
    :ivar provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "sku": {"key": "sku", "type": "ExpressRouteCircuitSku"},
        "etag": {"key": "etag", "type": "str"},
        "circuit_provisioning_state": {"key": "properties.circuitProvisioningState", "type": "str"},
        "service_provider_provisioning_state": {"key": "properties.serviceProviderProvisioningState", "type": "str"},
        "authorizations": {"key": "properties.authorizations", "type": "[ExpressRouteCircuitAuthorization]"},
        "peerings": {"key": "properties.peerings", "type": "[ExpressRouteCircuitPeering]"},
        "service_key": {"key": "properties.serviceKey", "type": "str"},
        "service_provider_notes": {"key": "properties.serviceProviderNotes", "type": "str"},
        "service_provider_properties": {
            "key": "properties.serviceProviderProperties",
            "type": "ExpressRouteCircuitServiceProviderProperties",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["_models.ExpressRouteCircuitSku"] = None,
        etag: Optional[str] = None,
        circuit_provisioning_state: Optional[str] = None,
        service_provider_provisioning_state: Optional[Union[str, "_models.ServiceProviderProvisioningState"]] = None,
        authorizations: Optional[List["_models.ExpressRouteCircuitAuthorization"]] = None,
        peerings: Optional[List["_models.ExpressRouteCircuitPeering"]] = None,
        service_key: Optional[str] = None,
        service_provider_notes: Optional[str] = None,
        service_provider_properties: Optional["_models.ExpressRouteCircuitServiceProviderProperties"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword sku: The SKU.
        :paramtype sku: ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitSku
        :keyword etag: Gets a unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword circuit_provisioning_state: The CircuitProvisioningState state of the resource.
        :paramtype circuit_provisioning_state: str
        :keyword service_provider_provisioning_state: The ServiceProviderProvisioningState state of the
         resource. Possible values are 'NotProvisioned', 'Provisioning', 'Provisioned', and
         'Deprovisioning'. Known values are: "NotProvisioned", "Provisioning", "Provisioned", and
         "Deprovisioning".
        :paramtype service_provider_provisioning_state: str or
         ~azure.mgmt.network.v2015_06_15.models.ServiceProviderProvisioningState
        :keyword authorizations: The list of authorizations.
        :paramtype authorizations:
         list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitAuthorization]
        :keyword peerings: The list of peerings.
        :paramtype peerings: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeering]
        :keyword service_key: The ServiceKey.
        :paramtype service_key: str
        :keyword service_provider_notes: The ServiceProviderNotes.
        :paramtype service_provider_notes: str
        :keyword service_provider_properties: The ServiceProviderProperties.
        :paramtype service_provider_properties:
         ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitServiceProviderProperties
        :keyword provisioning_state: Gets the provisioning state of the public IP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.sku = sku
        self.etag = etag
        self.circuit_provisioning_state = circuit_provisioning_state
        self.service_provider_provisioning_state = service_provider_provisioning_state
        self.authorizations = authorizations
        self.peerings = peerings
        self.service_key = service_key
        self.service_provider_notes = service_provider_notes
        self.service_provider_properties = service_provider_properties
        self.provisioning_state = provisioning_state


class ExpressRouteCircuitArpTable(_serialization.Model):
    """The ARP table associated with the ExpressRouteCircuit.

    :ivar ip_address: The IP address.
    :vartype ip_address: str
    :ivar mac_address: The MAC address.
    :vartype mac_address: str
    """

    _attribute_map = {
        "ip_address": {"key": "ipAddress", "type": "str"},
        "mac_address": {"key": "macAddress", "type": "str"},
    }

    def __init__(self, *, ip_address: Optional[str] = None, mac_address: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword ip_address: The IP address.
        :paramtype ip_address: str
        :keyword mac_address: The MAC address.
        :paramtype mac_address: str
        """
        super().__init__(**kwargs)
        self.ip_address = ip_address
        self.mac_address = mac_address


class ExpressRouteCircuitAuthorization(SubResource):
    """Authorization in an ExpressRouteCircuit resource.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar authorization_key: The authorization key.
    :vartype authorization_key: str
    :ivar authorization_use_status: AuthorizationUseStatus. Possible values are: 'Available' and
     'InUse'. Known values are: "Available" and "InUse".
    :vartype authorization_use_status: str or
     ~azure.mgmt.network.v2015_06_15.models.AuthorizationUseStatus
    :ivar provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "authorization_use_status": {"key": "properties.authorizationUseStatus", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        authorization_key: Optional[str] = None,
        authorization_use_status: Optional[Union[str, "_models.AuthorizationUseStatus"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: Gets name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword authorization_key: The authorization key.
        :paramtype authorization_key: str
        :keyword authorization_use_status: AuthorizationUseStatus. Possible values are: 'Available' and
         'InUse'. Known values are: "Available" and "InUse".
        :paramtype authorization_use_status: str or
         ~azure.mgmt.network.v2015_06_15.models.AuthorizationUseStatus
        :keyword provisioning_state: Gets the provisioning state of the public IP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.authorization_key = authorization_key
        self.authorization_use_status = authorization_use_status
        self.provisioning_state = provisioning_state


class ExpressRouteCircuitListResult(_serialization.Model):
    """Response for ListExpressRouteCircuit API service call.

    :ivar value: A list of ExpressRouteCircuits in a resource group.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuit]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuit]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuit"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of ExpressRouteCircuits in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuit]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitPeering(SubResource):  # pylint: disable=too-many-instance-attributes
    """Peering in an ExpressRouteCircuit resource.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar peering_type: The PeeringType. Possible values are: 'AzurePublicPeering',
     'AzurePrivatePeering', and 'MicrosoftPeering'. Known values are: "AzurePublicPeering",
     "AzurePrivatePeering", and "MicrosoftPeering".
    :vartype peering_type: str or
     ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeeringType
    :ivar state: The state of peering. Possible values are: 'Disabled' and 'Enabled'. Known values
     are: "Disabled" and "Enabled".
    :vartype state: str or ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeeringState
    :ivar azure_asn: The Azure ASN.
    :vartype azure_asn: int
    :ivar peer_asn: The peer ASN.
    :vartype peer_asn: int
    :ivar primary_peer_address_prefix: The primary address prefix.
    :vartype primary_peer_address_prefix: str
    :ivar secondary_peer_address_prefix: The secondary address prefix.
    :vartype secondary_peer_address_prefix: str
    :ivar primary_azure_port: The primary port.
    :vartype primary_azure_port: str
    :ivar secondary_azure_port: The secondary port.
    :vartype secondary_azure_port: str
    :ivar shared_key: The shared key.
    :vartype shared_key: str
    :ivar vlan_id: The VLAN ID.
    :vartype vlan_id: int
    :ivar microsoft_peering_config: The Microsoft peering configuration.
    :vartype microsoft_peering_config:
     ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeeringConfig
    :ivar stats: Gets peering stats.
    :vartype stats: ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitStats
    :ivar provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "peering_type": {"key": "properties.peeringType", "type": "str"},
        "state": {"key": "properties.state", "type": "str"},
        "azure_asn": {"key": "properties.azureASN", "type": "int"},
        "peer_asn": {"key": "properties.peerASN", "type": "int"},
        "primary_peer_address_prefix": {"key": "properties.primaryPeerAddressPrefix", "type": "str"},
        "secondary_peer_address_prefix": {"key": "properties.secondaryPeerAddressPrefix", "type": "str"},
        "primary_azure_port": {"key": "properties.primaryAzurePort", "type": "str"},
        "secondary_azure_port": {"key": "properties.secondaryAzurePort", "type": "str"},
        "shared_key": {"key": "properties.sharedKey", "type": "str"},
        "vlan_id": {"key": "properties.vlanId", "type": "int"},
        "microsoft_peering_config": {
            "key": "properties.microsoftPeeringConfig",
            "type": "ExpressRouteCircuitPeeringConfig",
        },
        "stats": {"key": "properties.stats", "type": "ExpressRouteCircuitStats"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        peering_type: Optional[Union[str, "_models.ExpressRouteCircuitPeeringType"]] = None,
        state: Optional[Union[str, "_models.ExpressRouteCircuitPeeringState"]] = None,
        azure_asn: Optional[int] = None,
        peer_asn: Optional[int] = None,
        primary_peer_address_prefix: Optional[str] = None,
        secondary_peer_address_prefix: Optional[str] = None,
        primary_azure_port: Optional[str] = None,
        secondary_azure_port: Optional[str] = None,
        shared_key: Optional[str] = None,
        vlan_id: Optional[int] = None,
        microsoft_peering_config: Optional["_models.ExpressRouteCircuitPeeringConfig"] = None,
        stats: Optional["_models.ExpressRouteCircuitStats"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: Gets name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword peering_type: The PeeringType. Possible values are: 'AzurePublicPeering',
         'AzurePrivatePeering', and 'MicrosoftPeering'. Known values are: "AzurePublicPeering",
         "AzurePrivatePeering", and "MicrosoftPeering".
        :paramtype peering_type: str or
         ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeeringType
        :keyword state: The state of peering. Possible values are: 'Disabled' and 'Enabled'. Known
         values are: "Disabled" and "Enabled".
        :paramtype state: str or ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeeringState
        :keyword azure_asn: The Azure ASN.
        :paramtype azure_asn: int
        :keyword peer_asn: The peer ASN.
        :paramtype peer_asn: int
        :keyword primary_peer_address_prefix: The primary address prefix.
        :paramtype primary_peer_address_prefix: str
        :keyword secondary_peer_address_prefix: The secondary address prefix.
        :paramtype secondary_peer_address_prefix: str
        :keyword primary_azure_port: The primary port.
        :paramtype primary_azure_port: str
        :keyword secondary_azure_port: The secondary port.
        :paramtype secondary_azure_port: str
        :keyword shared_key: The shared key.
        :paramtype shared_key: str
        :keyword vlan_id: The VLAN ID.
        :paramtype vlan_id: int
        :keyword microsoft_peering_config: The Microsoft peering configuration.
        :paramtype microsoft_peering_config:
         ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeeringConfig
        :keyword stats: Gets peering stats.
        :paramtype stats: ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitStats
        :keyword provisioning_state: Gets the provisioning state of the public IP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.peering_type = peering_type
        self.state = state
        self.azure_asn = azure_asn
        self.peer_asn = peer_asn
        self.primary_peer_address_prefix = primary_peer_address_prefix
        self.secondary_peer_address_prefix = secondary_peer_address_prefix
        self.primary_azure_port = primary_azure_port
        self.secondary_azure_port = secondary_azure_port
        self.shared_key = shared_key
        self.vlan_id = vlan_id
        self.microsoft_peering_config = microsoft_peering_config
        self.stats = stats
        self.provisioning_state = provisioning_state


class ExpressRouteCircuitPeeringConfig(_serialization.Model):
    """Specifies the peering configuration.

    :ivar advertised_public_prefixes: The reference of AdvertisedPublicPrefixes.
    :vartype advertised_public_prefixes: list[str]
    :ivar advertised_public_prefixes_state: AdvertisedPublicPrefixState of the Peering resource.
     Possible values are 'NotConfigured', 'Configuring', 'Configured', and 'ValidationNeeded'. Known
     values are: "NotConfigured", "Configuring", "Configured", and "ValidationNeeded".
    :vartype advertised_public_prefixes_state: str or
     ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState
    :ivar customer_asn: The CustomerASN of the peering.
    :vartype customer_asn: int
    :ivar routing_registry_name: The RoutingRegistryName of the configuration.
    :vartype routing_registry_name: str
    """

    _attribute_map = {
        "advertised_public_prefixes": {"key": "advertisedPublicPrefixes", "type": "[str]"},
        "advertised_public_prefixes_state": {"key": "advertisedPublicPrefixesState", "type": "str"},
        "customer_asn": {"key": "customerASN", "type": "int"},
        "routing_registry_name": {"key": "routingRegistryName", "type": "str"},
    }

    def __init__(
        self,
        *,
        advertised_public_prefixes: Optional[List[str]] = None,
        advertised_public_prefixes_state: Optional[
            Union[str, "_models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState"]
        ] = None,
        customer_asn: Optional[int] = None,
        routing_registry_name: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword advertised_public_prefixes: The reference of AdvertisedPublicPrefixes.
        :paramtype advertised_public_prefixes: list[str]
        :keyword advertised_public_prefixes_state: AdvertisedPublicPrefixState of the Peering resource.
         Possible values are 'NotConfigured', 'Configuring', 'Configured', and 'ValidationNeeded'. Known
         values are: "NotConfigured", "Configuring", "Configured", and "ValidationNeeded".
        :paramtype advertised_public_prefixes_state: str or
         ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeeringAdvertisedPublicPrefixState
        :keyword customer_asn: The CustomerASN of the peering.
        :paramtype customer_asn: int
        :keyword routing_registry_name: The RoutingRegistryName of the configuration.
        :paramtype routing_registry_name: str
        """
        super().__init__(**kwargs)
        self.advertised_public_prefixes = advertised_public_prefixes
        self.advertised_public_prefixes_state = advertised_public_prefixes_state
        self.customer_asn = customer_asn
        self.routing_registry_name = routing_registry_name


class ExpressRouteCircuitPeeringListResult(_serialization.Model):
    """Response for ListPeering API service call retrieves all peerings that belong to an
    ExpressRouteCircuit.

    :ivar value: The peerings in an express route circuit.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeering]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitPeering]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitPeering"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The peerings in an express route circuit.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitPeering]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitRoutesTable(_serialization.Model):
    """The routes table associated with the ExpressRouteCircuit.

    All required parameters must be populated in order to send to Azure.

    :ivar address_prefix: Gets AddressPrefix.
    :vartype address_prefix: str
    :ivar next_hop_type: Gets NextHopType. Required. Known values are: "VirtualNetworkGateway",
     "VnetLocal", "Internet", "VirtualAppliance", and "None".
    :vartype next_hop_type: str or ~azure.mgmt.network.v2015_06_15.models.RouteNextHopType
    :ivar next_hop_ip: Gets NextHopIP.
    :vartype next_hop_ip: str
    :ivar as_path: Gets AsPath.
    :vartype as_path: str
    """

    _validation = {
        "next_hop_type": {"required": True},
    }

    _attribute_map = {
        "address_prefix": {"key": "addressPrefix", "type": "str"},
        "next_hop_type": {"key": "nextHopType", "type": "str"},
        "next_hop_ip": {"key": "nextHopIP", "type": "str"},
        "as_path": {"key": "asPath", "type": "str"},
    }

    def __init__(
        self,
        *,
        next_hop_type: Union[str, "_models.RouteNextHopType"],
        address_prefix: Optional[str] = None,
        next_hop_ip: Optional[str] = None,
        as_path: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword address_prefix: Gets AddressPrefix.
        :paramtype address_prefix: str
        :keyword next_hop_type: Gets NextHopType. Required. Known values are: "VirtualNetworkGateway",
         "VnetLocal", "Internet", "VirtualAppliance", and "None".
        :paramtype next_hop_type: str or ~azure.mgmt.network.v2015_06_15.models.RouteNextHopType
        :keyword next_hop_ip: Gets NextHopIP.
        :paramtype next_hop_ip: str
        :keyword as_path: Gets AsPath.
        :paramtype as_path: str
        """
        super().__init__(**kwargs)
        self.address_prefix = address_prefix
        self.next_hop_type = next_hop_type
        self.next_hop_ip = next_hop_ip
        self.as_path = as_path


class ExpressRouteCircuitsArpTableListResult(_serialization.Model):
    """Response for ListArpTable associated with the Express Route Circuits API.

    :ivar value: Gets list of the ARP table.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitArpTable]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitArpTable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitArpTable"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets list of the ARP table.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitArpTable]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitServiceProviderProperties(_serialization.Model):
    """Contains ServiceProviderProperties in an ExpressRouteCircuit.

    :ivar service_provider_name: The serviceProviderName.
    :vartype service_provider_name: str
    :ivar peering_location: The peering location.
    :vartype peering_location: str
    :ivar bandwidth_in_mbps: The BandwidthInMbps.
    :vartype bandwidth_in_mbps: int
    """

    _attribute_map = {
        "service_provider_name": {"key": "serviceProviderName", "type": "str"},
        "peering_location": {"key": "peeringLocation", "type": "str"},
        "bandwidth_in_mbps": {"key": "bandwidthInMbps", "type": "int"},
    }

    def __init__(
        self,
        *,
        service_provider_name: Optional[str] = None,
        peering_location: Optional[str] = None,
        bandwidth_in_mbps: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword service_provider_name: The serviceProviderName.
        :paramtype service_provider_name: str
        :keyword peering_location: The peering location.
        :paramtype peering_location: str
        :keyword bandwidth_in_mbps: The BandwidthInMbps.
        :paramtype bandwidth_in_mbps: int
        """
        super().__init__(**kwargs)
        self.service_provider_name = service_provider_name
        self.peering_location = peering_location
        self.bandwidth_in_mbps = bandwidth_in_mbps


class ExpressRouteCircuitSku(_serialization.Model):
    """Contains SKU in an ExpressRouteCircuit.

    :ivar name: The name of the SKU.
    :vartype name: str
    :ivar tier: The tier of the SKU. Possible values are 'Standard' and 'Premium'. Known values
     are: "Standard" and "Premium".
    :vartype tier: str or ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitSkuTier
    :ivar family: The family of the SKU. Possible values are: 'UnlimitedData' and 'MeteredData'.
     Known values are: "UnlimitedData" and "MeteredData".
    :vartype family: str or ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitSkuFamily
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "family": {"key": "family", "type": "str"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[Union[str, "_models.ExpressRouteCircuitSkuTier"]] = None,
        family: Optional[Union[str, "_models.ExpressRouteCircuitSkuFamily"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the SKU.
        :paramtype name: str
        :keyword tier: The tier of the SKU. Possible values are 'Standard' and 'Premium'. Known values
         are: "Standard" and "Premium".
        :paramtype tier: str or ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitSkuTier
        :keyword family: The family of the SKU. Possible values are: 'UnlimitedData' and 'MeteredData'.
         Known values are: "UnlimitedData" and "MeteredData".
        :paramtype family: str or ~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitSkuFamily
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.family = family


class ExpressRouteCircuitsRoutesTableListResult(_serialization.Model):
    """Response for ListRoutesTable associated with the Express Route Circuits API.

    :ivar value: The list of routes table.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitRoutesTable]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitRoutesTable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitRoutesTable"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: The list of routes table.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitRoutesTable]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitsStatsListResult(_serialization.Model):
    """Response for ListStats from Express Route Circuits Api service call.

    :ivar value: Gets List of Stats.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitStats]
    :ivar next_link: Gets the URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteCircuitStats]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteCircuitStats"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets List of Stats.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteCircuitStats]
        :keyword next_link: Gets the URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ExpressRouteCircuitStats(_serialization.Model):
    """Contains stats associated with the peering.

    :ivar bytes_in: Gets BytesIn of the peering.
    :vartype bytes_in: int
    :ivar bytes_out: Gets BytesOut of the peering.
    :vartype bytes_out: int
    """

    _attribute_map = {
        "bytes_in": {"key": "bytesIn", "type": "int"},
        "bytes_out": {"key": "bytesOut", "type": "int"},
    }

    def __init__(self, *, bytes_in: Optional[int] = None, bytes_out: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword bytes_in: Gets BytesIn of the peering.
        :paramtype bytes_in: int
        :keyword bytes_out: Gets BytesOut of the peering.
        :paramtype bytes_out: int
        """
        super().__init__(**kwargs)
        self.bytes_in = bytes_in
        self.bytes_out = bytes_out


class ExpressRouteServiceProvider(Resource):
    """A ExpressRouteResourceProvider object.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar peering_locations: Get a list of peering locations.
    :vartype peering_locations: list[str]
    :ivar bandwidths_offered: Gets bandwidths offered.
    :vartype bandwidths_offered:
     list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteServiceProviderBandwidthsOffered]
    :ivar provisioning_state: Gets the provisioning state of the resource.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "peering_locations": {"key": "properties.peeringLocations", "type": "[str]"},
        "bandwidths_offered": {
            "key": "properties.bandwidthsOffered",
            "type": "[ExpressRouteServiceProviderBandwidthsOffered]",
        },
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        peering_locations: Optional[List[str]] = None,
        bandwidths_offered: Optional[List["_models.ExpressRouteServiceProviderBandwidthsOffered"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword peering_locations: Get a list of peering locations.
        :paramtype peering_locations: list[str]
        :keyword bandwidths_offered: Gets bandwidths offered.
        :paramtype bandwidths_offered:
         list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteServiceProviderBandwidthsOffered]
        :keyword provisioning_state: Gets the provisioning state of the resource.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.peering_locations = peering_locations
        self.bandwidths_offered = bandwidths_offered
        self.provisioning_state = provisioning_state


class ExpressRouteServiceProviderBandwidthsOffered(_serialization.Model):
    """Contains bandwidths offered in ExpressRouteServiceProvider resources.

    :ivar offer_name: The OfferName.
    :vartype offer_name: str
    :ivar value_in_mbps: The ValueInMbps.
    :vartype value_in_mbps: int
    """

    _attribute_map = {
        "offer_name": {"key": "offerName", "type": "str"},
        "value_in_mbps": {"key": "valueInMbps", "type": "int"},
    }

    def __init__(self, *, offer_name: Optional[str] = None, value_in_mbps: Optional[int] = None, **kwargs: Any) -> None:
        """
        :keyword offer_name: The OfferName.
        :paramtype offer_name: str
        :keyword value_in_mbps: The ValueInMbps.
        :paramtype value_in_mbps: int
        """
        super().__init__(**kwargs)
        self.offer_name = offer_name
        self.value_in_mbps = value_in_mbps


class ExpressRouteServiceProviderListResult(_serialization.Model):
    """Response for the ListExpressRouteServiceProvider API service call.

    :ivar value: A list of ExpressRouteResourceProvider resources.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteServiceProvider]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ExpressRouteServiceProvider]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.ExpressRouteServiceProvider"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of ExpressRouteResourceProvider resources.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.ExpressRouteServiceProvider]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class FrontendIPConfiguration(SubResource):  # pylint: disable=too-many-instance-attributes
    """Frontend IP address of the load balancer.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar inbound_nat_rules: Read only. Inbound rules URIs that use this frontend IP.
    :vartype inbound_nat_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :ivar inbound_nat_pools: Read only. Inbound pools URIs that use this frontend IP.
    :vartype inbound_nat_pools: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :ivar outbound_nat_rules: Read only. Outbound rules URIs that use this frontend IP.
    :vartype outbound_nat_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :ivar load_balancing_rules: Gets load balancing rules URIs that use this frontend IP.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :ivar private_ip_address: The private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The Private IP allocation method. Possible values are:
     'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :ivar subnet: The reference of the subnet resource.
    :vartype subnet: ~azure.mgmt.network.v2015_06_15.models.Subnet
    :ivar public_ip_address: The reference of the Public IP resource.
    :vartype public_ip_address: ~azure.mgmt.network.v2015_06_15.models.PublicIPAddress
    :ivar provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "inbound_nat_rules": {"key": "properties.inboundNatRules", "type": "[SubResource]"},
        "inbound_nat_pools": {"key": "properties.inboundNatPools", "type": "[SubResource]"},
        "outbound_nat_rules": {"key": "properties.outboundNatRules", "type": "[SubResource]"},
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[SubResource]"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "PublicIPAddress"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        inbound_nat_rules: Optional[List["_models.SubResource"]] = None,
        inbound_nat_pools: Optional[List["_models.SubResource"]] = None,
        outbound_nat_rules: Optional[List["_models.SubResource"]] = None,
        load_balancing_rules: Optional[List["_models.SubResource"]] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.Subnet"] = None,
        public_ip_address: Optional["_models.PublicIPAddress"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword inbound_nat_rules: Read only. Inbound rules URIs that use this frontend IP.
        :paramtype inbound_nat_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
        :keyword inbound_nat_pools: Read only. Inbound pools URIs that use this frontend IP.
        :paramtype inbound_nat_pools: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
        :keyword outbound_nat_rules: Read only. Outbound rules URIs that use this frontend IP.
        :paramtype outbound_nat_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
        :keyword load_balancing_rules: Gets load balancing rules URIs that use this frontend IP.
        :paramtype load_balancing_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
        :keyword private_ip_address: The private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The Private IP allocation method. Possible values are:
         'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
        :keyword subnet: The reference of the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.v2015_06_15.models.Subnet
        :keyword public_ip_address: The reference of the Public IP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.v2015_06_15.models.PublicIPAddress
        :keyword provisioning_state: Gets the provisioning state of the public IP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.inbound_nat_rules = inbound_nat_rules
        self.inbound_nat_pools = inbound_nat_pools
        self.outbound_nat_rules = outbound_nat_rules
        self.load_balancing_rules = load_balancing_rules
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class InboundNatPool(SubResource):
    """Inbound NAT pool of the load balancer.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar frontend_ip_configuration: A reference to frontend IP addresses.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar protocol: The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'.
     Known values are: "Udp" and "Tcp".
    :vartype protocol: str or ~azure.mgmt.network.v2015_06_15.models.TransportProtocol
    :ivar frontend_port_range_start: The first port number in the range of external ports that will
     be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
     between 1 and 65534.
    :vartype frontend_port_range_start: int
    :ivar frontend_port_range_end: The last port number in the range of external ports that will be
     used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
     between 1 and 65535.
    :vartype frontend_port_range_end: int
    :ivar backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 1 and 65535.
    :vartype backend_port: int
    :ivar provisioning_state: Gets the provisioning state of the PublicIP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "frontend_port_range_start": {"key": "properties.frontendPortRangeStart", "type": "int"},
        "frontend_port_range_end": {"key": "properties.frontendPortRangeEnd", "type": "int"},
        "backend_port": {"key": "properties.backendPort", "type": "int"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.TransportProtocol"]] = None,
        frontend_port_range_start: Optional[int] = None,
        frontend_port_range_end: Optional[int] = None,
        backend_port: Optional[int] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword frontend_ip_configuration: A reference to frontend IP addresses.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword protocol: The transport protocol for the endpoint. Possible values are: 'Udp' or
         'Tcp'. Known values are: "Udp" and "Tcp".
        :paramtype protocol: str or ~azure.mgmt.network.v2015_06_15.models.TransportProtocol
        :keyword frontend_port_range_start: The first port number in the range of external ports that
         will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values
         range between 1 and 65534.
        :paramtype frontend_port_range_start: int
        :keyword frontend_port_range_end: The last port number in the range of external ports that will
         be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range
         between 1 and 65535.
        :paramtype frontend_port_range_end: int
        :keyword backend_port: The port used for internal connections on the endpoint. Acceptable
         values are between 1 and 65535.
        :paramtype backend_port: int
        :keyword provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.frontend_ip_configuration = frontend_ip_configuration
        self.protocol = protocol
        self.frontend_port_range_start = frontend_port_range_start
        self.frontend_port_range_end = frontend_port_range_end
        self.backend_port = backend_port
        self.provisioning_state = provisioning_state


class InboundNatRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """Inbound NAT rule of the load balancer.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar frontend_ip_configuration: A reference to frontend IP addresses.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar backend_ip_configuration: A reference to a private IP address defined on a network
     interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations
     is forwarded to the backed IP.
    :vartype backend_ip_configuration:
     ~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceIPConfiguration
    :ivar protocol: The transport protocol for the endpoint. Possible values are: 'Udp' or 'Tcp'.
     Known values are: "Udp" and "Tcp".
    :vartype protocol: str or ~azure.mgmt.network.v2015_06_15.models.TransportProtocol
    :ivar frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values range from 1 to 65534.
    :vartype frontend_port: int
    :ivar backend_port: The port used for the internal endpoint. Acceptable values range from 1 to
     65535.
    :vartype backend_port: int
    :ivar idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :vartype idle_timeout_in_minutes: int
    :ivar enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :vartype enable_floating_ip: bool
    :ivar provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "backend_ip_configuration": {
            "key": "properties.backendIPConfiguration",
            "type": "NetworkInterfaceIPConfiguration",
        },
        "protocol": {"key": "properties.protocol", "type": "str"},
        "frontend_port": {"key": "properties.frontendPort", "type": "int"},
        "backend_port": {"key": "properties.backendPort", "type": "int"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "enable_floating_ip": {"key": "properties.enableFloatingIP", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        backend_ip_configuration: Optional["_models.NetworkInterfaceIPConfiguration"] = None,
        protocol: Optional[Union[str, "_models.TransportProtocol"]] = None,
        frontend_port: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: Gets name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword frontend_ip_configuration: A reference to frontend IP addresses.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword backend_ip_configuration: A reference to a private IP address defined on a network
         interface of a VM. Traffic sent to the frontend port of each of the frontend IP configurations
         is forwarded to the backed IP.
        :paramtype backend_ip_configuration:
         ~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceIPConfiguration
        :keyword protocol: The transport protocol for the endpoint. Possible values are: 'Udp' or
         'Tcp'. Known values are: "Udp" and "Tcp".
        :paramtype protocol: str or ~azure.mgmt.network.v2015_06_15.models.TransportProtocol
        :keyword frontend_port: The port for the external endpoint. Port numbers for each rule must be
         unique within the Load Balancer. Acceptable values range from 1 to 65534.
        :paramtype frontend_port: int
        :keyword backend_port: The port used for the internal endpoint. Acceptable values range from 1
         to 65535.
        :paramtype backend_port: int
        :keyword idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
         between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
         protocol is set to TCP.
        :paramtype idle_timeout_in_minutes: int
        :keyword enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
         capability required to configure a SQL AlwaysOn Availability Group. This setting is required
         when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
         after you create the endpoint.
        :paramtype enable_floating_ip: bool
        :keyword provisioning_state: Gets the provisioning state of the public IP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.frontend_ip_configuration = frontend_ip_configuration
        self.backend_ip_configuration = backend_ip_configuration
        self.protocol = protocol
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.provisioning_state = provisioning_state


class IPConfiguration(SubResource):
    """IPConfiguration.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar private_ip_address: The private IP address of the IP configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The private IP allocation method. Possible values are
     'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :ivar subnet: The reference of the subnet resource.
    :vartype subnet: ~azure.mgmt.network.v2015_06_15.models.Subnet
    :ivar public_ip_address: The reference of the public IP resource.
    :vartype public_ip_address: ~azure.mgmt.network.v2015_06_15.models.PublicIPAddress
    :ivar provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "PublicIPAddress"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.Subnet"] = None,
        public_ip_address: Optional["_models.PublicIPAddress"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword private_ip_address: The private IP address of the IP configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The private IP allocation method. Possible values are
         'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
        :keyword subnet: The reference of the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.v2015_06_15.models.Subnet
        :keyword public_ip_address: The reference of the public IP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.v2015_06_15.models.PublicIPAddress
        :keyword provisioning_state: Gets the provisioning state of the public IP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class LoadBalancer(Resource):  # pylint: disable=too-many-instance-attributes
    """LoadBalancer resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar frontend_ip_configurations: Object representing the frontend IPs to be used for the load
     balancer.
    :vartype frontend_ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.FrontendIPConfiguration]
    :ivar backend_address_pools: Collection of backend address pools used by a load balancer.
    :vartype backend_address_pools: list[~azure.mgmt.network.v2015_06_15.models.BackendAddressPool]
    :ivar load_balancing_rules: Object collection representing the load balancing rules Gets the
     provisioning.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2015_06_15.models.LoadBalancingRule]
    :ivar probes: Collection of probe objects used in the load balancer.
    :vartype probes: list[~azure.mgmt.network.v2015_06_15.models.Probe]
    :ivar inbound_nat_rules: Collection of inbound NAT Rules used by a load balancer. Defining
     inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT
     pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are
     associated with individual virtual machines cannot reference an Inbound NAT pool. They have to
     reference individual inbound NAT rules.
    :vartype inbound_nat_rules: list[~azure.mgmt.network.v2015_06_15.models.InboundNatRule]
    :ivar inbound_nat_pools: Defines an external port range for inbound NAT to a single backend
     port on NICs associated with a load balancer. Inbound NAT rules are created automatically for
     each NIC associated with the Load Balancer using an external port from this range. Defining an
     Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound Nat rules.
     Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with
     individual virtual machines cannot reference an inbound NAT pool. They have to reference
     individual inbound NAT rules.
    :vartype inbound_nat_pools: list[~azure.mgmt.network.v2015_06_15.models.InboundNatPool]
    :ivar outbound_nat_rules: The outbound NAT rules.
    :vartype outbound_nat_rules: list[~azure.mgmt.network.v2015_06_15.models.OutboundNatRule]
    :ivar resource_guid: The resource GUID property of the load balancer resource.
    :vartype resource_guid: str
    :ivar provisioning_state: Gets the provisioning state of the PublicIP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "frontend_ip_configurations": {
            "key": "properties.frontendIPConfigurations",
            "type": "[FrontendIPConfiguration]",
        },
        "backend_address_pools": {"key": "properties.backendAddressPools", "type": "[BackendAddressPool]"},
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[LoadBalancingRule]"},
        "probes": {"key": "properties.probes", "type": "[Probe]"},
        "inbound_nat_rules": {"key": "properties.inboundNatRules", "type": "[InboundNatRule]"},
        "inbound_nat_pools": {"key": "properties.inboundNatPools", "type": "[InboundNatPool]"},
        "outbound_nat_rules": {"key": "properties.outboundNatRules", "type": "[OutboundNatRule]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        frontend_ip_configurations: Optional[List["_models.FrontendIPConfiguration"]] = None,
        backend_address_pools: Optional[List["_models.BackendAddressPool"]] = None,
        load_balancing_rules: Optional[List["_models.LoadBalancingRule"]] = None,
        probes: Optional[List["_models.Probe"]] = None,
        inbound_nat_rules: Optional[List["_models.InboundNatRule"]] = None,
        inbound_nat_pools: Optional[List["_models.InboundNatPool"]] = None,
        outbound_nat_rules: Optional[List["_models.OutboundNatRule"]] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword frontend_ip_configurations: Object representing the frontend IPs to be used for the
         load balancer.
        :paramtype frontend_ip_configurations:
         list[~azure.mgmt.network.v2015_06_15.models.FrontendIPConfiguration]
        :keyword backend_address_pools: Collection of backend address pools used by a load balancer.
        :paramtype backend_address_pools:
         list[~azure.mgmt.network.v2015_06_15.models.BackendAddressPool]
        :keyword load_balancing_rules: Object collection representing the load balancing rules Gets the
         provisioning.
        :paramtype load_balancing_rules: list[~azure.mgmt.network.v2015_06_15.models.LoadBalancingRule]
        :keyword probes: Collection of probe objects used in the load balancer.
        :paramtype probes: list[~azure.mgmt.network.v2015_06_15.models.Probe]
        :keyword inbound_nat_rules: Collection of inbound NAT Rules used by a load balancer. Defining
         inbound NAT rules on your load balancer is mutually exclusive with defining an inbound NAT
         pool. Inbound NAT pools are referenced from virtual machine scale sets. NICs that are
         associated with individual virtual machines cannot reference an Inbound NAT pool. They have to
         reference individual inbound NAT rules.
        :paramtype inbound_nat_rules: list[~azure.mgmt.network.v2015_06_15.models.InboundNatRule]
        :keyword inbound_nat_pools: Defines an external port range for inbound NAT to a single backend
         port on NICs associated with a load balancer. Inbound NAT rules are created automatically for
         each NIC associated with the Load Balancer using an external port from this range. Defining an
         Inbound NAT pool on your Load Balancer is mutually exclusive with defining inbound Nat rules.
         Inbound NAT pools are referenced from virtual machine scale sets. NICs that are associated with
         individual virtual machines cannot reference an inbound NAT pool. They have to reference
         individual inbound NAT rules.
        :paramtype inbound_nat_pools: list[~azure.mgmt.network.v2015_06_15.models.InboundNatPool]
        :keyword outbound_nat_rules: The outbound NAT rules.
        :paramtype outbound_nat_rules: list[~azure.mgmt.network.v2015_06_15.models.OutboundNatRule]
        :keyword resource_guid: The resource GUID property of the load balancer resource.
        :paramtype resource_guid: str
        :keyword provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pools = backend_address_pools
        self.load_balancing_rules = load_balancing_rules
        self.probes = probes
        self.inbound_nat_rules = inbound_nat_rules
        self.inbound_nat_pools = inbound_nat_pools
        self.outbound_nat_rules = outbound_nat_rules
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class LoadBalancerListResult(_serialization.Model):
    """Response for ListLoadBalancers API service call.

    :ivar value: A list of load balancers in a resource group.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.LoadBalancer]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[LoadBalancer]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.LoadBalancer"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of load balancers in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.LoadBalancer]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LoadBalancingRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """A load balancing rule for a load balancer.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar frontend_ip_configuration: A reference to frontend IP addresses.
    :vartype frontend_ip_configuration: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar backend_address_pool: A reference to a pool of DIPs. Inbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :vartype backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar probe: The reference of the load balancer probe used by the load balancing rule.
    :vartype probe: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar protocol: The transport protocol for the external endpoint. Possible values are 'Udp' or
     'Tcp'. Known values are: "Udp" and "Tcp".
    :vartype protocol: str or ~azure.mgmt.network.v2015_06_15.models.TransportProtocol
    :ivar load_distribution: The load distribution policy for this rule. Possible values are
     'Default', 'SourceIP', and 'SourceIPProtocol'. Known values are: "Default", "SourceIP", and
     "SourceIPProtocol".
    :vartype load_distribution: str or ~azure.mgmt.network.v2015_06_15.models.LoadDistribution
    :ivar frontend_port: The port for the external endpoint. Port numbers for each rule must be
     unique within the Load Balancer. Acceptable values are between 1 and 65534.
    :vartype frontend_port: int
    :ivar backend_port: The port used for internal connections on the endpoint. Acceptable values
     are between 1 and 65535.
    :vartype backend_port: int
    :ivar idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
     between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
     protocol is set to TCP.
    :vartype idle_timeout_in_minutes: int
    :ivar enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
     capability required to configure a SQL AlwaysOn Availability Group. This setting is required
     when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
     after you create the endpoint.
    :vartype enable_floating_ip: bool
    :ivar provisioning_state: Gets the provisioning state of the PublicIP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "frontend_ip_configuration": {"key": "properties.frontendIPConfiguration", "type": "SubResource"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "probe": {"key": "properties.probe", "type": "SubResource"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "load_distribution": {"key": "properties.loadDistribution", "type": "str"},
        "frontend_port": {"key": "properties.frontendPort", "type": "int"},
        "backend_port": {"key": "properties.backendPort", "type": "int"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "enable_floating_ip": {"key": "properties.enableFloatingIP", "type": "bool"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        frontend_ip_configuration: Optional["_models.SubResource"] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        probe: Optional["_models.SubResource"] = None,
        protocol: Optional[Union[str, "_models.TransportProtocol"]] = None,
        load_distribution: Optional[Union[str, "_models.LoadDistribution"]] = None,
        frontend_port: Optional[int] = None,
        backend_port: Optional[int] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        enable_floating_ip: Optional[bool] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword frontend_ip_configuration: A reference to frontend IP addresses.
        :paramtype frontend_ip_configuration: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword backend_address_pool: A reference to a pool of DIPs. Inbound traffic is randomly load
         balanced across IPs in the backend IPs.
        :paramtype backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword probe: The reference of the load balancer probe used by the load balancing rule.
        :paramtype probe: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword protocol: The transport protocol for the external endpoint. Possible values are 'Udp'
         or 'Tcp'. Known values are: "Udp" and "Tcp".
        :paramtype protocol: str or ~azure.mgmt.network.v2015_06_15.models.TransportProtocol
        :keyword load_distribution: The load distribution policy for this rule. Possible values are
         'Default', 'SourceIP', and 'SourceIPProtocol'. Known values are: "Default", "SourceIP", and
         "SourceIPProtocol".
        :paramtype load_distribution: str or ~azure.mgmt.network.v2015_06_15.models.LoadDistribution
        :keyword frontend_port: The port for the external endpoint. Port numbers for each rule must be
         unique within the Load Balancer. Acceptable values are between 1 and 65534.
        :paramtype frontend_port: int
        :keyword backend_port: The port used for internal connections on the endpoint. Acceptable
         values are between 1 and 65535.
        :paramtype backend_port: int
        :keyword idle_timeout_in_minutes: The timeout for the TCP idle connection. The value can be set
         between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the
         protocol is set to TCP.
        :paramtype idle_timeout_in_minutes: int
        :keyword enable_floating_ip: Configures a virtual machine's endpoint for the floating IP
         capability required to configure a SQL AlwaysOn Availability Group. This setting is required
         when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed
         after you create the endpoint.
        :paramtype enable_floating_ip: bool
        :keyword provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.frontend_ip_configuration = frontend_ip_configuration
        self.backend_address_pool = backend_address_pool
        self.probe = probe
        self.protocol = protocol
        self.load_distribution = load_distribution
        self.frontend_port = frontend_port
        self.backend_port = backend_port
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.enable_floating_ip = enable_floating_ip
        self.provisioning_state = provisioning_state


class LocalNetworkGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar local_network_address_space: Local network site address space.
    :vartype local_network_address_space: ~azure.mgmt.network.v2015_06_15.models.AddressSpace
    :ivar gateway_ip_address: IP address of local network gateway.
    :vartype gateway_ip_address: str
    :ivar bgp_settings: Local network gateway's BGP speaker settings.
    :vartype bgp_settings: ~azure.mgmt.network.v2015_06_15.models.BgpSettings
    :ivar resource_guid: The resource GUID property of the LocalNetworkGateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: Gets or sets Provisioning state of the LocalNetworkGateway resource
     Updating/Deleting/Failed.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "local_network_address_space": {"key": "properties.localNetworkAddressSpace", "type": "AddressSpace"},
        "gateway_ip_address": {"key": "properties.gatewayIpAddress", "type": "str"},
        "bgp_settings": {"key": "properties.bgpSettings", "type": "BgpSettings"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        local_network_address_space: Optional["_models.AddressSpace"] = None,
        gateway_ip_address: Optional[str] = None,
        bgp_settings: Optional["_models.BgpSettings"] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: Gets a unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword local_network_address_space: Local network site address space.
        :paramtype local_network_address_space: ~azure.mgmt.network.v2015_06_15.models.AddressSpace
        :keyword gateway_ip_address: IP address of local network gateway.
        :paramtype gateway_ip_address: str
        :keyword bgp_settings: Local network gateway's BGP speaker settings.
        :paramtype bgp_settings: ~azure.mgmt.network.v2015_06_15.models.BgpSettings
        :keyword resource_guid: The resource GUID property of the LocalNetworkGateway resource.
        :paramtype resource_guid: str
        :keyword provisioning_state: Gets or sets Provisioning state of the LocalNetworkGateway
         resource Updating/Deleting/Failed.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.local_network_address_space = local_network_address_space
        self.gateway_ip_address = gateway_ip_address
        self.bgp_settings = bgp_settings
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class LocalNetworkGatewayListResult(_serialization.Model):
    """Response for ListLocalNetworkGateways API service call.

    :ivar value: A list of local network gateways that exists in a resource group.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.LocalNetworkGateway]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[LocalNetworkGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.LocalNetworkGateway"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of local network gateways that exists in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.LocalNetworkGateway]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkInterface(Resource):  # pylint: disable=too-many-instance-attributes
    """A network interface in a resource group.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar virtual_machine: The reference of a virtual machine.
    :vartype virtual_machine: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar network_security_group: The reference of the NetworkSecurityGroup resource.
    :vartype network_security_group: ~azure.mgmt.network.v2015_06_15.models.NetworkSecurityGroup
    :ivar ip_configurations: A list of IPConfigurations of the network interface.
    :vartype ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceIPConfiguration]
    :ivar dns_settings: The DNS settings in network interface.
    :vartype dns_settings: ~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceDnsSettings
    :ivar mac_address: The MAC address of the network interface.
    :vartype mac_address: str
    :ivar primary: Gets whether this is a primary network interface on a virtual machine.
    :vartype primary: bool
    :ivar enable_ip_forwarding: Indicates whether IP forwarding is enabled on this network
     interface.
    :vartype enable_ip_forwarding: bool
    :ivar resource_guid: The resource GUID property of the network interface resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "virtual_machine": {"key": "properties.virtualMachine", "type": "SubResource"},
        "network_security_group": {"key": "properties.networkSecurityGroup", "type": "NetworkSecurityGroup"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[NetworkInterfaceIPConfiguration]"},
        "dns_settings": {"key": "properties.dnsSettings", "type": "NetworkInterfaceDnsSettings"},
        "mac_address": {"key": "properties.macAddress", "type": "str"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "enable_ip_forwarding": {"key": "properties.enableIPForwarding", "type": "bool"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        virtual_machine: Optional["_models.SubResource"] = None,
        network_security_group: Optional["_models.NetworkSecurityGroup"] = None,
        ip_configurations: Optional[List["_models.NetworkInterfaceIPConfiguration"]] = None,
        dns_settings: Optional["_models.NetworkInterfaceDnsSettings"] = None,
        mac_address: Optional[str] = None,
        primary: Optional[bool] = None,
        enable_ip_forwarding: Optional[bool] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword virtual_machine: The reference of a virtual machine.
        :paramtype virtual_machine: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword network_security_group: The reference of the NetworkSecurityGroup resource.
        :paramtype network_security_group: ~azure.mgmt.network.v2015_06_15.models.NetworkSecurityGroup
        :keyword ip_configurations: A list of IPConfigurations of the network interface.
        :paramtype ip_configurations:
         list[~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceIPConfiguration]
        :keyword dns_settings: The DNS settings in network interface.
        :paramtype dns_settings: ~azure.mgmt.network.v2015_06_15.models.NetworkInterfaceDnsSettings
        :keyword mac_address: The MAC address of the network interface.
        :paramtype mac_address: str
        :keyword primary: Gets whether this is a primary network interface on a virtual machine.
        :paramtype primary: bool
        :keyword enable_ip_forwarding: Indicates whether IP forwarding is enabled on this network
         interface.
        :paramtype enable_ip_forwarding: bool
        :keyword resource_guid: The resource GUID property of the network interface resource.
        :paramtype resource_guid: str
        :keyword provisioning_state: The provisioning state of the public IP resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.virtual_machine = virtual_machine
        self.network_security_group = network_security_group
        self.ip_configurations = ip_configurations
        self.dns_settings = dns_settings
        self.mac_address = mac_address
        self.primary = primary
        self.enable_ip_forwarding = enable_ip_forwarding
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class NetworkInterfaceDnsSettings(_serialization.Model):
    """DNS settings of a network interface.

    :ivar dns_servers: List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to azure
     provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it must be
     the only value in dnsServers collection.
    :vartype dns_servers: list[str]
    :ivar applied_dns_servers: If the VM that uses this NIC is part of an Availability Set, then
     this list will have the union of all DNS servers from all NICs that are part of the
     Availability Set. This property is what is configured on each of those VMs.
    :vartype applied_dns_servers: list[str]
    :ivar internal_dns_name_label: Relative DNS name for this NIC used for internal communications
     between VMs in the same virtual network.
    :vartype internal_dns_name_label: str
    :ivar internal_fqdn: Fully qualified DNS name supporting internal communications between VMs in
     the same virtual network.
    :vartype internal_fqdn: str
    """

    _attribute_map = {
        "dns_servers": {"key": "dnsServers", "type": "[str]"},
        "applied_dns_servers": {"key": "appliedDnsServers", "type": "[str]"},
        "internal_dns_name_label": {"key": "internalDnsNameLabel", "type": "str"},
        "internal_fqdn": {"key": "internalFqdn", "type": "str"},
    }

    def __init__(
        self,
        *,
        dns_servers: Optional[List[str]] = None,
        applied_dns_servers: Optional[List[str]] = None,
        internal_dns_name_label: Optional[str] = None,
        internal_fqdn: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword dns_servers: List of DNS servers IP addresses. Use 'AzureProvidedDNS' to switch to
         azure provided DNS resolution. 'AzureProvidedDNS' value cannot be combined with other IPs, it
         must be the only value in dnsServers collection.
        :paramtype dns_servers: list[str]
        :keyword applied_dns_servers: If the VM that uses this NIC is part of an Availability Set, then
         this list will have the union of all DNS servers from all NICs that are part of the
         Availability Set. This property is what is configured on each of those VMs.
        :paramtype applied_dns_servers: list[str]
        :keyword internal_dns_name_label: Relative DNS name for this NIC used for internal
         communications between VMs in the same virtual network.
        :paramtype internal_dns_name_label: str
        :keyword internal_fqdn: Fully qualified DNS name supporting internal communications between VMs
         in the same virtual network.
        :paramtype internal_fqdn: str
        """
        super().__init__(**kwargs)
        self.dns_servers = dns_servers
        self.applied_dns_servers = applied_dns_servers
        self.internal_dns_name_label = internal_dns_name_label
        self.internal_fqdn = internal_fqdn


class NetworkInterfaceIPConfiguration(SubResource):  # pylint: disable=too-many-instance-attributes
    """IPConfiguration in a network interface.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar load_balancer_backend_address_pools: The reference of LoadBalancerBackendAddressPool
     resource.
    :vartype load_balancer_backend_address_pools:
     list[~azure.mgmt.network.v2015_06_15.models.BackendAddressPool]
    :ivar load_balancer_inbound_nat_rules: A list of references of LoadBalancerInboundNatRules.
    :vartype load_balancer_inbound_nat_rules:
     list[~azure.mgmt.network.v2015_06_15.models.InboundNatRule]
    :ivar private_ip_address:
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: Defines how a private IP address is assigned. Possible
     values are: 'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :ivar subnet: Subnet in a virtual network resource.
    :vartype subnet: ~azure.mgmt.network.v2015_06_15.models.Subnet
    :ivar primary: Gets whether this is a primary customer address on the network interface.
    :vartype primary: bool
    :ivar public_ip_address: Public IP address resource.
    :vartype public_ip_address: ~azure.mgmt.network.v2015_06_15.models.PublicIPAddress
    :ivar provisioning_state:
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "load_balancer_backend_address_pools": {
            "key": "properties.loadBalancerBackendAddressPools",
            "type": "[BackendAddressPool]",
        },
        "load_balancer_inbound_nat_rules": {
            "key": "properties.loadBalancerInboundNatRules",
            "type": "[InboundNatRule]",
        },
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "Subnet"},
        "primary": {"key": "properties.primary", "type": "bool"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "PublicIPAddress"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        load_balancer_backend_address_pools: Optional[List["_models.BackendAddressPool"]] = None,
        load_balancer_inbound_nat_rules: Optional[List["_models.InboundNatRule"]] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.Subnet"] = None,
        primary: Optional[bool] = None,
        public_ip_address: Optional["_models.PublicIPAddress"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword load_balancer_backend_address_pools: The reference of LoadBalancerBackendAddressPool
         resource.
        :paramtype load_balancer_backend_address_pools:
         list[~azure.mgmt.network.v2015_06_15.models.BackendAddressPool]
        :keyword load_balancer_inbound_nat_rules: A list of references of LoadBalancerInboundNatRules.
        :paramtype load_balancer_inbound_nat_rules:
         list[~azure.mgmt.network.v2015_06_15.models.InboundNatRule]
        :keyword private_ip_address:
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: Defines how a private IP address is assigned. Possible
         values are: 'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
        :keyword subnet: Subnet in a virtual network resource.
        :paramtype subnet: ~azure.mgmt.network.v2015_06_15.models.Subnet
        :keyword primary: Gets whether this is a primary customer address on the network interface.
        :paramtype primary: bool
        :keyword public_ip_address: Public IP address resource.
        :paramtype public_ip_address: ~azure.mgmt.network.v2015_06_15.models.PublicIPAddress
        :keyword provisioning_state:
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_rules = load_balancer_inbound_nat_rules
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class NetworkInterfaceListResult(_serialization.Model):
    """Response for the ListNetworkInterface API service call.

    :ivar value: A list of network interfaces in a resource group.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.NetworkInterface]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkInterface]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkInterface"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of network interfaces in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.NetworkInterface]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class NetworkSecurityGroup(Resource):  # pylint: disable=too-many-instance-attributes
    """NetworkSecurityGroup resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar security_rules: A collection of security rules of the network security group.
    :vartype security_rules: list[~azure.mgmt.network.v2015_06_15.models.SecurityRule]
    :ivar default_security_rules: The default security rules of network security group.
    :vartype default_security_rules: list[~azure.mgmt.network.v2015_06_15.models.SecurityRule]
    :ivar network_interfaces: A collection of references to network interfaces.
    :vartype network_interfaces: list[~azure.mgmt.network.v2015_06_15.models.NetworkInterface]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2015_06_15.models.Subnet]
    :ivar resource_guid: The resource GUID property of the network security group resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "security_rules": {"key": "properties.securityRules", "type": "[SecurityRule]"},
        "default_security_rules": {"key": "properties.defaultSecurityRules", "type": "[SecurityRule]"},
        "network_interfaces": {"key": "properties.networkInterfaces", "type": "[NetworkInterface]"},
        "subnets": {"key": "properties.subnets", "type": "[Subnet]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        security_rules: Optional[List["_models.SecurityRule"]] = None,
        default_security_rules: Optional[List["_models.SecurityRule"]] = None,
        network_interfaces: Optional[List["_models.NetworkInterface"]] = None,
        subnets: Optional[List["_models.Subnet"]] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword security_rules: A collection of security rules of the network security group.
        :paramtype security_rules: list[~azure.mgmt.network.v2015_06_15.models.SecurityRule]
        :keyword default_security_rules: The default security rules of network security group.
        :paramtype default_security_rules: list[~azure.mgmt.network.v2015_06_15.models.SecurityRule]
        :keyword network_interfaces: A collection of references to network interfaces.
        :paramtype network_interfaces: list[~azure.mgmt.network.v2015_06_15.models.NetworkInterface]
        :keyword subnets: A collection of references to subnets.
        :paramtype subnets: list[~azure.mgmt.network.v2015_06_15.models.Subnet]
        :keyword resource_guid: The resource GUID property of the network security group resource.
        :paramtype resource_guid: str
        :keyword provisioning_state: The provisioning state of the public IP resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.security_rules = security_rules
        self.default_security_rules = default_security_rules
        self.network_interfaces = network_interfaces
        self.subnets = subnets
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class NetworkSecurityGroupListResult(_serialization.Model):
    """Response for ListNetworkSecurityGroups API service call.

    :ivar value: A list of NetworkSecurityGroup resources.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.NetworkSecurityGroup]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[NetworkSecurityGroup]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.NetworkSecurityGroup"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of NetworkSecurityGroup resources.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.NetworkSecurityGroup]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OutboundNatRule(SubResource):
    """Outbound NAT pool of the load balancer.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar allocated_outbound_ports: The number of outbound ports to be used for NAT.
    :vartype allocated_outbound_ports: int
    :ivar frontend_ip_configurations: The Frontend IP addresses of the load balancer.
    :vartype frontend_ip_configurations: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :ivar backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load
     balanced across IPs in the backend IPs.
    :vartype backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar provisioning_state: Gets the provisioning state of the PublicIP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "allocated_outbound_ports": {"key": "properties.allocatedOutboundPorts", "type": "int"},
        "frontend_ip_configurations": {"key": "properties.frontendIPConfigurations", "type": "[SubResource]"},
        "backend_address_pool": {"key": "properties.backendAddressPool", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        allocated_outbound_ports: Optional[int] = None,
        frontend_ip_configurations: Optional[List["_models.SubResource"]] = None,
        backend_address_pool: Optional["_models.SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword allocated_outbound_ports: The number of outbound ports to be used for NAT.
        :paramtype allocated_outbound_ports: int
        :keyword frontend_ip_configurations: The Frontend IP addresses of the load balancer.
        :paramtype frontend_ip_configurations: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
        :keyword backend_address_pool: A reference to a pool of DIPs. Outbound traffic is randomly load
         balanced across IPs in the backend IPs.
        :paramtype backend_address_pool: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword provisioning_state: Gets the provisioning state of the PublicIP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.allocated_outbound_ports = allocated_outbound_ports
        self.frontend_ip_configurations = frontend_ip_configurations
        self.backend_address_pool = backend_address_pool
        self.provisioning_state = provisioning_state


class Probe(SubResource):
    """A load balancer probe.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Gets name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar load_balancing_rules: The load balancer rules that use this probe.
    :vartype load_balancing_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
    :ivar protocol: The protocol of the end point. Possible values are: 'Http' or 'Tcp'. If 'Tcp'
     is specified, a received ACK is required for the probe to be successful. If 'Http' is
     specified, a 200 OK response from the specifies URI is required for the probe to be successful.
     Known values are: "Http" and "Tcp".
    :vartype protocol: str or ~azure.mgmt.network.v2015_06_15.models.ProbeProtocol
    :ivar port: The port for communicating the probe. Possible values range from 1 to 65535,
     inclusive.
    :vartype port: int
    :ivar interval_in_seconds: The interval, in seconds, for how frequently to probe the endpoint
     for health status. Typically, the interval is slightly less than half the allocated timeout
     period (in seconds) which allows two full probes before taking the instance out of rotation.
     The default value is 15, the minimum value is 5.
    :vartype interval_in_seconds: int
    :ivar number_of_probes: The number of probes where if no response, will result in stopping
     further traffic from being delivered to the endpoint. This values allows endpoints to be taken
     out of rotation faster or slower than the typical times used in Azure.
    :vartype number_of_probes: int
    :ivar request_path: The URI used for requesting health status from the VM. Path is required if
     a protocol is set to http. Otherwise, it is not allowed. There is no default value.
    :vartype request_path: str
    :ivar provisioning_state: Gets the provisioning state of the public IP resource. Possible
     values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "load_balancing_rules": {"key": "properties.loadBalancingRules", "type": "[SubResource]"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "port": {"key": "properties.port", "type": "int"},
        "interval_in_seconds": {"key": "properties.intervalInSeconds", "type": "int"},
        "number_of_probes": {"key": "properties.numberOfProbes", "type": "int"},
        "request_path": {"key": "properties.requestPath", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        load_balancing_rules: Optional[List["_models.SubResource"]] = None,
        protocol: Optional[Union[str, "_models.ProbeProtocol"]] = None,
        port: Optional[int] = None,
        interval_in_seconds: Optional[int] = None,
        number_of_probes: Optional[int] = None,
        request_path: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: Gets name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword load_balancing_rules: The load balancer rules that use this probe.
        :paramtype load_balancing_rules: list[~azure.mgmt.network.v2015_06_15.models.SubResource]
        :keyword protocol: The protocol of the end point. Possible values are: 'Http' or 'Tcp'. If
         'Tcp' is specified, a received ACK is required for the probe to be successful. If 'Http' is
         specified, a 200 OK response from the specifies URI is required for the probe to be successful.
         Known values are: "Http" and "Tcp".
        :paramtype protocol: str or ~azure.mgmt.network.v2015_06_15.models.ProbeProtocol
        :keyword port: The port for communicating the probe. Possible values range from 1 to 65535,
         inclusive.
        :paramtype port: int
        :keyword interval_in_seconds: The interval, in seconds, for how frequently to probe the
         endpoint for health status. Typically, the interval is slightly less than half the allocated
         timeout period (in seconds) which allows two full probes before taking the instance out of
         rotation. The default value is 15, the minimum value is 5.
        :paramtype interval_in_seconds: int
        :keyword number_of_probes: The number of probes where if no response, will result in stopping
         further traffic from being delivered to the endpoint. This values allows endpoints to be taken
         out of rotation faster or slower than the typical times used in Azure.
        :paramtype number_of_probes: int
        :keyword request_path: The URI used for requesting health status from the VM. Path is required
         if a protocol is set to http. Otherwise, it is not allowed. There is no default value.
        :paramtype request_path: str
        :keyword provisioning_state: Gets the provisioning state of the public IP resource. Possible
         values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.load_balancing_rules = load_balancing_rules
        self.protocol = protocol
        self.port = port
        self.interval_in_seconds = interval_in_seconds
        self.number_of_probes = number_of_probes
        self.request_path = request_path
        self.provisioning_state = provisioning_state


class PublicIPAddress(Resource):  # pylint: disable=too-many-instance-attributes
    """Public IP address resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar public_ip_allocation_method: The public IP allocation method. Possible values are:
     'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
    :vartype public_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :ivar ip_configuration: IPConfiguration.
    :vartype ip_configuration: ~azure.mgmt.network.v2015_06_15.models.IPConfiguration
    :ivar dns_settings: The FQDN of the DNS record associated with the public IP address.
    :vartype dns_settings: ~azure.mgmt.network.v2015_06_15.models.PublicIPAddressDnsSettings
    :ivar ip_address:
    :vartype ip_address: str
    :ivar idle_timeout_in_minutes: The idle timeout of the public IP address.
    :vartype idle_timeout_in_minutes: int
    :ivar resource_guid: The resource GUID property of the public IP resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the PublicIP resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "public_ip_allocation_method": {"key": "properties.publicIPAllocationMethod", "type": "str"},
        "ip_configuration": {"key": "properties.ipConfiguration", "type": "IPConfiguration"},
        "dns_settings": {"key": "properties.dnsSettings", "type": "PublicIPAddressDnsSettings"},
        "ip_address": {"key": "properties.ipAddress", "type": "str"},
        "idle_timeout_in_minutes": {"key": "properties.idleTimeoutInMinutes", "type": "int"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        public_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        ip_configuration: Optional["_models.IPConfiguration"] = None,
        dns_settings: Optional["_models.PublicIPAddressDnsSettings"] = None,
        ip_address: Optional[str] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword public_ip_allocation_method: The public IP allocation method. Possible values are:
         'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
        :paramtype public_ip_allocation_method: str or
         ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
        :keyword ip_configuration: IPConfiguration.
        :paramtype ip_configuration: ~azure.mgmt.network.v2015_06_15.models.IPConfiguration
        :keyword dns_settings: The FQDN of the DNS record associated with the public IP address.
        :paramtype dns_settings: ~azure.mgmt.network.v2015_06_15.models.PublicIPAddressDnsSettings
        :keyword ip_address:
        :paramtype ip_address: str
        :keyword idle_timeout_in_minutes: The idle timeout of the public IP address.
        :paramtype idle_timeout_in_minutes: int
        :keyword resource_guid: The resource GUID property of the public IP resource.
        :paramtype resource_guid: str
        :keyword provisioning_state: The provisioning state of the PublicIP resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.public_ip_allocation_method = public_ip_allocation_method
        self.ip_configuration = ip_configuration
        self.dns_settings = dns_settings
        self.ip_address = ip_address
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class PublicIPAddressDnsSettings(_serialization.Model):
    """Contains FQDN of the DNS record associated with the public IP address.

    :ivar domain_name_label: Gets or sets the Domain name label.The concatenation of the domain
     name label and the regionalized DNS zone make up the fully qualified domain name associated
     with the public IP address. If a domain name label is specified, an A DNS record is created for
     the public IP in the Microsoft Azure DNS system.
    :vartype domain_name_label: str
    :ivar fqdn: Gets the FQDN, Fully qualified domain name of the A DNS record associated with the
     public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
    :vartype fqdn: str
    :ivar reverse_fqdn: Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain name
     that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS record
     is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
    :vartype reverse_fqdn: str
    """

    _attribute_map = {
        "domain_name_label": {"key": "domainNameLabel", "type": "str"},
        "fqdn": {"key": "fqdn", "type": "str"},
        "reverse_fqdn": {"key": "reverseFqdn", "type": "str"},
    }

    def __init__(
        self,
        *,
        domain_name_label: Optional[str] = None,
        fqdn: Optional[str] = None,
        reverse_fqdn: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword domain_name_label: Gets or sets the Domain name label.The concatenation of the domain
         name label and the regionalized DNS zone make up the fully qualified domain name associated
         with the public IP address. If a domain name label is specified, an A DNS record is created for
         the public IP in the Microsoft Azure DNS system.
        :paramtype domain_name_label: str
        :keyword fqdn: Gets the FQDN, Fully qualified domain name of the A DNS record associated with
         the public IP. This is the concatenation of the domainNameLabel and the regionalized DNS zone.
        :paramtype fqdn: str
        :keyword reverse_fqdn: Gets or Sets the Reverse FQDN. A user-visible, fully qualified domain
         name that resolves to this public IP address. If the reverseFqdn is specified, then a PTR DNS
         record is created pointing from the IP address in the in-addr.arpa domain to the reverse FQDN.
        :paramtype reverse_fqdn: str
        """
        super().__init__(**kwargs)
        self.domain_name_label = domain_name_label
        self.fqdn = fqdn
        self.reverse_fqdn = reverse_fqdn


class PublicIPAddressListResult(_serialization.Model):
    """Response for ListPublicIpAddresses API service call.

    :ivar value: A list of public IP addresses that exists in a resource group.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.PublicIPAddress]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[PublicIPAddress]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.PublicIPAddress"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of public IP addresses that exists in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.PublicIPAddress]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Route(SubResource):
    """Route resource.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar address_prefix: The destination CIDR to which the route applies.
    :vartype address_prefix: str
    :ivar next_hop_type: The type of Azure hop the packet should be sent to. Possible values are:
     'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'. Known values
     are: "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", and "None".
    :vartype next_hop_type: str or ~azure.mgmt.network.v2015_06_15.models.RouteNextHopType
    :ivar next_hop_ip_address: The IP address packets should be forwarded to. Next hop values are
     only allowed in routes where the next hop type is VirtualAppliance.
    :vartype next_hop_ip_address: str
    :ivar provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "next_hop_type": {"key": "properties.nextHopType", "type": "str"},
        "next_hop_ip_address": {"key": "properties.nextHopIpAddress", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        address_prefix: Optional[str] = None,
        next_hop_type: Optional[Union[str, "_models.RouteNextHopType"]] = None,
        next_hop_ip_address: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword address_prefix: The destination CIDR to which the route applies.
        :paramtype address_prefix: str
        :keyword next_hop_type: The type of Azure hop the packet should be sent to. Possible values
         are: 'VirtualNetworkGateway', 'VnetLocal', 'Internet', 'VirtualAppliance', and 'None'. Known
         values are: "VirtualNetworkGateway", "VnetLocal", "Internet", "VirtualAppliance", and "None".
        :paramtype next_hop_type: str or ~azure.mgmt.network.v2015_06_15.models.RouteNextHopType
        :keyword next_hop_ip_address: The IP address packets should be forwarded to. Next hop values
         are only allowed in routes where the next hop type is VirtualAppliance.
        :paramtype next_hop_ip_address: str
        :keyword provisioning_state: The provisioning state of the resource. Possible values are:
         'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.address_prefix = address_prefix
        self.next_hop_type = next_hop_type
        self.next_hop_ip_address = next_hop_ip_address
        self.provisioning_state = provisioning_state


class RouteListResult(_serialization.Model):
    """Response for the ListRoute API service call.

    :ivar value: Gets a list of routes in a resource group.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.Route]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Route]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Route"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets a list of routes in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.Route]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RouteTable(Resource):
    """Route table resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar routes: Collection of routes contained within a route table.
    :vartype routes: list[~azure.mgmt.network.v2015_06_15.models.Route]
    :ivar subnets: A collection of references to subnets.
    :vartype subnets: list[~azure.mgmt.network.v2015_06_15.models.Subnet]
    :ivar provisioning_state: The provisioning state of the resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "routes": {"key": "properties.routes", "type": "[Route]"},
        "subnets": {"key": "properties.subnets", "type": "[Subnet]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        routes: Optional[List["_models.Route"]] = None,
        subnets: Optional[List["_models.Subnet"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: Gets a unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword routes: Collection of routes contained within a route table.
        :paramtype routes: list[~azure.mgmt.network.v2015_06_15.models.Route]
        :keyword subnets: A collection of references to subnets.
        :paramtype subnets: list[~azure.mgmt.network.v2015_06_15.models.Subnet]
        :keyword provisioning_state: The provisioning state of the resource. Possible values are:
         'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.routes = routes
        self.subnets = subnets
        self.provisioning_state = provisioning_state


class RouteTableListResult(_serialization.Model):
    """Response for the ListRouteTable API service call.

    :ivar value: Gets a list of route tables in a resource group.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.RouteTable]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[RouteTable]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.RouteTable"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets a list of route tables in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.RouteTable]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SecurityRule(SubResource):  # pylint: disable=too-many-instance-attributes
    """Network security rule.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar description: A description for this rule. Restricted to 140 chars.
    :vartype description: str
    :ivar protocol: Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and
     '*'. Known values are: "Tcp", "Udp", and "*".
    :vartype protocol: str or ~azure.mgmt.network.v2015_06_15.models.SecurityRuleProtocol
    :ivar source_port_range: The source port or range. Integer or range between 0 and 65535.
     Asterisk '*' can also be used to match all ports.
    :vartype source_port_range: str
    :ivar destination_port_range: The destination port or range. Integer or range between 0 and
     65535. Asterisk '*' can also be used to match all ports.
    :vartype destination_port_range: str
    :ivar source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to
     match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet'
     can also be used. If this is an ingress rule, specifies where network traffic originates from.
    :vartype source_address_prefix: str
    :ivar destination_address_prefix: The destination address prefix. CIDR or source IP range.
     Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork',
     'AzureLoadBalancer' and 'Internet' can also be used.
    :vartype destination_address_prefix: str
    :ivar access: The network traffic is allowed or denied. Possible values are: 'Allow' and
     'Deny'. Known values are: "Allow" and "Deny".
    :vartype access: str or ~azure.mgmt.network.v2015_06_15.models.SecurityRuleAccess
    :ivar priority: The priority of the rule. The value can be between 100 and 4096. The priority
     number must be unique for each rule in the collection. The lower the priority number, the
     higher the priority of the rule.
    :vartype priority: int
    :ivar direction: The direction of the rule. The direction specifies if rule will be evaluated
     on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'. Known values
     are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.network.v2015_06_15.models.SecurityRuleDirection
    :ivar provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "protocol": {"key": "properties.protocol", "type": "str"},
        "source_port_range": {"key": "properties.sourcePortRange", "type": "str"},
        "destination_port_range": {"key": "properties.destinationPortRange", "type": "str"},
        "source_address_prefix": {"key": "properties.sourceAddressPrefix", "type": "str"},
        "destination_address_prefix": {"key": "properties.destinationAddressPrefix", "type": "str"},
        "access": {"key": "properties.access", "type": "str"},
        "priority": {"key": "properties.priority", "type": "int"},
        "direction": {"key": "properties.direction", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        description: Optional[str] = None,
        protocol: Optional[Union[str, "_models.SecurityRuleProtocol"]] = None,
        source_port_range: Optional[str] = None,
        destination_port_range: Optional[str] = None,
        source_address_prefix: Optional[str] = None,
        destination_address_prefix: Optional[str] = None,
        access: Optional[Union[str, "_models.SecurityRuleAccess"]] = None,
        priority: Optional[int] = None,
        direction: Optional[Union[str, "_models.SecurityRuleDirection"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword description: A description for this rule. Restricted to 140 chars.
        :paramtype description: str
        :keyword protocol: Network protocol this rule applies to. Possible values are 'Tcp', 'Udp', and
         '*'. Known values are: "Tcp", "Udp", and "*".
        :paramtype protocol: str or ~azure.mgmt.network.v2015_06_15.models.SecurityRuleProtocol
        :keyword source_port_range: The source port or range. Integer or range between 0 and 65535.
         Asterisk '*' can also be used to match all ports.
        :paramtype source_port_range: str
        :keyword destination_port_range: The destination port or range. Integer or range between 0 and
         65535. Asterisk '*' can also be used to match all ports.
        :paramtype destination_port_range: str
        :keyword source_address_prefix: The CIDR or source IP range. Asterisk '*' can also be used to
         match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet'
         can also be used. If this is an ingress rule, specifies where network traffic originates from.
        :paramtype source_address_prefix: str
        :keyword destination_address_prefix: The destination address prefix. CIDR or source IP range.
         Asterisk '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork',
         'AzureLoadBalancer' and 'Internet' can also be used.
        :paramtype destination_address_prefix: str
        :keyword access: The network traffic is allowed or denied. Possible values are: 'Allow' and
         'Deny'. Known values are: "Allow" and "Deny".
        :paramtype access: str or ~azure.mgmt.network.v2015_06_15.models.SecurityRuleAccess
        :keyword priority: The priority of the rule. The value can be between 100 and 4096. The
         priority number must be unique for each rule in the collection. The lower the priority number,
         the higher the priority of the rule.
        :paramtype priority: int
        :keyword direction: The direction of the rule. The direction specifies if rule will be
         evaluated on incoming or outgoing traffic. Possible values are: 'Inbound' and 'Outbound'. Known
         values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.network.v2015_06_15.models.SecurityRuleDirection
        :keyword provisioning_state: The provisioning state of the public IP resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.description = description
        self.protocol = protocol
        self.source_port_range = source_port_range
        self.destination_port_range = destination_port_range
        self.source_address_prefix = source_address_prefix
        self.destination_address_prefix = destination_address_prefix
        self.access = access
        self.priority = priority
        self.direction = direction
        self.provisioning_state = provisioning_state


class SecurityRuleListResult(_serialization.Model):
    """Response for ListSecurityRule API service call. Retrieves all security rules that belongs to a
    network security group.

    :ivar value: The security rules in a network security group.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.SecurityRule]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityRule]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.SecurityRule"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The security rules in a network security group.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.SecurityRule]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Subnet(SubResource):
    """Subnet in a virtual network resource.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar address_prefix: The address prefix for the subnet.
    :vartype address_prefix: str
    :ivar network_security_group: The reference of the NetworkSecurityGroup resource.
    :vartype network_security_group: ~azure.mgmt.network.v2015_06_15.models.NetworkSecurityGroup
    :ivar route_table: The reference of the RouteTable resource.
    :vartype route_table: ~azure.mgmt.network.v2015_06_15.models.RouteTable
    :ivar ip_configurations: Gets an array of references to the network interface IP configurations
     using subnet.
    :vartype ip_configurations: list[~azure.mgmt.network.v2015_06_15.models.IPConfiguration]
    :ivar provisioning_state: The provisioning state of the resource.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "address_prefix": {"key": "properties.addressPrefix", "type": "str"},
        "network_security_group": {"key": "properties.networkSecurityGroup", "type": "NetworkSecurityGroup"},
        "route_table": {"key": "properties.routeTable", "type": "RouteTable"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[IPConfiguration]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        address_prefix: Optional[str] = None,
        network_security_group: Optional["_models.NetworkSecurityGroup"] = None,
        route_table: Optional["_models.RouteTable"] = None,
        ip_configurations: Optional[List["_models.IPConfiguration"]] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword address_prefix: The address prefix for the subnet.
        :paramtype address_prefix: str
        :keyword network_security_group: The reference of the NetworkSecurityGroup resource.
        :paramtype network_security_group: ~azure.mgmt.network.v2015_06_15.models.NetworkSecurityGroup
        :keyword route_table: The reference of the RouteTable resource.
        :paramtype route_table: ~azure.mgmt.network.v2015_06_15.models.RouteTable
        :keyword ip_configurations: Gets an array of references to the network interface IP
         configurations using subnet.
        :paramtype ip_configurations: list[~azure.mgmt.network.v2015_06_15.models.IPConfiguration]
        :keyword provisioning_state: The provisioning state of the resource.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.address_prefix = address_prefix
        self.network_security_group = network_security_group
        self.route_table = route_table
        self.ip_configurations = ip_configurations
        self.provisioning_state = provisioning_state


class SubnetListResult(_serialization.Model):
    """Response for ListSubnets API service callRetrieves all subnet that belongs to a virtual
    network.

    :ivar value: The subnets in a virtual network.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.Subnet]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Subnet]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Subnet"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The subnets in a virtual network.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.Subnet]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class Usage(_serialization.Model):
    """Describes network resource usage.

    All required parameters must be populated in order to send to Azure.

    :ivar unit: An enum describing the unit of measurement. Required. "Count"
    :vartype unit: str or ~azure.mgmt.network.v2015_06_15.models.UsageUnit
    :ivar current_value: The current value of the usage. Required.
    :vartype current_value: int
    :ivar limit: The limit of usage. Required.
    :vartype limit: int
    :ivar name: The name of the type of usage. Required.
    :vartype name: ~azure.mgmt.network.v2015_06_15.models.UsageName
    """

    _validation = {
        "unit": {"required": True},
        "current_value": {"required": True},
        "limit": {"required": True},
        "name": {"required": True},
    }

    _attribute_map = {
        "unit": {"key": "unit", "type": "str"},
        "current_value": {"key": "currentValue", "type": "int"},
        "limit": {"key": "limit", "type": "int"},
        "name": {"key": "name", "type": "UsageName"},
    }

    def __init__(
        self,
        *,
        unit: Union[str, "_models.UsageUnit"],
        current_value: int,
        limit: int,
        name: "_models.UsageName",
        **kwargs: Any
    ) -> None:
        """
        :keyword unit: An enum describing the unit of measurement. Required. "Count"
        :paramtype unit: str or ~azure.mgmt.network.v2015_06_15.models.UsageUnit
        :keyword current_value: The current value of the usage. Required.
        :paramtype current_value: int
        :keyword limit: The limit of usage. Required.
        :paramtype limit: int
        :keyword name: The name of the type of usage. Required.
        :paramtype name: ~azure.mgmt.network.v2015_06_15.models.UsageName
        """
        super().__init__(**kwargs)
        self.unit = unit
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UsageName(_serialization.Model):
    """The usage names.

    :ivar value: A string describing the resource name.
    :vartype value: str
    :ivar localized_value: A localized string describing the resource name.
    :vartype localized_value: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "str"},
        "localized_value": {"key": "localizedValue", "type": "str"},
    }

    def __init__(self, *, value: Optional[str] = None, localized_value: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword value: A string describing the resource name.
        :paramtype value: str
        :keyword localized_value: A localized string describing the resource name.
        :paramtype localized_value: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class UsagesListResult(_serialization.Model):
    """The list usages operation response.

    :ivar value: The list network resource usages.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.Usage]
    :ivar next_link: URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[Usage]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.Usage"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: The list network resource usages.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.Usage]
        :keyword next_link: URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetwork(Resource):  # pylint: disable=too-many-instance-attributes
    """Virtual Network resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar address_space: The AddressSpace that contains an array of IP address ranges that can be
     used by subnets.
    :vartype address_space: ~azure.mgmt.network.v2015_06_15.models.AddressSpace
    :ivar dhcp_options: The dhcpOptions that contains an array of DNS servers available to VMs
     deployed in the virtual network.
    :vartype dhcp_options: ~azure.mgmt.network.v2015_06_15.models.DhcpOptions
    :ivar subnets: A list of subnets in a Virtual Network.
    :vartype subnets: list[~azure.mgmt.network.v2015_06_15.models.Subnet]
    :ivar resource_guid: The resourceGuid property of the Virtual Network resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the PublicIP resource. Possible values are:
     'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "address_space": {"key": "properties.addressSpace", "type": "AddressSpace"},
        "dhcp_options": {"key": "properties.dhcpOptions", "type": "DhcpOptions"},
        "subnets": {"key": "properties.subnets", "type": "[Subnet]"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        address_space: Optional["_models.AddressSpace"] = None,
        dhcp_options: Optional["_models.DhcpOptions"] = None,
        subnets: Optional[List["_models.Subnet"]] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: Gets a unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword address_space: The AddressSpace that contains an array of IP address ranges that can
         be used by subnets.
        :paramtype address_space: ~azure.mgmt.network.v2015_06_15.models.AddressSpace
        :keyword dhcp_options: The dhcpOptions that contains an array of DNS servers available to VMs
         deployed in the virtual network.
        :paramtype dhcp_options: ~azure.mgmt.network.v2015_06_15.models.DhcpOptions
        :keyword subnets: A list of subnets in a Virtual Network.
        :paramtype subnets: list[~azure.mgmt.network.v2015_06_15.models.Subnet]
        :keyword resource_guid: The resourceGuid property of the Virtual Network resource.
        :paramtype resource_guid: str
        :keyword provisioning_state: The provisioning state of the PublicIP resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.address_space = address_space
        self.dhcp_options = dhcp_options
        self.subnets = subnets
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class VirtualNetworkGateway(Resource):  # pylint: disable=too-many-instance-attributes
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar ip_configurations: IP configurations for virtual network gateway.
    :vartype ip_configurations:
     list[~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayIPConfiguration]
    :ivar gateway_type: The type of this virtual network gateway. Possible values are: 'Vpn' and
     'ExpressRoute'. Known values are: "Vpn" and "ExpressRoute".
    :vartype gateway_type: str or ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayType
    :ivar vpn_type: The type of this virtual network gateway. Possible values are: 'PolicyBased'
     and 'RouteBased'. Known values are: "PolicyBased" and "RouteBased".
    :vartype vpn_type: str or ~azure.mgmt.network.v2015_06_15.models.VpnType
    :ivar enable_bgp: Whether BGP is enabled for this virtual network gateway or not.
    :vartype enable_bgp: bool
    :ivar gateway_default_site: The reference of the LocalNetworkGateway resource which represents
     local network site having default routes. Assign Null value in case of removing existing
     default site setting.
    :vartype gateway_default_site: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar sku: The reference of the VirtualNetworkGatewaySku resource which represents the SKU
     selected for Virtual network gateway.
    :vartype sku: ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewaySku
    :ivar vpn_client_configuration: The reference of the VpnClientConfiguration resource which
     represents the P2S VpnClient configurations.
    :vartype vpn_client_configuration:
     ~azure.mgmt.network.v2015_06_15.models.VpnClientConfiguration
    :ivar bgp_settings: Virtual network gateway's BGP speaker settings.
    :vartype bgp_settings: ~azure.mgmt.network.v2015_06_15.models.BgpSettings
    :ivar resource_guid: The resource GUID property of the VirtualNetworkGateway resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the VirtualNetworkGateway resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "ip_configurations": {"key": "properties.ipConfigurations", "type": "[VirtualNetworkGatewayIPConfiguration]"},
        "gateway_type": {"key": "properties.gatewayType", "type": "str"},
        "vpn_type": {"key": "properties.vpnType", "type": "str"},
        "enable_bgp": {"key": "properties.enableBgp", "type": "bool"},
        "gateway_default_site": {"key": "properties.gatewayDefaultSite", "type": "SubResource"},
        "sku": {"key": "properties.sku", "type": "VirtualNetworkGatewaySku"},
        "vpn_client_configuration": {"key": "properties.vpnClientConfiguration", "type": "VpnClientConfiguration"},
        "bgp_settings": {"key": "properties.bgpSettings", "type": "BgpSettings"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        ip_configurations: Optional[List["_models.VirtualNetworkGatewayIPConfiguration"]] = None,
        gateway_type: Optional[Union[str, "_models.VirtualNetworkGatewayType"]] = None,
        vpn_type: Optional[Union[str, "_models.VpnType"]] = None,
        enable_bgp: Optional[bool] = None,
        gateway_default_site: Optional["_models.SubResource"] = None,
        sku: Optional["_models.VirtualNetworkGatewaySku"] = None,
        vpn_client_configuration: Optional["_models.VpnClientConfiguration"] = None,
        bgp_settings: Optional["_models.BgpSettings"] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: Gets a unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword ip_configurations: IP configurations for virtual network gateway.
        :paramtype ip_configurations:
         list[~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayIPConfiguration]
        :keyword gateway_type: The type of this virtual network gateway. Possible values are: 'Vpn' and
         'ExpressRoute'. Known values are: "Vpn" and "ExpressRoute".
        :paramtype gateway_type: str or
         ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayType
        :keyword vpn_type: The type of this virtual network gateway. Possible values are: 'PolicyBased'
         and 'RouteBased'. Known values are: "PolicyBased" and "RouteBased".
        :paramtype vpn_type: str or ~azure.mgmt.network.v2015_06_15.models.VpnType
        :keyword enable_bgp: Whether BGP is enabled for this virtual network gateway or not.
        :paramtype enable_bgp: bool
        :keyword gateway_default_site: The reference of the LocalNetworkGateway resource which
         represents local network site having default routes. Assign Null value in case of removing
         existing default site setting.
        :paramtype gateway_default_site: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword sku: The reference of the VirtualNetworkGatewaySku resource which represents the SKU
         selected for Virtual network gateway.
        :paramtype sku: ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewaySku
        :keyword vpn_client_configuration: The reference of the VpnClientConfiguration resource which
         represents the P2S VpnClient configurations.
        :paramtype vpn_client_configuration:
         ~azure.mgmt.network.v2015_06_15.models.VpnClientConfiguration
        :keyword bgp_settings: Virtual network gateway's BGP speaker settings.
        :paramtype bgp_settings: ~azure.mgmt.network.v2015_06_15.models.BgpSettings
        :keyword resource_guid: The resource GUID property of the VirtualNetworkGateway resource.
        :paramtype resource_guid: str
        :keyword provisioning_state: The provisioning state of the VirtualNetworkGateway resource.
         Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.ip_configurations = ip_configurations
        self.gateway_type = gateway_type
        self.vpn_type = vpn_type
        self.enable_bgp = enable_bgp
        self.gateway_default_site = gateway_default_site
        self.sku = sku
        self.vpn_client_configuration = vpn_client_configuration
        self.bgp_settings = bgp_settings
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class VirtualNetworkGatewayConnection(Resource):  # pylint: disable=too-many-instance-attributes
    """A common class for general resource information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar etag: Gets a unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar authorization_key: The authorizationKey.
    :vartype authorization_key: str
    :ivar virtual_network_gateway1: A common class for general resource information.
    :vartype virtual_network_gateway1: ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGateway
    :ivar virtual_network_gateway2: A common class for general resource information.
    :vartype virtual_network_gateway2: ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGateway
    :ivar local_network_gateway2: A common class for general resource information.
    :vartype local_network_gateway2: ~azure.mgmt.network.v2015_06_15.models.LocalNetworkGateway
    :ivar connection_type: Gateway connection type. Possible values are:
     'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient. Known values are: "IPsec", "Vnet2Vnet",
     "ExpressRoute", and "VPNClient".
    :vartype connection_type: str or
     ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayConnectionType
    :ivar routing_weight: The routing weight.
    :vartype routing_weight: int
    :ivar shared_key: The IPSec shared key.
    :vartype shared_key: str
    :ivar connection_status: Virtual network Gateway connection status. Possible values are
     'Unknown', 'Connecting', 'Connected' and 'NotConnected'. Known values are: "Unknown",
     "Connecting", "Connected", and "NotConnected".
    :vartype connection_status: str or
     ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayConnectionStatus
    :ivar egress_bytes_transferred: The egress bytes transferred in this connection.
    :vartype egress_bytes_transferred: int
    :ivar ingress_bytes_transferred: The ingress bytes transferred in this connection.
    :vartype ingress_bytes_transferred: int
    :ivar peer: The reference to peerings resource.
    :vartype peer: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar enable_bgp: EnableBgp flag.
    :vartype enable_bgp: bool
    :ivar resource_guid: The resource GUID property of the VirtualNetworkGatewayConnection
     resource.
    :vartype resource_guid: str
    :ivar provisioning_state: The provisioning state of the VirtualNetworkGatewayConnection
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _validation = {
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "location": {"key": "location", "type": "str"},
        "tags": {"key": "tags", "type": "{str}"},
        "etag": {"key": "etag", "type": "str"},
        "authorization_key": {"key": "properties.authorizationKey", "type": "str"},
        "virtual_network_gateway1": {"key": "properties.virtualNetworkGateway1", "type": "VirtualNetworkGateway"},
        "virtual_network_gateway2": {"key": "properties.virtualNetworkGateway2", "type": "VirtualNetworkGateway"},
        "local_network_gateway2": {"key": "properties.localNetworkGateway2", "type": "LocalNetworkGateway"},
        "connection_type": {"key": "properties.connectionType", "type": "str"},
        "routing_weight": {"key": "properties.routingWeight", "type": "int"},
        "shared_key": {"key": "properties.sharedKey", "type": "str"},
        "connection_status": {"key": "properties.connectionStatus", "type": "str"},
        "egress_bytes_transferred": {"key": "properties.egressBytesTransferred", "type": "int"},
        "ingress_bytes_transferred": {"key": "properties.ingressBytesTransferred", "type": "int"},
        "peer": {"key": "properties.peer", "type": "SubResource"},
        "enable_bgp": {"key": "properties.enableBgp", "type": "bool"},
        "resource_guid": {"key": "properties.resourceGuid", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        location: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        etag: Optional[str] = None,
        authorization_key: Optional[str] = None,
        virtual_network_gateway1: Optional["_models.VirtualNetworkGateway"] = None,
        virtual_network_gateway2: Optional["_models.VirtualNetworkGateway"] = None,
        local_network_gateway2: Optional["_models.LocalNetworkGateway"] = None,
        connection_type: Optional[Union[str, "_models.VirtualNetworkGatewayConnectionType"]] = None,
        routing_weight: Optional[int] = None,
        shared_key: Optional[str] = None,
        connection_status: Optional[Union[str, "_models.VirtualNetworkGatewayConnectionStatus"]] = None,
        egress_bytes_transferred: Optional[int] = None,
        ingress_bytes_transferred: Optional[int] = None,
        peer: Optional["_models.SubResource"] = None,
        enable_bgp: Optional[bool] = None,
        resource_guid: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword location: Resource location.
        :paramtype location: str
        :keyword tags: Resource tags.
        :paramtype tags: dict[str, str]
        :keyword etag: Gets a unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword authorization_key: The authorizationKey.
        :paramtype authorization_key: str
        :keyword virtual_network_gateway1: A common class for general resource information.
        :paramtype virtual_network_gateway1:
         ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGateway
        :keyword virtual_network_gateway2: A common class for general resource information.
        :paramtype virtual_network_gateway2:
         ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGateway
        :keyword local_network_gateway2: A common class for general resource information.
        :paramtype local_network_gateway2: ~azure.mgmt.network.v2015_06_15.models.LocalNetworkGateway
        :keyword connection_type: Gateway connection type. Possible values are:
         'IPsec','Vnet2Vnet','ExpressRoute', and 'VPNClient. Known values are: "IPsec", "Vnet2Vnet",
         "ExpressRoute", and "VPNClient".
        :paramtype connection_type: str or
         ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayConnectionType
        :keyword routing_weight: The routing weight.
        :paramtype routing_weight: int
        :keyword shared_key: The IPSec shared key.
        :paramtype shared_key: str
        :keyword connection_status: Virtual network Gateway connection status. Possible values are
         'Unknown', 'Connecting', 'Connected' and 'NotConnected'. Known values are: "Unknown",
         "Connecting", "Connected", and "NotConnected".
        :paramtype connection_status: str or
         ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayConnectionStatus
        :keyword egress_bytes_transferred: The egress bytes transferred in this connection.
        :paramtype egress_bytes_transferred: int
        :keyword ingress_bytes_transferred: The ingress bytes transferred in this connection.
        :paramtype ingress_bytes_transferred: int
        :keyword peer: The reference to peerings resource.
        :paramtype peer: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword enable_bgp: EnableBgp flag.
        :paramtype enable_bgp: bool
        :keyword resource_guid: The resource GUID property of the VirtualNetworkGatewayConnection
         resource.
        :paramtype resource_guid: str
        :keyword provisioning_state: The provisioning state of the VirtualNetworkGatewayConnection
         resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, location=location, tags=tags, **kwargs)
        self.etag = etag
        self.authorization_key = authorization_key
        self.virtual_network_gateway1 = virtual_network_gateway1
        self.virtual_network_gateway2 = virtual_network_gateway2
        self.local_network_gateway2 = local_network_gateway2
        self.connection_type = connection_type
        self.routing_weight = routing_weight
        self.shared_key = shared_key
        self.connection_status = connection_status
        self.egress_bytes_transferred = egress_bytes_transferred
        self.ingress_bytes_transferred = ingress_bytes_transferred
        self.peer = peer
        self.enable_bgp = enable_bgp
        self.resource_guid = resource_guid
        self.provisioning_state = provisioning_state


class VirtualNetworkGatewayConnectionListResult(_serialization.Model):
    """Response for the ListVirtualNetworkGatewayConnections API service call.

    :ivar value: Gets a list of VirtualNetworkGatewayConnection resources that exists in a resource
     group.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayConnection]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkGatewayConnection]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.VirtualNetworkGatewayConnection"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets a list of VirtualNetworkGatewayConnection resources that exists in a
         resource group.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewayConnection]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetworkGatewayIPConfiguration(SubResource):
    """IP configuration for virtual network gateway.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar private_ip_address: Gets or sets the privateIPAddress of the IP Configuration.
    :vartype private_ip_address: str
    :ivar private_ip_allocation_method: The private IP allocation method. Possible values are:
     'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
    :vartype private_ip_allocation_method: str or
     ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
    :ivar subnet: The reference of the subnet resource.
    :vartype subnet: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar public_ip_address: The reference of the public IP resource.
    :vartype public_ip_address: ~azure.mgmt.network.v2015_06_15.models.SubResource
    :ivar provisioning_state: The provisioning state of the public IP resource. Possible values
     are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "private_ip_address": {"key": "properties.privateIPAddress", "type": "str"},
        "private_ip_allocation_method": {"key": "properties.privateIPAllocationMethod", "type": "str"},
        "subnet": {"key": "properties.subnet", "type": "SubResource"},
        "public_ip_address": {"key": "properties.publicIPAddress", "type": "SubResource"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        private_ip_address: Optional[str] = None,
        private_ip_allocation_method: Optional[Union[str, "_models.IPAllocationMethod"]] = None,
        subnet: Optional["_models.SubResource"] = None,
        public_ip_address: Optional["_models.SubResource"] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword private_ip_address: Gets or sets the privateIPAddress of the IP Configuration.
        :paramtype private_ip_address: str
        :keyword private_ip_allocation_method: The private IP allocation method. Possible values are:
         'Static' and 'Dynamic'. Known values are: "Static" and "Dynamic".
        :paramtype private_ip_allocation_method: str or
         ~azure.mgmt.network.v2015_06_15.models.IPAllocationMethod
        :keyword subnet: The reference of the subnet resource.
        :paramtype subnet: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword public_ip_address: The reference of the public IP resource.
        :paramtype public_ip_address: ~azure.mgmt.network.v2015_06_15.models.SubResource
        :keyword provisioning_state: The provisioning state of the public IP resource. Possible values
         are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.private_ip_address = private_ip_address
        self.private_ip_allocation_method = private_ip_allocation_method
        self.subnet = subnet
        self.public_ip_address = public_ip_address
        self.provisioning_state = provisioning_state


class VirtualNetworkGatewayListResult(_serialization.Model):
    """Response for the ListVirtualNetworkGateways API service call.

    :ivar value: Gets a list of VirtualNetworkGateway resources that exists in a resource group.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGateway]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetworkGateway]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.VirtualNetworkGateway"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets a list of VirtualNetworkGateway resources that exists in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGateway]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualNetworkGatewaySku(_serialization.Model):
    """VirtualNetworkGatewaySku details.

    :ivar name: Gateway sku name -Basic/HighPerformance/Standard. Known values are: "Basic",
     "HighPerformance", and "Standard".
    :vartype name: str or ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewaySkuName
    :ivar tier: Gateway sku tier -Basic/HighPerformance/Standard. Known values are: "Basic",
     "HighPerformance", and "Standard".
    :vartype tier: str or ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewaySkuTier
    :ivar capacity: The capacity.
    :vartype capacity: int
    """

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "tier": {"key": "tier", "type": "str"},
        "capacity": {"key": "capacity", "type": "int"},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "_models.VirtualNetworkGatewaySkuName"]] = None,
        tier: Optional[Union[str, "_models.VirtualNetworkGatewaySkuTier"]] = None,
        capacity: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: Gateway sku name -Basic/HighPerformance/Standard. Known values are: "Basic",
         "HighPerformance", and "Standard".
        :paramtype name: str or ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewaySkuName
        :keyword tier: Gateway sku tier -Basic/HighPerformance/Standard. Known values are: "Basic",
         "HighPerformance", and "Standard".
        :paramtype tier: str or ~azure.mgmt.network.v2015_06_15.models.VirtualNetworkGatewaySkuTier
        :keyword capacity: The capacity.
        :paramtype capacity: int
        """
        super().__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class VirtualNetworkListResult(_serialization.Model):
    """Response for the ListVirtualNetworks API service call.

    :ivar value: Gets a list of VirtualNetwork resources in a resource group.
    :vartype value: list[~azure.mgmt.network.v2015_06_15.models.VirtualNetwork]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[VirtualNetwork]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self, *, value: Optional[List["_models.VirtualNetwork"]] = None, next_link: Optional[str] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value: Gets a list of VirtualNetwork resources in a resource group.
        :paramtype value: list[~azure.mgmt.network.v2015_06_15.models.VirtualNetwork]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VpnClientConfiguration(_serialization.Model):
    """VpnClientConfiguration for P2S client.

    :ivar vpn_client_address_pool: Gets or sets the reference of the Address space resource which
     represents Address space for P2S VpnClient.
    :vartype vpn_client_address_pool: ~azure.mgmt.network.v2015_06_15.models.AddressSpace
    :ivar vpn_client_root_certificates: VpnClientRootCertificate for Virtual network gateway.
    :vartype vpn_client_root_certificates:
     list[~azure.mgmt.network.v2015_06_15.models.VpnClientRootCertificate]
    :ivar vpn_client_revoked_certificates: VpnClientRevokedCertificate for Virtual network gateway.
    :vartype vpn_client_revoked_certificates:
     list[~azure.mgmt.network.v2015_06_15.models.VpnClientRevokedCertificate]
    """

    _attribute_map = {
        "vpn_client_address_pool": {"key": "vpnClientAddressPool", "type": "AddressSpace"},
        "vpn_client_root_certificates": {"key": "vpnClientRootCertificates", "type": "[VpnClientRootCertificate]"},
        "vpn_client_revoked_certificates": {
            "key": "vpnClientRevokedCertificates",
            "type": "[VpnClientRevokedCertificate]",
        },
    }

    def __init__(
        self,
        *,
        vpn_client_address_pool: Optional["_models.AddressSpace"] = None,
        vpn_client_root_certificates: Optional[List["_models.VpnClientRootCertificate"]] = None,
        vpn_client_revoked_certificates: Optional[List["_models.VpnClientRevokedCertificate"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword vpn_client_address_pool: Gets or sets the reference of the Address space resource
         which represents Address space for P2S VpnClient.
        :paramtype vpn_client_address_pool: ~azure.mgmt.network.v2015_06_15.models.AddressSpace
        :keyword vpn_client_root_certificates: VpnClientRootCertificate for Virtual network gateway.
        :paramtype vpn_client_root_certificates:
         list[~azure.mgmt.network.v2015_06_15.models.VpnClientRootCertificate]
        :keyword vpn_client_revoked_certificates: VpnClientRevokedCertificate for Virtual network
         gateway.
        :paramtype vpn_client_revoked_certificates:
         list[~azure.mgmt.network.v2015_06_15.models.VpnClientRevokedCertificate]
        """
        super().__init__(**kwargs)
        self.vpn_client_address_pool = vpn_client_address_pool
        self.vpn_client_root_certificates = vpn_client_root_certificates
        self.vpn_client_revoked_certificates = vpn_client_revoked_certificates


class VpnClientParameters(_serialization.Model):
    """VpnClientParameters.

    :ivar processor_architecture: VPN client Processor Architecture. Possible values are: 'AMD64'
     and 'X86'. Known values are: "Amd64" and "X86".
    :vartype processor_architecture: str or
     ~azure.mgmt.network.v2015_06_15.models.ProcessorArchitecture
    """

    _attribute_map = {
        "processor_architecture": {"key": "ProcessorArchitecture", "type": "str"},
    }

    def __init__(
        self, *, processor_architecture: Optional[Union[str, "_models.ProcessorArchitecture"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword processor_architecture: VPN client Processor Architecture. Possible values are:
         'AMD64' and 'X86'. Known values are: "Amd64" and "X86".
        :paramtype processor_architecture: str or
         ~azure.mgmt.network.v2015_06_15.models.ProcessorArchitecture
        """
        super().__init__(**kwargs)
        self.processor_architecture = processor_architecture


class VpnClientRevokedCertificate(SubResource):
    """VPN client revoked certificate of virtual network gateway.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar thumbprint: The revoked VPN client certificate thumbprint.
    :vartype thumbprint: str
    :ivar provisioning_state: The provisioning state of the VPN client revoked certificate
     resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "thumbprint": {"key": "properties.thumbprint", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        thumbprint: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword thumbprint: The revoked VPN client certificate thumbprint.
        :paramtype thumbprint: str
        :keyword provisioning_state: The provisioning state of the VPN client revoked certificate
         resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.thumbprint = thumbprint
        self.provisioning_state = provisioning_state


class VpnClientRootCertificate(SubResource):
    """VPN client root certificate of virtual network gateway.

    :ivar id: Resource Identifier.
    :vartype id: str
    :ivar name: The name of the resource that is unique within a resource group. This name can be
     used to access the resource.
    :vartype name: str
    :ivar etag: A unique read-only string that changes whenever the resource is updated.
    :vartype etag: str
    :ivar public_cert_data: Gets or sets the certificate public data.
    :vartype public_cert_data: str
    :ivar provisioning_state: The provisioning state of the VPN client root certificate resource.
     Possible values are: 'Updating', 'Deleting', and 'Failed'.
    :vartype provisioning_state: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "etag": {"key": "etag", "type": "str"},
        "public_cert_data": {"key": "properties.publicCertData", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,  # pylint: disable=redefined-builtin
        name: Optional[str] = None,
        etag: Optional[str] = None,
        public_cert_data: Optional[str] = None,
        provisioning_state: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource Identifier.
        :paramtype id: str
        :keyword name: The name of the resource that is unique within a resource group. This name can
         be used to access the resource.
        :paramtype name: str
        :keyword etag: A unique read-only string that changes whenever the resource is updated.
        :paramtype etag: str
        :keyword public_cert_data: Gets or sets the certificate public data.
        :paramtype public_cert_data: str
        :keyword provisioning_state: The provisioning state of the VPN client root certificate
         resource. Possible values are: 'Updating', 'Deleting', and 'Failed'.
        :paramtype provisioning_state: str
        """
        super().__init__(id=id, **kwargs)
        self.name = name
        self.etag = etag
        self.public_cert_data = public_cert_data
        self.provisioning_state = provisioning_state
