# Tutorials

This page lists further learning materials and code walkthroughs for the H3 library and bindings. Contributions to this list are welcome, please feel free to open a [pull request](https://github.com/uber/h3/tree/master/docs/community/tutorials.md).

## Videos

- [Introduction to H3](https://www.youtube.com/watch?v=wDuKeUkNLkQ) (June 2019)
- [Engineering an H3-based Geospatial Data Platform at Uber](https://www.youtube.com/watch?v=aCj-YVZ0mlE)
- [Building City Cores with H3](https://www.youtube.com/watch?v=PutOhe8HVNU)
- [H3-js: Hexagons in the Browser](https://www.youtube.com/watch?v=BsMIrBHLfLE&list=PLLEUtp5eGr7CNf9Bj3w3i30rzaU8lKZeV&index=16&t=0s)
- [Hexagon Convolution for Data Smoothing & Forecasting](https://www.youtube.com/watch?v=z3PaGIQTFSE&list=PLLEUtp5eGr7CNf9Bj3w3i30rzaU8lKZeV&index=14&t=0s)
- [Spatial Intelligence Using Hex](https://www.youtube.com/watch?v=0OlIpNAqokQ&list=PLLEUtp5eGr7CNf9Bj3w3i30rzaU8lKZeV&index=18&t=0s)
- [Hierarchical Hexagons in Depth](https://www.youtube.com/watch?v=UILoSqvIM2w&list=PLLEUtp5eGr7CNf9Bj3w3i30rzaU8lKZeV&index=15&t=0s)
- [H3: Tiling the Earth with Hexagons](https://www.youtube.com/watch?v=_-265mfMzl4&list=PLLEUtp5eGr7CNf9Bj3w3i30rzaU8lKZeV&index=22&t=0s) (Introduction to H3, November 2018)
- [H3: Tiling the Earth with Hexagons](https://www.youtube.com/watch?v=ay2uwtRO3QE) (Introduction to H3, January 2018)

## Java

- [H3 Measurements](https://github.com/isaacbrodsky/h3measurements): Measurements of average cell area, average cell perimeter length, truncation error, and so on.

## JavaScript

- [H3 Tutorials on Observable](https://beta.observablehq.com/collection/@nrabinowitz/h3-tutorial)

## Python

- [Usage (IPython Notebook)](https://github.com/uber/h3-py-notebooks/blob/master/Usage.ipynb)
- [Unified Data Layers (IPython Notebook)](https://github.com/uber/h3-py-notebooks/blob/master/UnifiedDataLayers.ipynb)
- [H3 API examples on Urban Analytics(IPython Notebook)](https://github.com/uber/h3-py-notebooks/blob/master/H3%20API%20examples%20on%20Urban%20Analytics.ipynb)
