/*
 * Decompiled with CFR 0.152.
 */
package org.junit.internal.requests;

import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.builders.SuiteMethodBuilder;
import org.junit.internal.requests.MemoizingRequest;
import org.junit.runner.Runner;
import org.junit.runners.model.RunnerBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassRequest
extends MemoizingRequest {
    private final Class<?> fTestClass;
    private final boolean canUseSuiteMethod;

    public ClassRequest(Class<?> testClass, boolean canUseSuiteMethod) {
        this.fTestClass = testClass;
        this.canUseSuiteMethod = canUseSuiteMethod;
    }

    public ClassRequest(Class<?> testClass) {
        this(testClass, true);
    }

    @Override
    protected Runner createRunner() {
        return new CustomAllDefaultPossibilitiesBuilder().safeRunnerForClass(this.fTestClass);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CustomSuiteMethodBuilder
    extends SuiteMethodBuilder {
        private CustomSuiteMethodBuilder() {
        }

        @Override
        public Runner runnerForClass(Class<?> testClass) throws Throwable {
            if (testClass == ClassRequest.this.fTestClass && !ClassRequest.this.canUseSuiteMethod) {
                return null;
            }
            return super.runnerForClass(testClass);
        }
    }

    private class CustomAllDefaultPossibilitiesBuilder
    extends AllDefaultPossibilitiesBuilder {
        private CustomAllDefaultPossibilitiesBuilder() {
        }

        protected RunnerBuilder suiteMethodBuilder() {
            return new CustomSuiteMethodBuilder();
        }
    }
}

