/*
 * Copyright 2014 Emmanuel Engelhart <kelson@kiwix.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU  General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 */

#include <common/otherTools.h>
#include <map>

std::map<std::string, std::string> codeisomapping {
  { "af", "afg" },
  { "ax", "ala" },
  { "al", "alb" },
  { "dz", "dza" },
  { "as", "asm" },
  { "ad", "and" },
  { "ao", "ago" },
  { "ai", "aia" },
  { "aq", "ata" },
  { "ag", "atg" },
  { "ar", "arg" },
  { "am", "arm" },
  { "aw", "abw" },
  { "au", "aus" },
  { "at", "aut" },
  { "az", "aze" },
  { "bs", "bhs" },
  { "bh", "bhr" },
  { "bd", "bgd" },
  { "bb", "brb" },
  { "by", "blr" },
  { "be", "bel" },
  { "bz", "blz" },
  { "bj", "ben" },
  { "bm", "bmu" },
  { "bt", "btn" },
  { "bo", "bol" },
  { "ba", "bih" },
  { "bw", "bwa" },
  { "bv", "bvt" },
  { "br", "bra" },
  { "vg", "vgb" },
  { "io", "iot" },
  { "bn", "brn" },
  { "bg", "bgr" },
  { "bf", "bfa" },
  { "bi", "bdi" },
  { "kh", "khm" },
  { "cm", "cmr" },
  { "ca", "can" },
  { "cv", "cpv" },
  { "ky", "cym" },
  { "cf", "caf" },
  { "td", "tcd" },
  { "cl", "chl" },
  { "cn", "chn" },
  { "hk", "hkg" },
  { "mo", "mac" },
  { "cx", "cxr" },
  { "cc", "cck" },
  { "co", "col" },
  { "km", "com" },
  { "cg", "cog" },
  { "cd", "cod" },
  { "ck", "cok" },
  { "cr", "cri" },
  { "ci", "civ" },
  { "hr", "hrv" },
  { "cu", "cub" },
  { "cy", "cyp" },
  { "cz", "cze" },
  { "dk", "dnk" },
  { "dj", "dji" },
  { "dm", "dma" },
  { "do", "dom" },
  { "ec", "ecu" },
  { "eg", "egy" },
  { "sv", "slv" },
  { "gq", "gnq" },
  { "er", "eri" },
  { "ee", "est" },
  { "et", "eth" },
  { "fk", "flk" },
  { "fo", "fro" },
  { "fj", "fji" },
  { "fi", "fin" },
  { "fr", "fra" },
  { "gf", "guf" },
  { "pf", "pyf" },
  { "tf", "atf" },
  { "ga", "gab" },
  { "gm", "gmb" },
  { "ge", "geo" },
  { "de", "deu" },
  { "gh", "gha" },
  { "gi", "gib" },
  { "gr", "grc" },
  { "gl", "grl" },
  { "gd", "grd" },
  { "gp", "glp" },
  { "gu", "gum" },
  { "gt", "gtm" },
  { "gg", "ggy" },
  { "gn", "gin" },
  { "gw", "gnb" },
  { "gy", "guy" },
  { "ht", "hti" },
  { "hm", "hmd" },
  { "va", "vat" },
  { "hn", "hnd" },
  { "hu", "hun" },
  { "is", "isl" },
  { "in", "ind" },
  { "id", "idn" },
  { "ir", "irn" },
  { "iq", "irq" },
  { "ie", "irl" },
  { "im", "imn" },
  { "il", "isr" },
  { "it", "ita" },
  { "jm", "jam" },
  { "jp", "jpn" },
  { "je", "jey" },
  { "jo", "jor" },
  { "kz", "kaz" },
  { "ke", "ken" },
  { "ki", "kir" },
  { "kp", "prk" },
  { "kr", "kor" },
  { "kw", "kwt" },
  { "kg", "kgz" },
  { "la", "lao" },
  { "lv", "lva" },
  { "lb", "lbn" },
  { "ls", "lso" },
  { "lr", "lbr" },
  { "ly", "lby" },
  { "li", "lie" },
  { "lt", "ltu" },
  { "lu", "lux" },
  { "mk", "mkd" },
  { "mg", "mdg" },
  { "mw", "mwi" },
  { "my", "mys" },
  { "mv", "mdv" },
  { "ml", "mli" },
  { "mt", "mlt" },
  { "mh", "mhl" },
  { "mq", "mtq" },
  { "mr", "mrt" },
  { "mu", "mus" },
  { "yt", "myt" },
  { "mx", "mex" },
  { "fm", "fsm" },
  { "md", "mda" },
  { "mc", "mco" },
  { "mn", "mng" },
  { "me", "mne" },
  { "ms", "msr" },
  { "ma", "mar" },
  { "mz", "moz" },
  { "mm", "mmr" },
  { "na", "nam" },
  { "nr", "nru" },
  { "np", "npl" },
  { "nl", "nld" },
  { "an", "ant" },
  { "nc", "ncl" },
  { "nz", "nzl" },
  { "ni", "nic" },
  { "ne", "ner" },
  { "ng", "nga" },
  { "nu", "niu" },
  { "nf", "nfk" },
  { "mp", "mnp" },
  { "no", "nor" },
  { "om", "omn" },
  { "pk", "pak" },
  { "pw", "plw" },
  { "ps", "pse" },
  { "pa", "pan" },
  { "pg", "png" },
  { "py", "pry" },
  { "pe", "per" },
  { "ph", "phl" },
  { "pn", "pcn" },
  { "pl", "pol" },
  { "pt", "prt" },
  { "pr", "pri" },
  { "qa", "qat" },
  { "re", "reu" },
  { "ro", "rou" },
  { "ru", "rus" },
  { "rw", "rwa" },
  { "bl", "blm" },
  { "sh", "shn" },
  { "kn", "kna" },
  { "lc", "lca" },
  { "mf", "maf" },
  { "pm", "spm" },
  { "vc", "vct" },
  { "ws", "wsm" },
  { "sm", "smr" },
  { "st", "stp" },
  { "sa", "sau" },
  { "sn", "sen" },
  { "rs", "srb" },
  { "sc", "syc" },
  { "sl", "sle" },
  { "sg", "sgp" },
  { "sk", "svk" },
  { "si", "svn" },
  { "sb", "slb" },
  { "so", "som" },
  { "za", "zaf" },
  { "gs", "sgs" },
  { "ss", "ssd" },
  { "es", "esp" },
  { "lk", "lka" },
  { "sd", "sdn" },
  { "sr", "sur" },
  { "sj", "sjm" },
  { "sz", "swz" },
  { "se", "swe" },
  { "ch", "che" },
  { "sy", "syr" },
  { "tw", "twn" },
  { "tj", "tjk" },
  { "tz", "tza" },
  { "th", "tha" },
  { "tl", "tls" },
  { "tg", "tgo" },
  { "tk", "tkl" },
  { "to", "ton" },
  { "tt", "tto" },
  { "tn", "tun" },
  { "tr", "tur" },
  { "tm", "tkm" },
  { "tc", "tca" },
  { "tv", "tuv" },
  { "ug", "uga" },
  { "ua", "ukr" },
  { "ae", "are" },
  { "gb", "gbr" },
  { "us", "usa" },
  { "um", "umi" },
  { "uy", "ury" },
  { "uz", "uzb" },
  { "vu", "vut" },
  { "ve", "ven" },
  { "vn", "vnm" },
  { "vi", "vir" },
  { "wf", "wlf" },
  { "eh", "esh" },
  { "ye", "yem" },
  { "zm", "zmb" },
  { "zw", "zwe" }
};

void kiwix::sleep(unsigned int milliseconds)
{
#ifdef _WIN32
  Sleep(milliseconds);
#else
  usleep(1000 * milliseconds);
#endif
}


struct XmlStringWriter: pugi::xml_writer
{
  std::string result;
  virtual void write(const void* data, size_t size){
    result.append(static_cast<const char*>(data), size);
  }
};

std::string kiwix::nodeToString(pugi::xml_node node)
{
  XmlStringWriter writer;
  node.print(writer, "  ");
  return writer.result;
}

std::string kiwix::converta2toa3(const std::string& a2code){
  return codeisomapping.at(a2code);
}
